<div class="bg-zinc-50/80 backdrop-blur-sm dark:bg-zinc-950 shrink-0 px-4 lg:px-8 z-50 sticky top-0 app-header">
    <div class="relative py-4 lg:py-0 flex flex-wrap items-center justify-center">
        <div class="shrink-0 flex items-center space-x-1">
            <!--:Sidebar toggler:-->
            <button type="button" data-toggle="app_sidebar"
                class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800 lg:hidden">
                <span class="icon-[iconoir--menu] text-lg"></span>
            </button>
            <!--:Search:-->
            <script src="//unpkg.com/alpinejs" defer></script>
            

            <div class="ml-4 relative w-48 h-8 bg-zinc-800 overflow-hidden rounded-md shadow">

                <!-- Sliding container: wide enough to hold repeated content -->
                <div class="absolute flex whitespace-nowrap animate-marquee">
                    <?php if(empty(Auth::user()->alert)): ?>
                        <!-- Balance -->
                        <div class="px-4 h-8 flex items-center justify-center">
                            <span class="text-gray-200 font-semibold">
                                Balance: $<?php echo e(number_format(Auth::user()->balance, 2)); ?>

                            </span>
                        </div>

                        <!-- Profit -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-green-500 font-semibold">
                                Profit: $<?php echo e(number_format(Auth::user()->profit, 2)); ?>

                            </span>
                        </div>

                        <!-- Total Deposit -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-gray-200 font-semibold">
                                Total Deposit: $<?php echo e(number_format($totalDeposits, 2)); ?>

                            </span>
                        </div>

                        <!-- Total Withdrawal -->
                        <div class="px-4 flex h-8 items-center justify-center">
                            <span class="text-green-500 font-semibold">
                                Total Withdrawal: $<?php echo e(number_format($totalWithdrawals, 2)); ?>

                            </span>
                        </div>
                    <?php else: ?>
                        <!-- Show ONLY the alert -->
                        <div class="px-4 h-8 flex items-center justify-center">
                            <span class="text-yellow-400 font-semibold">
                                <?php echo e(Auth::user()->alert); ?>

                            </span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <style>
                @keyframes marquee {
                    0% {
                        transform: translateX(100%);
                    }

                    100% {
                        transform: translateX(-100%);
                    }
                }

                .animate-marquee {
                    animation: marquee 20s linear infinite;
                }
            </style>


        </div>
        <div class="flex items-center space-x-1 shrink-0 ms-auto lg:order-last">
            <input class="input-switch" data-theme-switch="dark" name="check_theme" type="checkbox" value="1">
            
            <!--:TLang:-->
            <!--:Theme Lang switcher:-->
            

            <!--:Notifications:-->
            <div class="sm:relative">
                <button data-bs-auto-close="outside" type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800 relative"
                    data-bs-toggle="dropdown" data-bs-display="static">
                    <span class="icon-[lucide--bell] text-lg"></span>
                    <!--:Notification badge with animation:-->
                    <span class="absolute right-1 top-1 flex size-2">
                        <span
                            class="absolute inline-flex h-full w-full animate-ping rounded-full bg-orange-400 opacity-75"></span>
                        <span class="relative inline-flex size-2 rounded-full bg-orange-500"></span>
                    </span>
                </button>
                <div
                    class="dropdown-menu absolute w-[94%] left-[3%] sm:w-96 abslute rtl:sm:left-0 ltr:sm:right-0 sm:left-auto top-full z-50 !p-0 mt-0.5 lg:mt-4.5 overflow-hidden">
                    <div class="px-3 pt-3 flex justify-between items-center">
                        <h5 class="text-lg">Notifications</h5>
                        <?php if($userNotifications->count()): ?>
                            <button type="button" data-bs-toggle="tooltip" data-bs-placement="left"
                                data-bs-title="Mark all as read" class="hover:text-primary cursor-pointer">
                                <?php echo e($userNotifications->count()); ?>

                            </button>
                        <?php endif; ?>
                    </div>
                    <div class="p-3 space-y-0.5 max-h-96 overflow-y-auto" data-simplebar>
                        <!--:Notification item:-->
                        <?php $__empty_1 = true; $__currentLoopData = $userNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="#"
                                class="px-3 py-2 gap-3 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 flex">
                                <span
                                    class="size-8 rounded-full bg-sky-500/10 text-white flex items-center justify-center shrink-0">
                                    <span class="icon-[lucide--bell] text-lg"></span>
                                </span>
                                <div class="flex-grow">
                                    <div class="leading-normal">
                                        <span class="h5"><?php echo e($note->type); ?>:</span>
                                        <?php echo e($note->data['message'] ?? 'No message'); ?>

                                    </div>
                                    <small class="text-muted"><?php echo e($note->created_at->diffForHumans()); ?></small>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div
                                class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                                <span class="icon-[lucide--bell] text-4xl mb-3"></span>
                                <p class="text-xl font-semibold">No Notification yet.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                </div>
            </div>

            <!--:Apps:-->
            
            <!--:Theme color switcher:-->
            <div class="relative">
                <button type="button"
                    class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800"
                    data-bs-toggle="dropdown" data-bs-display="static" data-bs-auto-close="outside">
                    <img src="<?php echo e(asset('upload/profile/' . Auth::User()->image)); ?>" class="shrink-0 rounded-full"
                        alt="" style="height:25px; width:25px;">
                </button>
                <div class="dropdown-menu absolute min-w-56 abslute ltr:right-0 rtl:left-0 top-full z-50 !p-2 mt-4.5">
                    <div class="flex items-center gap-3.5 p-2 mb-2 rounded-lg bg-zinc-50 dark:bg-zinc-800">
                        <div class="flex-grow">
                            <p class="text-sm text-muted">Signed in as</p>
                            <p class="text-sm"><?php echo e(Auth::User()->firstname); ?>

                                <?php echo e(Auth::User()->lastname); ?>

                            </p>
                        </div>
                        <span class="shrink-0 pl-2">
                            <span class="icon-[solar--verified-check-bold] text-green-500"></span>
                        </span>
                    </div>

                    <div class="mb-1 px-1">
                        <h5>Balance: $<?php echo e(number_format(Auth::user()->balance, 2)); ?></h5>
                    </div>

                    <div class="mb-1 px-1">
                        <h5><?php
                            $kyc = Auth::user()->kycVerification ?? null;
                        ?>

                            <?php if(!$kyc): ?>
                                <span
                                    class="badge bg-red-500/10 text-red-600 mt-1 mb-3 animate-pulse shadow-lg shadow-red-500/10">
                                    🔴 Unverified Account
                                </span>
                            <?php elseif($kyc->status === 'Pending'): ?>
                                <span
                                    class="badge bg-amber-500/10 text-amber-600 mt-1 mb-3 animate-pulse shadow-lg shadow-amber-400/30">
                                    🕒 Pending Verification
                                </span>
                            <?php elseif($kyc->status === 'Approved'): ?>
                                <span
                                    class="badge bg-green-500/10 text-green-600 mt-1 mb-3 shadow-md shadow-green-400/20">
                                    Verified Account
                                </span>
                            <?php else: ?>
                                <span
                                    class="badge bg-red-500/10 text-red-600 mt-1 mb-3 animate-pulse shadow-lg shadow-red-500/10">
                                    🔴 Unverified Account
                                </span>
                            <?php endif; ?>
                        </h5>
                    </div>
                    <a href="<?php echo e(url('user/profile')); ?>" class="dropdown-item">
                        <span class="dropdown-icon">
                            <span class="icon-[lucide--user]"></span>
                        </span>Profile</a>
                    <hr class="border-zinc-100 dark:border-zinc-800 my-2">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <a href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault(); this.closest('form').submit();" class="dropdown-item">
                            <span class="dropdown-icon">
                                <span class="icon-[lucide--log-out]"></span>
                            </span>Sign out</a>
                    </form>
                </div>
            </div>
        </div>
        <div class="collapse lg:ms-8 navbar-collapse w-full lg:flex-grow lg:w-auto lg:visible flex flex-wrap lg:justify-end items-center !visible lg:!flex lg:basis-auto basis-full lg:pt-0 lg:!bg-transparent"
            id="appNavbar">
            <div
                class="navbar-nav relative mt-2 lg:mt-0 flex flex-col lg:gap-4 gap-0.5 lg:flex-row lg:items-center bg-white dark:bg-zinc-950 lg:!bg-transparent w-full overflow-y-auto lg:overflow-visible lg:h-auto max-h-[80vh]">
                <div class="relative">
                    <a data-bs-display="static" data-bs-auto-close="outside" data-bs-toggle="dropdown"
                        href="index.html#" class="navbar-link ">
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>


<!--:Search Modal:-->

<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/layouts/user/header.blade.php ENDPATH**/ ?>