<!DOCTYPE html>
<html lang="en" class="h-full">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/home/vendor/css/swiper-bundle.min.css">
    <title>
        <?php if(isset($title)): ?>
            <?php echo e($title); ?> - <?php echo e($websiteSettings->site_name); ?>

        <?php else: ?>
            <?php echo e($websiteSettings->site_name); ?>

        <?php endif; ?>
    </title>
    <link rel="icon" href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" type="image/png">
    <!--:Lenis css:-->
    <link rel="stylesheet" href="/home/vendor/css/lenis.css" />
    <!--:Fonts:-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Funnel+Display:wght@300..800&family=Instrument+Serif:ital@0;1&display=swap"
        rel="stylesheet">
    <!--:Main Style:-->
    <link rel="stylesheet" href="home/css/style.css" />
</head>

<body
    class="font-theme flex flex-col h-full text-base font-normal bg-dark dark:bg-zinc-950 text-zinc-600 dark:text-zinc-300 text-left rtl:text-right">
    <div class="preloader fixed start-0 top-0 w-full h-full z-[1100] flex flex-col items-center justify-center bg-zinc-950 translate-y-0"
        id="preloader">
        <div class="progress-container">
            <div class="loading-text">Please wait...</div>
            <div class="progress-number">
                <span id="progressNumber">0</span>
            </div>
            <div class="progress-bar-container">
                <div class="progress-bar" id="progressBar"></div>
            </div>
        </div>
    </div>
    <main class="flex-1 flex flex-col app-content">
        <header class="z-50 fixed w-full start-0 bg-white/80 dark:bg-zinc-950 app-header backdrop-blur-sm">
            <div
                class="relative flex flex-wrap items-center justify-center max-w-7xl mx-auto px-4 lg:px-8 py-4 lg:py-0">
                <!--:Navbar brand:-->
                <a href="<?php echo e(url('/')); ?>" class="flex items-center relative z-[1] me-4">
                    <img class="logo-icon" :class="sidebarToggle ? 'xl:block' : 'hidden'"
                        src="<?php echo e(asset('upload/' . $websiteSettings->site_logo)); ?>" alt="Logo"
                        style="height: 50px; width:50px;" />
                </a>
                <div class="flex items-center space-x-1 shrink-0 ms-auto lg:order-last">
                    <!--:Navbar toggler:-->
                    <button type="button" data-bs-toggle="collapse" data-bs-target="#appLandingNavbar"
                        aria-label="toggle navbar"
                        class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800 lg:hidden">
                        <span class="icon-[iconoir--menu] text-lg"></span>
                    </button>


                    <div class="relative">
                        <button type="button"
                            class="cursor-pointer relative flex items-center justify-center size-8 rounded-lg hover:bg-zinc-200 hover:text-black dark:hover:text-white dark:hover:bg-zinc-800"
                            data-bs-toggle="dropdown" data-bs-display="static" data-bs-auto-close="outside">
                            <span class="icon-[icon-park-twotone--setting-two] text-lg"></span>
                        </button>
                        <div
                            class="dropdown-menu absolute min-w-48 abslute ltr:right-0 rtl:left-0 top-full z-50 !p-2 mt-4.5">
                            <div class="mb-3 px-3 pt-2">
                                <h5>Theme</h5>
                            </div>

                            <div class="flex flex-wrap px-3 pb-2 gap-2">
                                <button id="indigoTheme" class="theme-switcher cursor-pointer">
                                    <span class="flex items-center justify-center size-7 rounded-full text-white"
                                        style="background-color: #636DFF;">
                                        <span class="icon-[lucide--check] theme-check text-lg"></span>
                                    </span>
                                </button>
                                <button id="navyTheme" class="theme-switcher cursor-pointer">
                                    <span class="flex items-center justify-center size-7 rounded-full text-white"
                                        style="background-color: #0E6DD9;">
                                        <span class="icon-[lucide--check] theme-check text-lg"></span>
                                    </span>
                                </button>
                                <button id="emeraldTheme" class="theme-switcher cursor-pointer">
                                    <span class="flex items-center justify-center size-7 rounded-full text-white"
                                        style="background-color: #049772;">
                                        <span class="icon-[lucide--check] theme-check text-lg"></span>
                                    </span>
                                </button>
                                <button id="purpleTheme" class="theme-switcher cursor-pointer">
                                    <span class="flex items-center justify-center size-7 rounded-full text-white"
                                        style="background-color: #D300C5;">
                                        <span class="icon-[lucide--check] theme-check text-lg"></span>
                                    </span>
                                </button>
                            </div>
                            <div class="pt-2 mt-2 border-t border-dashed border-zinc-200 dark:border-zinc-700">
                                <label class="flex items-center cursor-pointer dropdown-item">
                                    <span class="icon-[icon-park-twotone--sun-one] me-2"></span>
                                    <span class="flex-grow text-sm me-2">Dark mode</span>
                                    <input class="input-switch" data-theme-switch="dark" name="check_theme"
                                        type="checkbox" value="1">
                                </label>
                            </div>
                            <div class="pt-2 mt-2 border-t border-dashed border-zinc-200 dark:border-zinc-700">
                                <label for="toggleRTL"
                                    class="flex items-center justify-between cursor-pointer dropdown-item">
                                    <span class="text-sm">Enable RTL</span>
                                    <input type="checkbox" class="input-switch" id="toggleRTL" />
                                </label>

                            </div>
                        </div>
                    </div>
                    <a href="<?php echo e(url('login')); ?>" class="btn ms-2 bg-zinc-700 hover:bg-zinc-800 text-white gap-1">
                        Start free trail</a>
                </div>
                <div class="collapse navbar-collapse lg:relative w-full lg:flex-grow lg:w-auto lg:visible flex flex-wrap items-center !visible lg:!flex lg:basis-auto basis-full lg:pt-0 lg:!bg-transparent"
                    id="appLandingNavbar">
                    <div
                        class="navbar-nav relative mt-2 lg:mt-0 rounded-lg lg:rounded-0 p-4 lg:p-0 flex flex-col lg:gap-4 gap-0.5 lg:flex-row lg:justify-center bg-white dark:bg-zinc-950 lg:!bg-transparent w-full overflow-y-auto lg:overflow-visible lg:h-auto max-h-[80vh]">
                        <a data-scroll href="<?php echo e(url('/')); ?>" class="navbar-link">
                            Home
                        </a>
                        <div>
                            <a href="<?php echo e(url('/')); ?>" class="navbar-link" data-bs-toggle="dropdown"
                                data-bs-auto-close="outside" data-bs-display="static">
                                Features <span class="icon-[lucide--chevron-down] navbar-arrow"></span>
                            </a>
                            <div class="dropdown-menu lg:absolute !top-full lg:mt-1.5 w-full lg:w-[60%] z-50">
                                <div class="grid grid-cols-1 lg:gap-4 lg:grid-cols-2 lg:p-4">
                                    <div class="flex flex-col gap-3">
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--chart-pie]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Analytics</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="shrink-0 size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--every-user]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Collaboration</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="shrink-0 size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--data-user]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Automation</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="flex flex-col gap-3">
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="shrink-0 size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--bank-card]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Plans</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="shrink-0 size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--headset-one]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Support</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                            <div class="flex items-center">
                                                <div
                                                    class="shrink-0 size-8 flex items-center justify-center text-xl bg-primary-subtle rounded-lg">
                                                    <span class="icon-[icon-park-twotone--database-point]"></span>
                                                </div>
                                                <div class="flex-grow ps-3">
                                                    <span class="mb-0 font-medium">Integrations</span>
                                                    <p class="text-sm">Lorem ipsum dolor sit amet </p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a data-scroll href="<?php echo e(url('/')); ?>#!" class="navbar-link">
                            Pricing
                        </a>
                        <a data-scroll href="<?php echo e(url('/')); ?>#!" class="navbar-link">
                            Blog
                        </a>
                        <div>
                            <a href="<?php echo e(url('/')); ?>" class="navbar-link" data-bs-toggle="dropdown"
                                data-bs-auto-close="outside" data-bs-display="static">
                                Company <span class="icon-[lucide--chevron-down] navbar-arrow"></span>
                            </a>
                            <div class="dropdown-menu lg:absolute !top-full lg:mt-1.5 w-full lg:!p-4 lg:w-56 z-50">
                                <div class="pb-2 text-zinc-400 text-sm">
                                    Meet our company
                                </div>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--briefcase] text-lg me-2"></span>
                                    About us
                                </a>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--doc-success] text-lg me-2"></span>
                                    Careers
                                </a>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--message-security] text-lg me-2"></span>
                                    Security
                                </a>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--shield-add] text-lg me-2"></span>
                                    Privacy
                                </a>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--newspaper-folding] text-lg me-2"></span>
                                    Press center
                                </a>
                                <a href="<?php echo e(url('/')); ?>#!" class="dropdown-item">
                                    <span class="icon-[icon-park-twotone--party-balloon] text-lg me-2"></span>
                                    Partners
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!--:Page content:-->
        <div class="content flex-grow">
            <!--:Hero:-->
            <section class="relative pt-8 overflow-hidden">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:pb-24">
                    <div class="flex flex-wrap -mx-4 items-center">
                        <div class="w-full md:w-7/12 md:me-auto px-4 mb-12 md:mb-0">
                            <div data-rn-animate data-rn-delay="100" class="mb-7">
                                <div class="flex items-center -space-x-2">
                                    <img src="/home/images/avatars/1.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <img src="/home/images/avatars/4.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <img src="/home/images/avatars/5.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <span
                                        class="flex countup items-center justify-center shadow-card px-3 h-8 rounded-full bg-white dark:bg-zinc-800 relative z-[1]"
                                        data-rn-countup="150" data-rn-prefix="+" data-rn-suffix="k users">+150k
                                        users</span>
                                </div>
                            </div>
                            <h1 class="text-5xl lg:text-6xl mb-5" data-rn-animate data-rn-delay="200">
                                A software to manage <span class="text-zinc-400">your</span> business online
                            </h1>
                            <p class="text-lg mb-7" data-rn-animate data-rn-delay="300">
                                Raven helps to launch your products fast and grow exponentially.
                            </p>
                            <div class="flex flex-col gap-4" data-rn-animate data-rn-delay="400">
                                <div>
                                    <a href="<?php echo e(url('/')); ?>#!"
                                        class="inline-flex font-semibold relative items-center h-10 rounded-full group hover:pe-5 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-primary before:rounded-full">
                                        <div class="flex items-center relative">
                                            <span
                                                class="flex items-center justify-center size-10 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-white">
                                                <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                            </span> <span class="capitalize font-medium">Get started</span>
                                        </div>
                                    </a>
                                </div>
                                <small class="text-zinc-400 font-display italic tracking-wide font-normal">No credit
                                    card required*</small>
                            </div>
                        </div>
                        <div class="w-full md:w-5/12 px-4">
                            <div class="relative pe-8 pb-8">
                                <div class="size-96 rounded-full end-0 bottom-0 absolute bg-primary">
                                </div>
                                <div class="relative dark:bg-zinc-800 rounded-xl">
                                    <img src="/home/images/shots/dashboard.png" class="max-w-full rounded-xl"
                                        alt="">

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Partners:-->
            <section class="relative bg-zinc-100 dark:bg-zinc-900">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24 realtive overflow-hidden shadow-both">
                    <div class="swiper swiper-partners">
                        <div class="swiper-wrapper">
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">
                                    <img src="/home/images/partners/deliveroo.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">

                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/expedia.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/google.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/nasdaq.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/shopify.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/spotify.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">
                                    <img src="/home/images/partners/deliveroo.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">

                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/expedia.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/google.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/nasdaq.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/shopify.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>
                            <!--:swiper item:-->
                            <div class="swiper-slide">
                                <div class="flex items-center justify-center">

                                    <img src="/home/images/partners/spotify.svg"
                                        class="w-auto h-8 invert-0 dark:invert" alt="">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </section>

            <!--:Features:-->
            <section class="relative">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 lg:gap-12">
                        <div class="mb-9 md:mb-0">
                            <div class="text-center" data-rn-animate data-rn-delay="100">
                                <div
                                    class="mb-4 text-primary size-16 mask hexagon mx-auto bg-primary/10 flex items-center justify-center">
                                    <span class="icon-[icon-park-twotone--chart-graph] text-3xl"></span>
                                </div>
                                <h5 class="mb-3 text-xl">Analytics</h5>
                                <p class="lg:px-6">Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor
                                    dolore magna aliqua enim ad minim veniam.</p>
                            </div>
                        </div>
                        <div class="mb-9 md:mb-0">
                            <div class="text-center" data-rn-animate data-rn-delay="200">
                                <div
                                    class="mb-4 text-lime-500 size-16 mask hexagon mx-auto bg-lime-500/10 flex items-center justify-center">
                                    <span class="icon-[icon-park-twotone--data-user] text-3xl"></span>
                                </div>
                                <h5 class="mb-3 text-xl">Automation</h5>
                                <p class="lg:px-6">Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor
                                    dolore magna aliqua enim ad minim veniam.</p>
                            </div>
                        </div>
                        <div>
                            <div class="text-center" data-rn-animate data-rn-delay="300">
                                <div
                                    class="mb-4 text-purple-500 size-16 mask hexagon mx-auto bg-purple-500/10 flex items-center justify-center">
                                    <span class="icon-[icon-park-twotone--every-user] text-3xl"></span>
                                </div>
                                <h5 class="mb-3 text-xl">Collaboration</h5>
                                <p class="lg:px-6">Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor
                                    dolore magna aliqua enim ad minim veniam.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Features:-->
            <section class="relative border-t border-zinc-200 dark:border-zinc-800">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24">
                    <div class="flex flex-wrap -mx-4 items-center">
                        <div class="w-full md:w-6/12 sm:w-8/12 px-4 mb-12 md:mb-0" data-rn-animate
                            data-rn-delay="100">
                            <div
                                class="rounded-3xl p-6 lg:p-12 xl:p-16 bg-zinc-100 dark:bg-zinc-800 relative overflow-hidden">
                                <!--:Blur bg:-->
                                <img src="/home/images/blur1.png" class="absolute start-0 top-0" alt="">
                                <div class="grid grid-cols-2 items-center gap-4 relative">
                                    <div>
                                        <div class="relative overflow-hidden rounded-lg shadow-card">
                                            <img src="/home/images/shots/08.png" class="max-w-full rounded-lg"
                                                alt="">
                                        </div>
                                    </div>
                                    <div>
                                        <div class="relative overflow-hidden rounded-lg mb-4 shadow-card">
                                            <img src="/home/images/shots/01.png" class="max-w-full rounded-lg"
                                                alt="">
                                        </div>
                                        <div class="relative overflow-hidden mb-4 rounded-lg shadow-card">
                                            <img src="/home/images/shots/02.png" class="max-w-full rounded-lg"
                                                alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-full md:w-6/12 lg:w-4/12 lg:mx-auto px-4">
                            <div data-rn-animate data-rn-delay="100" class="mb-7">
                                <div class="flex items-center -space-x-2">
                                    <img src="/home/images/avatars/1.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <img src="/home/images/avatars/4.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <img src="/home/images/avatars/5.jpg" class="rounded-full size-8 relative"
                                        alt="">
                                    <span
                                        class="flex countup items-center justify-center shadow-card px-3 h-8 rounded-full bg-white dark:bg-zinc-800 relative z-[1]"
                                        data-rn-countup="150" data-rn-prefix="+" data-rn-suffix="k users"></span>
                                </div>
                            </div>

                            <h2 class="text-3xl lg:text-4xl mb-6" data-rn-animate data-rn-delay="200">
                                Drive marketing performance <span class="text-zinc-400">with</span> AI powered
                                insights
                            </h2>
                            <p class="mb-7 text-lg" data-rn-animate data-rn-delay="300">Lorem
                                ipsum is placeholder text commonly used in the graphic, print, and
                                publishing.
                            </p>
                            <ul class="mb-7">
                                <li class="flex mb-3 items-start gap-2" data-rn-animate data-rn-delay="400">
                                    <span
                                        class="icon-[lets-icons--check-ring-round-duotone] text-3xl shrink-0 text-zinc-400"></span>
                                    Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
                                    consequat.
                                </li>
                                <li class="flex mb-3 items-start gap-2" data-rn-animate data-rn-delay="500">
                                    <span
                                        class="icon-[lets-icons--check-ring-round-duotone] text-3xl shrink-0 text-zinc-400"></span>
                                    Excepteur
                                    sint occaecat cupidatat sunt in culpa qui officia deserunt mollit anim
                                    id
                                    est laborum.
                                </li>
                            </ul>
                            <div data-rn-animate data-rn-delay="600">
                                <a href="<?php echo e(url('/')); ?>#!"
                                    class="inline-flex relative items-center h-10 rounded-full group hover:pe-5 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-primary before:rounded-full">
                                    <div class="flex items-center relative">
                                        <span
                                            class="flex items-center justify-center size-10 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-white">
                                            <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                        </span><span class="capitalize font-medium">Learn more</span>
                                    </div>
                                </a>
                            </div>

                        </div>
                    </div>
                    <div class="flex flex-wrap -mx-4 mt-12 lg:mt-16">
                        <div class="w-full px-4 md:w-6/12 lg:w-5/12 lg:mx-auto mt-9" data-rn-animate
                            data-rn-delay="100">
                            <div
                                class="mb-7 text-primary size-14 mask squircle bg-primary/10 flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--adjacent-item] text-3xl"></span>
                            </div>
                            <h5 class="mb-2 text-2xl">Proven Performance</h5>
                            <p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing
                                eiusmod tempor dolore magna aliqua. Ut enim ad minim veniam, quis
                                nostrud
                                exercitation ullamco laboris commodo.</p>
                        </div>
                        <div class="w-full px-4 md:w-6/12 lg:w-5/12 lg:mx-auto mt-9" data-rn-animate
                            data-rn-delay="200">
                            <div
                                class="mb-7 text-orange-500 size-14 mask squircle bg-orange-500/10 flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--file-quality] text-3xl"></span>
                            </div>
                            <h5 class="mb-2 text-2xl">Unparalleled Track Record</h5>
                            <p class="mb-0">Consectetur adipiscing
                                elit, sed do eiusmod tempor dolore magna aliqua. Ut enim ad minim veniam, quis
                                nostrud exercitation ullamco laboris nisi ut aliquip commodo.</p>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Features:-->
            <section class="relative">
                <div class="absolute end-0 top-0 w-[55%] h-[25%] md:h-full rounded-s-4xl bg-zinc-100 dark:bg-zinc-800">
                </div>
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24 relative">
                    <div class="flex flex-wrap -mx-4 items-center">
                        <div class="w-full px-4 md:w-6/12 ms-auto md:order-last mb-9 md:mb-0" data-rn-animate
                            data-rn-delay="100">
                            <div class="relative pb-12 pe-4 md:pe-12">
                                <img src="/home/images/img1.jpg" class="max-w-full rounded-3xl shadow-card"
                                    alt="">
                                <img src="/home/images/shots/07.png"
                                    class="max-w-full absolute end-0 bottom-0 w-32 md:w-56 rounded-md md:rounded-xl shadow-card"
                                    alt="">
                            </div>
                        </div>
                        <div class="w-full px-4 md:w-6/12 lg:w-4/12 lg:mx-auto md:order-1">
                            <div class="countup" data-rn-animate data-rn-delay="200">
                                <p
                                    class="px-4 py-2 rounded-full bg-purple-500 text-white font-display italic tracking-wide shadow-card inline-flex items-center text-sm mb-6">
                                    <span class="icon-[icon-park-twotone--message] text-lg me-2"></span> Unlimited
                                    messages
                                </p>
                            </div>

                            <h2 class="text-3xl lg:text-4xl mb-6" data-rn-animate data-rn-delay="200">
                                Inbuilt
                                chat <span class="text-zinc-400">for your</span> organization
                            </h2>
                            <p class="text-lg mb-9" data-rn-animate data-rn-delay="300">
                                Lorem ipsum is placeholder text commonly used in the graphic, print, and publishing.</p>
                            <div class="grid grid-cols-2 gap-4 mb-9 divide-x divide-zinc-100 dark:divide-zinc-800">
                                <div class="flex flex-col gap-2">
                                    <h3 class="text-3xl" data-rn-countup="40" data-rn-suffix="%"></h3>
                                    <p class="text-lg">Revenue growth</p>
                                </div>
                                <div class="flex flex-col gap-2 ps-4">
                                    <h3 class="text-3xl" data-rn-countup="150" data-rn-prefix="+"
                                        data-rn-suffix="k"></h3>
                                    <p class="text-lg">Users</p>
                                </div>
                            </div>
                            <div data-rn-animate data-rn-delay="600">
                                <a href="<?php echo e(url('/')); ?>#!"
                                    class="inline-flex relative items-center h-10 rounded-full group hover:pe-5 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-primary before:rounded-full">
                                    <div class="flex items-center relative">
                                        <span
                                            class="flex items-center justify-center size-10 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-white">
                                            <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                        </span> <span class="capitalize font-medium">Learn more</span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Integrations:-->
            <section class="relative">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24 relative">
                    <div class="flex flex-wrap items-center -mx-4">
                        <div class="w-full px-4 md:w-6/12 lg:w-5/12 mb-12 md:mb-0">
                            <div class="flex flex-wrap items-center justify-center gap-4">
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/confluence.svg" class="max-w-full" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/edge.svg" class="max-w-full" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/figma.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/framer.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/gmail.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/jira.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/mailchimp.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/marvel.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/microsoft.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/ms_yammer.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/slack.svg" class="w-12 h-auto" alt="">
                                </span>
                                <!--:Brand:-->
                                <span
                                    class="flex items-center justify-center rounded-full shadow-card size-24 bg-white dark:bg-zinc-900">
                                    <img src="/home/images/brands/snapchat.svg" class="w-12 h-auto" alt="">
                                </span>
                            </div>
                        </div>
                        <div class="w-full px-4 md:w-6/12 lg:w-4/12 lg:mx-auto">
                            <div class="countup" data-rn-animate="" data-rn-delay="100">
                                <p
                                    class="px-4 py-2 rounded-full bg-primary text-white font-display italic tracking-wide shadow-card inline-flex items-center text-sm mb-6">
                                    <span class="icon-[lets-icons--code] text-xl me-2"></span> Integration
                                </p>
                            </div>
                            <h2 class="text-3xl lg:text-4xl mb-6" data-rn-animate data-rn-delay="200">
                                Deploy anywhere - <span class="text-zinc-400">with any</span> data.
                            </h2>
                            <p class="text-lg mb-7" data-rn-animate="" data-rn-delay="300">Lorem ipsum is
                                placeholder text commonly used in the graphic, print,
                                and publishing.</p>
                            <ul class="mb-9">
                                <li class="flex mb-3 items-start gap-2" data-rn-animate data-rn-delay="400">
                                    <span
                                        class="icon-[lets-icons--check-ring-round-duotone] text-3xl shrink-0 text-zinc-400"></span>
                                    Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
                                    consequat.
                                </li>
                                <li class="flex mb-3 items-start gap-2" data-rn-animate="" data-rn-delay="500">
                                    <span
                                        class="icon-[lets-icons--check-ring-round-duotone] text-3xl shrink-0 text-zinc-400"></span>
                                    Excepteur
                                    sint occaecat cupidatat sunt in culpa qui officia deserunt mollit anim
                                    id
                                    est laborum.
                                </li>
                            </ul>
                            <div data-rn-animate data-rn-delay="600">
                                <a href="<?php echo e(url('/')); ?>#!"
                                    class="inline-flex relative items-center h-10 rounded-full group hover:pe-5 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-primary before:rounded-full">
                                    <div class="flex items-center relative">
                                        <span
                                            class="flex items-center justify-center size-10 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-white">
                                            <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                        </span> <span class="capitalize font-medium">how it work</span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Features:-->
            <section class="relative overflow-hidden bg-zinc-50 dark:bg-zinc-900 rounded-4xl">
                <div class="relative max-w-5xl mx-auto px-4 lg:px-8 py-16 lg:py-24">
                    <div class="text-center mb-12 lg:mb-20">
                        <div class="countup" data-rn-animate="" data-rn-delay="100">
                            <p
                                class="px-4 py-2 rounded-full bg-pink-500 text-white font-display italic tracking-wide shadow-card inline-flex items-center text-sm mb-6">
                                <span class="icon-[lets-icons--code] text-xl me-2"></span> Awesome features
                            </p>
                        </div>
                        <h2 class="text-4xl lg:text-5xl max-w-xl mx-auto mb-0" data-rn-animate data-rn-delay="100">
                            See what we <span class="text-zinc-400">can do for</span>
                            your organization
                        </h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-12 xl:gap-16">
                        <div class="flex items-start" data-rn-animate data-rn-delay="100">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-sky-500 text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--chart-pie] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">Analytics</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                        <div class="flex items-start" data-rn-animate data-rn-delay="200">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-pink-500 text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--every-user] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">Collaboration</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                        <div class="flex items-start" data-rn-animate data-rn-delay="100">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-primary text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--data-user] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">Automation</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                        <div class="flex items-start" data-rn-animate data-rn-delay="200">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-orange-500 text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--shield] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">Secure &amp; Reliable</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                        <div class="flex items-start" data-rn-animate data-rn-delay="100">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-lime-500 text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--bank-card] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">Affordable</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                        <div class="flex items-start" data-rn-animate data-rn-delay="200">
                            <div
                                class="shrink-0 size-14 mask squircle mx-auto bg-purple-500 text-white flex items-center justify-center">
                                <span class="icon-[icon-park-twotone--headset-one] text-3xl"></span>
                            </div>
                            <div class="flex-grow ps-5 lg:ps-8">
                                <h5 class="mb-2 text-xl">24/7 Support</h5>
                                <p>Lorem ipsum dolor sit amet, consectetur
                                    adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore
                                    magna
                                    aliqua. </p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--:Plans:-->
            <section class="relative">
                <div class="max-w-7xl mx-auto py-16 lg:py-24 px-4 lg:px-8">
                    <div class="mb-9 lg:mb-12 mx-auto text-center">
                        <p class="px-4 py-2 rounded-full bg-amber-500 text-white font-display italic tracking-wide shadow-card inline-flex items-center text-sm mb-6"
                            data-rn-animate data-rn-delay="100">Pay as you go</p>
                        <h2 class="text-4xl lg:text-5xl" data-rn-animate data-rn-delay="200">
                            <span class="text-zinc-400">Simple</span> pricing
                            plans
                        </h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <!--:Pricing card:-->
                        <div class="p-1 rounded-2xl bg-zinc-100 dark:bg-zinc-900" data-rn-animate data-rn-delay="100">
                            <div class="p-4 lg:p-8 rounded-2xl bg-white dark:bg-zinc-950 h-full flex flex-col">
                                <div>
                                    <h3 class="text-2xl mb-1">Individuals</h3>
                                    <p class="mb-5 text-sm">Good for individuals who are just starting out</p>
                                    <h2 class="text-5xl mb-2">$0</h2>
                                    <span class="text-zinc-400 font-display italic tracking-wide">monthly</span>
                                </div>
                                <ul class="py-8 gap-4 flex flex-col flex-grow">
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            1 user
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited calendars
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited tasks
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Workflows
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Integrate with any app
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Accept payments
                                        </span>
                                    </li>
                                </ul>
                                <div class="mt-auto">
                                    <a href="<?php echo e(url('/')); ?>#!"
                                        class="btn btn-lg bg-zinc-800 hover:bg-zinc-700 text-white">Purchase
                                        basic</a>
                                </div>
                            </div>
                        </div>
                        <!--:Pricing card:-->
                        <div class="p-1 rounded-2xl bg-gradient-to-tl from-primary-deep via-purple-900 to-orange-900"
                            data-rn-animate data-rn-delay="200">
                            <div class="p-4 lg:p-8 rounded-2xl bg-white dark:bg-zinc-950 h-full flex flex-col">
                                <div>
                                    <h3 class="text-2xl mb-1">Team</h3>
                                    <p class="mb-5 text-sm">Highly recommended for small teams</p>
                                    <h2 class="text-5xl mb-2">$49</h2>
                                    <span class="text-zinc-400 font-display italic tracking-wide">monthly</span>
                                </div>
                                <ul class="py-8 gap-4 flex flex-col flex-grow">
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            1 team
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited calendars
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited tasks
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Workflows
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Integrate with any app
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Accept payments
                                        </span>
                                    </li>
                                </ul>
                                <div class="">
                                    <a href="<?php echo e(url('/')); ?>#!"
                                        class="btn btn-lg bg-primary hover:bg-primary-deep text-white">Purchase
                                        team</a>
                                </div>
                            </div>

                        </div>
                        <!--:Pricing card:-->
                        <div class="p-1 rounded-2xl bg-zinc-100 dark:bg-zinc-900" data-rn-animate data-rn-delay="300">
                            <div class="p-4 lg:p-8 rounded-2xl bg-white dark:bg-zinc-950 h-full flex flex-col">
                                <div>
                                    <h3 class="text-2xl mb-1">Enterprise</h3>
                                    <p class="mb-5 text-sm">Robust scheduling for large teams</p>
                                    <h2 class="text-5xl mb-2">$249</h2>
                                    <span class="text-zinc-400 font-display italic tracking-wide">monthly</span>
                                </div>
                                <ul class="py-8 gap-4 flex flex-col flex-grow">
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited users
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited calendars
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited tasks
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Workflows
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Unlimited apps integration
                                        </span>
                                    </li>
                                    <li class="flex items-center gap-4">
                                        <span
                                            class="icon-[lets-icons--check-ring-round-duotone] text-xl text-zinc-400"></span>
                                        <span>
                                            Accept payments
                                        </span>
                                    </li>
                                </ul>
                                <div>
                                    <a href="<?php echo e(url('/')); ?>#!"
                                        class="btn btn-lg bg-zinc-800 hover:bg-zinc-700 text-white">Purchase
                                        enterprise</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </section>

            <!--:Testimonials:-->
            <section class="relative bg-zinc-50 dark:bg-zinc-900">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24 realtive overflow-hidden">
                    <div class="flex flex-col sm:flex-row sm:items-center mb-12 gap-4">
                        <div class="flex-grow mb-4 sm:mb-0">
                            <h2 class="text-4xl lg:text-5xl mb-3" data-rn-animate data-rn-delay="200">
                                Customer reviews
                            </h2>
                            <p class="text-lg" data-rn-animate="" data-rn-delay="300">
                                See what people thinks about our services
                            </p>
                        </div>
                        <div class="shrink-0" data-rn-animate data-rn-delay="300">
                            <!--:Stylish action button:-->
                            <a href="<?php echo e(url('/')); ?>#!"
                                class="inline-flex relative items-center h-10 rounded-full group hover:pe-5 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-primary before:rounded-full">
                                <div class="flex items-center relative">
                                    <span
                                        class="flex items-center justify-center size-10 rounded-full me-2 transition-all duration-300 group-hover:me-0 text-white">
                                        <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                    </span> <span class="capitalize font-medium">View Reviews</span>
                                </div>
                            </a>
                        </div>
                    </div>

                    <!--:Reviews slider:-->
                    <div class="relative" data-rn-animate data-rn-delay="400">
                        <div class="swiper swiper-reviews">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/1.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/2.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/3.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/4.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/5.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <!--:Card:-->
                                    <div
                                        class="p-4 lg:p-6 rounded-xl border-2 border-zinc-100 dark:border-zinc-800 bg-white dark:bg-zinc-950">
                                        <img src="/home/images/avatars/6.jpg" alt=""
                                            class="size-12 mask squircle mb-5">
                                        <p class="mb-7">
                                            We were looking for an innovation partner that could be provide all the
                                            components that we needed. SaaS, with its abilities was a good match.
                                        </p>
                                        <h5 class="text-lg">Adam Milne</h5>
                                        <p class="text-zinc-400">Team leader at xyz inc</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--:FAQs:-->
            <section class="relative">
                <div class="max-w-7xl mx-auto px-4 lg:px-8 py-16 lg:py-24 realtive overflow-hidden">
                    <div class="mb-6 lg:mb-12 max-w-2xl mx-auto text-center">

                        <p class="px-4 py-2 rounded-full bg-orange-500 text-white font-display italic tracking-wide shadow-card inline-flex items-center text-sm mb-6"
                            data-rn-animate="" data-rn-delay="300">
                            FAQs
                        </p>
                        <h2 class="text-4xl lg:text-5xl mb-5" data-rn-animate data-rn-delay="200">
                            Frequently
                            asked questions
                        </h2>
                    </div>

                    <!--:Faqs list:-->
                    <div class="relative max-w-4xl mx-auto mb-16" data-rn-animate data-rn-delay="400">
                        <div class="divide-y px-4 divide-zinc-200 dark:divide-zinc-800" id="accordionExample">
                            <!--:Collapse item:-->
                            <div class="collapse-item">
                                <button class="flex w-full items-center justify-between cursor-pointer py-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                    aria-expanded="true" aria-controls="collapseOne">
                                    <span class="flex-grow text-lg text-start block h5">Can these templates be
                                        integrated
                                        with other
                                        frameworks?</span>
                                    <span
                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                </button>
                                <div id="collapseOne" class="collapse show" data-bs-parent="#accordionExample">
                                    <div class="pb-4">
                                        Nostrud exercitation ullamco laboris nisi ut aliquip ex ea
                                        commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse
                                        cillum
                                        dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,
                                        sunt in
                                        culpa qui officia deserunt mollit anim id est laborum.
                                    </div>
                                </div>
                            </div>
                            <!--:Collapse item:-->
                            <div class="collapse-item">
                                <button class="flex w-full items-center justify-between cursor-pointer py-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                    aria-expanded="false" aria-controls="collapseTwo">
                                    <span class="flex-grow text-lg text-start h5 block">Are the templates fully
                                        responsive
                                        and
                                        mobile-friendly?</span>
                                    <span
                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                </button>
                                <div id="collapseTwo" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="pb-4">
                                        Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
                                        commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse
                                        cillum
                                        dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,
                                        sunt in
                                        culpa qui officia deserunt mollit anim id est laborum.
                                    </div>
                                </div>
                            </div>
                            <!--:Collapse item:-->
                            <div class="collapse-item">
                                <button class="flex w-full items-center justify-between cursor-pointer py-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                    aria-expanded="false" aria-controls="collapseThree">
                                    <span class="flex-grow text-lg text-start h5 block">Can I customize the colors,
                                        fonts,
                                        and
                                        layouts?</span>
                                    <span
                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                </button>
                                <div id="collapseThree" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="pb-4">
                                        Veniam quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
                                        commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse
                                        cillum
                                        dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,
                                        sunt in
                                        culpa qui officia deserunt mollit anim id est laborum.
                                    </div>
                                </div>
                            </div>
                            <!--:Collapse item:-->
                            <div class="collapse-item">
                                <button class="flex w-full items-center justify-between cursor-pointer py-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                    aria-expanded="false" aria-controls="collapseFour">
                                    <span class="flex-grow text-lg text-start block h5">Do I need prior coding
                                        knowledge?</span>
                                    <span
                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                </button>
                                <div id="collapseFour" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="pb-4">
                                        Minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
                                        commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse
                                        cillum
                                        dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,
                                        sunt in
                                        culpa qui officia deserunt mollit anim id est laborum.
                                    </div>
                                </div>
                            </div>
                            <!--:Collapse item:-->
                            <div class="collapse-item">
                                <button class="flex w-full items-center justify-between cursor-pointer py-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive"
                                    aria-expanded="false" aria-controls="collapseFive">
                                    <span class="flex-grow text-lg text-start block h5">What type of license is
                                        included
                                        with this
                                        template?</span>
                                    <span
                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                </button>
                                <div id="collapseFive" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="pb-4">
                                        Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
                                        commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit
                                        esse
                                        cillum
                                        dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident,
                                        sunt in
                                        culpa qui officia deserunt mollit anim id est laborum.
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="flex items-center gap-4 justify-center" data-rn-animate data-rn-delay="500">
                        Didn't see your answer?
                        <a href="<?php echo e(url('/')); ?>#!"
                            class="inline-flex relative items-center h-10 rounded-full group hover:pe-4 hover:text-white transition-all duration-300
                                  before:h-10 before:w-10 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-zinc-800 before:rounded-full">
                            <div class="flex items-center relative">
                                <span
                                    class="flex items-center justify-center size-10 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-white">
                                    <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                </span> <span class="capitalize font-medium">contact us</span>
                            </div>
                        </a>
                    </div>
                </div>
            </section>

            <!--:CTA:-->
            <section class="relative">
                <div class="max-w-7xl mx-auto px-4 lg:px-8">
                    <div class="px-4 lg:px-8 rounded-4xl bg-primary py-16">
                        <div class="max-w-2xl mx-auto text-center">
                            <p data-rn-animate data-rn-delay="100"
                                class="text-white/70 mb-6 font-display italic tracking-wide text-xl">join 150,000 users
                                today</p>
                            <h2 class="text-3xl lg:text-5xl !text-white mb-9" data-rn-animate data-rn-delay="200">
                                A complete solution for you and your client's needs
                            </h2>
                            <div data-rn-animate data-rn-delay="300">
                                <a href="<?php echo e(url('/')); ?>#!"
                                    class="inline-flex relative items-center h-12 rounded-full group hover:pe-5 text-white hover:text-primary transition-all duration-300
                                  before:h-12 before:w-12 before:transition-all hover:before:w-full before:duration-300 before:absolute before:start-0 before:top-0 before:bg-white before:rounded-full">
                                    <div class="flex items-center relative">
                                        <span
                                            class="flex items-center justify-center size-12 rounded-full me-4 transition-all duration-300 group-hover:me-0 text-primary">
                                            <span class="icon-[lets-icons--arrow-alt-lright] text-xl"></span>
                                        </span> <span class="font-medium capitalize">Request a Quote</span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>

        <!--:Footer:-->
        <footer class="footer">
            <div class="max-w-7xl mx-auto px-4 lg:px-8 py-4">
                <div class="grid grid-cols-1 lg:grid-cols-12 pt-16 pb-8">
                    <div class="lg:col-span-4 mb-12 lg:mb-0">
                        <span
                            class="flex size-8 items-center justify-center rounded-lg bg-gradient-to-tl from-primary via-primary-deep to-primary-deep text-white shrink-0 font-normal">
                            <svg xmlns="http://www.w3.org/2000/svg" height="20px" viewBox="0 -960 960 960"
                                width="20px" fill="currentColor">
                                <path
                                    d="m400-240-51 123q-6 15-21.5 21.5T297-95q-15-6-21.5-21.5T275-147l43-104q-106-28-172-114T80-560v-160q0-66 47-113t113-47q22 0 42 7.5t40 15.5l191 78q13 5 12.5 18.5T512-742l-112 42v60l426 271q7 5 11 11.5t6 14.5l28 140q3 17-7.5 30T836-160h-14q-11 0-19-5.5T790-180l-30-60H560v120q0 17-11.5 28.5T520-80q-17 0-28.5-11.5T480-120v-120h-80ZM240-680q-17 0-28.5-11.5T200-720q0-17 11.5-28.5T240-760q17 0 28.5 11.5T280-720q0 17-11.5 28.5T240-680Zm160 320Zm0 40h353l-63-40H400q-36 0-67.5-14.5T279-415q-13-14-25-38.5T242-498q0-17 11.5-28.5T282-538q15 0 26 10t14 24q5 28 27 46t51 18h165L320-596v-124q0-33-23.5-56.5T240-800q-33 0-56.5 23.5T160-720v160q0 100 70 170t170 70Z">
                                </path>
                            </svg>
                        </span>
                        <p class="mt-4 mb-7">
                            Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut
                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                            laboris nisi ut aliquip ex ea commodo consequat.
                        </p>
                        <div class="flex items-center gap-6 flex-wrap">
                            <a href="<?php echo e(url('/')); ?>#!" class="hover:text-primary">
                                <span class="icon-[simple-icons--x]"></span>
                            </a>
                            <a href="<?php echo e(url('/')); ?>#!" class="hover:text-primary">
                                <span class="icon-[simple-icons--facebook]"></span>
                            </a>
                            <a href="<?php echo e(url('/')); ?>#!" class="hover:text-primary">
                                <span class="icon-[simple-icons--linkedin]"></span>
                            </a>
                            <a href="<?php echo e(url('/')); ?>#!" class="hover:text-primary">
                                <span class="icon-[simple-icons--slack]"></span>
                            </a>
                            <a href="<?php echo e(url('/')); ?>#!" class="hover:text-primary">
                                <span class="icon-[simple-icons--discord]"></span>
                            </a>
                        </div>
                    </div>
                    <div class="lg:col-span-7 lg:col-start-6">
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-8 sm:gap-4">

                            <div>
                                <h5 class="mb-4">Solutions</h5>
                                <ul class="flex flex-col space-y-3">
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Marketing</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Operations</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Product</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Sales</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Retail</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">All teams</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Education</a></li>
                                </ul>
                            </div>
                            <div>
                                <h5 class="mb-4">Resources</h5>
                                <ul class="flex flex-col space-y-3">
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Help center</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">What’s new</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Community</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Events</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Developers</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Marketplace</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Certifications</a>
                                    </li>
                                </ul>
                            </div>
                            <div>
                                <h5 class="mb-4">Company</h5>
                                <ul class="flex flex-col space-y-3">
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">About us</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Customers</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Careers</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Security</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Privacy</a></li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Press center</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>#!"
                                            class="hover:text-primary hover:border-b border-dotted">Partners</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div
                    class="grid grid-cols-1 md:grid-cols-12 gap-2 border-t border-zinc-100 dark:border-zinc-900 pt-8 pb-4">
                    <div class="md:col-span-5 order-last md:order-1">
                        <span class="text-sm text-muted text-center md:text-start block">
                            &copy; Copyright 2025. <strong>Raven</strong> all rights reserved
                        </span>
                    </div>
                    <div class="md:col-span-7 md:order-last order-1">
                        <ul class="flex flex-wrap w-full items-center gap-1.5 text-sm md:justify-end justify-center">
                            <li><a href="<?php echo e(url('/')); ?>#!" class="text-muted hover:!text-primary">Support</a>
                            </li>
                            <li class="size-1 bg-current rounded-full mx-1 opacity-30"></li>
                            <li><a href="<?php echo e(url('/')); ?>#!" class="text-muted hover:!text-primary">Changelog</a>
                            </li>
                            <li class="size-1 bg-current rounded-full mx-1 opacity-30"></li>
                            <li><a href="<?php echo e(url('/')); ?>#!" class="text-muted hover:!text-primary">Privacy
                                    policy</a></li>
                            <li class="size-1 bg-current rounded-full mx-1 opacity-30"></li>
                            <li><a href="<?php echo e(url('/')); ?>#!" class="text-muted hover:!text-primary">Terms &
                                    conditions</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
    </main>


    <div class="cursor"></div>
    <!--:Scripts:-->
    <script src="/home/js/theme.js"></script>
    <script src="/home/vendor/js/swiper-bundle.min.js"></script>
    <script>
        const swiper = new Swiper('.swiper-partners', {
            slidesPerView: "auto",
            spaceBetween: 80,
            centeredSlides: false,
            freeMode: true,
            loop: true,
            speed: 3000,
            autoplay: {
                delay: 0,
                disableOnInteraction: false,
                pauseOnMouseEnter: false,
            },
            allowTouchMove: false,
        });
    </script>

    <!--:Reviews:-->
    <script>
        const swiperR = new Swiper('.swiper-reviews', {
            slidesPerView: 1,
            spaceBetween: 30,
            centeredSlides: false,
            freeMode: true,
            loop: true,
            speed: 5000,
            autoplay: {
                delay: 0,
                disableOnInteraction: false,
                pauseOnMouseEnter: false,
            },
            allowTouchMove: true,
            breakpoints: {
                1200: {
                    slidesPerView: 3,
                },
                768: {
                    slidesPerView: 2,
                },
            },
        });
    </script>
</body>

</html>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/hhome.blade.php ENDPATH**/ ?>