<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>AI Bot Trade Started | <?php echo e($websiteSettings->site_name); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            padding: 50px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .logo {
            text-align: center;
            margin-bottom: 25px;
        }

        h1 {
            font-size: 22px;
            font-weight: 700;
            color: #111827;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            color: #2563eb;
            margin-top: 0;
            margin-bottom: 20px;
        }

        p {
            font-size: 15px;
            line-height: 24px;
            color: #444;
            text-align: center;
            margin-bottom: 20px;
        }

        .details {
            text-align: left;
            margin: 20px 0;
            background: #f9fafb;
            border-radius: 10px;
            padding: 15px 20px;
            font-size: 14px;
            line-height: 1.7;
        }

        .details strong {
            color: #111827;
        }

        .button {
            display: inline-block;
            background-color: #2563eb;
            color: #fff !important;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 8px;
            margin: 10px auto 25px;
        }

        .highlight {
            color: #2563eb;
            font-weight: 600;
        }

        .footer {
            margin-top: 30px;
            font-size: 13px;
            color: #6b7280;
            background-color: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
        }

        @media (max-width: 480px) {
            .container {
                padding: 30px 20px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="logo">
            <img src="<?php echo e(asset('upload/' . $websiteSettings->site_logo)); ?>" alt="<?php echo e($websiteSettings->site_name); ?> Logo"
                width="70" height="70" />
        </div>

        <h1>AI Bot Trade Started Successfully</h1>
        <h2>Hello <?php echo e($trade->user->firstname); ?>, your bot is now live! 🚀</h2>

        <p>You have successfully started an <span class="highlight"><?php echo e($trade->bot->name); ?></span> AI Bot Trade.</p>

        <div class="details">
            <p><strong>Bot Name:</strong> <?php echo e($trade->bot->name); ?></p>
            <p><strong>Amount Invested:</strong> $<?php echo e(number_format($trade->amount_invested, 2)); ?></p>
            <p><strong>Duration:</strong> <?php echo e($trade->bot->duration_days); ?> days</p>
            <p><strong>Status:</strong> Running</p>
            <p><strong>Start Date:</strong> <?php echo e($trade->started_at->format('M d, Y')); ?></p>
            <p><strong>End Date:</strong> <?php echo e($trade->ends_at->format('M d, Y')); ?></p>
        </div>

        <div style="text-align:center;">
            <a href="<?php echo e(route('user.botdetails', $trade->bot->id)); ?>" class="button">View Trade Details</a>
        </div>

        <p>You can monitor your investment progress anytime from your dashboard.</p>

        <div class="footer">
            Best regards,<br>
            <strong><?php echo e($websiteSettings->site_name); ?> Team</strong><br>
            <small>Invest smart. Earn confidently.</small>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/emails/user/bot_trade_started.blade.php ENDPATH**/ ?>