<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 sm:mb-0">
            <h2 class="text-2xl font-semibold mb-1 text-black dark:text-white">Withdraw Funds</h2>
            <p>Withdraw your funds quickly and securely</p>
        </div>
        <div class="shrink-0">
            <a href="<?php echo e(url('user/dashboard')); ?>" class="btn bg-primary text-white hover:bg-primary-deep">Back to
                Dashboard</a>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-4xl mx-auto">
            <div
                class="flex flex-col rounded-xl bg-white dark:bg-zinc-900 shadow-card border-zinc-200 dark:border-zinc-700 border overflow-hidden divide-y divide-zinc-500/10 dark:divide-zinc-800">
                <div class="px-4 py-3.5">
                    <div class="py-3 flex items-center gap-3.5">
                        <a href="" class="shrink-0">
                            <div
                                class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-sky-500/10 text-sky-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                    viewBox="0 0 48 48">
                                    <g fill="currentColor">
                                        <path fill-rule="evenodd"
                                            d="M17 25h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zM17 33h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2z"
                                            clip-rule="evenodd" />
                                        <path fill-rule="evenodd"
                                            d="M10 11a1 1 0 0 0-1 1v27a1 1 0 0 0 1 1h28c.55 0 1-.449 1-1.002V12.002c0-.554-.45-1.002-1-1.002h-3V9h3c1.658 0 3 1.347 3 3.002v26.996A3 3 0 0 1 38 42H10a3 3 0 0 1-3-3V12a3 3 0 0 1 3-3h5v2zm21 0H19V9h12z"
                                            clip-rule="evenodd" />
                                        <path fill-rule="evenodd" d="M39 20H9v-2h30z" clip-rule="evenodd" />
                                        <path
                                            d="M15 7a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0zm16 0a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0z" />
                                    </g>
                                </svg>
                            </div>
                        </a>
                        <div class="flex-grow">
                            <p class="flex text-md font-semibold items-center gap-1">
                                Select Withdrawal Method
                            </p>
                            <p class="text-muted">
                                Choose your preferred withdrawal method for receiving funds </p>
                        </div>
                    </div>
                </div>
                <div class="bg-white dark:bg-zinc-900 rounded-lg shadow p-6">
                    <h2 class="text-xl font-semibold mb-4 text-center">Withdraw Funds</h2>

                    <?php if(session('success')): ?>
                        <div class="p-3 bg-green-500/20 text-green-700 rounded mb-3"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="p-3 bg-red-500/20 text-red-700 rounded mb-3"><?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('user.withdrawal.store')); ?>" x-data="{ method: 'bank', cryptoType: '' }">
                        <?php echo csrf_field(); ?>
                        <!-- Select Method -->
                        <div class="mb-4">
                            <label class="block mb-1 font-medium">Select Withdrawal Method</label>
                            <select x-model="method" name="method_type" class="input">
                                <option value="bank">Bank Transfer</option>
                                <option value="crypto">Crypto Wallet</option>
                            </select>
                        </div>

                        <!-- Common Amount -->
                        <div class="mb-4">
                            <label class="block mb-1 font-medium">Amount ($)</label>
                            <input type="number" placeholder="Enter Amount to Withdraw" name="amount" step="0.01"
                                min="10" class="input" required>
                            <small class="badge bg-primary-subtle mt-0.5">Account Balance:
                                $<?php echo e(number_format(Auth::user()->balance, 2)); ?></small>
                        </div>

                        <!-- 🏦 Bank Form -->
                        <div x-show="method === 'bank'" class="space-y-4">
                            <div>
                                <label class="block mb-1 font-medium">Bank Name</label>
                                <input type="text" placeholder="Enter Bank Name" name="bank_name" class="input">
                            </div>
                            <div>
                                <label class="block mb-1 font-medium">Account Name</label>
                                <input type="text" placeholder="Enter Account Name" name="account_name"
                                    class="input">
                            </div>
                            <div>
                                <label class="block mb-1 font-medium">Account Number</label>
                                <input type="text" placeholder="Enter Bank Name" name="account_number"
                                    class="input">
                            </div>
                            <div>
                                <label class="block mb-1 font-medium">Swift Code</label>
                                <input type="text" placeholder="Enter Swift Code" name="swift_code" class="input">
                            </div>
                        </div>

                        <!-- 🪙 Crypto Form -->
                        <div x-show="method === 'crypto'" class="space-y-4">
                            <div>
                                <label class="block mb-1 font-medium">Crypto Type</label>
                                <select name="crypto_type" x-model="cryptoType" class="input">
                                    <option value="">--Select Crypto Wallet--</option>
                                    <option value="Bitcoin (BTC)">Bitcoin (BTC)</option>
                                    <option value="Ethereum (ETH)">Ethereum (ETH)</option>
                                    <option value="Tether (USDT)">Tether (USDT)</option>
                                </select>
                            </div>
                            <div>
                                <label class="block mb-1 font-medium">Wallet Address</label>
                                <input type="text" placeholder="Enter Wallet Address" name="wallet_address"
                                    class="input">
                            </div>
                            <div>
                                <label class="block mb-1 font-medium">Network</label>
                                <select name="network" class="input">
                                    <option value="TRC20">TRC20</option>
                                    <option value="ERC20">ERC20</option>
                                    <option value="BEP20">BEP20</option>
                                    <option value="BTC">Bitcoin Network</option>
                                </select>
                            </div>
                        </div>

                        <!-- ⚠️ Dynamic Info Alert (Positioned Right Under Select) -->
                        <template x-if="method === 'bank'">
                            <div
                                class="flex mt-4 gap-2 items-center p-3 mb-2 rounded-lg bg-blue-500/10 border border-blue-500/30 text-blue-700 dark:text-blue-300">
                                <span class="icon-[lucide--info] shrink-0 text-blue-600 dark:text-blue-400"></span>
                                <p class="text-sm">
                                    You have chosen <strong>Bank Transfer</strong>. Please note that a processing fee of
                                    <strong>$5</strong> applies to bank withdrawals.
                                </p>
                            </div>
                        </template>

                        <template x-if="method === 'crypto'">
                            <div
                                class="flex mt-4 gap-2 items-center p-3 mb-2 rounded-lg bg-yellow-500/10 border border-yellow-500/30 text-yellow-700 dark:text-yellow-300">
                                <span
                                    class="icon-[lucide--alert-triangle] shrink-0 text-yellow-600 dark:text-yellow-400"></span>
                                <p class="text-sm">
                                    You have chosen <strong><span
                                            x-text="cryptoType ? cryptoType : 'Crypto Wallet'"></span></strong>.
                                    Please ensure the wallet address and network are correct.
                                    A network fee of <strong>$2</strong> will be applied.
                                </p>
                            </div>
                        </template>

                        <div class="mt-6 text-center">
                            <button type="submit"
                                class="btn bg-green-500 rounded-xl text-white w-full mt-4 px-4 hover:bg-primary-deep h-10">
                                Submit Withdrawal
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="divide-dashed divide-y mt-3 border-zinc-200 dark:border-zinc-700 border divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden rounded-xl bg-white dark:bg-zinc-900 shadow-card"
                id="task-board">
                <!-- Parent Task -->
                <div class="mb-2 pb-2 parent-task group">
                    <div class="flex items-center justify-between px-4 gap-2 pt-4 pb-2.5">
                        <div class="w-8 h-8 flex items-center justify-center bg-primary-subtle rounded-lg shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                viewBox="0 0 32 32">
                                <mask id="SVGwjo0bdvJ" fill="#fff">
                                    <path d="M17.5 9.5a1.5 1.5 0 1 1-3 0a1.5 1.5 0 0 1 3 0" />
                                </mask>
                                <g fill="none" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M15 14h1v9h1m12-7a13 13 0 1 1-26 0a13 13 0 0 1 26 0" />
                                    <path fill="currentColor" d="M17.5 9.5a1.5 1.5 0 1 1-3 0a1.5 1.5 0 0 1 3 0Z"
                                        mask="url(#SVGwjo0bdvJ)" />
                                </g>
                            </svg>
                        </div>
                        <div class="flex-grow">
                            <h5 class="text-md">Withdrawal Information</h5>
                        </div>
                    </div>

                    <!-- Child Tasks List -->
                    <ul
                        class="divide-y px-2 whitespace-nowrap overflow-x-auto divide-zinc-500/10 dark:divide-zinc-800 child-list">
                        <!--:Child task item:-->
                        <li class="flex items-start py-2.5 child-task min-w-max">
                            <!--:Task desc:-->
                            <div class="flex items-center flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <path fill="#1ea216"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p for="task1" class="peer-checked:line-through peer-checked:opacity-50">
                                    Withdrawals are typically processed within 24 hours
                                </p>
                            </div>
                        </li>
                        <!--:Child task item:-->
                        <li class="flex items-start py-2.5 child-task min-w-max">
                            <!--:Task desc:-->
                            <div class="flex items-center flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <path fill="#1ea216"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p for="task2" class="peer-checked:line-through peer-checked:opacity-50">
                                    Minimum withdrawal amount: $50
                                </p>
                            </div>
                        </li>
                        <!--:Child task item:-->
                        <li class="flex items-start py-2.5 child-task min-w-max">
                            <!--:Task desc:-->
                            <div class="flex items-center flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <path fill="#1ea216"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p for="task3" class="peer-checked:line-through peer-checked:opacity-50">
                                    A $5 fee applies to all withdrawals
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/withdrawal.blade.php ENDPATH**/ ?>