<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.getItem('theme') === 'light' ? false : true }"
    :class="{ 'dark': darkMode }" class="dark bg-gray-900 h-full">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?php if(isset($pageTitle)): ?>
            <?php echo e($pageTitle); ?> - <?php echo e($websiteSettings->site_name); ?>

        <?php else: ?>
            <?php echo e($websiteSettings->site_name); ?>

        <?php endif; ?>
    </title>
    <link rel="icon" href="/user/images/favicon.png" type="image/png">
    <link rel="stylesheet" href="/user/vendor/css/simplebar.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/user/css/style.css" />
    <link href="/user/vendor/css/tom-select.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
</head>

<body
    class="font-theme flex flex-col h-full text-base font-normal bg-zinc-50 dark:bg-zinc-800 overflow-hidden text-zinc-700 dark:text-zinc-300">

    <!-- ✅ Full-screen centered layout -->
    <main
        class="flex flex-col items-center justify-center flex-1 bg-gradient-to-br from-gray-800 via-gray-800 to-gray-900 bg-cover bg-center px-4 py-10">

        <!-- ✅ Centered Card -->
        <div
            class="max-w-3xl mx-auto w-full rounded-xl bg-white/60 dark:bg-zinc-900/90 shadow-2xl backdrop-blur-lg p-6 sm:p-8 border border-white/20 dark:border-white/10">

            <!-- Header -->
            <div class="mb-6 flex flex-col items-center text-center">
                <a href="<?php echo e(url('/')); ?>" class="flex items-center justify-center mb-5">
                    <span
                        class="flex w-12 h-12 items-center justify-center rounded-full bg-gradient-to-tl from-primary via-primary-deep to-primary-deep text-white font-normal shadow-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"
                            fill="currentColor">
                            <path
                                d="m400-240-51 123q-6 15-21.5 21.5T297-95q-15-6-21.5-21.5T275-147l43-104q-106-28-172-114T80-560v-160q0-66 47-113t113-47q22 0 42 7.5t40 15.5l191 78q13 5 12.5 18.5T512-742l-112 42v60l426 271q7 5 11 11.5t6 14.5l28 140q3 17-7.5 30T836-160h-14q-11 0-19-5.5T790-180l-30-60H560v120q0 17-11.5 28.5T520-80q-17 0-28.5-11.5T480-120v-120h-80ZM240-680q-17 0-28.5-11.5T200-720q0-17 11.5-28.5T240-760q17 0 28.5 11.5T280-720q0 17-11.5 28.5T240-680Zm160 320Zm0 40h353l-63-40H400q-36 0-67.5-14.5T279-415q-13-14-25-38.5T242-498q0-17 11.5-28.5T282-538q15 0 26 10t14 24q5 28 27 46t51 18h165L320-596v-124q0-33-23.5-56.5T240-800q-33 0-56.5 23.5T160-720v160q0 100 70 170t170 70Z" />
                        </svg>
                    </span>
                </a>

                <h3 class="text-2xl font-semibold text-gray-100 leading-none mb-2.5">
                    Verify Your Email Address
                </h3>
                <p class="text-sm text-gray-300">
                    We’ve sent a 6-digit verification code to your email. Please enter it below to verify your account.
                </p>
                <?php if(session('message')): ?>
                    <div class="bg-green-100 text-green-700 p-2 rounded mb-3 text-center">
                        <?php echo e(session('message')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="bg-red-100 text-red-700 p-2 rounded mb-3 text-center">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
            </div>

            <!-- Access Code Form -->
            <form action="<?php echo e(route('verify.email.submit')); ?>" method="POST" class="space-y-4">
                <?php echo csrf_field(); ?>

                <div class="flex flex-col gap-1 mb-2">
                    <label for="access_code" class="block mb-1 text-sm text-gray-300">Verification Code</label>
                    <input id="code" name="code" type="text" placeholder="Enter Verification Code"
                        class="input input-lg w-full px-4 py-3 rounded-md bg-white/90 dark:bg-zinc-800 text-gray-900 dark:text-white border border-gray-300 dark:border-gray-700 focus:ring-2 focus:ring-primary focus:outline-none" />
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('code'),'class' => 'mt-2 text-red-400 text-sm']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('code')),'class' => 'mt-2 text-red-400 text-sm']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>
                <input type="hidden" name="email" value="<?php echo e(session('email')); ?>">
                <button type="submit"
                    class="btn bg-primary text-white mt-4 hover:bg-primary-deep w-full py-3 rounded-md font-semibold transition duration-300">
                    Verify Email
                </button>
            </form>

            <form method="POST" action="<?php echo e(route('verification.resend')); ?>" class="mt-4 text-center">
                <?php echo csrf_field(); ?>
                <button type="submit" class="text-blue-600 hover:underline text-sm">
                    Resend verification code
                </button>
            </form>

            <!-- Footer -->
            <div class="mt-4 text-center">
                <p class="text-gray-400 text-sm mb-2">
                    <a href="<?php echo e(url('login')); ?>" class="text-primary hover:text-primary-deep underline">Back to
                        login</a>
                </p>

                <p class="text-xs text-gray-500 dark:text-gray-400 mt-4">
                    &copy; <?php echo e(date('Y')); ?> <strong><?php echo e($websiteSettings->site_name); ?></strong>. All rights
                    reserved.
                </p>
            </div>
        </div>
    </main>

    <!-- jQuery + Toastr -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "timeOut": "4000"
            };

            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>
            <?php if(session('warning')): ?>
                toastr.warning("<?php echo e(session('warning')); ?>");
            <?php endif; ?>
            <?php if(session('info')): ?>
                toastr.info("<?php echo e(session('info')); ?>");
            <?php endif; ?>
        });
    </script>

    <script src="/user/js/theme.js"></script>
    <script src="/user/vendor/js/tom-select.complete.min.js"></script>
</body>

</html><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/auth/verify-email.blade.php ENDPATH**/ ?>