<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="content flex-grow lg:px-12">
        <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
            <div class="flex-grow mb-3 sm:mb-0">
                <h2 class="text-xl font-semibold text-black gap-1 flex dark:text-white">
                    <span class="top-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="2">
                                <circle cx="8" cy="8" r="6" />
                                <path d="M18.09 10.37A6 6 0 1 1 10.34 18M7 6h1v4" />
                                <path d="m16.71 13.88l.7.71l-2.82 2.82" />
                            </g>
                        </svg>
                    </span>
                    <span class="sidebar-text">Stake</span>
                </h2>
            </div>
        </div>

        <!--:Page content:-->
        <div class="content flex flex-col flex-grow px-4">
            <div class="mb-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                <!--:Card:-->
                <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                    <div class="shrink-0 w-3/5">
                        <h4 class="text-2xl mb-1">$<?php echo e(number_format($totalStaked, 2)); ?></h4>
                        <p class="mb-2">Total Stakings</p>
                        <span class="text-md">
                            <span class="text-nuted"><?php echo e($totalplan); ?> stakings</span>
                        </span>
                    </div>
                </div>
                <!--:Card:-->
                <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                    <div class="shrink-0 w-3/5">
                        <h4 class="text-2xl mb-1">$<?php echo e(number_format($totalActiveStaked, 2)); ?></h4>
                        <p class="mb-2">Active Stakings</p>
                        <span class="text-md">
                            <span class="text-nuted"><?php echo e($activeplan); ?> stakings</span>
                        </span>
                    </div>
                </div>
                <!--:Card:-->
                <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                    <div class="shrink-0 w-3/5">
                        <h4 class="text-2xl mb-1">$<?php echo e(number_format($totalReturn, 2)); ?></h4>
                        <p class="mb-2">Closed Stakings</p>
                        <span class="text-md">
                            <span class="text-nuted"><?php echo e($closedplan); ?> stakings</span>
                        </span>
                    </div>
                </div>
            </div>

            <div class="rounded-xl shadow-card w-full">
                <div class="px-4 pt-4 flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <!-- Nav tabs -->
                    <div class="flex flex-wrap gap-2 lg:gap-1" id="myTab" role="tablist">
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary active [.active]:bg-primary-subtle [.active]:text-primary"
                            id="revenue-tab" data-bs-toggle="tab" data-bs-target="#revenue" type="button"
                            role="tab" aria-controls="revenue" aria-selected="true">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2">
                                    <path d="M10 12h4m-4-4h4m0 13v-3a2 2 0 0 0-4 0v3" />
                                    <path
                                        d="M6 10H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2" />
                                    <path d="M6 21V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v16" />
                                </g>
                            </svg>Pools</button>
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                            id="forex-tab" data-bs-toggle="tab" data-bs-target="#forex" type="button" role="tab"
                            aria-controls="profit" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round"
                                    stroke-linejoin="round" stroke-width="2"
                                    d="M12 16v5m4-7v7m4-11v11m2-18l-8.646 8.646a.5.5 0 0 1-.708 0L9.354 8.354a.5.5 0 0 0-.707 0L2 15m2 3v3m4-7v7" />
                            </svg> Your Investments</button>
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                            id="howorks-tab" data-bs-toggle="tab" data-bs-target="#howorks" type="button"
                            role="tab" aria-controls="howorks" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2">
                                    <path
                                        d="M3.85 8.62a4 4 0 0 1 4.78-4.77a4 4 0 0 1 6.74 0a4 4 0 0 1 4.78 4.78a4 4 0 0 1 0 6.74a4 4 0 0 1-4.77 4.78a4 4 0 0 1-6.75 0a4 4 0 0 1-4.78-4.77a4 4 0 0 1 0-6.76" />
                                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3m.08 4h.01" />
                                </g>
                            </svg> How it works</button>
                    </div>
                </div>
                <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                <!-- Tab panes -->
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="revenue" role="tabpanel" aria-labelledby="revenue-tab"
                        tabindex="0">
                        <div class="w-full mb-4 mt-4">
                            <div class="grid grid-cols-1 md:grid-cols-3 sm:grid-cols-2 gap-4 mb-4">
                                <?php $__empty_2 = true; $__currentLoopData = $stake; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                    <div
                                        class="rounded-md p-2 bg-white dark:bg-zinc-900 shadow-card transition-all hover:-translate-y-1 transform group dark:border-zinc-800 border border-zinc-200 hover:border-zinc-500">
                                        <div class="px-4 pb-4">
                                            <ul class="px-2 divide-y divide-zinc-500/10 dark:divide-zinc-800">
                                                <li class="py-3 flex items-center gap-3.5">
                                                    <a href="index-education.html#!" class="shrink-0">
                                                        <?php if($item->crypto->logo_icon): ?>
                                                            <img src="<?php echo e(asset($item->crypto->logo_icon)); ?>"
                                                                class="size-10 rounded-full" alt="">
                                                        <?php endif; ?>
                                                    </a>
                                                    <div class="flex-grow overflow-hidden">
                                                        <h6><?php echo e($item->name); ?></h6>
                                                        <p class="text-zinc-400 truncate"><?php echo e($item->crypto->name); ?></p>
                                                    </div>
                                                </li>
                                            </ul>
                                            <ul class="px-2 py-6 divide-y divide-zinc-500/10 dark:divide-zinc-800">
                                                <li class="py-3 flex items-center gap-3.5">
                                                    <div class="flex-grow overflow-hidden">
                                                        <p class="text-zinc-400 truncate">Minimum</p>
                                                    </div>
                                                    <div class="shrink-0">
                                                        <span class="text-sm text-zinc-400"><?php echo e($item->minimum_amount); ?>

                                                            <?php echo e($item->crypto->name); ?></span>
                                                    </div>
                                                </li>
                                                <li class="py-3 flex items-center gap-3.5">
                                                    <div class="flex-grow overflow-hidden">
                                                        <p class="text-zinc-400 truncate">Maximum</p>
                                                    </div>
                                                    <div class="shrink-0">
                                                        <span
                                                            class="text-sm text-zinc-400"><?php echo e($item->maximum_amount); ?>

                                                            <?php echo e($item->crypto->name); ?></span>
                                                    </div>
                                                </li>
                                                <li class="py-3 flex items-center gap-3.5">
                                                    <div class="flex-grow overflow-hidden">
                                                        <p class="text-zinc-400 truncate">Cycle</p>
                                                    </div>
                                                    <div class="shrink-0">
                                                        <span class="text-sm text-zinc-400">Daily</span>
                                                    </div>
                                                </li>
                                            </ul>
                                            <div class="flex gap-2 w-full mt-4">
                                                <button type="button" data-bs-toggle="modal"
                                                    data-bs-target="#stakeModal" data-id="<?php echo e($item->id); ?>"
                                                    data-name="<?php echo e($item->name); ?>"
                                                    data-min="<?php echo e($item->minimum_amount); ?>"
                                                    data-max="<?php echo e($item->maximum_amount); ?>"
                                                    data-rate="<?php echo e($item->interest_rate); ?>"
                                                    data-crypto="<?php echo e($item->crypto->name); ?>"
                                                    class="btn flex-1 bg-primary text-white hover:bg-primary-deep">
                                                    Stake
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                    <p>No available Stake Plan.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="forex" role="tabpanel" aria-labelledby="forex-tab"
                        tabindex="0">
                        <div class="grid grid-cols-1 gap-4 mb-4">
                            <!--:Card:-->
                            <div class="w-full mb-4 mt-4">
                                <!-- Desktop Table -->
                                <div class="hidden lg:block overflow-x-auto">
                                    <div class="overflow-x-auto px-4">
                                        <table class="table-default">
                                            <thead class="border-t border-zinc-500/10 dark:border-zinc-800">
                                                <tr>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Pool Name</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Amount</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Expiration</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Interest Rate</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        ROI</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Status</th>
                                                    <th
                                                        class="px-6 py-4 text-left text-xs font-medium text-slate-400 uppercase tracking-wider">
                                                        Date</th>
                                                </tr>
                                            </thead>
                                            <tbody
                                                class="divide-y divide-zinc-200 dark:divide-zinc-900 border-t border-zinc-200 dark:border-zinc-800">
                                                <?php $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $totalearned = $item->amount + $item->interest_earned;
                                                    ?>
                                                    <tr class="hover:bg-gray-800/50 transition-colors duration-300">
                                                        <td class="whitespace-nowrap">
                                                            <div class="flex items-center gap-2">
                                                                <?php if($item->cryptos->logo_icon): ?>
                                                                    <img src="<?php echo e(asset($item->cryptos->logo_icon)); ?>"
                                                                        alt="<?php echo e($item->stakingPlan->name); ?>"
                                                                        class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                <?php else: ?>
                                                                    <div
                                                                        class="w-8 h-8 bg-gray-700 flex items-center justify-center text-xs text-white rounded-md">
                                                                        N/A
                                                                    </div>
                                                                <?php endif; ?>
                                                                <div>
                                                                    <h6 class="leading-tight">
                                                                        <?php echo e($item->cryptos->full_name); ?>

                                                                    </h6>
                                                                    <p class="text-sm"><?php echo e($item->cryptos->name); ?></p>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span
                                                                class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-900/30 text-blue-400">
                                                                $<?php echo e(number_format($item->amount, 2)); ?>

                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span id="countdown-<?php echo e($item->id); ?>"
                                                                class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-900/30 text-blue-400">

                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span
                                                                class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-900/30 text-blue-400">
                                                                <?php echo e($item->interest_rate); ?>%
                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span
                                                                class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-900/30 text-blue-400">
                                                                <?php if($item->status === 'completed'): ?>
                                                                    <span class="badge bg-green-500/10 text-green-500">
                                                                        $<?php echo e(number_format($totalearned, 2)); ?>

                                                                        Paid</span>
                                                                <?php else: ?>
                                                                    <span
                                                                        class="badge bg-sky-500/10 text-sky-500">$<?php echo e(number_format($item->amount, 2)); ?>

                                                                        Staked</span>
                                                                <?php endif; ?>
                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4">
                                                            <span
                                                                class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                                                            <?php if($item->status === 'completed'): ?> badge bg-green-500/10 text-green-500
                                                            <?php elseif($item->status === 'active'): ?> badge bg-sky-500/10 text-sky-500
                                                            <?php elseif($item->status === 'canceled'): ?> badge bg-red-500/10 text-red-500
                                                            <?php else: ?> bg-gray-900/30 text-gray-400 <?php endif; ?>">
                                                                <div
                                                                    class="w-1.5 h-1.5 rounded-full mr-1.5
                                                            <?php if($item->status === 'completed'): ?> bg-amber-500/10
                                                            <?php elseif($item->status === 'active'): ?> bg-green-500/10
                                                            <?php elseif($item->status === 'canceled'): ?> bg-red-500/10
                                                            <?php else: ?> bg-gray-500 <?php endif; ?>">
                                                                </div>
                                                                <?php echo e(ucfirst($item->status)); ?>

                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4 text-slate-300 font-light">
                                                            <?php echo e($item->created_at->format('M d, Y \a\t h:i A')); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                        <div aria-label="Page navigation example"
                                            class="flex px-4 mt-3 items-center gap-2 pagination">
                                            
                                        </div>
                                    </div>
                                </div>

                                <!-- Mobile Table -->
                                <div class="block lg:hidden space-y-4">
                                    <div>
                                        <?php $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="overflow-x-auto mb-2">
                                                <div
                                                    class="rounded-md p-4 border-zinc-200 dark:border-zinc-800 border transition-colors duration-300">
                                                    <div class="flex items-start justify-between mb-3">
                                                        <!-- Logo and Amount Section -->
                                                        <div class="flex items-center space-x-5">
                                                            <!-- Gateway Logo -->
                                                            <div class="flex items-center gap-2">
                                                                <?php if($item->cryptos->logo_icon): ?>
                                                                    <img src="<?php echo e(asset($item->cryptos->logo_icon)); ?>"
                                                                        alt="<?php echo e($item->stakingPlan->name); ?>"
                                                                        class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                <?php else: ?>
                                                                    <div
                                                                        class="w-8 h-8 bg-gray-700 flex items-center justify-center text-xs text-white rounded-md">
                                                                        N/A
                                                                    </div>
                                                                <?php endif; ?>
                                                                <div>
                                                                    <h6 class="leading-tight">
                                                                        <?php echo e($item->cryptos->full_name); ?>

                                                                    </h6>
                                                                    <p class="text-sm"><?php echo e($item->cryptos->name); ?></p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Status Badge -->
                                                        <span
                                                            class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                                                            <?php if($item->status === 'completed'): ?> badge bg-green-500/10 text-green-500
                                                            <?php elseif($item->status === 'active'): ?> badge bg-sky-500/10 text-sky-500
                                                            <?php elseif($item->status === 'canceled'): ?> badge bg-red-500/10 text-red-500
                                                            <?php else: ?> bg-gray-900/30 text-gray-400 <?php endif; ?>">
                                                            <div
                                                                class="w-1.5 h-1.5 rounded-full mr-1.5
                                                            <?php if($item->status === 'completed'): ?> bg-amber-500/10
                                                            <?php elseif($item->status === 'active'): ?> bg-green-500/10
                                                            <?php elseif($item->status === 'canceled'): ?> bg-red-500/10
                                                            <?php else: ?> bg-gray-500 <?php endif; ?>">
                                                            </div>
                                                            <?php echo e(ucfirst($item->status)); ?>

                                                        </span>
                                                    </div>
                                                    <?php
                                                        $totalearned = $item->amount + $item->interest_earned;
                                                    ?>
                                                    <!-- Payment Mode -->
                                                    <div class="flex justify-between items-center text-sm">
                                                        <span class="text-slate-400"><?php echo e($item->duration); ?> days</span>
                                                        <?php if($item->status === 'completed'): ?>
                                                            <span class="badge bg-green-500/10 text-green-500">
                                                                $<?php echo e(number_format($totalearned, 2)); ?> Paid</span>
                                                        <?php else: ?>
                                                            <span
                                                                class="badge bg-sky-500/10 text-sky-500">$<?php echo e(number_format($item->amount, 2)); ?>

                                                                Staked</span>
                                                        <?php endif; ?>
                                                    </div>

                                                    <!-- Date -->
                                                    <div class="mt-2 text-md text-slate-500">
                                                        <?php echo e($item->start_date->format('M d, Y')); ?> -
                                                        <?php echo e($item->end_date->format('M d, Y')); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div aria-label="Page navigation example"
                                        class="flex px-4 mt-3 items-center gap-2 pagination">
                                        <?php echo e($plan->links()); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="howorks" role="tabpanel" aria-labelledby="howorks-tab"
                        tabindex="0">
                        <div class="grid grid-cols-1 gap-4 mb-4">
                            <!--:Card:-->
                            <div class="content flex-grow lg:px-4">
                                <div class="py-4 max-w-7xl mx-auto">
                                    <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card">
                                        <div class="px-4 pt-4 pb-1.5 flex items-center justify-between">
                                            <h5 class="text-lg">FAQs</h5>
                                        </div>
                                        <div class="divide-y px-4 divide-zinc-100 dark:divide-zinc-900"
                                            id="accordionExample">
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">
                                                    <span class="flex-grow truncate text-start block h5">How does 'Real
                                                        Estate'
                                                        work?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseOne" class="collapse show"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        Real estate allows you to invest in commercial real estate
                                                        projects,
                                                        and
                                                        in return, you earn a share of the returns. The 'open' projects
                                                        are
                                                        projects that are available for investment. The 'closed'
                                                        projects
                                                        are
                                                        projects that are no longer available for investment.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseTwo" aria-expanded="false"
                                                    aria-controls="collapseTwo">
                                                    <span class="flex-grow truncate text-start h5 block">How do I make
                                                        money
                                                        from real estate?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseTwo" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        We source for projects with potential and in their later stages
                                                        of
                                                        development. We carefully vet these projects, collect the
                                                        necessary
                                                        documents and then list them on the platform for you to invest
                                                        in.
                                                        These
                                                        projects are typically in the pre-lease-up stage, which means
                                                        they
                                                        are
                                                        in the early stages of development and have the potential to
                                                        generate
                                                        significant returns.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseThree" aria-expanded="false"
                                                    aria-controls="collapseThree">
                                                    <span class="flex-grow truncate text-start h5 block">How do I
                                                        invest in
                                                        a
                                                        project?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseThree" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        To invest in a project, simply select the project you are
                                                        interested
                                                        in,
                                                        and then click the 'Invest now' button. A dialog will appear,
                                                        where
                                                        you
                                                        can select the amount you want to invest and the duration of
                                                        your
                                                        investment. Once you have made your selection, click the
                                                        'Invest'
                                                        button
                                                        to complete the investment.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseFour" aria-expanded="false"
                                                    aria-controls="collapseFour">
                                                    <span class="flex-grow truncate text-start block h5">How do I know
                                                        how
                                                        much
                                                        I will earn?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseFour" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The ROI is the estimated percentage of your amount that you will
                                                        earn
                                                        back after the investment is complete. We also return back your
                                                        initial
                                                        investment amount to you.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseFive" aria-expanded="false"
                                                    aria-controls="collapseFive">
                                                    <span class="flex-grow truncate text-start block h5">How long does
                                                        an
                                                        investment last?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseFive" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The duration of the investment is defined by the project. For
                                                        example,
                                                        if you select a 12-month investment, you will earn a share of
                                                        the
                                                        returns for 12 months. Once the investment is complete, you will
                                                        receive
                                                        your initial investment amount back. We forward-fund the
                                                        project, so
                                                        you
                                                        don't have to wait for the project to be fully funded or
                                                        complete
                                                        before
                                                        you can start earning returns.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseSix" aria-expanded="false"
                                                    aria-controls="collapseSix">
                                                    <span class="flex-grow truncate text-start block h5">Can I invest
                                                        in
                                                        multiple projects at the same time?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseSix" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        Yes, you can invest in multiple projects at the same time. You
                                                        can
                                                        invest in as many projects as you want, and you can invest in
                                                        the
                                                        same
                                                        project multiple times.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseSeven" aria-expanded="false"
                                                    aria-controls="collapseSeven">
                                                    <span class="flex-grow truncate text-start block h5">What is the
                                                        minimum
                                                        investment amount?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseSeven" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The minimum investment amount is defined by the project. For
                                                        example, if
                                                        the minimum investment amount is $1000, you can invest in the
                                                        project
                                                        with a minimum of $1000.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseEight" aria-expanded="false"
                                                    aria-controls="collapseEight">
                                                    <span class="flex-grow truncate text-start block h5">What is the
                                                        total
                                                        portfolio value?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseEight" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The total portfolio value is usually a total of your accumulated
                                                        earnings. You can withdraw from this amount at any time. At
                                                        completion
                                                        of an investment, your initial investment amount will be added
                                                        to
                                                        this
                                                        total and you will be able to withdraw from it.
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--:Modal Center + scroll:-->
    <div id="stakeModal" role="dialog" class="modal fixed w-full h-full left-0 top-0 z-[60] hidden [&.show]:flex"
        tabindex="-1">
        <div
            class="modal-dialog relative flex items-center justify-center m-4 h-[calc(100vh-2rem)] pointer-events-none">
            <!--:Modal content:-->
            <div
                class="modal-content overflow-hidden max-w-[30rem] mx-auto bg-white dark:bg-zinc-900 rounded-xl w-full pointer-events-auto">
                <div class="p-4 flex items-center justify-between">
                    <h5 class="text-lg">Stake <span id="planName"></span>
                    </h5>
                    <!--:Close:-->
                    <button type="button" class="btn btn-default !p-0 !rounded-full size-8" data-bs-dismiss="modal">
                        <span class="icon-[lucide--x] text-xl"></span>
                    </button>
                </div>

                <div class="content flex-grow lg:px-2">
                    <div class="flex flex-col rounded-md bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                        <div class="bg-white dark:bg-zinc-900 rounded-lg shadow p-6">

                            <form method="POST" action="<?php echo e(route('user.store.staking')); ?>">
                                <?php echo csrf_field(); ?>

                                <input type="hidden" name="staking_plan_id" id="planId">

                                <!-- Common Amount -->
                                <div class="mb-4">
                                    <label class="block mb-1 font-medium">Amount</label>
                                    <input type="number" name="amount" id="amountInput" class="input" required>
                                    <small id="minMaxText"></small>

                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="text-red-600"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Common Amount -->
                                <div class="mb-4">
                                    <label class="block mb-1 font-medium">Duration</label>
                                    <select name="duration" id="durationSelect" class="input">
                                        <?php for($i = 1; $i <= 10; $i++): ?>
                                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?>

                                                Day<?php echo e($i > 1 ? 's' : ''); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>

                                <!-- Common Amount -->
                                <div class="mb-4">
                                    <label class="block mb-1 font-medium">Interest Rate (%)</label>
                                    <input type="text" name="interest_rate" id="interestRate" class="input"
                                        readonly>
                                </div>

                                <!-- Common Amount -->
                                <div class="mb-4">
                                    <label class="block mb-1 font-medium">Expected Return</label>
                                    <input type="text" id="interestEarned" class="input" readonly>
                                </div>

                                <!-- Common Amount -->
                                <div class="mb-4">
                                    <label class="block mb-1 font-medium">Total Return</label>
                                    <input type="text" id="totalReturn" class="input" readonly>
                                </div>

                                <div class="mt-6 text-center">
                                    <button type="submit"
                                        class="btn bg-primary rounded-xl text-white w-full mt-4 px-4 hover:bg-primary-deep h-10">
                                        Stake Now
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        let min = 0,
            max = 0,
            rate = 0;

        const modal = document.getElementById('stakeModal');

        modal.addEventListener('show.bs.modal', function(event) {
            const btn = event.relatedTarget;

            document.getElementById('planId').value = btn.dataset.id;
            document.getElementById('planName').innerText = btn.dataset.name;

            min = parseFloat(btn.dataset.min);
            max = parseFloat(btn.dataset.max);
            rate = parseFloat(btn.dataset.rate);

            document.getElementById('interestRate').value = rate;
            document.getElementById('amountInput').min = min;
            document.getElementById('amountInput').max = max;
            document.getElementById('minMaxText').innerText =
                `Min: $${min} | Max: $${max}`;

            calculate();
        });

        document.getElementById('amountInput').addEventListener('input', calculate);
        document.getElementById('durationSelect').addEventListener('change', calculate);

        function calculate() {
            const amount = parseFloat(document.getElementById('amountInput').value) || 0;
            const days = parseInt(document.getElementById('durationSelect').value);

            if (amount < min || amount > max) return;

            const interest = (amount * rate / 100) * days;
            const total = amount + interest;

            document.getElementById('interestEarned').value = interest.toFixed(2);
            document.getElementById('totalReturn').value = total.toFixed(2);
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                const endDate<?php echo e($item->id); ?> = new Date(
                    "<?php echo e(\Carbon\Carbon::parse($item->end_date)); ?>").getTime();

                const countdownFunc<?php echo e($item->id); ?> = setInterval(function() {
                    const now = new Date().getTime();
                    const distance = endDate<?php echo e($item->id); ?> - now;

                    if (distance <= 0) {
                        clearInterval(countdownFunc<?php echo e($item->id); ?>);
                        document.getElementById("countdown-<?php echo e($item->id); ?>").innerHTML = "Completed";
                        const mobile = document.getElementById("countdown-mobile-<?php echo e($item->id); ?>");
                        if (mobile) mobile.innerHTML = "Completed";
                        return;
                    }

                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    const formatted = `${days}d ${hours}h ${minutes}m ${seconds}s`;
                    document.getElementById("countdown-<?php echo e($item->id); ?>").innerHTML = formatted;

                    const mobile = document.getElementById("countdown-mobile-<?php echo e($item->id); ?>");
                    if (mobile) mobile.innerHTML = formatted;
                }, 1000);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        });
    </script>



    

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/staking.blade.php ENDPATH**/ ?>