<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>

    <!--:Page Header:-->
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 sm:mb-0">
            <h2 class="text-2xl font-semibold mb-1 text-black dark:text-white">📈 My Live Trades</h2>
            <p>Track and manage your active investment portfolios</p>
        </div>
        <div class="shrink-0">
            <a href="<?php echo e(url('user/market')); ?>" class="btn bg-primary text-white hover:bg-primary-deep">Browse Market</a>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex flex-col flex-grow px-2 lg:px-8">
        <div class="mb-4">
            <div
                class="rounded-md bg-white dark:bg-zinc-900 border-zinc-700 dark:border-zinc-700 border shadow-card overflow-hidden">
                <div class="rounded-md bg-white dark:bg-zinc-900 shadow-card">
                    <!-- Nav tabs -->
                    <div class="flex justify-center w-full px-2" id="myTab2" role="tablist">
                        <div class="flex w-full max-w-full bg-zinc-50 dark:bg-white/3 rounded-md p-1 mt-3">
                            <button
                                class="flex-1 py-2 text-center hover:text-primary rounded-md [.active]:bg-primary-subtle [.active]:text-white font-medium transition-all duration-200 focus:outline-none active"
                                id="revenue1e-tab" data-bs-toggle="tab" data-bs-target="#revenue1e" type="button"
                                role="tab" aria-controls="revenue1e" aria-selected="true">
                                Open Trades (<?php echo e($openTrades->count()); ?>)
                            </button>
                            <button
                                class="flex-1 py-2 text-center hover:text-primary [.active]:bg-primary-subtle [.active]:text-white font-medium rounded-md transition-all duration-200 focus:outline-none"
                                id="sales1e-tab" data-bs-toggle="tab" data-bs-target="#sales1e" type="button" role="tab"
                                aria-controls="sales1e" aria-selected="false">
                                Closed Trades (<?php echo e($closedTrades->count()); ?>)
                            </button>
                        </div>
                    </div>

                    <!-- Tab panes -->
                    <div class="tab-content p-4">
                        <div class="tab-pane fade show active" id="revenue1e" role="tabpanel"
                            aria-labelledby="revenue1e-tab" tabindex="0">
                            <div class="grid grid-cols-1 md:grid-cols-3 sm:grid-cols-2 gap-4 mb-4">
                                <!--:Course card:-->
                                <?php if($openTrades->count() > 0): ?>
                                    <?php $__currentLoopData = $openTrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            // Extract base symbol (e.g. BTC/USD → BTC)
                                            $baseSymbol = strtoupper(explode('/', $trade->symbol)[0] ?? '');

                                            // ---- 15 CRYPTO ----
                                            $coinLogos = [
                                                'BTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1.png',
                                                'ETH' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1027.png',
                                                'BNB' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1839.png',
                                                'SOL' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/5426.png',
                                                'XRP' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/52.png',
                                                'ADA' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2010.png',
                                                'DOGE' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/74.png',
                                                'DOT' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/6636.png',
                                                'LTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2.png',
                                                'AVAX' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/5805.png',
                                                'TRX' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1958.png',
                                                'MATIC' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/3890.png',
                                                'LINK' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/1975.png',
                                                'UNI' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/7083.png',
                                                'XLM' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/512.png',
                                            ];

                                            // ---- 15 FOREX ----
                                            $forexLogos = [
                                                'EUR' => 'https://flagsapi.com/EU/flat/64.png',
                                                'USD' => 'https://flagsapi.com/US/flat/64.png',
                                                'GBP' => 'https://flagsapi.com/GB/flat/64.png',
                                                'JPY' => 'https://flagsapi.com/JP/flat/64.png',
                                                'AUD' => 'https://flagsapi.com/AU/flat/64.png',
                                                'CAD' => 'https://flagsapi.com/CA/flat/64.png',
                                                'CHF' => 'https://flagsapi.com/CH/flat/64.png',
                                                'NZD' => 'https://flagsapi.com/NZ/flat/64.png',
                                                'CNY' => 'https://flagsapi.com/CN/flat/64.png',
                                                'SEK' => 'https://flagsapi.com/SE/flat/64.png',
                                                'NOK' => 'https://flagsapi.com/NO/flat/64.png',
                                                'ZAR' => 'https://flagsapi.com/ZA/flat/64.png',
                                                'HKD' => 'https://flagsapi.com/HK/flat/64.png',
                                                'SGD' => 'https://flagsapi.com/SG/flat/64.png',
                                                'INR' => 'https://flagsapi.com/IN/flat/64.png',
                                            ];

                                            // ---- 15 STOCKS ----
                                            $stockLogos = [
                                                'AAPL' => 'https://logo.clearbit.com/apple.com',
                                                'MSFT' => 'https://logo.clearbit.com/microsoft.com',
                                                'GOOGL' => 'https://logo.clearbit.com/abc.xyz',
                                                'AMZN' => 'https://logo.clearbit.com/amazon.com',
                                                'TSLA' => 'https://logo.clearbit.com/tesla.com',
                                                'NVDA' => 'https://logo.clearbit.com/nvidia.com',
                                                'META' => 'https://logo.clearbit.com/meta.com',
                                                'NFLX' => 'https://logo.clearbit.com/netflix.com',
                                                'INTC' => 'https://logo.clearbit.com/intel.com',
                                                'AMD' => 'https://logo.clearbit.com/amd.com',
                                                'IBM' => 'https://logo.clearbit.com/ibm.com',
                                                'ORCL' => 'https://logo.clearbit.com/oracle.com',
                                                'CSCO' => 'https://logo.clearbit.com/cisco.com',
                                                'ADBE' => 'https://logo.clearbit.com/adobe.com',
                                                'CRM' => 'https://logo.clearbit.com/salesforce.com',
                                                'PYPL' => 'https://logo.clearbit.com/paypal.com',
                                                'QCOM' => 'https://logo.clearbit.com/qualcomm.com',
                                                'TXN' => 'https://logo.clearbit.com/ti.com',
                                                'AVGO' => 'https://logo.clearbit.com/broadcom.com',
                                                'SAP' => 'https://logo.clearbit.com/sap.com',
                                                'SHOP' => 'https://logo.clearbit.com/shopify.com',
                                                'UBER' => 'https://logo.clearbit.com/uber.com',
                                                'LYFT' => 'https://logo.clearbit.com/lyft.com',
                                                'SQ' => 'https://logo.clearbit.com/block.xyz',
                                                'TWTR' => 'https://logo.clearbit.com/twitter.com',
                                                'SNOW' => 'https://logo.clearbit.com/snowflake.com',
                                            ];

                                            // Combine all
                                            $allLogos = array_merge($coinLogos, $forexLogos, $stockLogos);

                                            $logoUrl = $allLogos[$baseSymbol] ?? null;
                                        ?>

                                        <div
                                            class="rounded-md p-2 bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card transition-all hover:-translate-y-1 transform group">
                                            <div
                                                class="flex items-center rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden p-4 relative">

                                                <!-- Icon moved to the left -->
                                                <div class="flex items-center gap-2 relative">
                                                    <!-- Briefcase Icon -->
                                                    <div
                                                        class="shrink-0 bg-amber-500/10 text-amber-500 rounded-full size-12 flex items-center justify-center">
                                                        <?php if($logoUrl): ?>
                                                            <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e($baseSymbol); ?> logo"
                                                                class="h-10 w-10 inline-block mr-2">
                                                        <?php else: ?>
                                                            <span
                                                                class="inline-block h-6 w-6 rounded-full bg-gray-300 text-gray-600 text-xs flex items-center justify-center">
                                                                <?php echo e(substr($baseSymbol, 0, 1)); ?>

                                                            </span>
                                                        <?php endif; ?>
                                                    </div>

                                                    <!-- Active Badge -->
                                                    <span
                                                        class="badge flex items-center gap-1 bg-green-500/10 text-green-500 h-6 px-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                            viewBox="0 0 24 24">
                                                            <path fill="none" stroke="#e1c134" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="2"
                                                                d="M2 12h4l3 9l6-18l3 9h4" />
                                                        </svg>
                                                        <?php echo e($trade->status); ?>

                                                    </span>
                                                </div>

                                                <!-- Details on the right -->
                                                <div class="flex-grow text-right">
                                                    <span class="text-md font-semibold mb-1 text-green-500">
                                                        $<?php echo e(number_format($trade->amount, 2)); ?>

                                                    </span>
                                                    <p class="mb-2 text-sm">
                                                        <?php echo e(\Carbon\Carbon::parse($trade->created_at)->format('M d, H:i')); ?>

                                                    </p>
                                                </div>
                                            </div>
                                            <div class="flex items-center justify-between mb-3">
                                                <div class="flex px-4 lg:px-4 items-center gap-2">
                                                    <!-- Left Icon -->
                                                    <div
                                                        class="shrink-0 bg-green-500/10 text-green-500 rounded-full size-10 flex items-center justify-center">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                            viewBox="0 0 24 24">
                                                            <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="1.5">
                                                                <path d="M20 13V8h-5" />
                                                                <path
                                                                    d="m20 8l-5 5c-.883.883-1.324 1.324-1.865 1.373q-.135.012-.27 0c-.541-.05-.982-.49-1.865-1.373s-1.324-1.324-1.865-1.373a1.5 1.5 0 0 0-.27 0c-.541.05-.982.49-1.865 1.373l-3 3" />
                                                            </g>
                                                        </svg>
                                                    </div>

                                                    <!-- Right Content -->
                                                    <div class="flex flex-col">
                                                        <!-- Side and Asset Name on the same row -->
                                                        <div class="flex items-center">
                                                            <span
                                                                class="px-2 py-0.5 text-md font-semibold rounded bg-gradient-to-br from-indigo-500 to-purple-600 text-white">
                                                                <?php echo e(strtoupper($trade->side)); ?>

                                                            </span>
                                                            <span
                                                                class="text-md font-semibold text-gray-800 dark:text-gray-200">
                                                                <?php echo e($trade->asset_name); ?>

                                                            </span>
                                                        </div>

                                                        <!-- Leverage below -->
                                                        <p class="text-sm text-gray-400 mt-1">
                                                            Leverage: <?php echo e($trade->leverage); ?>x
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="px-1 pb-4">
                                                <!--progress-->
                                                <div
                                                    class="mb-4 px-2 overflow-hidden p-1 rounded-md bg-zinc-50 dark:bg-white/3">
                                                    <div class="flex items-center justify-between">
                                                        <div class="flex items-center gap-2">
                                                            <p>Time Progress</p>
                                                            <span class="flex items-center text-sm text-green-500">
                                                                <span class="icon-[lucide--chevron-up]"></span>
                                                                <span>1.4%</span>
                                                            </span>
                                                        </div>
                                                        <?php
                                                            $now = time();
                                                            $expiresAt = strtotime($trade->expires_at);
                                                            $remainingSeconds = max(0, $expiresAt - $now);

                                                            if ($remainingSeconds >= 86400) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 86400) .
                                                                    ' days remaining';
                                                            } elseif ($remainingSeconds >= 3600) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 3600) .
                                                                    ' hours remaining';
                                                            } elseif ($remainingSeconds >= 60) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 60) .
                                                                    ' minutes remaining';
                                                            } elseif ($remainingSeconds > 0) {
                                                                $timeRemaining =
                                                                    $remainingSeconds . ' seconds remaining';
                                                            } else {
                                                                $timeRemaining = 'Expired';
                                                            }
                                                        ?>
                                                        <div class="shrink-0">
                                                            <p class="text-sm">
                                                                <?php echo e($timeRemaining); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                    <?php
                                                        $startTime =
                                                            \Carbon\Carbon::parse($trade->created_at)->timestamp * 1000;
                                                        $endTime =
                                                            \Carbon\Carbon::parse($trade->expires_at)->timestamp * 1000;
                                                    ?>

                                                    <div class="flex items-center gap-2">
                                                        <div
                                                            class="h-1.5 bg-zinc-500/20 rounded-full flex-grow overflow-hidden relative">
                                                            <div class="progress-bg h-1.5 bg-zinc-500 rounded-full transition-all duration-500"
                                                                data-start="<?php echo e($startTime); ?>" data-end="<?php echo e($endTime); ?>"
                                                                style="width: 0%;">
                                                            </div>
                                                        </div>
                                                        <span class="text-xs text-zinc-400 progress-percent">0%</span>
                                                    </div>

                                                    <script>
                                                        document.querySelectorAll('.progress-bg').forEach(el => {
                                                            const start = parseInt(el.dataset.start);
                                                            const end = parseInt(el.dataset.end);
                                                            const percentText = el.parentElement.nextElementSibling;

                                                            function updateProgress() {
                                                                const now = Date.now();
                                                                const total = end - start;
                                                                const elapsed = Math.min(now - start, total);
                                                                const percent = Math.min((elapsed / total) * 100, 100);
                                                                el.style.width = percent.toFixed(2) + '%';
                                                                percentText.textContent = percent.toFixed(0) + '%';

                                                                // 🟡 Optional: change color as expiration nears
                                                                if (percent > 80) el.classList.replace('bg-emerald-500', 'bg-red-500');
                                                                else if (percent > 60) el.classList.replace('bg-emerald-500', 'bg-yellow-500');
                                                            }

                                                            updateProgress();
                                                            setInterval(updateProgress, 1000);
                                                        });
                                                    </script>

                                                    <div class="flex items-center justify-between mb-2">
                                                        <div class="flex items-center gap-2">
                                                            <p class="text-sm text-muted">Started
                                                                <?php echo e(\Carbon\Carbon::parse($trade->created_at)->diffForHumans()); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-2">
                                                    <div class="grid grid-cols-2 md:grid-cols-2 gap-2">
                                                        <!--:Card:-->
                                                        <div
                                                            class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                                            <p class="mb-2 text-sm">Duration</p>
                                                            <h5 class="text-md"><?php echo e($trade['expiration']); ?></h5>
                                                        </div>
                                                        <!--:Card:-->
                                                        <div
                                                            class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                                            <p class="mb-2 text-sm">Current P&L</p>
                                                            <h5 class="text-md">
                                                                <span
                                                                    class="<?php echo e($trade->profit_loss >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                                                    $<?php echo e(number_format($trade->profit_loss, 2)); ?>

                                                                </span>
                                                            </h5>
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5">
                                                <div class="flex flex-col gap-2">
                                                    <a href="<?php echo e(url('user/monitor_trade/' . $trade->id)); ?>"
                                                        class="btn bg-zinc-100 gap-1 dark:bg-zinc-700 hover:bg-zinc-200 dark:hover:bg-zinc-600 dark:hover:text-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                            viewBox="0 0 24 24">
                                                            <path fill="currentColor"
                                                                d="M11.5 18c4 0 7.46-2.22 9.24-5.5C18.96 9.22 15.5 7 11.5 7s-7.46 2.22-9.24 5.5C4.04 15.78 7.5 18 11.5 18m0-12c4.56 0 8.5 2.65 10.36 6.5C20 16.35 16.06 19 11.5 19S3 16.35 1.14 12.5C3 8.65 6.94 6 11.5 6m0 2C14 8 16 10 16 12.5S14 17 11.5 17S7 15 7 12.5S9 8 11.5 8m0 1A3.5 3.5 0 0 0 8 12.5a3.5 3.5 0 0 0 3.5 3.5a3.5 3.5 0 0 0 3.5-3.5A3.5 3.5 0 0 0 11.5 9" />
                                                        </svg>Monitor Trade</a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    </div>
                                    <div
                                        class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48"
                                            class="mb-3">
                                            <g fill="none">
                                                <path fill="url(#SVGHyoaDcJJ)"
                                                    d="M23.5 13a1.5 1.5 0 0 1 1.5 1.5V23h5.5a1.5 1.5 0 0 1 0 3h-7a1.5 1.5 0 0 1-1.5-1.5v-10a1.5 1.5 0 0 1 1.5-1.5" />
                                                <path fill="url(#SVGGRTsNbtc)"
                                                    d="M24 9c8.284 0 15 6.716 15 15s-6.716 15-15 15S9 32.284 9 24q.002-1.162.171-2.275a1.5 1.5 0 0 0-2.966-.45Q6.001 22.61 6 24c0 9.941 8.059 18 18 18s18-8.059 18-18S33.941 6 24 6c-4.61 0-8.816 1.734-12 4.584V7.5a1.5 1.5 0 0 0-3 0v7a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 0-3h-3.698A14.94 14.94 0 0 1 24 9" />
                                                <defs>
                                                    <linearGradient id="SVGHyoaDcJJ" x1="20.313" x2="44.734" y1="37.809"
                                                        y2="28.299" gradientUnits="userSpaceOnUse">
                                                        <stop stop-color="#d373fc" />
                                                        <stop offset="1" stop-color="#6d37cd" />
                                                    </linearGradient>
                                                    <linearGradient id="SVGGRTsNbtc" x1="6" x2="15.663" y1="8.118" y2="48.577"
                                                        gradientUnits="userSpaceOnUse">
                                                        <stop stop-color="#0fafff" />
                                                        <stop offset="1" stop-color="#0067bf" />
                                                    </linearGradient>
                                                </defs>
                                            </g>
                                        </svg>

                                        <p class="text-xl font-semibold">No open trades yet.</p>
                                    </div>
                                <?php endif; ?>
                        </div>
                        <div class="tab-pane fade" id="sales1e" role="tabpanel" aria-labelledby="sales1e-tab"
                            tabindex="0">
                            <div class="grid grid-cols-1 md:grid-cols-3 sm:grid-cols-2 gap-4 mb-4">
                                <!--:Course card:-->
                                <?php if($closedTrades->count() > 0): ?>
                                    <?php $__currentLoopData = $closedTrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            // Extract base symbol (e.g. BTC/USD → BTC)
                                            $baseSymbol = strtoupper(explode('/', $trade->symbol)[0] ?? '');

                                            // ---- 15 CRYPTO ----
                                            $coinLogos = [
                                                'BTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1.png',
                                                'ETH' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1027.png',
                                                'BNB' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1839.png',
                                                'SOL' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/5426.png',
                                                'XRP' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/52.png',
                                                'ADA' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2010.png',
                                                'DOGE' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/74.png',
                                                'DOT' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/6636.png',
                                                'LTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2.png',
                                                'AVAX' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/5805.png',
                                                'TRX' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1958.png',
                                                'MATIC' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/3890.png',
                                                'LINK' =>
                                                    'https://s2.coinmarketcap.com/static/img/coins/64x64/1975.png',
                                                'UNI' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/7083.png',
                                                'XLM' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/512.png',
                                            ];

                                            // ---- 15 FOREX ----
                                            $forexLogos = [
                                                'EUR' => 'https://flagsapi.com/EU/flat/64.png',
                                                'USD' => 'https://flagsapi.com/US/flat/64.png',
                                                'GBP' => 'https://flagsapi.com/GB/flat/64.png',
                                                'JPY' => 'https://flagsapi.com/JP/flat/64.png',
                                                'AUD' => 'https://flagsapi.com/AU/flat/64.png',
                                                'CAD' => 'https://flagsapi.com/CA/flat/64.png',
                                                'CHF' => 'https://flagsapi.com/CH/flat/64.png',
                                                'NZD' => 'https://flagsapi.com/NZ/flat/64.png',
                                                'CNY' => 'https://flagsapi.com/CN/flat/64.png',
                                                'SEK' => 'https://flagsapi.com/SE/flat/64.png',
                                                'NOK' => 'https://flagsapi.com/NO/flat/64.png',
                                                'ZAR' => 'https://flagsapi.com/ZA/flat/64.png',
                                                'HKD' => 'https://flagsapi.com/HK/flat/64.png',
                                                'SGD' => 'https://flagsapi.com/SG/flat/64.png',
                                                'INR' => 'https://flagsapi.com/IN/flat/64.png',
                                            ];

                                            // ---- 15 STOCKS ----
                                            $stockLogos = [
                                                'AAPL' => 'https://logo.clearbit.com/apple.com',
                                                'MSFT' => 'https://logo.clearbit.com/microsoft.com',
                                                'GOOGL' => 'https://logo.clearbit.com/abc.xyz',
                                                'AMZN' => 'https://logo.clearbit.com/amazon.com',
                                                'TSLA' => 'https://logo.clearbit.com/tesla.com',
                                                'NVDA' => 'https://logo.clearbit.com/nvidia.com',
                                                'META' => 'https://logo.clearbit.com/meta.com',
                                                'NFLX' => 'https://logo.clearbit.com/netflix.com',
                                                'INTC' => 'https://logo.clearbit.com/intel.com',
                                                'AMD' => 'https://logo.clearbit.com/amd.com',
                                                'IBM' => 'https://logo.clearbit.com/ibm.com',
                                                'ORCL' => 'https://logo.clearbit.com/oracle.com',
                                                'CSCO' => 'https://logo.clearbit.com/cisco.com',
                                                'ADBE' => 'https://logo.clearbit.com/adobe.com',
                                                'CRM' => 'https://logo.clearbit.com/salesforce.com',
                                                'PYPL' => 'https://logo.clearbit.com/paypal.com',
                                                'QCOM' => 'https://logo.clearbit.com/qualcomm.com',
                                                'TXN' => 'https://logo.clearbit.com/ti.com',
                                                'AVGO' => 'https://logo.clearbit.com/broadcom.com',
                                                'SAP' => 'https://logo.clearbit.com/sap.com',
                                                'SHOP' => 'https://logo.clearbit.com/shopify.com',
                                                'UBER' => 'https://logo.clearbit.com/uber.com',
                                                'LYFT' => 'https://logo.clearbit.com/lyft.com',
                                                'SQ' => 'https://logo.clearbit.com/block.xyz',
                                                'TWTR' => 'https://logo.clearbit.com/twitter.com',
                                                'SNOW' => 'https://logo.clearbit.com/snowflake.com',
                                            ];

                                            // Combine all
                                            $allLogos = array_merge($coinLogos, $forexLogos, $stockLogos);

                                            $logoUrl = $allLogos[$baseSymbol] ?? null;
                                        ?>
                                        <div
                                            class="rounded-md p-2 bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card transition-all hover:-translate-y-1 transform group">
                                            <div
                                                class="flex items-center rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden p-4 relative">

                                                <!-- Icon moved to the left -->
                                                <div class="flex items-center gap-2 relative">
                                                    <!-- Briefcase Icon -->
                                                    <div>
                                                        <?php if($logoUrl): ?>
                                                            <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e($baseSymbol); ?> logo"
                                                                class="h-10 w-10 inline-block mr-2">
                                                        <?php else: ?>
                                                            <span
                                                                class="inline-block h-6 w-6 rounded-full bg-gray-300 text-gray-600 text-xs flex items-center justify-center">
                                                                <?php echo e(substr($baseSymbol, 0, 1)); ?>

                                                            </span>
                                                        <?php endif; ?>
                                                    </div>

                                                    <!-- Active Badge -->
                                                    <?php if($trade->status === 'closed'): ?>
                                                        <span
                                                            class="badge flex items-center gap-1 bg-red-500/10 text-red-500 h-6 px-2">
                                                            <!-- Red X icon for closed -->
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24">
                                                                <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                                    stroke-linejoin="round" stroke-width="1.5"
                                                                    d="M6.758 17.243L12.001 12m5.243-5.243L12 12m0 0L6.758 6.757M12.001 12l5.243 5.243" />
                                                            </svg>
                                                            <?php echo e(ucfirst($trade->status)); ?>

                                                        </span>
                                                    <?php elseif($trade->status === 'completed'): ?>
                                                        <span
                                                            class="badge flex items-center gap-1 bg-green-500/10 text-green-500 h-6 px-2">
                                                            <!-- Green check icon for completed -->
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                                viewBox="0 0 2048 2048">
                                                                <path fill="currentColor"
                                                                    d="M1837 557L768 1627l-557-558l90-90l467 466l979-978z" />
                                                            </svg>
                                                            <?php echo e(ucfirst($trade->status)); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span
                                                            class="badge flex items-center gap-1 bg-gray-500/10 text-gray-500 h-6 px-2">
                                                            <?php echo e(ucfirst($trade->status)); ?>

                                                        </span>
                                                    <?php endif; ?>

                                                </div>

                                                <!-- Details on the right -->
                                                <div class="flex-grow text-right">
                                                    <span class="text-md font-semibold mb-1 text-green-500">
                                                        $<?php echo e(number_format($trade->amount, 2)); ?>

                                                    </span>
                                                    <p class="mb-2 text-sm">
                                                        <?php echo e(\Carbon\Carbon::parse($trade->created_at)->format('M d, H:i')); ?>

                                                    </p>
                                                </div>
                                            </div>
                                            <div class="flex items-center justify-between mb-3">
                                                <div class="flex px-4 lg:px-4 items-center gap-2">
                                                    <!-- Left Icon -->
                                                    <div
                                                        class="shrink-0 bg-green-500/10 text-green-500 rounded-full size-10 flex items-center justify-center">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                            viewBox="0 0 24 24">
                                                            <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="1.5">
                                                                <path d="M20 13V8h-5" />
                                                                <path
                                                                    d="m20 8l-5 5c-.883.883-1.324 1.324-1.865 1.373q-.135.012-.27 0c-.541-.05-.982-.49-1.865-1.373s-1.324-1.324-1.865-1.373a1.5 1.5 0 0 0-.27 0c-.541.05-.982.49-1.865 1.373l-3 3" />
                                                            </g>
                                                        </svg>
                                                    </div>

                                                    <!-- Right Content -->
                                                    <div class="flex flex-col">
                                                        <!-- Side and Asset Name on the same row -->
                                                        <div class="flex items-center">
                                                            <span
                                                                class="px-2 py-0.5 text-md font-semibold rounded bg-gradient-to-br from-indigo-500 to-purple-600 text-white">
                                                                <?php echo e(strtoupper($trade->side)); ?>

                                                            </span>
                                                            <span
                                                                class="text-md font-semibold text-gray-800 dark:text-gray-200">
                                                                <?php echo e($trade->asset_name); ?>

                                                            </span>
                                                        </div>

                                                        <!-- Leverage below -->
                                                        <p class="text-sm text-gray-400 mt-1">
                                                            Leverage: <?php echo e($trade->leverage); ?>x
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="px-1 pb-4">
                                                <!--progress-->
                                                <div
                                                    class="mb-4 px-2 overflow-hidden p-1 rounded-md bg-zinc-50 dark:bg-white/3">
                                                    <div class="flex items-center justify-between">
                                                        <div class="flex items-center gap-2">
                                                            <p>Time Progress</p>
                                                            <span class="flex items-center text-sm text-green-500">
                                                                <span class="icon-[lucide--chevron-up]"></span>
                                                                <span>1.4%</span>
                                                            </span>
                                                        </div>
                                                        <?php
                                                            $now = time();
                                                            $expiresAt = strtotime($trade->expires_at);
                                                            $remainingSeconds = max(0, $expiresAt - $now);

                                                            if ($remainingSeconds >= 86400) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 86400) .
                                                                    ' days remaining';
                                                            } elseif ($remainingSeconds >= 3600) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 3600) .
                                                                    ' hours remaining';
                                                            } elseif ($remainingSeconds >= 60) {
                                                                $timeRemaining =
                                                                    floor($remainingSeconds / 60) .
                                                                    ' minutes remaining';
                                                            } elseif ($remainingSeconds > 0) {
                                                                $timeRemaining =
                                                                    $remainingSeconds . ' seconds remaining';
                                                            } else {
                                                                $timeRemaining = 'Expired';
                                                            }
                                                        ?>
                                                        <div class="shrink-0">
                                                            <p class="text-sm">
                                                                <?php echo e($timeRemaining); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                    <?php
                                                        $startTime =
                                                            \Carbon\Carbon::parse($trade->created_at)->timestamp * 1000;
                                                        $endTime =
                                                            \Carbon\Carbon::parse($trade->expires_at)->timestamp * 1000;
                                                    ?>

                                                    <div class="flex items-center gap-2">
                                                        <div
                                                            class="h-1.5 bg-zinc-500/20 rounded-full flex-grow overflow-hidden relative">
                                                            <div class="progress-bg h-1.5 bg-zinc-500 rounded-full transition-all duration-500"
                                                                data-start="<?php echo e($startTime); ?>" data-end="<?php echo e($endTime); ?>"
                                                                style="width: 0%;">
                                                            </div>
                                                        </div>
                                                        <span class="text-xs text-zinc-400 progress-percent">0%</span>
                                                    </div>

                                                    <script>
                                                        document.querySelectorAll('.progress-bg').forEach(el => {
                                                            const start = parseInt(el.dataset.start);
                                                            const end = parseInt(el.dataset.end);
                                                            const percentText = el.parentElement.nextElementSibling;

                                                            function updateProgress() {
                                                                const now = Date.now();
                                                                const total = end - start;
                                                                const elapsed = Math.min(now - start, total);
                                                                const percent = Math.min((elapsed / total) * 100, 100);
                                                                el.style.width = percent.toFixed(2) + '%';
                                                                percentText.textContent = percent.toFixed(0) + '%';

                                                                // 🟡 Optional: change color as expiration nears
                                                                if (percent > 80) el.classList.replace('bg-emerald-500', 'bg-red-500');
                                                                else if (percent > 60) el.classList.replace('bg-emerald-500', 'bg-yellow-500');
                                                            }

                                                            updateProgress();
                                                            setInterval(updateProgress, 1000);
                                                        });
                                                    </script>

                                                    <div class="flex items-center justify-between mb-2">
                                                        <div class="flex items-center gap-2">
                                                            <p class="text-sm text-muted">Started
                                                                <?php echo e(\Carbon\Carbon::parse($trade->created_at)->diffForHumans()); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-2">
                                                    <div class="grid grid-cols-2 md:grid-cols-2 gap-2">
                                                        <!--:Card:-->
                                                        <div
                                                            class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                                            <p class="mb-2 text-sm">Duration</p>
                                                            <h5 class="text-md"><?php echo e($trade['expiration']); ?></h5>
                                                        </div>
                                                        <!--:Card:-->
                                                        <div
                                                            class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                                            <p class="mb-2 text-sm">Current P&L</p>
                                                            <h5 class="text-md">
                                                                <span
                                                                    class="<?php echo e($trade->profit_loss >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                                                    $<?php echo e(number_format($trade->profit_loss, 2)); ?>

                                                                </span>
                                                            </h5>
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5">
                                                <div class="flex flex-col gap-2">
                                                    <a href="<?php echo e(url('user/trade_details', $trade->id)); ?>"
                                                        class="btn bg-zinc-100 gap-1 dark:bg-zinc-700 hover:bg-zinc-200 dark:hover:bg-zinc-600 dark:hover:text-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            viewBox="0 0 512 512">
                                                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="32"
                                                                d="M32 32v432a16 16 0 0 0 16 16h432" />
                                                            <rect width="80" height="192" x="96" y="224" fill="none"
                                                                stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="32" rx="20" ry="20" />
                                                            <rect width="80" height="240" x="240" y="176" fill="none"
                                                                stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="32" rx="20" ry="20" />
                                                            <rect width="80" height="304" x="383.64" y="112" fill="none"
                                                                stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="32" rx="20" ry="20" />
                                                        </svg>View Details</a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div
                                        class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48"
                                            class="mb-3">
                                            <g fill="none">
                                                <path fill="url(#SVGHyoaDcJJ)"
                                                    d="M23.5 13a1.5 1.5 0 0 1 1.5 1.5V23h5.5a1.5 1.5 0 0 1 0 3h-7a1.5 1.5 0 0 1-1.5-1.5v-10a1.5 1.5 0 0 1 1.5-1.5" />
                                                <path fill="url(#SVGGRTsNbtc)"
                                                    d="M24 9c8.284 0 15 6.716 15 15s-6.716 15-15 15S9 32.284 9 24q.002-1.162.171-2.275a1.5 1.5 0 0 0-2.966-.45Q6.001 22.61 6 24c0 9.941 8.059 18 18 18s18-8.059 18-18S33.941 6 24 6c-4.61 0-8.816 1.734-12 4.584V7.5a1.5 1.5 0 0 0-3 0v7a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 0-3h-3.698A14.94 14.94 0 0 1 24 9" />
                                                <defs>
                                                    <linearGradient id="SVGHyoaDcJJ" x1="20.313" x2="44.734" y1="37.809"
                                                        y2="28.299" gradientUnits="userSpaceOnUse">
                                                        <stop stop-color="#d373fc" />
                                                        <stop offset="1" stop-color="#6d37cd" />
                                                    </linearGradient>
                                                    <linearGradient id="SVGGRTsNbtc" x1="6" x2="15.663" y1="8.118"
                                                        y2="48.577" gradientUnits="userSpaceOnUse">
                                                        <stop stop-color="#0fafff" />
                                                        <stop offset="1" stop-color="#0067bf" />
                                                    </linearGradient>
                                                </defs>
                                            </g>
                                        </svg>
                                        <p class="text-xl font-semibold">No closed trades yet.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/live_trades.blade.php ENDPATH**/ ?>