<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>

    <div class="px-4 py-10 mb-4 lg:py-12 rounded-b-xl bg-gradient-to-t from-primary dark:from-primary">
        <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
            <div class="flex justify-center mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 32 32">
                    <g fill="none">
                        <path fill="#f8312f"
                            d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                        <path fill="#ffb02e"
                            d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                        <path fill="#cdc4d6"
                            d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                        <path fill="#212121"
                            d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                        <path fill="#00a6ed"
                            d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                    </g>
                </svg>
            </div>
            <h4 class="text-xl lg:text-2xl mb-2">AI Trading Bot Hub</h4>
            <p class="text-white mb-6">
                Invest in AI-powered trading bots that works 24/7 to maximize your profits across multiple markets
            </p>
            <div class="flex items-center flex-wrap justify-center gap-4">
                <a href="<?php echo e(url('user/dashboard')); ?>" type="button"
                    class="btn bg-primary text-white hover:bg-primary-deep">Back to
                    Dashboard</a>
                <a href="<?php echo e(url('user/bot_dashboard')); ?>" type="button"
                    class="btn bg-primary text-white hover:bg-primary-deep gap-2">
                    My Bot Investments<span class="icon-[lucide--external-link]"></span>
                </a>
            </div>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow px-1 pt-4 lg:px-4">
        <div class="rounded-xl shadow-card mb-4 border border-zinc-200 dark:border-zinc-700">
            <div class="px-4 pt-4 flex items-center justify-between">
                <div class="flex-grow md:pe-12">
                    <h5 class="text-lg mb-3">Available Trading Bots</h5>
                    <p class="mb-4">Choose from our AI-Powered Trading Bots</p>
                </div>
            </div>
            <hr class="border-zinc-200 dark:border-zinc-800 border-dashed mb-3">
            <div class="px-4 flex items-center justify-between">
                <div class="flex-grow md:pe-12">
                    <!-- Nav tabs -->
                    <div class="flex flex-wrap gap-2 lg:gap-1" id="myTab" role="tablist">
                        <button
                            class="flex items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary active [.active]:bg-primary-subtle [.active]:text-muted"
                            id="revenue-tab" data-bs-toggle="tab" data-bs-target="#revenue" type="button" role="tab"
                            aria-controls="revenue" aria-selected="true">All Bots</button>
                        <button
                            class="flex items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-muted"
                            id="sales-tab" data-bs-toggle="tab" data-bs-target="#sales" type="button" role="tab"
                            aria-controls="sales" aria-selected="false">Forex</button>
                        <button
                            class="flex items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-muted"
                            id="profit-tab" data-bs-toggle="tab" data-bs-target="#profit" type="button" role="tab"
                            aria-controls="profit" aria-selected="false">Crypto</button>
                        <button
                            class="flex items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-muted"
                            id="stock-tab" data-bs-toggle="tab" data-bs-target="#stock" type="button" role="tab"
                            aria-controls="stock" aria-selected="false">Stock</button>
                    </div>
                </div>
            </div>
            <!-- Tab panes -->
            <div class="tab-content p-4">
                <div class="tab-pane fade show active" id="revenue" role="tabpanel" aria-labelledby="revenue-tab"
                    tabindex="0">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                        <!--:Project card:-->
                        <?php $__currentLoopData = $bots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="rounded-xl shadow-card relative bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 transition-all hover:-translate-y-1 transform group">
                                <div class="px-4 pt-4 flex items-center justify-between">
                                    <!-- Left section -->
                                    <div class="flex items-start gap-2">
                                        <!-- SVG -->
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                                viewBox="0 0 48 48">
                                                <g fill="none">
                                                    <path fill="#deeeff"
                                                        d="M23.997 47.997c13.255 0 24-10.745 24-24s-10.745-24-24-24s-24 10.745-24 24s10.745 24 24 24" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 10.906a.87.87 0 0 0-.872-.872h-6.982a.87.87 0 0 0-.873.872l-.872 6.11h10.472z" />
                                                    <path fill="#6bafff"
                                                        d="M30.98 27.488c0 .964-.782 1.746-1.746 1.746H18.76a1.745 1.745 0 0 1-1.745-1.746V17.016h13.963zm-8.729-13.965a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m3.491 0a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m.873 1.965a.655.655 0 0 1-.654.655h-3.928a.655.655 0 0 1 0-1.31h3.928c.361 0 .654.294.654.655" />
                                                    <path fill="#2e3ecd"
                                                        d="M35.342 27.488c0 .964-.781 1.746-1.745 1.746h-.873a1.745 1.745 0 0 1-1.745-1.746V17.016h2.618c.964 0 1.745.781 1.745 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M32.288 30.979v1.745h-1.745V30.98l1.745-1.746h1.746l1.745 1.746v1.745h-1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M12.651 27.488c0 .964.782 1.746 1.746 1.746h.873c.964 0 1.745-.782 1.745-1.746V17.016h-2.618c-.964 0-1.746.781-1.746 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M15.707 30.979v1.745h1.745V30.98l-1.745-1.746H13.96l-1.745 1.746v1.745h1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M23.124 29.233h-4.363v5.237h4.363zm6.11 0H24.87v5.237h4.364z" />
                                                    <path fill="#6bafff"
                                                        d="M17.888 35.343c0-.482.39-.873.872-.873h4.364c.24 0 .436.196.436.437v2.618c0 .24-.195.436-.436.436H18.76a.87.87 0 0 1-.872-.873zm12.218 0a.873.873 0 0 0-.872-.873H24.87a.437.437 0 0 0-.436.437v2.618c0 .24.195.436.436.436h4.364c.482 0 .872-.39.872-.873z" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 27.487a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m-8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m0 6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744" />
                                                </g>
                                            </svg>
                                        </div>

                                        <!-- Texts beside SVG -->
                                        <div class="flex flex-col">
                                            <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>"
                                                class="text-md truncate hover:text-primary font-medium">
                                                <?php echo e($bot->name); ?>

                                            </a>
                                            <p class="text-sm text-gray-600"><?php echo e($bot->trading_type); ?> Trading</p>
                                        </div>
                                    </div>

                                    <!-- Right section -->
                                    <span
                                        class="badge bg-green-500/10 text-green-500 px-3 py-1 rounded-md"><?php echo e($bot->success_rate); ?>%
                                        success</span>
                                </div>

                                <div class="p-4">
                                    <p class="line-clamp-2 mb-3">
                                        <?php echo e($bot->description); ?>

                                    </p>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                        <!--:Card 1:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->daily_profit); ?></h4>
                                                <p class="text-sm">Daily Profit</p>
                                            </div>
                                        </div>

                                        <!--:Card 2:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle  shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->duration_days); ?> Days</h4>
                                                <p class="text-sm">Duration</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium">Investment Range:</span>
                                        <span class="text-sm font-semibold">$<?php echo e(number_format($bot->min_amount, 2)); ?> -
                                            $<?php echo e(number_format($bot->max_amount, 2)); ?> </span>
                                    </div>
                                    <div class="rounded-lg border-dashed mt-3">
                                        <small class="text-xs font-semibold">Trading Pairs:</small>
                                        <h6>
                                            <div class="flex flex-wrap gap-1 mt-2">
                                                <?php $__currentLoopData = explode(',', $bot->trading_pairs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <span class="px-2 py-1 text-xs font-semibold rounded-sm
                                                     bg-sky-500/10 text-blue-800 dark:bg-sky-500/10 dark:text-blue-200 h-5">
                                                                                <?php echo e(trim($pair)); ?>

                                                                            </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </h6>
                                    </div>
                                    <div class="flex items-center justify-between mt-3">
                                        <span
                                            class="flex items-center gap-1 text-xs font-medium text-gray-700 dark:text-gray-300">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M21 19.75c0-2.09-1.67-5.068-4-5.727m-2 5.727c0-2.651-2.686-6-6-6s-6 3.349-6 6m9-12.5a3 3 0 1 1-6 0a3 3 0 0 1 6 0m3 3a3 3 0 1 0 0-6" />
                                            </svg>
                                            <?php echo e($bot->active_users); ?> Active Users
                                        </span>

                                        <span class="text-xs font-semibold">$<?php echo e(number_format($bot->total_earned, 2)); ?>

                                            Total Earned</span>
                                    </div>
                                    <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>" type="button"
                                        class="w-full rounded-md mt-2 h-9 bg-sky-500/10 text-primary flex items-center justify-center gap-2">
                                        Invest Now
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                            class="inline-block">
                                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"
                                                d="m14 16l4-4m0 0l-4-4m4 4H6" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="tab-pane fade" id="sales" role="tabpanel" aria-labelledby="sales-tab" tabindex="0">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                        <!--:Project card:-->
                        <?php $__currentLoopData = $forexbots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="rounded-xl shadow-card relative bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 transition-all hover:-translate-y-1 transform group">
                                <div class="px-4 pt-4 flex items-center justify-between">
                                    <!-- Left section -->
                                    <div class="flex items-start gap-2">
                                        <!-- SVG -->
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                                viewBox="0 0 48 48">
                                                <g fill="none">
                                                    <path fill="#deeeff"
                                                        d="M23.997 47.997c13.255 0 24-10.745 24-24s-10.745-24-24-24s-24 10.745-24 24s10.745 24 24 24" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 10.906a.87.87 0 0 0-.872-.872h-6.982a.87.87 0 0 0-.873.872l-.872 6.11h10.472z" />
                                                    <path fill="#6bafff"
                                                        d="M30.98 27.488c0 .964-.782 1.746-1.746 1.746H18.76a1.745 1.745 0 0 1-1.745-1.746V17.016h13.963zm-8.729-13.965a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m3.491 0a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m.873 1.965a.655.655 0 0 1-.654.655h-3.928a.655.655 0 0 1 0-1.31h3.928c.361 0 .654.294.654.655" />
                                                    <path fill="#2e3ecd"
                                                        d="M35.342 27.488c0 .964-.781 1.746-1.745 1.746h-.873a1.745 1.745 0 0 1-1.745-1.746V17.016h2.618c.964 0 1.745.781 1.745 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M32.288 30.979v1.745h-1.745V30.98l1.745-1.746h1.746l1.745 1.746v1.745h-1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M12.651 27.488c0 .964.782 1.746 1.746 1.746h.873c.964 0 1.745-.782 1.745-1.746V17.016h-2.618c-.964 0-1.746.781-1.746 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M15.707 30.979v1.745h1.745V30.98l-1.745-1.746H13.96l-1.745 1.746v1.745h1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M23.124 29.233h-4.363v5.237h4.363zm6.11 0H24.87v5.237h4.364z" />
                                                    <path fill="#6bafff"
                                                        d="M17.888 35.343c0-.482.39-.873.872-.873h4.364c.24 0 .436.196.436.437v2.618c0 .24-.195.436-.436.436H18.76a.87.87 0 0 1-.872-.873zm12.218 0a.873.873 0 0 0-.872-.873H24.87a.437.437 0 0 0-.436.437v2.618c0 .24.195.436.436.436h4.364c.482 0 .872-.39.872-.873z" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 27.487a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m-8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m0 6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744" />
                                                </g>
                                            </svg>
                                        </div>

                                        <!-- Texts beside SVG -->
                                        <div class="flex flex-col">
                                            <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>"
                                                class="text-md truncate hover:text-primary font-medium">
                                                <?php echo e($bot->name); ?>

                                            </a>
                                            <p class="text-sm text-gray-600"><?php echo e($bot->trading_type); ?> Trading</p>
                                        </div>
                                    </div>

                                    <!-- Right section -->
                                    <span
                                        class="badge bg-green-500/10 text-green-500 px-3 py-1 rounded-md"><?php echo e($bot->success_rate); ?>%
                                        success</span>
                                </div>

                                <div class="p-4">
                                    <p class="line-clamp-2 mb-3">
                                        <?php echo e($bot->description); ?>

                                    </p>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                        <!--:Card 1:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->daily_profit); ?></h4>
                                                <p class="text-sm">Daily Profit</p>
                                            </div>
                                        </div>

                                        <!--:Card 2:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle  shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->duration_days); ?> Days</h4>
                                                <p class="text-sm">Duration</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium">Investment Range:</span>
                                        <span class="text-sm font-semibold">$<?php echo e(number_format($bot->min_amount, 2)); ?>

                                            -
                                            $<?php echo e(number_format($bot->max_amount, 2)); ?> </span>
                                    </div>
                                    <div class="rounded-lg border-dashed mt-3">
                                        <small class="text-xs font-semibold">Trading Pairs:</small>
                                        <h6>
                                            <div class="flex flex-wrap gap-1 mt-2">
                                                <?php $__currentLoopData = explode(',', $bot->trading_pairs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <span class="px-2 py-1 text-xs font-semibold rounded-sm
                                                     bg-sky-500/10 text-blue-800 dark:bg-sky-500/10 dark:text-blue-200 h-5">
                                                                                <?php echo e(trim($pair)); ?>

                                                                            </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </h6>
                                    </div>
                                    <div class="flex items-center justify-between mt-3">
                                        <span
                                            class="flex items-center gap-1 text-xs font-medium text-gray-700 dark:text-gray-300">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M21 19.75c0-2.09-1.67-5.068-4-5.727m-2 5.727c0-2.651-2.686-6-6-6s-6 3.349-6 6m9-12.5a3 3 0 1 1-6 0a3 3 0 0 1 6 0m3 3a3 3 0 1 0 0-6" />
                                            </svg>
                                            <?php echo e($bot->active_users); ?> Active Users
                                        </span>

                                        <span class="text-xs font-semibold">$<?php echo e(number_format($bot->total_earned, 2)); ?>

                                            Total Earned</span>
                                    </div>
                                    <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>" type="button"
                                        class="w-full rounded-md mt-2 h-9 bg-sky-500/10 text-primary flex items-center justify-center gap-2">
                                        Invest Now
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                            class="inline-block">
                                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"
                                                d="m14 16l4-4m0 0l-4-4m4 4H6" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="tab-pane fade" id="profit" role="tabpanel" aria-labelledby="profit-tab" tabindex="0">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                        <!--:Project card:-->
                        <?php $__currentLoopData = $cryptobots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="rounded-xl shadow-card relative bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 transition-all hover:-translate-y-1 transform group">
                                <div class="px-4 pt-4 flex items-center justify-between">
                                    <!-- Left section -->
                                    <div class="flex items-start gap-2">
                                        <!-- SVG -->
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                                viewBox="0 0 48 48">
                                                <g fill="none">
                                                    <path fill="#deeeff"
                                                        d="M23.997 47.997c13.255 0 24-10.745 24-24s-10.745-24-24-24s-24 10.745-24 24s10.745 24 24 24" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 10.906a.87.87 0 0 0-.872-.872h-6.982a.87.87 0 0 0-.873.872l-.872 6.11h10.472z" />
                                                    <path fill="#6bafff"
                                                        d="M30.98 27.488c0 .964-.782 1.746-1.746 1.746H18.76a1.745 1.745 0 0 1-1.745-1.746V17.016h13.963zm-8.729-13.965a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m3.491 0a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m.873 1.965a.655.655 0 0 1-.654.655h-3.928a.655.655 0 0 1 0-1.31h3.928c.361 0 .654.294.654.655" />
                                                    <path fill="#2e3ecd"
                                                        d="M35.342 27.488c0 .964-.781 1.746-1.745 1.746h-.873a1.745 1.745 0 0 1-1.745-1.746V17.016h2.618c.964 0 1.745.781 1.745 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M32.288 30.979v1.745h-1.745V30.98l1.745-1.746h1.746l1.745 1.746v1.745h-1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M12.651 27.488c0 .964.782 1.746 1.746 1.746h.873c.964 0 1.745-.782 1.745-1.746V17.016h-2.618c-.964 0-1.746.781-1.746 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M15.707 30.979v1.745h1.745V30.98l-1.745-1.746H13.96l-1.745 1.746v1.745h1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M23.124 29.233h-4.363v5.237h4.363zm6.11 0H24.87v5.237h4.364z" />
                                                    <path fill="#6bafff"
                                                        d="M17.888 35.343c0-.482.39-.873.872-.873h4.364c.24 0 .436.196.436.437v2.618c0 .24-.195.436-.436.436H18.76a.87.87 0 0 1-.872-.873zm12.218 0a.873.873 0 0 0-.872-.873H24.87a.437.437 0 0 0-.436.437v2.618c0 .24.195.436.436.436h4.364c.482 0 .872-.39.872-.873z" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 27.487a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m-8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m0 6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744" />
                                                </g>
                                            </svg>
                                        </div>

                                        <!-- Texts beside SVG -->
                                        <div class="flex flex-col">
                                            <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>"
                                                class="text-md truncate hover:text-primary font-medium">
                                                <?php echo e($bot->name); ?>

                                            </a>
                                            <p class="text-sm text-gray-600"><?php echo e($bot->trading_type); ?> Trading</p>
                                        </div>
                                    </div>

                                    <!-- Right section -->
                                    <span
                                        class="badge bg-green-500/10 text-green-500 px-3 py-1 rounded-md"><?php echo e($bot->success_rate); ?>%
                                        success</span>
                                </div>

                                <div class="p-4">
                                    <p class="line-clamp-2 mb-3">
                                        <?php echo e($bot->description); ?>

                                    </p>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                        <!--:Card 1:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->daily_profit); ?></h4>
                                                <p class="text-sm">Daily Profit</p>
                                            </div>
                                        </div>

                                        <!--:Card 2:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle  shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->duration_days); ?> Days</h4>
                                                <p class="text-sm">Duration</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium">Investment Range:</span>
                                        <span class="text-sm font-semibold">$<?php echo e(number_format($bot->min_amount, 2)); ?>

                                            -
                                            $<?php echo e(number_format($bot->max_amount, 2)); ?> </span>
                                    </div>
                                    <div class="rounded-lg border-dashed mt-3">
                                        <small class="text-xs font-semibold">Trading Pairs:</small>
                                        <h6>
                                            <div class="flex flex-wrap gap-1 mt-2">
                                                <?php $__currentLoopData = explode(',', $bot->trading_pairs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <span class="px-2 py-1 text-xs font-semibold rounded-sm
                                                     bg-sky-500/10 text-blue-800 dark:bg-sky-500/10 dark:text-blue-200 h-5">
                                                                                <?php echo e(trim($pair)); ?>

                                                                            </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </h6>
                                    </div>
                                    <div class="flex items-center justify-between mt-3">
                                        <span
                                            class="flex items-center gap-1 text-xs font-medium text-gray-700 dark:text-gray-300">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M21 19.75c0-2.09-1.67-5.068-4-5.727m-2 5.727c0-2.651-2.686-6-6-6s-6 3.349-6 6m9-12.5a3 3 0 1 1-6 0a3 3 0 0 1 6 0m3 3a3 3 0 1 0 0-6" />
                                            </svg>
                                            <?php echo e($bot->active_users); ?> Active Users
                                        </span>

                                        <span class="text-xs font-semibold">$<?php echo e(number_format($bot->total_earned, 2)); ?>

                                            Total Earned</span>
                                    </div>
                                    <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>" type="button"
                                        class="w-full rounded-md mt-2 h-9 bg-sky-500/10 text-primary flex items-center justify-center gap-2">
                                        Invest Now
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                            class="inline-block">
                                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"
                                                d="m14 16l4-4m0 0l-4-4m4 4H6" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="tab-pane fade" id="stock" role="tabpanel" aria-labelledby="stock-tab" tabindex="0">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
                        <!--:Project card:-->
                        <?php $__currentLoopData = $stockbots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="rounded-xl shadow-card relative bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 transition-all hover:-translate-y-1 transform group">
                                <div class="px-4 pt-4 flex items-center justify-between">
                                    <!-- Left section -->
                                    <div class="flex items-start gap-2">
                                        <!-- SVG -->
                                        <div class="flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                                viewBox="0 0 48 48">
                                                <g fill="none">
                                                    <path fill="#deeeff"
                                                        d="M23.997 47.997c13.255 0 24-10.745 24-24s-10.745-24-24-24s-24 10.745-24 24s10.745 24 24 24" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 10.906a.87.87 0 0 0-.872-.872h-6.982a.87.87 0 0 0-.873.872l-.872 6.11h10.472z" />
                                                    <path fill="#6bafff"
                                                        d="M30.98 27.488c0 .964-.782 1.746-1.746 1.746H18.76a1.745 1.745 0 0 1-1.745-1.746V17.016h13.963zm-8.729-13.965a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m3.491 0a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m.873 1.965a.655.655 0 0 1-.654.655h-3.928a.655.655 0 0 1 0-1.31h3.928c.361 0 .654.294.654.655" />
                                                    <path fill="#2e3ecd"
                                                        d="M35.342 27.488c0 .964-.781 1.746-1.745 1.746h-.873a1.745 1.745 0 0 1-1.745-1.746V17.016h2.618c.964 0 1.745.781 1.745 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M32.288 30.979v1.745h-1.745V30.98l1.745-1.746h1.746l1.745 1.746v1.745h-1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M12.651 27.488c0 .964.782 1.746 1.746 1.746h.873c.964 0 1.745-.782 1.745-1.746V17.016h-2.618c-.964 0-1.746.781-1.746 1.745z" />
                                                    <path fill="#6bafff"
                                                        d="M15.707 30.979v1.745h1.745V30.98l-1.745-1.746H13.96l-1.745 1.746v1.745h1.745V30.98z" />
                                                    <path fill="#2e3ecd"
                                                        d="M23.124 29.233h-4.363v5.237h4.363zm6.11 0H24.87v5.237h4.364z" />
                                                    <path fill="#6bafff"
                                                        d="M17.888 35.343c0-.482.39-.873.872-.873h4.364c.24 0 .436.196.436.437v2.618c0 .24-.195.436-.436.436H18.76a.87.87 0 0 1-.872-.873zm12.218 0a.873.873 0 0 0-.872-.873H24.87a.437.437 0 0 0-.436.437v2.618c0 .24.195.436.436.436h4.364c.482 0 .872-.39.872-.873z" />
                                                    <path fill="#2e3ecd"
                                                        d="M28.36 27.487a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m-8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m0 6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744m8.727-6.982a.872.872 0 1 0 0-1.744a.872.872 0 0 0 0 1.744" />
                                                </g>
                                            </svg>
                                        </div>

                                        <!-- Texts beside SVG -->
                                        <div class="flex flex-col">
                                            <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>"
                                                class="text-md truncate hover:text-primary font-medium">
                                                <?php echo e($bot->name); ?>

                                            </a>
                                            <p class="text-sm text-gray-600"><?php echo e($bot->trading_type); ?> Trading</p>
                                        </div>
                                    </div>

                                    <!-- Right section -->
                                    <span
                                        class="badge bg-green-500/10 text-green-500 px-3 py-1 rounded-md"><?php echo e($bot->success_rate); ?>%
                                        success</span>
                                </div>

                                <div class="p-4">
                                    <p class="line-clamp-2 mb-3">
                                        <?php echo e($bot->description); ?>

                                    </p>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                        <!--:Card 1:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->daily_profit); ?></h4>
                                                <p class="text-sm">Daily Profit</p>
                                            </div>
                                        </div>

                                        <!--:Card 2:-->
                                        <div
                                            class="rounded-md flex items-center gap-4 bg-primary-subtle dark:bg-primary-subtle  shadow-card p-2 overflow-hidden">
                                            <div class="flex-grow text-center">
                                                <h4 class="text-l"><?php echo e($bot->duration_days); ?> Days</h4>
                                                <p class="text-sm">Duration</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium">Investment Range:</span>
                                        <span class="text-sm font-semibold">$<?php echo e(number_format($bot->min_amount, 2)); ?>

                                            -
                                            $<?php echo e(number_format($bot->max_amount, 2)); ?> </span>
                                    </div>
                                    <div class="rounded-lg border-dashed mt-3">
                                        <small class="text-xs font-semibold">Trading Pairs:</small>
                                        <h6>
                                            <div class="flex flex-wrap gap-1 mt-2">
                                                <?php $__currentLoopData = explode(',', $bot->trading_pairs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <span class="px-2 py-1 text-xs font-semibold rounded-sm
                                                     bg-sky-500/10 text-blue-800 dark:bg-sky-500/10 dark:text-blue-200 h-5">
                                                                                <?php echo e(trim($pair)); ?>

                                                                            </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </h6>
                                    </div>
                                    <div class="flex items-center justify-between mt-3">
                                        <span
                                            class="flex items-center gap-1 text-xs font-medium text-gray-700 dark:text-gray-300">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M21 19.75c0-2.09-1.67-5.068-4-5.727m-2 5.727c0-2.651-2.686-6-6-6s-6 3.349-6 6m9-12.5a3 3 0 1 1-6 0a3 3 0 0 1 6 0m3 3a3 3 0 1 0 0-6" />
                                            </svg>
                                            <?php echo e($bot->active_users); ?> Active Users
                                        </span>

                                        <span class="text-xs font-semibold">$<?php echo e(number_format($bot->total_earned, 2)); ?>

                                            Total Earned</span>
                                    </div>
                                    <a href="<?php echo e(route('user.botdetails', ['name' => $bot->name])); ?>" type="button"
                                        class="w-full rounded-md mt-2 h-9 bg-sky-500/10 text-primary flex items-center justify-center gap-2">
                                        Invest Now
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                            class="inline-block">
                                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-miterlimit="10" stroke-width="1.5"
                                                d="m14 16l4-4m0 0l-4-4m4 4H6" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/bot_ai_trading.blade.php ENDPATH**/ ?>