<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AiBotController;
use App\Http\Controllers\AssetsController;
use App\Http\Controllers\CryptoController;
use App\Http\Controllers\GoogleController;
use App\Http\Controllers\PayPalController;
use App\Http\Controllers\SignalController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DepositController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\StakingController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\LiveTradeController;
use App\Http\Controllers\TwoFactorController;
use App\Http\Controllers\AccessCodeController;
use App\Http\Controllers\InvestmentController;
use App\Http\Controllers\RealEstateController;
use App\Http\Controllers\WithdrawalController;
use App\Http\Controllers\LoginAsUserController;
use App\Http\Controllers\StakingPlanController;
use App\Http\Controllers\TradeExpertController;
use App\Http\Controllers\UserCopyTradeController;
use App\Http\Controllers\InvestmentPlanController;
use App\Http\Controllers\WebsiteSettingController;
use App\Http\Controllers\Auth\AdminLoginController;
use App\Http\Controllers\KycVerificationController;
use App\Http\Controllers\RealEstateInvestmentController;

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/search-instruments', [HomeController::class, 'search']);

Route::get('/cron/run/{key}', [CronController::class, 'processAllCommands']);

Route::get('/', [HomeController::class, 'indexhome'])->name('home.index');

Route::get('cryptocurrencies', [HomeController::class, 'indexcrypto'])->name('home.cryptocurrencies');

Route::get('forex', [HomeController::class, 'indexforex'])->name('home.forex');

Route::get('shares', [HomeController::class, 'indexshares'])->name('home.shares');

Route::get('indices', [HomeController::class, 'indexindices'])->name('home.indices');

Route::get('etfs', [HomeController::class, 'indexetfs'])->name('home.etfs');

Route::get('automate', [HomeController::class, 'indexautomate'])->name('home.automate');

Route::get('copy', [HomeController::class, 'indexcopy'])->name('home.copy');

Route::get('trade', [HomeController::class, 'indextrade'])->name('home.trade');

Route::get('why', [HomeController::class, 'indexwhy'])->name('home.why');

Route::get('regulation', [HomeController::class, 'indexregulation'])->name('home.regulation');

Route::get('contact', [HomeController::class, 'indexcontact'])->name('home.contact');

Route::post('contact_store', [SupportController::class, 'homecontactstore'])->name('home.contactstore');

Route::get('for-traders', [HomeController::class, 'indexeducation'])->name('home.for-traders');

Route::get('about', [HomeController::class, 'indexabout'])->name('home.about');

Route::get('faq', [HomeController::class, 'indexfaq'])->name('home.faq');

Route::get('terms', [HomeController::class, 'indexterms'])->name('home.terms');

Route::get('privacy', [HomeController::class, 'indexprivacy'])->name('home.privacy');

Route::get('legals', [HomeController::class, 'indexlegals'])->name('home.legals');

Route::get('trading-conditions', [HomeController::class, 'indextradingconditions'])->name('home.trading-conditions');

Route::get('access', [AccessCodeController::class, 'access_code'])->name('access-code.form');

Route::post('/access-code', [AccessCodeController::class, 'access_code_submit'])->name('access-code.submit');

Route::get('/assets', [AssetsController::class, 'assetsindex']);
Route::get('/assets/{asset}', [AssetsController::class, 'assetsshow']);

Route::get('/auth/google', [GoogleController::class, 'redirect'])->name('google.redirect');
Route::get('/auth/google/callback', [GoogleController::class, 'callback'])->name('google.callback');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';


Route::middleware(['auth', 'verified', 'checkstatus', 'role:user'])->group(function () {

    Route::get('user/dashboard', [UserController::class, 'userdashboard'])->name('user.dashboard');

    Route::get('user/statement', [UserController::class, 'userstatement'])->name('user.statement');

    Route::get('user/portfolio', [UserController::class, 'userportfolio'])->name('user.portfolio');

    Route::get('user/investment', [UserController::class, 'userinvestment'])->name('user.investment');

    Route::get('user/investment_details/{id}', [UserController::class, 'userinvestmentdetails'])->name('user.investment_details');

    Route::post('/invest/{plan_id}', [InvestmentController::class, 'storeuserinvestment'])->name('storeuser.invest');

    Route::get('user/profile', [UserController::class, 'userprofile'])->name('user.profile');

    Route::post('user/profile', [UserController::class, 'updateuserprofile'])->name('user.profileupdate');

    Route::get('/settings', [UserController::class, 'usersettings'])->name('user.settings');

    Route::get('user/market', [UserController::class, 'usermarket'])->name('user.market');

    Route::get('user/trade', [UserController::class, 'usertrade'])->name('user.trade');

    Route::get('user/live_trades', [UserController::class, 'userlivetrade'])->name('user.live_trade');

    Route::get('user/monitor_trade/{id}', [UserController::class, 'usermonitortrade'])->name('user.monitor_trade');

    Route::get('user/trade_details/{id}', [UserController::class, 'usertradedetails'])->name('user.trade_details');

    Route::post('/orders/place', [LiveTradeController::class, 'userlivestore'])->name('orders.place');

    Route::post('/user/stop_trade/{id}', [LiveTradeController::class, 'userstopTrade'])->name('user.stop_trade');

    //AI BOT
    Route::get('user/bot_ai_trading', [UserController::class, 'userbottrade'])->name('user.bottrade');

    Route::get('user/bot_dashboard', [UserController::class, 'userbotdashboard'])->name('user.botdashboard');

    Route::get('user/bot_details/{name}', [AiBotController::class, 'userbotdetails'])->name('user.botdetails');

    Route::post('/bots/{bot:name}/start', [AiBotController::class, 'startbottrade'])->name('userbots.start');

    Route::post('/user/bots/{bot:name}/stop', [AiBotController::class, 'stopBotTradeByBotName'])
        ->name('userbots.stopbybot');

    //COPY TRADE
    Route::get('user/copy_trading', [UserController::class, 'usercopytrade'])->name('user.copytrade');

    Route::get('user/copy_experts', [UserController::class, 'usercopyexperts'])->name('user.copyexperts');

    Route::post('user/copy_tradedetails/{id}', [UserCopyTradeController::class, 'userstopcopy'])->name('user.copytrade.stop');

    Route::post('/user/copytrade/start/{expert_id}', [UserCopyTradeController::class, 'startusercopy'])
        ->name('user.copytrade.start');

    //CONNECT WALLET
    Route::get('user/connectwallet', [UserController::class, 'userconnectwallet'])->name('user.connectwallet');

    Route::post('user/storewallet', [WalletController::class, 'userwalletstore'])->name('user.connectwalletstore');

    Route::get('user/referrals', [UserController::class, 'userreferrals'])->name('user.referrals');

    //WITHDRAWAL
    Route::get('user/withdrawal', [WithdrawalController::class, 'userwithdrawal'])->middleware(['auth', 'withdrawal.access'])->name('user.withdrawal');

    Route::post('user/withdrawal_store', [WithdrawalController::class, 'userwithdrawalstore'])->name('user.withdrawal.store');

    Route::get('user/withdrawal_access', [WithdrawalController::class, 'userwithdrawalaccess'])->name('user.withdrawalaccess');

    Route::post('/withdrawal-access', [WithdrawalController::class, 'verifyAccess'])->middleware('auth')->name('withdrawal.verify');

    //DEPOSIT
    Route::get('user/deposit', [DepositController::class, 'userdeposit'])->name('user.deposit');

    Route::post('/deposit/confirm', [DepositController::class, 'handleConfirm'])->name('user.deposit.handleConfirm');

    Route::get('user/deposit_confirm', [DepositController::class, 'confirmDeposit'])->name('user.deposit_confirm');

    Route::post('/deposit/store', [DepositController::class, 'storeDeposit'])->name('user.deposit.store');

    //KYC VERIFICATION
    Route::get('user/verify_account', [UserController::class, 'userkycindex'])->name('user.kyc.index');

    Route::get('user/start_verification', [UserController::class, 'userkycstart'])->name('user.kyc.start');

    Route::post('user/start_kyc', [KycVerificationController::class, 'startkyc'])->name('user.kyc.startstore');

    //SUPPORT
    Route::get('user/support', [UserController::class, 'usersupport'])->name('user.support');

    Route::post('user/support_store', [SupportController::class, 'usersupportstore'])->name('user.support_store');

    //INTERNAL TRANSFER
    Route::get('user/internal_transfer', [TransferController::class, 'showusertransfer'])->name('user.internal_transfer');

    Route::post('/transfer_store', [TransferController::class, 'storeusertransfer'])->name('user.transfer.send');


    //LOAN MANAGEMENT
    Route::get('user/apply_loan', [LoanController::class, 'showuserloanapply'])->name('user.apply_loan');

    Route::post('user/loan_store', [LoanController::class, 'storeuserloan'])->name('user.loan.store');

    Route::get('user/loan_history', [LoanController::class, 'showuserloanhistory'])->name('user.loan_history');

    Route::get('user/activity_log', [UserController::class, 'showuseractivitylog'])->name('user.activity_log');

    Route::get('user/swap', [UserController::class, 'showswapfund'])->name('user.swap_fund');

    Route::post('/user/swap-funds', [UserController::class, 'swapFunds'])->name('user.swapFunds');


    //SIGNALS
    Route::get('user/signals', [SignalController::class, 'showusersignal'])->name('user.signals');

    Route::get('user/signal_details/{id}', [SignalController::class, 'showusersignaldetails'])->name('user.signals.details');

    Route::post('user/store_signal', [SignalController::class, 'userstoresignal'])->name('user.store.signal');


    //REAL ESTATE
    Route::get('user/real_estate', [RealEstateController::class, 'showuserreal'])->name('user.real_estate');

    Route::get('user/realestate_details/{real}', [RealEstateController::class, 'showuserrealdetails'])->name('user.real.details');

    Route::post('/real-estate/{id}/invest', [RealEstateInvestmentController::class, 'investrealestate'])->name('user.realestate.invest');

    Route::get('user/estate_invest_details/{id}', [RealEstateController::class, 'realestateinvestdetails'])->name('user.realestate.details');

    //STAKING
    Route::get('user/staking', [StakingController::class, 'showuserstaking'])->name('user.staking');
    // Route::get('user/signal_details/{id}', [StakingController::class, 'showusersignaldetails'])->name('user.signals.details');
    Route::post('user/store_staking', [StakingController::class, 'userstorestaking'])->name('user.store.staking');


    //PAYPAL
    Route::get('paypal/checkout', [PayPalController::class, 'checkout'])->name('paypal.checkout');
    Route::get('paypal/payment/success', [PayPalController::class, 'success'])->name('paypal.success');
    Route::get('paypal/payment/cancel', [PayPalController::class, 'cancel'])->name('paypal.cancel');

    Route::get('user/2fa_setup', [TwoFactorController::class, 'enable2FA'])->name('2fa.setup');
    Route::post('/2fa/enable', [TwoFactorController::class, 'store2FA'])->name('2fa.enable');
    Route::post('/2fa/verify', [TwoFactorController::class, 'verify2FA'])->name('2fa.verify');

    Route::get('auth/2fa_verify', [TwoFactorController::class, 'showVerifyForm'])->name('2fa.verify.form');
    Route::post('/2fa/verify', [TwoFactorController::class, 'login2faverify'])->name('login.2fa.verify');
    Route::post('/2fa/disable', [TwoFactorController::class, 'disable2fa'])->name('2fa.disable');
});

// Stop impersonating
Route::get('/admin/impersonate/stop', [LoginAsUserController::class, 'adminstoploginasuser'])->name('admin.impersonate.stop');

Route::get('/adminaccess/login', [AdminLoginController::class, 'showadminLoginForm'])->middleware('guest')->name('admin.login');
Route::post('/admin/login', [AdminLoginController::class, 'adminlogin']);
Route::post('/admin/logout', [AdminLoginController::class, 'adminlogout'])->name('admin.logout');


Route::middleware(['auth', 'role:admin'])->group(function () {

    Route::get('admin/dashboard', [AdminController::class, 'admindashboard'])->name('admin.dashboard');

    Route::get('admin/profile', [AdminController::class, 'adminprofile'])->name('admin.profile');

    Route::post('admin/profile/update', [AdminController::class, 'adminprofileupdate'])->name('admin.profile.update');

    //USER MANAGEMENT
    Route::get('admin/users/index', [AdminController::class, 'adminuserindex'])->name('admin.user.index');

    Route::get('admin/users/edit/{id}', [AdminController::class, 'adminuserdetails'])->name('admin.user.details');

    Route::post('admin/users/update/{id}', [AdminController::class, 'adminuserupdate'])->name('admin.user.update');

    Route::post('admin/users/destroy/{id}', [AdminController::class, 'adminuserdestroy'])->name('admin.user.destroy');


    //DEPOSIT
    Route::get('admin/deposit/index', [DepositController::class, 'admindepositindex'])->name('admin.deposit.index');

    Route::get('admin/deposit/details/{id}', [DepositController::class, 'admindepositdetails'])->name('admin.deposit.details');

    Route::post('/admin/deposit/status/{id}', [DepositController::class, 'admindepositstatus'])->name('admin.deposit.status');

    Route::get('admin/deposit/gateway', [DepositController::class, 'adminpaymentgateway'])->name('admin.gateway.index');

    Route::get('admin/deposit/add_gateway', [DepositController::class, 'adminpaymentgatewayadd'])->name('admin.gateway.add');

    Route::post('admin/deposit/store_gateway', [DepositController::class, 'adminpaymentgatewaystore'])->name('admin.gateway.store');

    Route::get('admin/deposit/edit_gateway/{id}', [DepositController::class, 'adminpaymentgatewayedit'])->name('admin.gateway.edit');

    Route::post('admin/deposit/update_gateway/{id}', [DepositController::class, 'adminpaymentgatewayupdate'])->name('admin.gateway.update');


    //INVESTMENT
    Route::get('admin/investment/plan', [InvestmentPlanController::class, 'admininvestplanindex'])->name('admin.invest.plan');

    Route::get('admin/investment/add_plan', [InvestmentPlanController::class, 'admininvestplanadd'])->name('admin.invest.add_plan');

    Route::post('admin/investment/store_plan', [InvestmentPlanController::class, 'adminplanstore'])->name('admin.plans.store');

    Route::get('admin/investment/edit_plan/{id}', [InvestmentPlanController::class, 'admininvestplanedit'])->name('admin.invest.edit_plan');

    Route::put('admin/plan/update/{id}', [InvestmentPlanController::class, 'admininvestplanupdate'])->name('admin.plans.update');

    Route::get('admin/investment/invest', [InvestmentController::class, 'adminuserinvest'])->name('admin.investment.invest');



    Route::get('admin/live/trade', [InvestmentController::class, 'adminuserlivetrade'])->name('admin.user.live_trade');

    Route::post('/admin/users/{id}/adjust-funds', [AdminController::class, 'adjustUserFunds'])
        ->name('admin.adjust.funds');


    //SETTINGS
    Route::get('admin/website_settings', [WebsiteSettingController::class, 'adminwebsitesetting'])->name('admin.website.index');

    Route::put('admin/website_update', [WebsiteSettingController::class, 'websitesettingupdate'])->name('admin.website.update');

    Route::get('admin/email_settings', [WebsiteSettingController::class, 'adminemailsettings'])->name('admin.email.index');

    Route::put('admin/smtp_settings', [WebsiteSettingController::class, 'updateSmtpSettings'])->name('admin.email.update');



    //AI BOT
    Route::get('admin/aibot/index', [AiBotController::class, 'adminaibotindex'])->name('admin.aibot.index');

    Route::get('admin/aibot/create', [AiBotController::class, 'adminaibotcreate'])->name('admin.aibot.create');

    Route::get('admin/aibot/edit/{id}', [AiBotController::class, 'adminaibotedit'])->name('admin.aibot.edit');

    Route::post('admin/aibot/store', [AiBotController::class, 'aibotstore'])->name('admin.aibot.store');

    Route::post('admin/aibot/update/{id}', [AiBotController::class, 'aibotupdate'])->name('admin.aibot.update');

    Route::delete('aibot/{id}', [AiBotController::class, 'aibotdestroy'])->name('admin.aibot.destroy');

    Route::get('/run-daily-bot-update', [AiBotController::class, 'dailyBotProfitUpdate'])
        ->name('bots.daily.update');

    Route::get('admin/aibot/bot_trades', [AiBotController::class, 'adminaibottrades'])->name('admin.aibot.trades');


    //SIGNALS
    Route::get('admin/signal/index', [SignalController::class, 'adminsignalindex'])->name('admin.signal.index');

    Route::get('admin/signal/add', [SignalController::class, 'adminsignaladd'])->name('admin.signal.add');

    Route::get('admin/signal/edit/{id}', [SignalController::class, 'adminsignaledit'])->name('admin.signal.edit');

    Route::post('admin/signal/store', [SignalController::class, 'admincreatesignal'])->name('admin.signal.store');

    Route::post('/admin/signals/update/{id}', [SignalController::class, 'adminupdatesignal'])->name('admin.signal.update');

    Route::delete('signal_destroy/{signal}', [SignalController::class, 'signaldestroy'])->name('admin.signal.destroy');

    Route::get('admin/signal/deposit', [SignalController::class, 'adminusersignal'])->name('admin.signal.deposit');

    Route::get('admin/signal/details/{id}', [SignalController::class, 'adminsignaldeposit'])->name('admin.signal.deposit_details');

    Route::post('admin/signaldeposit/update/{id}', [SignalController::class, 'adminsignaldepositupdate'])->name('admin.signaldeposit.update');


    //REAL ESTATE
    Route::get('admin/realestate/index', [RealEstateController::class, 'adminrealindex'])->name('admin.realestate.index');

    Route::get('admin/realestate/add', [RealEstateController::class, 'adminrealadd'])->name('admin.realestate.add');

    Route::post('admin/realestate/store', [RealEstateController::class, 'adminrealstore'])->name('admin.realestate.store');

    Route::get('admin/realestate/edit/{id}', [RealEstateController::class, 'adminrealedit'])->name('admin.realestate.edit');

    Route::post('real-estates/update/{id}', [RealEstateController::class, 'adminrealupdate'])->name('admin.realestate.update');

    Route::delete('real-estates/{realEstate}', [RealEstateController::class, 'adminrealdestroy'])->name('admin.realestate.destroy');

    Route::get('admin/realestate/trades', [RealEstateController::class, 'adminuserestate'])->name('admin.realestate.trades');

    //STAKING ADMIN
    Route::get('admin/staking/index', [StakingPlanController::class, 'adminstakingindex'])->name('admin.staking.index');

    Route::get('admin/staking/add', [StakingPlanController::class, 'adminstakingadd'])->name('admin.staking.add');

    Route::get('admin/staking/edit/{id}', [StakingPlanController::class, 'adminstakingedit'])->name('admin.staking.edit');

    Route::post('admin/staking/store', [StakingPlanController::class, 'adminstakestore'])->name('admin.staking.store');

    Route::post('/admin/staking/update/{id}', [StakingPlanController::class, 'adminstakeupdate'])->name('admin.staking.update');

    Route::delete('staking_destroy/{staking}', [StakingPlanController::class, 'stakingdestroy'])->name('admin.staking.destroy');

    Route::get('admin/staking/trades', [StakingController::class, 'adminuserstake'])->name('admin.staking.trades');


    // Route::get('/run-daily-bot-update', [AiBotController::class, 'dailyBotProfitUpdate'])
    //     ->name('bots.daily.update');

    // Route::get('admin/aibot/bot_trades', [AiBotController::class, 'adminaibottrades'])->name('admin.aibot.trades');


    //CONTACT
    Route::get('admin/contact_request', [ContactController::class, 'admincontactrequest'])->name('admin.contact.request');

    Route::get('admin/contact_details/{id}', [ContactController::class, 'admincontactrequestdetails'])->name('admin.contact.details');


    //COPY TRADE EXPERTS
    Route::get('admin/experts/index', [TradeExpertController::class, 'expertindex'])->name('admin.experts.index');

    Route::get('admin/experts/create', [TradeExpertController::class, 'expertcreate'])->name('admin.experts.create');

    Route::post('admin/experts/store', [TradeExpertController::class, 'expertstore'])->name('admin.experts.store');

    Route::get('admin/experts/edit/{id}', [TradeExpertController::class, 'expertsedit'])->name('admin.experts.edit');

    Route::post('admin/experts/update/{id}', [TradeExpertController::class, 'expertupdate'])->name('admin.experts.update');

    Route::delete('copytrade/{id}', [TradeExpertController::class, 'destroy'])->name('admin.copytrade.destroy');

    Route::get('admin/copy/trades', [TradeExpertController::class, 'adminusercopytrades'])->name('admin.copytrade.user_trade');


    //WITHDRAWAL
    Route::get('admin/withdraw/index', [WithdrawalController::class, 'adminwithdrawindex'])->name('admin.withdraw.index');

    Route::get('admin/withdraw/details/{id}', [WithdrawalController::class, 'adminwithdrawdetails'])->name('admin.withdrawdetails');

    Route::post('/withdrawals/{id}/approve', [WithdrawalController::class, 'adminapprovewith'])->name('withdrawals.approve');

    Route::post('/withdrawals/{id}/reject', [WithdrawalController::class, 'adminrejectwith'])->name('withdrawals.reject');



    //CRYPTOS
    Route::get('admin/crypto/index', [CryptoController::class, 'admincryptoindex'])->name('admin.crypto.index');

    Route::get('admin/crypto/edit/{id}', [CryptoController::class, 'admincryptoedit'])->name('admin.crypto.edit');

    Route::post('admin/crypto/update/{id}', [CryptoController::class, 'admincryptoupdate'])->name('admin.crypto.update');

    Route::post('/withdrawals/{id}/reject', [CryptoController::class, 'adminrejectwith'])->name('admin.crypto.destroy');


    //WALLET
    Route::get('admin/wallet/index', [WalletController::class, 'walletindex'])->name('admin.wallet.index');

    Route::get('admin/wallet/create', [WalletController::class, 'walletcreate'])->name('admin.wallet.create');

    Route::post('admin/wallet/store', [WalletController::class, 'walletstore'])->name('admin.wallet.store');

    Route::get('admin/wallet/edit/{id}', [WalletController::class, 'walletedit'])->name('admin.wallet.edit');

    Route::put('admin/wallet/update/{id}', [WalletController::class, 'walletupdate'])->name('admin.wallet.update');

    Route::get('admin/wallet/connections', [WalletController::class, 'walletconnections'])->name('admin.wallet.connections');

    Route::get('admin/wallet/connect_details/{id}', [WalletController::class, 'walletconnectionsdetails'])->name('admin.wallet.connect_details');

    Route::put('admin/wallet/connect_update/{id}', [WalletController::class, 'walletconnectupdate'])->name('admin.wallet.connect_update');


    //LOAN MANAGEMENT
    Route::get('admin/loan/type', [LoanController::class, 'adminloantype'])->name('admin.loan.type');

    Route::get('admin/loan/type_edit/{id}', [LoanController::class, 'adminloanedittype'])->name('admin.loan.type_edit');

    Route::post('admin/loan/type_store', [LoanController::class, 'adminloanstoretype'])->name('admin.loan.type_store');

    Route::put('admin/loan/type_update/{id}', [LoanController::class, 'adminloanupdatetype'])->name('admin.loan.type_update');

    Route::get('admin/loan/application', [LoanController::class, 'adminloanindex'])->name('admin.loan.index');

    Route::get('admin/loan/user_loan/{id}', [LoanController::class, 'adminuserloans'])->name('admin.loan.user_loan');

    Route::post('admin/loan/loan_update/{id}', [LoanController::class, 'updateLoanStatus'])->name('admin.loan.loan_update');


    //KYC VERIFICATION
    Route::get('admin/kyc/index', [KycVerificationController::class, 'adminkycindex'])->name('admin.kyc.index');

    Route::get('admin/kyc/details/{id}', [KycVerificationController::class, 'adminkycdetails'])->name('admin.kyc.details');

    Route::post('admin/kyc/update/{id}', [KycVerificationController::class, 'updatekycStatus'])->name('admin.kyc.update');


    //API MANAGEMENT
    Route::get('admin/api_management', [ApiController::class, 'apimanagement'])->name('admin.api_management');

    Route::post('admin/api-management', [ApiController::class, 'apiupdate'])->name('admin.api.management.update');


    // LOGIN AS USER
    // Impersonate user
    Route::get('/admin/impersonate/{id}', [LoginAsUserController::class, 'adminstartloginasuser'])->name('admin.impersonate');
});
