@if ($paginator->hasPages())
    <ul class="flex items-center gap-0.5 sm:flex">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li class="opacity-50 cursor-not-allowed">
                <span class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-500">‹</span>
            </li>
        @else
            <li>
                <a href="{{ $paginator->previousPageUrl() }}"
                    class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-700 hover:bg-brand-500/[0.08] hover:text-brand-500 dark:text-gray-400 dark:hover:text-brand-500">‹</a>
            </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            @if (is_string($element))
                <li><span
                        class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-400">{{ $element }}</span>
                </li>
            @endif

            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li>
                            <span
                                class="bg-brand-500/[0.08] text-brand-500 flex h-10 w-10 items-center justify-center rounded-lg font-medium">
                                {{ $page }}
                            </span>
                        </li>
                    @else
                        <li>
                            <a href="{{ $url }}"
                                class="text-theme-sm hover:bg-brand-500/[0.08] hover:text-brand-500 dark:hover:text-brand-500 flex h-10 w-10 items-center justify-center rounded-lg font-medium text-gray-700 dark:text-gray-400">
                                {{ $page }}
                            </a>
                        </li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li>
                <a href="{{ $paginator->nextPageUrl() }}"
                    class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-700 hover:bg-brand-500/[0.08] hover:text-brand-500 dark:text-gray-400 dark:hover:text-brand-500">›</a>
            </li>
        @else
            <li class="opacity-50 cursor-not-allowed">
                <span class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-500">›</span>
            </li>
        @endif
    </ul>
@endif
