<x-user :title="$pageTitle">
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 sm:mb-0">
            <h2 class="text-lg font-semibold mb-1 text-black dark:text-white">📈 Monitor {{ $trade->asset_name }}</h2>
            <p>Track and manage your active investment portfolios</p>
        </div>
        <div class="shrink-0">
            @if ($trade->status === 'open')
                <form action="{{ route('user.stop_trade', $trade->id) }}" method="POST">
                    @csrf
                    <button type="submit"
                        class="btn bg-red-500/10 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-200 px-4 py-2 rounded-lg font-semibold">
                        Close Trade
                    </button>
                </form>
            @else
                <button type="button"
                    class="btn bg-sky-500/10 text-gray-500 cursor-not-allowed px-4 py-2 rounded-lg font-semibold"
                    disabled>
                    {{ ucfirst($trade->status) }}
                </button>
            @endif
        </div>
    </div>
    @php
        // Extract base symbol (e.g. BTC/USD → BTC)
        $baseSymbol = strtoupper(explode('/', $trade->symbol)[0] ?? '');

        // ---- 15 CRYPTO ----
        $coinLogos = [
            'BTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1.png',
            'ETH' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1027.png',
            'BNB' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1839.png',
            'SOL' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/5426.png',
            'XRP' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/52.png',
            'ADA' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2010.png',
            'DOGE' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/74.png',
            'DOT' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/6636.png',
            'LTC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/2.png',
            'AVAX' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/5805.png',
            'TRX' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1958.png',
            'MATIC' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/3890.png',
            'LINK' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/1975.png',
            'UNI' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/7083.png',
            'XLM' => 'https://s2.coinmarketcap.com/static/img/coins/64x64/512.png',
        ];

        // ---- 15 FOREX ----
        $forexLogos = [
            'EUR' => 'https://flagsapi.com/EU/flat/64.png',
            'USD' => 'https://flagsapi.com/US/flat/64.png',
            'GBP' => 'https://flagsapi.com/GB/flat/64.png',
            'JPY' => 'https://flagsapi.com/JP/flat/64.png',
            'AUD' => 'https://flagsapi.com/AU/flat/64.png',
            'CAD' => 'https://flagsapi.com/CA/flat/64.png',
            'CHF' => 'https://flagsapi.com/CH/flat/64.png',
            'NZD' => 'https://flagsapi.com/NZ/flat/64.png',
            'CNY' => 'https://flagsapi.com/CN/flat/64.png',
            'SEK' => 'https://flagsapi.com/SE/flat/64.png',
            'NOK' => 'https://flagsapi.com/NO/flat/64.png',
            'ZAR' => 'https://flagsapi.com/ZA/flat/64.png',
            'HKD' => 'https://flagsapi.com/HK/flat/64.png',
            'SGD' => 'https://flagsapi.com/SG/flat/64.png',
            'INR' => 'https://flagsapi.com/IN/flat/64.png',
        ];

        // ---- 15 STOCKS ----
        $stockLogos = [
            'AAPL' => 'https://logo.clearbit.com/apple.com',
            'TSLA' => 'https://logo.clearbit.com/tesla.com',
            'MSFT' => 'https://logo.clearbit.com/microsoft.com',
            'GOOGL' => 'https://logo.clearbit.com/abc.xyz',
            'AMZN' => 'https://logo.clearbit.com/amazon.com',
            'META' => 'https://logo.clearbit.com/meta.com',
            'NFLX' => 'https://logo.clearbit.com/netflix.com',
            'NVDA' => 'https://logo.clearbit.com/nvidia.com',
            'INTC' => 'https://logo.clearbit.com/intel.com',
            'AMD' => 'https://logo.clearbit.com/amd.com',
            'IBM' => 'https://logo.clearbit.com/ibm.com',
            'ORCL' => 'https://logo.clearbit.com/oracle.com',
            'DIS' => 'https://logo.clearbit.com/disney.com',
            'KO' => 'https://logo.clearbit.com/coca-cola.com',
            'PEP' => 'https://logo.clearbit.com/pepsico.com',
        ];

        // Combine all
        $allLogos = array_merge($coinLogos, $forexLogos, $stockLogos);

        $logoUrl = $allLogos[$baseSymbol] ?? null;
    @endphp

    <div class="content flex-grow pt-4 lg:px-4">
        <div class="px-2 gap-4">
            <div class="lg:col-span-8">
                <div class="rounded-xl border-zinc-700 dark:border-zinc-700 border gap-4 mb-4">
                    <!--:Card:-->
                    <div
                        class="rounded-xl w-full flex justify-between items-center bg-white dark:bg-zinc-900 shadow-card p-4 overflow-hidden">

                        {{-- 🔹 LEFT SIDE — Logo, Side, Asset Name, Created Date --}}
                        <div class="flex items-center gap-3">
                            {{-- Asset Logo --}}
                            @if ($logoUrl)
                                <img src="{{ $logoUrl }}" alt="{{ $baseSymbol }} logo"
                                    class="w-16 h-16 rounded-full border border-zinc-900 shadow">
                            @else
                                <span
                                    class="inline-block w-16 h-16 rounded-full bg-gray-300 text-gray-600 text-lg font-bold flex items-center justify-center">
                                    {{ substr($baseSymbol, 0, 1) }}
                                </span>
                            @endif

                            {{-- Trade Info --}}
                            <div class="flex flex-col">
                                <div class="flex items-center">
                                    {{-- Side Badge --}}
                                    <span
                                        class="px-2 py-0.5 text-md font-semibold rounded bg-gradient-to-br from-indigo-500 to-purple-600 text-white">
                                        {{ strtoupper($trade->side) }}
                                    </span>

                                    {{-- Asset Name --}}
                                    <h4 class="text-base font-semibold text-gray-800 dark:text-gray-200">
                                        {{ strtoupper($trade->asset_name) }}
                                    </h4>
                                </div>

                                {{-- Trade Date --}}
                                <p class="text-xs text-gray-500 mt-1">
                                    {{ $trade->created_at->format('M d, Y h:i A') }}
                                </p>
                            </div>
                        </div>

                        {{-- 🔸 RIGHT SIDE — Status, Amount, Leverage --}}
                        <div class="flex flex-col items-end text-right">
                            {{-- ✅ Status Badge --}}
                            <span
                                class="flex items-center gap-1 px-2 py-0.5 rounded-full text-xs font-medium
                                @if ($trade->status === 'closed') bg-red-500/10 text-red-500
                                @elseif($trade->status === 'completed')
                                    bg-green-500/10 text-green-500
                                @else
                                    bg-yellow-500/10 text-yellow-500 @endif">
                                @if ($trade->status === 'closed')
                                    {{-- ❌ Closed Icon --}}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                        viewBox="0 0 24 24">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2"
                                            d="M6.758 17.243L12.001 12m5.243-5.243L12 12m0 0L6.758 6.757M12.001 12l5.243 5.243" />
                                    </svg>
                                @elseif($trade->status === 'completed')
                                    {{-- ✅ Completed Icon --}}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                        viewBox="0 0 2048 2048">
                                        <path fill="currentColor"
                                            d="M1837 557L768 1627l-557-558l90-90l467 466l979-978z" />
                                    </svg>
                                @else
                                    {{-- ⏳ Open Icon --}}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                        viewBox="0 0 24 24">
                                        <path fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            d="M12 6v6l4 2m6-2a10 10 0 1 1-20 0a10 10 0 0 1 20 0Z" />
                                    </svg>
                                @endif

                                {{ ucfirst($trade->status) }}
                            </span>

                            {{-- 💰 Amount / Price --}}
                            <p class="mt-1 text-base font-semibold text-green-600 dark:text-green-400">
                                {{ $trade->amount ? '$' . number_format($trade->amount, 2) : 'N/A' }}
                            </p>

                            {{-- ⚙️ Leverage --}}
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                                Leverage: <span
                                    class="font-medium text-gray-700 dark:text-gray-200">{{ $trade->leverage }}x</span>
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <div class="px-2 mb-4 grid grid-cols-1 lg:grid-cols-12 gap-4">
            <div class="lg:col-span-8">
                <div class="mb-1 grid grid-cols-1 md:grid-cols-1 gap-4">
                    <div class="mt-2">
                        <div
                            class="mb-2 p-4 rounded-md bg-white dark:bg-zinc-900 border-zinc-700 dark:border-zinc-700 border shadow-card overflow-hidden">
                            <div class="mb-2.5 flex items-center justify-between">
                                <h5 class="text-lg">Live Progress</h5>
                            </div>
                            <div class="mb-4 px-2 overflow-hidden p-1 rounded-md bg-zinc-50 dark:bg-white/3">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <p>Time Progress</p>
                                        <span class="flex items-center text-sm text-green-500">
                                        </span>
                                    </div>
                                    @php
                                        $now = time();
                                        $expiresAt = strtotime($trade->expires_at);
                                        $remainingSeconds = max(0, $expiresAt - $now);

                                        if ($remainingSeconds >= 86400) {
                                            $timeRemaining = floor($remainingSeconds / 86400) . ' days remaining';
                                        } elseif ($remainingSeconds >= 3600) {
                                            $timeRemaining = floor($remainingSeconds / 3600) . ' hours remaining';
                                        } elseif ($remainingSeconds >= 60) {
                                            $timeRemaining = floor($remainingSeconds / 60) . ' minutes remaining';
                                        } elseif ($remainingSeconds > 0) {
                                            $timeRemaining = $remainingSeconds . ' seconds remaining';
                                        } else {
                                            $timeRemaining = 'Expired';
                                        }
                                    @endphp
                                    <div class="shrink-0">
                                        <p class="text-sm">
                                            {{ $timeRemaining }}
                                        </p>
                                    </div>
                                </div>
                                @php
                                    $startTime = \Carbon\Carbon::parse($trade->created_at)->timestamp * 1000;
                                    $endTime = \Carbon\Carbon::parse($trade->expires_at)->timestamp * 1000;
                                @endphp

                                <div class="flex items-center gap-2">
                                    <div class="h-1.5 bg-zinc-500/20 rounded-full flex-grow overflow-hidden relative">
                                        <div class="progress-bg h-1.5 bg-zinc-500 rounded-full transition-all duration-500"
                                            data-start="{{ $startTime }}" data-end="{{ $endTime }}"
                                            style="width: 0%;">
                                        </div>
                                    </div>
                                    <span class="text-xs text-zinc-400 progress-percent">0%</span>
                                </div>

                                <script>
                                    document.querySelectorAll('.progress-bg').forEach(el => {
                                        const start = parseInt(el.dataset.start);
                                        const end = parseInt(el.dataset.end);
                                        const percentText = el.parentElement.nextElementSibling;

                                        function updateProgress() {
                                            const now = Date.now();
                                            const total = end - start;
                                            const elapsed = Math.min(now - start, total);
                                            const percent = Math.min((elapsed / total) * 100, 100);
                                            el.style.width = percent.toFixed(2) + '%';
                                            percentText.textContent = percent.toFixed(0) + '%';

                                            // 🟡 Optional: change color as expiration nears
                                            if (percent > 80) el.classList.replace('bg-emerald-500', 'bg-red-500');
                                            else if (percent > 60) el.classList.replace('bg-emerald-500', 'bg-yellow-500');
                                        }

                                        updateProgress();
                                        setInterval(updateProgress, 1000);
                                    });
                                </script>

                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center gap-2">
                                        <p class="text-sm text-muted">Started
                                            {{ \Carbon\Carbon::parse($trade->created_at)->diffForHumans() }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-2">
                                <!--:Card:-->
                                <div
                                    class="overflow-hidden p-4 text-center bg-green-500/10 dark:bg-green-500/50 rounded-md">
                                    <p class="mb-2 text-green-600">Price</p>
                                    <h5 class="text-md">
                                        <p class="font-semibold text-green-600">
                                            {{ $trade['amount'] ? '$' . number_format($trade['amount'], 2) : 'N/A' }}
                                        </p>
                                    </h5>
                                </div>
                                <!--:Card:-->
                                <div
                                    class="overflow-hidden p-4 text-center bg-amber-500/10 dark:bg-amber-500/10 rounded-md">
                                    <p class="mb-2 text-amber-500">Closed Value</p>
                                    <p class="text-md text-amber-500">{{ $trade['current_value'] }}</p>
                                </div>
                                <!--:Card:-->
                                <div
                                    class="overflow-hidden p-4 text-center bg-primary-subtle dark:bg-primary-subtle rounded-md">
                                    <p class="mb-2 text-primary">Current P&L</p>
                                    <h5 class="text-md">
                                        <span
                                            class="{{ $trade->profit_loss >= 0 ? 'text-green-500' : 'text-red-500' }}">
                                            ${{ number_format($trade->profit_loss, 2) }}
                                        </span>
                                    </h5>
                                </div>

                                <!--:Card:-->
                                <div
                                    class="overflow-hidden p-4 text-center bg-red-500/10 dark:bg-red-500/10 rounded-md">
                                    <p class="mb-2">Time Left</p>
                                    <p class="text-md text-muted">{{ $timeRemaining }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div
                    class="rounded-md bg-white border-zinc-700 dark:border-zinc-700 border  dark:bg-zinc-900 shadow-card overflow-hidden">
                    <div class="flex items-center justify-between px-4 pt-4 pb-2.5">
                        <div class="flex items-center">
                            <h5 class="text-lg">Trade Details</h5>
                        </div>
                    </div>
                    <div class="px-2 mb-4 mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">

                        <!--:Card:-->
                        <div class="parent-task group">
                            <!-- Child Tasks List -->
                            <ul
                                class="divide-y px-2 whitespace-nowrap overflow-x-auto divide-zinc-500/10 dark:divide-zinc-800 child-list">
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task1"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Asset
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <p class="text-white">{{ $trade->asset_name }}</p>
                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task2"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Trade Type
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <span class="text-green-500">{{ $trade->side }}</span>

                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task3"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Investment Amount
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <p class="text-white">${{ number_format($trade->amount, 2) }}</p>
                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task3"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Leverage
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <p class="text-white">1:{{ $trade->leverage }}</p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <!--:Card:-->
                        <div class="pb-2 parent-task group">

                            <!-- Child Tasks List -->
                            <ul
                                class="divide-y px-2 whitespace-nowrap overflow-x-auto divide-zinc-500/10 dark:divide-zinc-800 child-list">
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task1"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Created
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <p class=" text-white">{{ $trade->created_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task2"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Activated
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <p class="text-white">{{ $trade->created_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task3"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Duration
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <span class="text-white">{{ $trade->expiration }}</span>
                                    </div>
                                </li>
                                <!--:Child task item:-->
                                <li class="flex items-start py-2.5 child-task min-w-max">
                                    <!--:Task desc:-->
                                    <div class="flex items-center flex-grow px-3">
                                        <label for="task3"
                                            class="peer-checked:line-through peer-checked:opacity-50">
                                            Expires
                                        </label>
                                    </div>
                                    <!--:Date/priority/status:-->
                                    <div class="flex items-center space-x-2 text-sm shrink-0">
                                        <span
                                            class="text-amber-500">{{ $trade->expires_at->format('M d, Y h:i A') }}</span>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
            <div class="lg:col-span-4">
                <div class="rounded-md mb-3 bg-white dark:bg-zinc-900 shadow-card">
                    <div class="flex mb-2 items-center justify-between px-4 pt-4">
                        <h5 class="text-lg">Trading Stats ({{ $trade->asset_name }})</h5>
                    </div>
                    <div class="parent-task group">
                        <!-- Child Tasks List -->
                        <ul
                            class="divide-y px-4 whitespace-nowrap overflow-x-auto divide-zinc-500/10 dark:divide-zinc-800 child-list">
                            <!--:Child task item:-->
                            <li class="flex items-start py-2.5 child-task min-w-max">
                                <!--:Task desc:-->
                                <div class="flex items-center flex-grow">
                                    <label for="task1"
                                        class="peer-checked:line-through peer-checked:opacity-50 text-muted">
                                        Total Trades
                                    </label>
                                </div>
                                <!--:Date/priority/status:-->
                                <div class="flex items-center space-x-2 text-sm shrink-0">
                                    <p class="text-white">{{ $totalTrades }}</p>
                                </div>
                            </li>
                            <!--:Child task item:-->
                            <li class="flex items-start py-2.5 child-task min-w-max">
                                <!--:Task desc:-->
                                <div class="flex items-center flex-grow">
                                    <label for="task2"
                                        class="peer-checked:line-through text-muted peer-checked:opacity-50">
                                        Active Trades
                                    </label>
                                </div>
                                <!--:Date/priority/status:-->
                                <div class="flex items-center space-x-2 text-sm shrink-0">
                                    <span class="text-amber-500">{{ $activeCount }}</span>
                                </div>
                            </li>
                            <!--:Child task item:-->
                            <li class="flex items-start py-2.5 child-task min-w-max">
                                <!--:Task desc:-->
                                <div class="flex items-center flex-grow">
                                    <label for="task3"
                                        class="peer-checked:line-through text-muted peer-checked:opacity-50">
                                        Completed
                                    </label>
                                </div>
                                <!--:Date/priority/status:-->
                                <div class="flex items-center space-x-2 text-sm shrink-0">
                                    <span class="text-green-500">{{ $completeCount }}</span>
                                </div>
                            </li>
                            <!--:Child task item:-->
                            <li class="flex items-start py-2.5 child-task min-w-max">
                                <!--:Task desc:-->
                                <div class="flex items-center flex-grow">
                                    <label for="task3"
                                        class="peer-checked:line-through text-muted peer-checked:opacity-50">
                                        Closed
                                    </label>
                                </div>
                                <!--:Date/priority/status:-->
                                <div class="flex items-center space-x-2 text-sm shrink-0">
                                    <p class="text-red-500">{{ $closedCount }}</p>
                                </div>
                            </li>
                            <!--:Child task item:-->
                            <li class="flex items-start py-2.5 child-task min-w-max">
                                <!--:Task desc:-->
                                <div class="flex items-center flex-grow">
                                    <label for="task3"
                                        class="peer-checked:line-through text-muted peer-checked:opacity-50">
                                        Total Invested
                                    </label>
                                </div>
                                <!--:Date/priority/status:-->
                                <div class="flex items-center space-x-2 text-sm shrink-0">
                                    <p class="text-white">${{ number_format($totalInvested, 2) }}</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="rounded-md bg-white dark:bg-zinc-900 shadow-card">
                    <div class="flex items-center justify-between px-4 pt-4">
                        <h5 class="text-lg">Quick Action</h5>
                    </div>
                    <div class="px-4 mb-4">
                        <div class="pt-0 flex items-center justify-center" dir="ltr">
                            <a href="{{ url('user/market') }}"
                                class="btn bg-primary text-white w-full mt-4 mb-3  gap-1 hover:bg-primary-deep h-10">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 512 512">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="32"
                                        d="M32 32v432a16 16 0 0 0 16 16h432" />
                                    <rect width="80" height="192" x="96" y="224" fill="none"
                                        stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="32" rx="20" ry="20" />
                                    <rect width="80" height="240" x="240" y="176" fill="none"
                                        stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="32" rx="20" ry="20" />
                                    <rect width="80" height="304" x="383.64" y="112" fill="none"
                                        stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="32" rx="20" ry="20" />
                                </svg>Browse Market
                            </a>
                        </div>
                        <div class="pt-0 flex items-center justify-center" dir="ltr">
                            <a href="{{ url('user/live_trades') }}"
                                class="btn bg-primary text-white w-full gap-1 mb-3 hover:bg-primary-deep h-10">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M11.962 20q-2.881 0-5.056-1.768T4.16 13.7q-.062-.221.044-.409t.333-.218q.213-.03.375.093q.161.123.229.35q.542 2.384 2.446 3.934T11.962 19q2.925 0 4.962-2.037T18.962 12t-2.038-4.963T11.962 5q-1.553 0-2.918.656q-1.365.655-2.41 1.805h1.981q.213 0 .357.144t.143.357t-.143.356t-.357.143H5.77q-.343 0-.575-.232t-.232-.575V4.808q0-.213.144-.356t.356-.144t.356.144t.144.356v1.888q1.16-1.273 2.718-1.984T11.962 4q1.665 0 3.119.626t2.541 1.714t1.714 2.54t.626 3.119t-.626 3.12t-1.714 2.542t-2.541 1.713t-3.12.626m.558-8.208l3 3q.14.14.15.344q.01.205-.15.364q-.16.16-.353.16q-.195 0-.354-.16l-3.05-3.05q-.131-.13-.187-.274t-.056-.297V7.5q0-.213.144-.356Q11.807 7 12.02 7t.356.144t.143.356z" />
                                </svg>
                                All My Trades
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="gap-4 px-4 mb-4">

            <div class="md:col-span-8">
                <!--:Card:-->
                <div class="rounded-md bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                    <div class="px-4 py-4 flex items-center justify-between">
                        <h5 class="text-lg">Recent Trades ({{ $trade->asset_name }})</h5>
                    </div>
                    <div class="overflow-x-auto px-4 mb-4">
                        <div class="space-y-3">
                            @forelse ($userTrades as $userTrade)
                                <div
                                    class="flex justify-between items-center p-3 rounded-md bg-zinc-100 dark:bg-zinc-800 shadow-sm">
                                    {{-- Left side: Trade info --}}
                                    <div>
                                        <p class="font-semibold text-gray-800 dark:text-gray-200">
                                            {{ strtoupper($userTrade->side) }} — {{ $userTrade->asset_name }}
                                        </p>
                                        <p class="text-xs text-gray-500">
                                            {{ $userTrade->created_at->format('M d, Y h:i A') }}
                                        </p>
                                    </div>

                                    {{-- Right side: Amount + Status --}}
                                    <div class="text-right">
                                        {{-- 💰 Amount --}}
                                        <p class="font-semibold text-green-600 dark:text-green-400 text-sm">
                                            ${{ number_format($userTrade->amount, 2) }}
                                        </p>

                                        {{-- 🔖 Status Badge --}}
                                        <span
                                            class="mt-1 inline-flex items-center justify-center px-2 py-0.5 rounded-full text-xs font-medium
                @if ($userTrade->status === 'closed') bg-red-500/10 text-red-500
                @elseif($userTrade->status === 'completed') bg-green-500/10 text-green-500
                @else bg-yellow-500/10 text-yellow-500 @endif">
                                            {{ ucfirst($userTrade->status) }}
                                        </span>
                                    </div>
                                </div>
                            @empty
                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                    You haven’t traded this asset yet.
                                </p>
                            @endforelse

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-user>
