<x-user :title="$pageTitle">
    <style>
        /* #myTab1 .nav-link {
            border: none !important;
            border-radius: 4499px;
        } */

        /* #myTab2 #revenue1e-tab.active,
        #sales1e-tab.active {
            background: #3d3d3d;
            color: #fff !important;
        } */

        /* Active: Sales = Red */
        /* #myTab2  {
            background: linear-gradient(to right, #b3b5b4, #b3b5b4);
            color: #fff !important;
        } */

        /* Active: Revenue = Green */
        #myTab1 #revenue1-tab.active {
            background: linear-gradient(to right, #22c55e, #059669);
            color: #fff !important;
        }

        /* Active: Sales = Red */
        #myTab1 #sales1-tab.active {
            background: linear-gradient(to right, #ef4444, #b91c1c);
            color: #fff !important;
        }
    </style>

    <!--:Page content:-->
    <div class="content flex-grow pt-4 lg:px-4">
        <div class="px-2 grid grid-cols-1 lg:grid-cols-12 gap-4">
            <div class="lg:col-span-8">
                <div
                    class="grid grid-cols-1 md:grid-cols-1 rounded-xl border-zinc-700 dark:border-zinc-700 border gap-4 mb-4">
                    <!--:Card:-->
                    <div
                        class="rounded-xl w-full flex items-center gap-4 bg-white dark:bg-zinc-900 shadow-card p-4 overflow-hidden">
                        <!--:Icon:-->
                        <div class="shrink-0 flex items-center justify-center size-13 rounded-lg">
                            @if ($data['logo'])
                                <img src="{{ $data['logo'] }}" alt="{{ $data['symbol'] }}"
                                    class="w-16 h-16 rounded-full border border-zinc-900 shadow">
                            @endif
                        </div>
                        <div class="flex-grow">
                            <h4 class="text-lg">{{ strtoupper($data['name']) }}</h4>
                            <p>{{ strtoupper($data['pair']) }}</p>
                        </div>
                        <p class="font-semibold text-green-600">
                            {{ $data['price'] ? '$' . number_format($data['price'], 2) : 'N/A' }}
                        </p>
                        @php
                            $change = is_numeric($data['change_24h']) ? (float) $data['change_24h'] : null;
                        @endphp

                        <p
                            class="font-semibold {{ $change !== null && $change >= 0 ? 'text-green-600' : 'text-red-600' }}">
                            {{ $change !== null ? number_format($change, 2) . '%' : 'N/A' }}
                        </p>

                    </div>
                </div>
                <!--:Card:-->
                <div
                    class="rounded-md bg-white dark:bg-zinc-900 shadow-card border-zinc-700 dark:border-zinc-700 border overflow-hidden">
                    <!-- Card Header -->
                    <div class="flex items-center justify-between p-4 border-b border-zinc-100 dark:border-zinc-800">
                        <h5 class="text-lg font-semibold text-zinc-800 dark:text-zinc-100">Price Chart</h5>
                    </div>

                    <!-- Chart Container -->
                    <div dir="ltr" class="p-2 ">
                        <div id="tradingview_chart" class="w-full rounded-lg overflow-hidden" style="height: 550px;">
                        </div>
                    </div>
                </div>

                <!-- TradingView Script -->
                <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                <script>
                    new TradingView.widget({
                        container_id: "tradingview_chart",
                        symbol: "{{ $data['symbol'] }}",
                        autosize: true,
                        theme: "dark",
                        locale: "en",
                        interval: "1",
                        timezone: "Etc/UTC",
                        style: "1",
                        withdateranges: true,
                        hide_side_toolbar: false,
                        allow_symbol_change: true,
                        details: true,
                        calendar: true,
                        studies: ["MACD@tv-basicstudies"],
                    });
                </script>

                <div class="mt-2">
                    <div
                        class="mb-2 p-4 rounded-md bg-white dark:bg-zinc-900 border-zinc-700 dark:border-zinc-700 border shadow-card overflow-hidden">
                        <div class="mb-2.5 flex items-center justify-between">
                            <h5 class="text-lg">Market Data</h5>
                        </div>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-2">
                            <!--:Card:-->
                            <div class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                <p class="mb-2">Type</p>
                                <h5 class="text-xl">{{ $data['type'] }}</h5>
                            </div>
                            <!--:Card:-->
                            <div class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                <p class="mb-2">Price</p>
                                <h5 class="text-xl">
                                    <p class="font-semibold text-green-600">
                                        {{ $data['price'] ? '$' . number_format($data['price'], 2) : 'N/A' }}
                                    </p>
                                </h5>
                            </div>
                            <!--:Card:-->
                            <div class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                <p class="mb-2">24h change</p>
                                <h5 class="text-xl">
                                    <p
                                        class="font-semibold {{ $change !== null && $change >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $change !== null ? number_format($change, 2) . '%' : 'N/A' }}
                                    </p>
                                </h5>
                            </div>
                            <!--:Card:-->
                            <div class="overflow-hidden p-4 text-center bg-zinc-50 dark:bg-white/3 rounded-md">
                                <p class="mb-2">Pair</p>
                                <h5 class="text-xl">{{ strtoupper($data['pair']) }}</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lg:col-span-4">
                <!--:Card:-->
                <div
                    class="rounded-md bg-white dark:bg-zinc-900 border-zinc-700 dark:border-zinc-700 border shadow-card overflow-hidden mb-4">
                    <div class="py-4">
                        <div class="max-w-xl">
                            <!--:Card:-->
                            <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card">
                                <div class="px-4 py-2 flex items-center justify-between">
                                    <h5 class="text-md">Place Order</h5>
                                </div>
                                <!-- Nav tabs -->
                                <div class="w-full flex items-center justify-center px-4">
                                    <div class="flex w-full overflow-hidden bg-gray-200 p-1 rounded-md border border-zinc-200 dark:border-zinc-700"
                                        id="myTab1" role="tablist">

                                        <!-- Revenue Tab -->
                                        <button
                                            class="w-1/2 rounded-md py-2 text-sm font-medium text-center transition-all duration-300
                                            nav-link active text-zinc-600 dark:text-zinc-300 bg-gradient-to-r from-green-500 to-emerald-600"
                                            id="revenue1-tab" data-bs-toggle="tab" data-bs-target="#revenue1"
                                            type="button" role="tab" aria-controls="revenue1" aria-selected="true">
                                            Buy
                                        </button>

                                        <!-- Sales Tab -->
                                        <button
                                            class="w-1/2 py-2 rounded-md text-sm font-medium text-center transition-all duration-300
                                            nav-link text-zinc-600 dark:text-zinc-300 bg-transparent hover:bg-zinc-100 dark:hover:bg-zinc-800"
                                            id="sales1-tab" data-bs-toggle="tab" data-bs-target="#sales1" type="button"
                                            role="tab" aria-controls="sales1" aria-selected="false">
                                            Sell
                                        </button>
                                    </div>
                                </div>

                                <!-- Tab panes -->
                                <div class="tab-content p-4">
                                    <div class="tab-pane fade show active" id="revenue1" role="tabpanel"
                                        aria-labelledby="revenue1-tab" tabindex="0">
                                        <div class="max-w-md mx-auto py-3" x-data="tradeForm(
                                            {{ Auth::user()->balance }},
                                            '{{ $data['pair'] ?? 'BTCUSD' }}',
                                            {{ $data['price'] ?? 1 }},
                                            '{{ strtoupper($data['name']) }}',
                                            '{{ $data['type'] }}'
                                        )">
                                            <form @submit.prevent="submitOrder">
                                                <!-- Asset Name-->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Asset Name</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="text" name="asset_name" readonly x-model="assetName">
                                                </div>

                                                <!-- Market Type -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Market Type</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="text" name="market_type" readonly x-model="marketType">
                                                </div>

                                                <!-- Order Type -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Order Type</label>
                                                    <div class="relative">
                                                        <select x-model="orderType" class="input appearance-none">
                                                            <option selected>Select Order Type</option>
                                                            <option value="market">Market Order</option>
                                                            <option value="limit">Limit Order</option>
                                                            <option value="stop">Stop Order</option>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Leverage -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Leverage</label>
                                                    <div class="relative">
                                                        <select x-model="leverage" class="input appearance-none">
                                                            <option selected>Select leverage</option>
                                                            <template x-for="num in [10,20,30,40,50,60,70,80,90,100]"
                                                                :key="num">
                                                                <option :value="num">1:<span
                                                                        x-text="num"></span></option>
                                                            </template>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Expiration -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Expiration</label>
                                                    <div class="relative">
                                                        <select x-model="expiration" class="input appearance-none">
                                                            <option selected>Select expiration</option>
                                                            <option value="3m">3 minutes</option>
                                                            <option value="5m">5 minutes</option>
                                                            <option value="15m">15 minutes</option>
                                                            <option value="30m">30 minutes</option>
                                                            <option value="1h">1 hour</option>
                                                            <option value="4h">4 hours</option>
                                                            <option value="1d">1 day</option>
                                                            <option value="2d">2 days</option>
                                                            <option value="7d">7 days</option>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Price -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Price ($)</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="number" step="0.01" x-model="price"
                                                        :disabled="orderType === 'market'">
                                                </div>

                                                <!-- Investment Amount -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Investment Amount
                                                        ($)</label>
                                                    <input x-model="amount" @input="updateDisplay"
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="number" step="0.01" min="0"
                                                        placeholder="Enter amount">
                                                </div>

                                                <!-- Quick Amount Buttons -->
                                                <div class="mt-4">
                                                    <div class="text-sm text-gray-600 dark:text-gray-400 mb-2">Quick
                                                        amounts:</div>
                                                    <div class="flex justify-between gap-2">
                                                        <template x-for="p in [25,50,75,100]" :key="p">
                                                            <button type="button" @click="setQuickAmount(p)"
                                                                class="flex-1 py-2 text-xs font-semibold bg-zinc-700 hover:bg-gray-300 text-white rounded transition">
                                                                <span x-text="p + '%'"></span>
                                                            </button>
                                                        </template>
                                                    </div>
                                                </div>

                                                <!-- Summary Display -->
                                                <div
                                                    class="bg-zinc-700 dark:bg-gray-300 rounded-lg p-4 border border-zinc-200 dark:border-zinc-800 mt-4">
                                                    <div class="flex justify-between items-center mb-2">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Investment
                                                            Amount:</span>
                                                        <span class="text-sm text-gray-900 dark:text-white">$<span
                                                                x-text="amountDisplay"></span></span>
                                                    </div>
                                                    <div class="flex justify-between items-center mb-2">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Units:</span>
                                                        <span class="text-sm text-gray-900 dark:text-white"><span
                                                                x-text="units"></span></span>
                                                    </div>
                                                    <div class="flex justify-between items-center">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Available
                                                            Balance:</span>
                                                        <span
                                                            class="text-sm text-gray-900 dark:text-white">${{ number_format(Auth::user()->balance, 2) }}</span>
                                                    </div>
                                                </div>

                                                <!-- Submit -->
                                                <button type="submit"
                                                    class="btn bg-green-500/30 text-white w-full mt-4 px-4 hover:bg-primary-deep h-12">
                                                    Buy {{ strtoupper($data['pair']) }}
                                                </button>
                                            </form>
                                        </div>

                                        <script>
                                            document.addEventListener('alpine:init', () => {
                                                Alpine.data('tradeForm', (balance, symbol, price, assetName, marketType) => ({
                                                    balance: parseFloat(balance),
                                                    symbol,
                                                    assetName,
                                                    marketType,
                                                    side: 'buy',
                                                    orderType: 'market',
                                                    leverage: 10,
                                                    expiration: '',
                                                    price: parseFloat(price) || 1,
                                                    amount: 0,
                                                    amountDisplay: '0.00',
                                                    units: 0,

                                                    setQuickAmount(percent) {
                                                        this.amount = (this.balance * percent / 100).toFixed(2);
                                                        this.updateDisplay();
                                                    },

                                                    updateDisplay() {
                                                        const amt = parseFloat(this.amount) || 0;
                                                        this.amountDisplay = amt.toFixed(2);
                                                        this.units = this.price > 0 ? (amt / this.price).toFixed(4) : 0;
                                                    },

                                                    async submitOrder() {
                                                        try {
                                                            const payload = {
                                                                symbol: this.symbol,
                                                                asset_name: this.assetName,
                                                                market_type: this.marketType,
                                                                side: this.side,
                                                                order_type: this.orderType,
                                                                amount: this.amount,
                                                                leverage: this.leverage,
                                                                expiration: this.expiration,
                                                            };

                                                            const res = await fetch('/orders/place', {
                                                                method: 'POST',
                                                                headers: {
                                                                    'Content-Type': 'application/json',
                                                                    'X-CSRF-TOKEN': document.querySelector(
                                                                        'meta[name=csrf-token]').content
                                                                },
                                                                body: JSON.stringify(payload)
                                                            });

                                                            if (res.ok) {
                                                                alert('✅ Order placed successfully!');
                                                                window.location.reload();
                                                            } else {
                                                                const data = await res.json();
                                                                alert(data.message || data.error || 'Failed to place order');
                                                            }

                                                        } catch (err) {
                                                            console.error(err);
                                                            alert('Error placing order.');
                                                        }
                                                    },
                                                }));
                                            });
                                        </script>

                                    </div>

                                    <div class="tab-pane fade" id="sales1" role="tabpanel"
                                        aria-labelledby="sales1-tab" tabindex="0">

                                        <div class="max-w-md mx-auto py-3" x-data="sellForm(
                                            {{ Auth::user()->balance }},
                                            '{{ $data['pair'] ?? 'BTCUSD' }}',
                                            {{ $data['price'] ?? 1 }},
                                            '{{ strtoupper($data['name']) }}',
                                            '{{ $data['type'] }}'
                                        )">
                                            <form @submit.prevent="submitOrder">
                                                <!-- Asset Name-->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Asset Name</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="text" name="asset_name" readonly
                                                        x-model="assetName">
                                                </div>

                                                <!-- Market Type -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Market Type</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="text" name="market_type" readonly
                                                        x-model="marketType">
                                                </div>

                                                <!-- Order Type -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Order Type</label>
                                                    <div class="relative">
                                                        <select x-model="orderType" class="input appearance-none">
                                                            <option selected>Select Order Type</option>
                                                            <option value="market">Market Order</option>
                                                            <option value="limit">Limit Order</option>
                                                            <option value="stop">Stop Order</option>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Leverage -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Leverage</label>
                                                    <div class="relative">
                                                        <select x-model="leverage" class="input appearance-none">
                                                            <option selected>Select leverage</option>
                                                            <template x-for="n in [10,20,30,40,50,60,70,80,90,100]"
                                                                :key="n">
                                                                <option :value="n">1:<span
                                                                        x-text="n"></span></option>
                                                            </template>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Expiration -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Expiration</label>
                                                    <div class="relative">
                                                        <select x-model="expiration" class="input appearance-none">
                                                            <option selected>Select expiration</option>
                                                            <option value="3m">3 minutes</option>
                                                            <option value="5m">5 minutes</option>
                                                            <option value="15m">15 minutes</option>
                                                            <option value="30m">30 minutes</option>
                                                            <option value="1h">1 hour</option>
                                                            <option value="4h">4 hours</option>
                                                            <option value="1d">1 day</option>
                                                            <option value="2d">2 days</option>
                                                            <option value="7d">7 days</option>
                                                        </select>
                                                        <span
                                                            class="icon-[lucide--chevron-down] opacity-50 pointer-events-none absolute end-2 top-1/2 -translate-y-1/2"></span>
                                                    </div>
                                                </div>

                                                <!-- Price -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Price ($)</label>
                                                    <input
                                                        class="input bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600"
                                                        type="number" step="0.01" x-model.number="price"
                                                        disabled>
                                                </div>

                                                <!-- Investment Amount -->
                                                <div class="flex flex-col gap-1 mb-4">
                                                    <label class="block mb-0.5 text-sm text-muted">Investment Amount
                                                        ($)</label>
                                                    <input class="input" type="number" step="0.01"
                                                        min="0" x-model.number="amount"
                                                        @input="updateDisplay">
                                                </div>

                                                <!-- Quick Amount Buttons -->
                                                <div class="mt-4">
                                                    <div class="text-sm text-gray-600 dark:text-gray-400 mb-2">Quick
                                                        amounts:</div>
                                                    <div class="flex justify-between gap-2">
                                                        <template x-for="percent in [25, 50, 75, 100]"
                                                            :key="percent">
                                                            <button type="button" @click="setQuickAmount(percent)"
                                                                class="flex-1 py-2 text-xs font-semibold bg-zinc-700 hover:bg-gray-300 text-gray-800 rounded transition-colors">
                                                                <span x-text="percent + '%'"></span>
                                                            </button>
                                                        </template>
                                                    </div>
                                                </div>

                                                <!-- Summary Box -->
                                                <div
                                                    class="bg-zinc-700 dark:bg-gray-300 rounded-lg p-4 border border-zinc-200 dark:border-zinc-800 mt-4">
                                                    <div class="flex justify-between items-center mb-2">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Investment
                                                            Amount:</span>
                                                        <span class="text-sm text-gray-900 dark:text-white">$<span
                                                                x-text="amountDisplay"></span></span>
                                                    </div>
                                                    <div class="flex justify-between items-center mb-2">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Units:</span>
                                                        <span class="text-sm text-gray-900 dark:text-white"><span
                                                                x-text="units.toFixed(4)"></span></span>
                                                    </div>
                                                    <div class="flex justify-between items-center">
                                                        <span
                                                            class="text-sm text-gray-600 dark:text-gray-400">Available
                                                            Balance:</span>
                                                        <span class="text-sm text-gray-900 dark:text-white">$<span
                                                                x-text="balance.toFixed(2)"></span></span>
                                                    </div>
                                                </div>

                                                <!-- Submit -->
                                                <button type="submit"
                                                    class="btn bg-red-500/30 text-white w-full mt-4 px-4 py-6 hover:bg-primary-deep h-12">
                                                    Sell {{ strtoupper($data['pair']) }}
                                                </button>
                                            </form>
                                        </div>

                                        <script>
                                            document.addEventListener('alpine:init', () => {
                                                Alpine.data('sellForm', (balance, symbol, price, assetName, marketType) => ({
                                                    balance: parseFloat(balance),
                                                    symbol,
                                                    assetName,
                                                    marketType,
                                                    side: 'sell',
                                                    orderType: 'market',
                                                    leverage: 10,
                                                    expiration: '',
                                                    price: parseFloat(price) || 1,
                                                    amount: 0,
                                                    amountDisplay: '0.00',
                                                    units: 0,

                                                    setQuickAmount(percent) {
                                                        this.amount = (this.balance * percent / 100).toFixed(2);
                                                        this.updateDisplay();
                                                    },

                                                    updateDisplay() {
                                                        const amt = parseFloat(this.amount) || 0;
                                                        this.amountDisplay = amt.toFixed(2);
                                                        this.units = this.price > 0 ? (amt / this.price).toFixed(4) : 0;
                                                    },

                                                    async submitOrder() {
                                                        try {
                                                            const payload = {
                                                                symbol: this.symbol,
                                                                asset_name: this.assetName,
                                                                market_type: this.marketType,
                                                                side: this.side,
                                                                order_type: this.orderType,
                                                                amount: this.amount,
                                                                leverage: this.leverage,
                                                                expiration: this.expiration,
                                                            };

                                                            const res = await fetch('/orders/place', {
                                                                method: 'POST',
                                                                headers: {
                                                                    'Content-Type': 'application/json',
                                                                    'X-CSRF-TOKEN': document.querySelector(
                                                                        'meta[name=csrf-token]').content
                                                                },
                                                                body: JSON.stringify(payload)
                                                            });

                                                            if (res.ok) {
                                                                alert('✅ Order placed successfully!');
                                                                window.location.reload();
                                                            } else {
                                                                const data = await res.json();
                                                                alert(data.message || data.error || 'Failed to place order');
                                                            }

                                                        } catch (err) {
                                                            console.error(err);
                                                            alert('Error placing order.');
                                                        }
                                                    },
                                                }));
                                            });
                                        </script>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/user/vendor/js/echarts.min.js"></script>
    <script src="/user/js/dashboard-education.js" type="text/javascript"></script>
</x-user>
