<x-user :title="$pageTitle">

    <div class="px-1 mb-4 lg:py-2 rounded-b-md bg-gradient-to-t from-zinc-900 dark:from-zinc-900">
        <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
            <div class="flex justify-center mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48">
                    <g fill="none">
                        <path fill="#deeeff"
                            d="M23.998 47.997c13.255 0 24-10.745 24-24c0-13.254-10.745-24-24-24s-24 10.746-24 24c0 13.255 10.745 24 24 24" />
                        <path fill="#2e3ecd"
                            d="M36.216 14.833a.873.873 0 0 1-.873.873H12.652a.87.87 0 0 1-.873-.873v-1.745c0-.483.39-.873.873-.873h22.69c.483 0 .873.39.873.873z" />
                        <path fill="#2e3ecd" fill-rule="evenodd"
                            d="M17.016 13.524H30.98l3.49 17.455h-2.705l.274-.769l.012-.082a4.85 4.85 0 0 0-9.073-3.02l-2.064 3.87h-7.389z"
                            clip-rule="evenodd" />
                        <path fill="#6bafff" fill-rule="evenodd"
                            d="M31.483 27.01a4.85 4.85 0 0 0-8.505.098l-1.133 2.125h-3.123a2.62 2.62 0 0 0-2.221-2.155l2.26-13.554h10.473z"
                            clip-rule="evenodd" />
                        <path fill="#2e3ecd"
                            d="M23.561 23.997c2.169 0 3.927-1.563 3.927-3.491s-1.758-3.49-3.927-3.49s-3.927 1.562-3.927 3.49s1.758 3.49 3.927 3.49" />
                        <path fill="#6bafff"
                            d="M25.95 20.54c0 .14-.124.252-.282.252h-.076q-.064.39-.261.7a.37.37 0 0 1-.326.174c-.207 0-.365-.145-.365-.329q0-.088.049-.169c.082-.136.147-.27.185-.401h-.827c-.223.735-.56 1.049-1.17 1.049c-.608 0-1-.416-1.076-1.025h-.289c-.157 0-.282-.111-.282-.252c0-.14.125-.25.282-.25h.294a2.25 2.25 0 0 1 .38-.953a.38.38 0 0 1 .327-.164c.212 0 .37.145.37.333c0 .063-.027.13-.07.189c-.147.203-.25.396-.305.619h.865c.212-.696.511-1.04 1.158-1.04c.6 0 1.002.406 1.072 1.015h.065c.158.001.283.112.283.252m-2.714.228h-.756q.058.342.354.343c.18 0 .299-.082.402-.343m.952-.455h.735c-.038-.232-.169-.333-.343-.333c-.169 0-.283.067-.391.333" />
                        <path fill="#2e3ecd" d="m28.35 37.96l2.838-7.965a3.977 3.977 0 0 0-7.44-2.476L18.18 37.96z" />
                        <path fill="#6bafff" d="M29.201 29.98a2.124 2.124 0 0 0-4.015-1.381l-.173.502l4.016 1.38z" />
                    </g>
                </svg>
            </div>
            <h4 class="text-2xl lg:text-4xl mb-2">Complete Your Subscription Payment</h4>
            <p class="text-text mb-6">
                Securely using any of the available <span class="badge bg-zinc-400/20 text-sky-500">Payment
                    Gateways</span> to get your subscription active
            </p>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow px-2 lg:px-8 pt-6 mb-4 gap-2.5">
        <div class="mb-4 gap-4 max-w-7xl mx-auto">
            <div class="lg:col-span-8">
                <!--:Project card:-->
                <div class="rounded-xl border-zinc-200 dark:border-zinc-800 border shadow-card p-4 mb-4 relative">
                    <div class="flex items-center gap-3.5">
                        <div class="w-12 h-12 flex items-center justify-center rounded-lg shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round"
                                    stroke-linejoin="round" stroke-width="2"
                                    d="M12 2v20m5-17H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6" />
                            </svg>
                        </div>
                        <div class="flex-grow">
                            <h5 class="text-xl">Payment Details</h5>
                        </div>
                        <div class="shrink-0">
                            <span class="badge shrink-0 bg-green-500/10 text--500">SSL Secured</span>
                        </div>
                    </div>
                    <!--:Description:-->
                    <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5">
                    <div class="md:col-span-4">
                        <div
                            class="overflow-hidden p-4 rounded-xl border border-zinc-200 bg-white dark:bg-zinc-900 dark:border-zinc-700">

                            <h3 class="mb-4 leading-tight text-center">
                                <span class="badge shrink-0 bg-white dark:bg-zinc-900 text-center text-sky-500">Amount
                                    to
                                    Deposit</span>
                            </h3>
                            <div class="flex items-center flex-wrap justify-center gap-4">
                                <h4 class="text-3xl lg:text-4xl mb-2 font-semibold">$ {{ number_format($amount, 2) }}
                                </h4>
                            </div>
                            <div class="flex items-center flex-wrap justify-center gap-4">
                                <span class="badge bg-amber-500/10 text-amber-500 h-8 mt-2 gap-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 24 24">
                                        <path fill="none" stroke="#f0c60e" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2"
                                            d="m21.73 18l-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3M12 9v4m0 4h.01" />
                                    </svg> Send the exact Amount to avoid delays
                                </span>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-700 border-dashed my-5">
                        <div class="px-1">
                            <div class="overflow-hidden p-4 rounded-xl bg-white dark:bg-zinc-900">
                                <div class="mb-2.5 flex items-center justify-between">
                                    <h5 class="text-lg">How to Complete Your Payment</h5>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">

                                    <!--:Card 1:-->
                                    <div class="overflow-hidden p-4">
                                        <div class="flex items-center gap-3 mb-2">
                                            <div
                                                class="size-6 flex items-center justify-center rounded-full bg-primary">
                                                1
                                            </div>
                                            <h5 class="text-xl">Send Payment</h5>
                                        </div>
                                        <span class="text-sm text-muted flex items-center gap-1">
                                            <span class="text-text">
                                                Transfer <span
                                                    class="font-semibold">${{ number_format($amount, 2) }}</span> to
                                                the
                                                wallet address
                                            </span>
                                        </span>
                                    </div>

                                    <!--:Card 2:-->
                                    <div class="overflow-hidden p-4 rounded-xl">
                                        <div class="flex items-center gap-3 mb-2">
                                            <div
                                                class="size-6 flex items-center justify-center rounded-full bg-primary">
                                                2
                                            </div>
                                            <h5 class="text-xl">Upload Payment Receipt</h5>
                                        </div>
                                        <span class="text-sm text-muted flex items-center gap-1">
                                            <span class="text-text">
                                                Take a screenshot of your Transaction Payment
                                            </span>
                                        </span>
                                    </div>

                                    <!--:Card 3:-->
                                    <div class="overflow-hidden p-4 rounded-xl">
                                        <div class="flex items-center gap-3 mb-2">
                                            <div
                                                class="size-6 flex items-center justify-center rounded-full bg-blue-500">
                                                3
                                            </div>
                                            <h5 class="text-xl">Submit and wait</h5>
                                        </div>
                                        <span class="text-sm text-muted flex items-center gap-1">
                                            <span class="text-text">
                                                Submit Proof and wait for confirmation
                                            </span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="border-zinc-200 dark:border-zinc-700 border-dashed my-5">
                    <div class="grid grid-cols-1 px-4 md:grid-cols-1 gap-4 mb-4 bg-white dark:bg-zinc-900 rounded-xl">

                        <div class="md:col-span-12">
                            <!--:card:-->
                            <div class="rounded-xl shadow-card overflow-hidden">
                                <div
                                    class="rounded-xl alert fade show shadow-card p-4 lg:p-6 mb-4 relative overflow-hidden">

                                    <form action="{{ route('user.store.signal') }}" method="POST"
                                        enctype="multipart/form-data" class="mt-4" id="my-dropzone">
                                        @csrf
                                        <input type="hidden" name="signal_id" value="{{ $signal->id }}">
                                        <div class="flex lg:px-4 flex-wrap -mx-2">
                                            <div class="w-full px-2 mb-4">
                                                <label class="mb-1 block">Select Payment Method</label>
                                                <select id="gatewaySelect" name="payment_gateway_id"
                                                    class="input w-full">
                                                    <option value="">-- Choose Method --</option>
                                                    @foreach ($pay as $gateway)
                                                        <option value="{{ $gateway->id }}">
                                                            {{ $gateway->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @foreach ($pay as $gateway)
                                                <div class="gateway-box hidden rounded mt-3"
                                                    id="gateway-{{ $gateway->id }}">
                                                    <div class="w-full px-2 mb-4">
                                                        <div class="flex px-2 mb-2 items-center space-x-2">
                                                            <p class="p">Wallet Address:</p>
                                                        </div>
                                                        <div class="flex items-center space-x-2">
                                                            <input type="text" class="input" id="walletAddress"
                                                                value="{{ $gateway->wallet_address }}" readonly>
                                                            <button type="button" onclick="copyWalletAddress()"
                                                                class="px-3 py-2 text-white text-sm bg-primary rounded-md hover:bg-blue-700">
                                                                Copy
                                                            </button>
                                                        </div>
                                                    </div>

                                                    <script>
                                                        function copyWalletAddress() {
                                                            const walletAddress = document.getElementById('walletAddress').value;

                                                            // Create a temporary element for mobile compatibility
                                                            const tempInput = document.createElement('input');
                                                            tempInput.value = walletAddress;
                                                            document.body.appendChild(tempInput);

                                                            // Select the text
                                                            tempInput.select();
                                                            tempInput.setSelectionRange(0, 99999); // for mobile

                                                            // Try the clipboard API first (modern way)
                                                            if (navigator.clipboard && window.isSecureContext) {
                                                                navigator.clipboard.writeText(walletAddress).then(() => {
                                                                    toastr?.success('Wallet address copied!');
                                                                }).catch(() => {
                                                                    document.execCommand('copy');
                                                                    toastr?.success('Wallet address copied!');
                                                                });
                                                            } else {
                                                                // Fallback for older mobile browsers
                                                                document.execCommand('copy');
                                                                toastr?.success('Wallet address copied!');
                                                            }

                                                            // Clean up
                                                            document.body.removeChild(tempInput);
                                                        }
                                                    </script>

                                                    @if ($gateway->qr_code)
                                                        <div class="rounded-xl shadow-card overflow-hidden">
                                                            <div
                                                                class="rounded-xl alert fade show shadow-card p-4 lg:p-6 text-center mb-4 relative overflow-hidden">
                                                                <div
                                                                    class="flex items-center flex-wrap justify-center gap-4">
                                                                    <img src="{{ asset('upload/' . $gateway->qr_code) }}"
                                                                        alt=""
                                                                        class="block rounded-md w30 h-30">
                                                                </div>
                                                                <p>Scan the QR Code or Copy the Wallet Address Above</p>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            @endforeach
                                            <div class="w-full px-2 mb-4">
                                                <label class="mb-1 block">Amount</label>
                                                <input type="number" class="input" name="price"
                                                    value="{{ $amount }}">
                                            </div>
                                            <div class="w-full mt-2 mb-4">
                                                <label class="mb-1 block">Upload Payment Proof</label>
                                                <input type="file" name="pay_image" required class="input">
                                                <x-input-error :messages="$errors->get('pay_image')" class="mt-2" />
                                            </div>
                                        </div>
                                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-5">
                                        <div class="p-4">
                                            <button type="submit"
                                                class="btn bg-primary text-white w-full px-4 hover:bg-primary-deep"><span
                                                    class="icon-[lucide--upload] text-lg me-1 leading-none text-white"></span>
                                                Complete Your Subscription</button>
                                        </div>
                                    </form>

                                    <script>
                                        document.getElementById('gatewaySelect').addEventListener('change', function() {

                                            // hide all gateway boxes
                                            document.querySelectorAll('.gateway-box').forEach(box => {
                                                box.classList.add('hidden');
                                            });

                                            const selectedId = this.value;
                                            if (!selectedId) return;

                                            const activeBox = document.getElementById('gateway-' + selectedId);
                                            if (activeBox) {
                                                activeBox.classList.remove('hidden');
                                            }
                                        });
                                    </script>

                                </div>
                            </div>
                        </div>
                        {{-- <div class="md:col-span-6">
                            @foreach ($pay as $gateway)
                                <!--:card:-->
                                <div class="rounded-xl shadow-card overflow-hidden">
                                    <div
                                        class="rounded-xl alert fade show shadow-card p-4 lg:p-6 text-center mb-4 relative overflow-hidden">
                                        <div class="flex items-center flex-wrap justify-center gap-4">
                                            <img src="{{ asset('upload/' . $gateway->qr_code) }}" alt=""
                                                class="block rounded-md mb-6 w-auto h-80 mx-auto">
                                        </div>
                                        <p>Scan the QR Code or Copy the Wallet Address Below</p>
                                    </div>
                                </div>
                            @endforeach
                        </div> --}}
                    </div>
                </div>
            </div>

            <div class="mb-4 p-4 rounded-xl shadow-card overflow-hidden">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <!-- Card 1 -->
                    <div
                        class="overflow-hidden p-4 text-center border-zinc-200 dark:border-zinc-800 border bg-white dark:bg-zinc-900 rounded-xl">
                        <div
                            class="mx-auto mb-3 size-12 flex items-center justify-center rounded-full bg-yellow-500/20 text-white">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <path fill="none" stroke="#348ef2" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M13.832 16.568a1 1 0 0 0 1.213-.303l.355-.465A2 2 0 0 1 17 15h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2A18 18 0 0 1 2 4a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v3a2 2 0 0 1-.8 1.6l-.468.351a1 1 0 0 0-.292 1.233a14 14 0 0 0 6.392 6.384" />
                            </svg>
                        </div>
                        <h5 class="text-xl mb-2">24/7 Customer Support</h5>
                        <p class="mb-2">Our dedicated support team is available around the clock to assist with your
                            shipment clearance</p>
                    </div>

                    <!-- Card 2 -->
                    <div
                        class="overflow-hidden p-4 text-center border-zinc-200 dark:border-zinc-800 border bg-white dark:bg-zinc-900 rounded-xl">
                        <div
                            class="mx-auto mb-3 size-12 flex items-center justify-center rounded-full bg-sky-500/20 text-white">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <mask id="SVGb0TUNbvy">
                                    <path fill="none" stroke="#fff" stroke-dasharray="56" stroke-dashoffset="56"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 19v0c-0.3 0 -0.59 -0.15 -0.74 -0.41c-0.8 -1.34 -1.26 -2.91 -1.26 -4.59c0 -4.97 4.03 -9 9 -9c4.97 0 9 4.03 9 9c0 1.68 -0.46 3.25 -1.26 4.59c-0.15 0.26 -0.44 0.41 -0.74 0.41Z">
                                        <animate fill="freeze" attributeName="stroke-dashoffset" dur="0.6s"
                                            values="56;0" />
                                    </path>
                                    <g transform="rotate(-100 12 14)">
                                        <path
                                            d="M12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14Z">
                                            <animate fill="freeze" attributeName="d" begin="0.4s" dur="0.2s"
                                                values="M12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14Z;M16 14C16 16.21 14.21 18 12 18C9.79 18 8 16.21 8 14C8 11.79 12 0 12 0C12 0 16 11.79 16 14Z" />
                                        </path>
                                        <path fill="#fff"
                                            d="M12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14Z">
                                            <animate fill="freeze" attributeName="d" begin="0.4s" dur="0.2s"
                                                values="M12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14C12 14 12 14 12 14Z;M14 14C14 15.1 13.1 16 12 16C10.9 16 10 15.1 10 14C10 12.9 12 4 12 4C12 4 14 12.9 14 14Z" />
                                        </path>
                                        <animateTransform attributeName="transform" begin="0.4s" dur="6s"
                                            repeatCount="indefinite" type="rotate"
                                            values="-100 12 14;45 12 14;45 12 14;45 12 14;20 12 14;10 12 14;0 12 14;35 12 14;45 12 14;55 12 14;50 12 14;15 12 14;-20 12 14;-100 12 14" />
                                    </g>
                                </mask>
                                <rect width="24" height="24" fill="#348ef2" mask="url(#SVGb0TUNbvy)" />
                            </svg>
                        </div>
                        <h5 class="text-xl mb-2">Fast Processing</h5>
                        <p class="mb-2">Your payment is processed quickly to ensure minimal delays in your shipment
                            delivery
                        </p>
                    </div>

                    <!-- Card 3 -->
                    <div
                        class="overflow-hidden p-4 text-center border-zinc-200 dark:border-zinc-800 border bg-white dark:bg-zinc-900 rounded-xl">
                        <div
                            class="mx-auto mb-3 size-12 flex items-center justify-center rounded-full bg-green-500/20 text-white">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <g fill="none">
                                    <path d="M3 4.65V12c0 7.35 9 10.5 9 10.5s9-3.15 9-10.5V4.65L12 1.5z"
                                        clip-rule="evenodd" />
                                    <path stroke="#348ef2" stroke-linecap="square" stroke-width="2"
                                        d="M3 4.65V12c0 7.35 9 10.5 9 10.5s9-3.15 9-10.5V4.65L12 1.5z"
                                        clip-rule="evenodd" />
                                    <path stroke="#348ef2" stroke-linecap="square" stroke-width="2"
                                        d="M8.173 11.172L11 14l5.657-5.657" />
                                </g>
                            </svg>
                        </div>
                        <h5 class="text-xl mb-2">Secured & Protected</h5>
                        <p class="mb-2">All payment data is secured with enterprise-grade encryption and security
                            protocols
                        </p>
                    </div>

                </div>
            </div>
        </div>
    </div>
</x-user>
