<x-user :title="$pageTitle">
    <div class="content flex-grow lg:px-12">
        <!--:Page Header:-->
        <div class="px-4 lg:px-8 py-4">
            <h2 class="text-xl mb-2">Real Estate Investment</h2>
            <!--:Breadcrumbs:-->
            <ol class="flex gap-1 items-center text-sm">
                <li class="flex items-center">Build wealth through strategic real estate investments with proven returns
                </li>
            </ol>
        </div>

        <!--:Page content:-->
        <div class="content flex flex-col flex-grow px-4 lg:px-8">
            <div class="px-2 mt-2">
                <div
                    class="mb-4 p-4 rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden border border-zinc-200 dark:border-zinc-700">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-sky-500/10 text-sky-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 20 20">
                                    <path fill="currentColor"
                                        d="M2 11a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1zm6-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v9a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1zm6-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1z" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                {{ $totalInvestments }}
                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Total Investment</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-green-500/10 text-green-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M13.75 9a.75.75 0 0 1 .75-.75H18a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-1.69l-4.72 4.72a.75.75 0 0 1-1.06 0L9 13.06l-2.47 2.47a.75.75 0 0 1-1.06-1.06l3-3a.75.75 0 0 1 1.06 0L12 13.94l4.19-4.19H14.5a.75.75 0 0 1-.75-.75" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                {{ $activeInvestments }}
                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Active</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-red-500/10 text-red-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M21 11a1 1 0 0 0-1 1v2.59l-6.29-6.3a1 1 0 0 0-1.42 0L9 11.59l-5.29-5.3a1 1 0 0 0-1.42 1.42l6 6a1 1 0 0 0 1.42 0l3.29-3.3L18.59 16H16a1 1 0 0 0 0 2h5a1 1 0 0 0 .38-.08a1 1 0 0 0 .54-.54A1 1 0 0 0 22 17v-5a1 1 0 0 0-1-1" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                {{ $completedInvestments }}
                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Completed</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-amber-500/10 text-amber-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 14 14">
                                    <g fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1">
                                        <path
                                            d="M7 13.5c3.5 0 6-1.238 6-3.994c0-2.995-1.5-4.992-4.5-6.49l1.18-1.518A.658.658 0 0 0 9.12.5H4.88a.66.66 0 0 0-.56.998L5.5 3.026C2.5 4.534 1 6.531 1 9.526C1 12.262 3.5 13.5 7 13.5" />
                                        <path
                                            d="M8.383 6.806a1.08 1.08 0 0 0-1.022-.723h-.838a.967.967 0 0 0-.207 1.912l1.277.28a1.084 1.084 0 0 1-.232 2.142H6.64c-.472 0-.873-.302-1.022-.722M7 6.083V5m0 6.5v-1.083" />
                                    </g>
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                ${{ number_format($totalAmountInvested, 2) }}
                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Total Invested</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="rounded-xl shadow-card w-full">
                <div class="px-4 pt-4 flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <!-- Nav tabs -->
                    <div class="flex flex-wrap gap-2 lg:gap-1" id="myTab" role="tablist">
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary active [.active]:bg-primary-subtle [.active]:text-primary"
                            id="revenue-tab" data-bs-toggle="tab" data-bs-target="#revenue" type="button"
                            role="tab" aria-controls="revenue" aria-selected="true">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2">
                                    <path d="M10 12h4m-4-4h4m0 13v-3a2 2 0 0 0-4 0v3" />
                                    <path
                                        d="M6 10H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2" />
                                    <path d="M6 21V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v16" />
                                </g>
                            </svg> Open</button>
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                            id="withdraw-tab" data-bs-toggle="tab" data-bs-target="#withdraw" type="button"
                            role="tab" aria-controls="withdraw" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2">
                                    <path d="M10 12h4m-4-4h4m0 13v-3a2 2 0 0 0-4 0v3" />
                                    <path
                                        d="M6 10H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2" />
                                    <path d="M6 21V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v16" />
                                </g>
                            </svg> Closed</button>
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                            id="forex-tab" data-bs-toggle="tab" data-bs-target="#forex" type="button" role="tab"
                            aria-controls="profit" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round"
                                    stroke-linejoin="round" stroke-width="2"
                                    d="M12 16v5m4-7v7m4-11v11m2-18l-8.646 8.646a.5.5 0 0 1-.708 0L9.354 8.354a.5.5 0 0 0-.707 0L2 15m2 3v3m4-7v7" />
                            </svg> Your Investments</button>
                        <button
                            class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                            id="howorks-tab" data-bs-toggle="tab" data-bs-target="#howorks" type="button"
                            role="tab" aria-controls="howorks" aria-selected="false">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                viewBox="0 0 24 24">
                                <g fill="none" stroke="currentColor" stroke-linecap="round"
                                    stroke-linejoin="round" stroke-width="2">
                                    <path
                                        d="M3.85 8.62a4 4 0 0 1 4.78-4.77a4 4 0 0 1 6.74 0a4 4 0 0 1 4.78 4.78a4 4 0 0 1 0 6.74a4 4 0 0 1-4.77 4.78a4 4 0 0 1-6.75 0a4 4 0 0 1-4.78-4.77a4 4 0 0 1 0-6.76" />
                                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3m.08 4h.01" />
                                </g>
                            </svg> How it works</button>
                    </div>
                </div>
                <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                <!-- Tab panes -->
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="revenue" role="tabpanel"
                        aria-labelledby="revenue-tab" tabindex="0">
                        <div class="w-full mb-4 mt-4">
                            <div class="grid grid-cols-1 md:grid-cols-3 sm:grid-cols-2 gap-4 mb-4">
                                <!--:Course card:-->
                                @forelse($openreal as $estate)
                                    <div
                                        class="rounded-xl p-2 bg-white dark:bg-zinc-900 shadow-card transition-all hover:-translate-y-1 transform group dark:border-zinc-800 border border-zinc-200 hover:border-zinc-500">
                                        <a href="{{ route('user.real.details', $estate->id) }}">
                                            @if ($estate->images->count())
                                                <img src="{{ asset($estate->images->first()->image) }}"
                                                    class="max-w-full rounded mb-4" alt="">
                                            @endif
                                        </a>
                                        <div class="flex items-center justify-between gap-3.5 px-4 pb-4">

                                        </div>
                                        <div class="px-4 pb-4">
                                            <a href="{{ route('user.real.details', $estate->id) }}"
                                                class="text-lg font-semibold block mb-2 text-zinc-900 dark:text-white">
                                                {{ $estate->title }}
                                            </a>
                                            <p class="line-clamp-2 mb-6 text-muted">
                                                {{ $estate->short_desc }}
                                            </p>
                                            <div
                                                class="grid grid-cols-3 gap-4 mb-6 divide-x divide-dashed divide-zinc-200 dark:divide-zinc-800">
                                                <div class="text-start">
                                                    <p class="text-sm text-muted"><a
                                                            href="{{ route('user.real.details', $estate->id) }}">Minimum</a>
                                                    </p>
                                                    <p>${{ number_format($estate->price, 2) }}</p>
                                                </div>
                                                <div class="text-center">
                                                    <p class="text-sm text-muted"><a
                                                            href="{{ route('user.real.details', $estate->id) }}">ROI</a>
                                                    </p>
                                                    <p>{{ $estate->roi }}%</p>
                                                </div>
                                                <div class="text-end">
                                                    <p class="text-sm text-muted"><a
                                                            href="{{ route('user.real.details', $estate->id) }}">Strategy</a>
                                                    </p>
                                                    <p>{{ $estate->strategy }}</p>
                                                </div>
                                            </div>
                                            <div class="flex gap-2 w-full mt-4">
                                                <a href="{{ route('user.real.details', $estate->id) }}"
                                                    type="button"
                                                    class="btn flex-1 bg-zinc-100 dark:bg-zinc-700
                                                        hover:bg-zinc-200 dark:hover:bg-zinc-600 dark:hover:text-white">
                                                    View Project
                                                </a>

                                                <button type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse{{ $estate->id }}"
                                                    class="btn flex-1 bg-primary text-white hover:bg-primary-deep">
                                                    Invest Now
                                                </button>

                                            </div>
                                        </div>
                                        <!--:Collapse:-->
                                        <div class="collapse" id="collapse{{ $estate->id }}">

                                            <div class="content flex-grow lg:px-4 mt-4">
                                                <div
                                                    class="flex flex-col rounded-md bg-white dark:bg-zinc-900 shadow-card border-zinc-200 dark:border-zinc-800 border overflow-hidden divide-y divide-zinc-500/10 dark:divide-zinc-800">
                                                    <div class="bg-white dark:bg-zinc-900 rounded-lg shadow p-6">
                                                        <h2 class="font-semibold mb-4">
                                                            {{ $estate->title }}</h2>
                                                        <form method="POST"
                                                            action="{{ route('user.realestate.invest', $estate->id) }}">
                                                            @csrf
                                                            <div class="investment-calculator">
                                                                <!-- Common Amount -->
                                                                <div class="mb-4">
                                                                    <label
                                                                        class="block mb-1 font-medium">Amount</label>

                                                                    <input type="number" name="amount"
                                                                        placeholder="{{ $estate->price }}"
                                                                        min="{{ $estate->price }}" step="0.01"
                                                                        class="input amountInput" required>

                                                                    <small class="text-gray-500">
                                                                        Minimum investment:
                                                                        ${{ number_format($estate->price, 2) }}
                                                                    </small>

                                                                    @error('amount')
                                                                        <p class="text-red-600">{{ $message }}</p>
                                                                    @enderror
                                                                </div>

                                                                <!-- Common Amount -->
                                                                <div class="mb-4">
                                                                    <label
                                                                        class="block mb-1 font-medium">Duration</label>
                                                                    <select class="input durationSelect"
                                                                        name="duration_days">
                                                                        <option value="1">1 day</option>
                                                                        <option value="5">5 days</option>
                                                                        <option value="10">10 day</option>
                                                                        <option value="15">15 day</option>
                                                                        <option value="20">20 day</option>
                                                                        <option value="30">1 month</option>
                                                                        <option value="60">2 months</option>
                                                                        <option value="90">3 months</option>
                                                                        <option value="120">4 months</option>
                                                                        <option value="150">5 months</option>
                                                                        <option value="180">6 months</option>
                                                                        <option value="210">7 months</option>
                                                                        <option value="240">8 months</option>
                                                                        <option value="270">9 months</option>
                                                                        <option value="300">10 months</option>
                                                                        <option value="330">11 months</option>
                                                                        <option value="360">1 year</option>
                                                                    </select>
                                                                </div>

                                                                <!-- Common Amount -->
                                                                <div class="mb-4">
                                                                    <label class="block mb-1 font-medium">ROI</label>
                                                                    <input type="number" name="roi_percent"
                                                                        class="input roiInput" required
                                                                        value="{{ $estate->roi }}" readonly>
                                                                    @error('roi_percent')
                                                                        <p style="color:red">{{ $message }}</p>
                                                                    @enderror
                                                                </div>

                                                                <!-- Expected Return -->
                                                                <div class="mb-4">
                                                                    <label class="block mb-1 font-medium">Expected
                                                                        Return</label>

                                                                    <div
                                                                        class="p-3 bg-gray-100 dark:bg-zinc-800 rounded">
                                                                        <p class="mb-1">Profit: $<span
                                                                                class="profitPreview">0.00</span>
                                                                        </p>
                                                                        <p>Total Return: $<span
                                                                                class="totalPreview">0.00</span>
                                                                        </p>
                                                                    </div>
                                                                </div>

                                                                <div class="mt-6 text-center">
                                                                    <button type="submit"
                                                                        class="btn bg-primary rounded-xl text-white w-full mt-4 px-4 hover:bg-primary-deep h-10">
                                                                        Invest
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <p>No available real estate investments.</p>
                                @endforelse
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="withdraw" role="tabpanel" aria-labelledby="withdraw-tab"
                        tabindex="0">
                        <div class="w-full mb-4 mt-4">
                            <div class="grid grid-cols-1 md:grid-cols-3 sm:grid-cols-2 gap-4 mb-4">

                                <!--:Course card:-->
                                @forelse($closereal as $estate)
                                    <div
                                        class="rounded-xl p-2 bg-white dark:bg-zinc-900 shadow-card transition-all hover:-translate-y-1 transform group dark:border-zinc-800 border border-zinc-200 hover:border-zinc-500">
                                        @if ($estate->images->count())
                                            <img src="{{ asset($estate->images->first()->image) }}"
                                                class="rounded mb-4"
                                                style="filter: grayscale(100%); width:100%; height:220px;"
                                                alt="">
                                        @endif
                                        <div class="flex items-center justify-between gap-3.5 px-4 pb-4">

                                        </div>
                                        <div class="px-4 pb-4">
                                            <p class="text-lg font-semibold block mb-2 text-zinc-900 dark:text-white">
                                                {{ $estate->title }}
                                            </p>
                                            <p class="line-clamp-2 mb-6 text-muted">
                                                {{ $estate->short_desc }}
                                            </p>
                                            <div
                                                class="grid grid-cols-3 gap-4 mb-6 divide-x divide-dashed divide-zinc-200 dark:divide-zinc-800">
                                                <div class="text-start">
                                                    <p class="text-sm text-muted">Minimum
                                                    </p>
                                                    <p>${{ number_format($estate->price, 2) }}</p>
                                                </div>
                                                <div class="text-center">
                                                    <p class="text-sm text-muted"><a
                                                            href="{{ route('user.real.details', $estate->id) }}">ROI</a>
                                                    </p>
                                                    <p>{{ $estate->roi }}%</p>
                                                </div>
                                                <div class="text-end">
                                                    <p class="text-sm text-muted"><a
                                                            href="{{ route('user.real.details', $estate->id) }}">Strategy</a>
                                                    </p>
                                                    <p>{{ $estate->strategy }}</p>
                                                </div>
                                            </div>
                                            <div class="flex gap-2 w-full mt-4">
                                                <button type="button" disabled
                                                    class="btn flex-1 bg-zinc-100 dark:bg-zinc-700
                                                        hover:bg-zinc-200 dark:hover:bg-zinc-600 dark:hover:text-white">
                                                    Project closed
                                                </button>

                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <p>No available real estate investments.</p>
                                @endforelse
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="forex" role="tabpanel" aria-labelledby="forex-tab"
                        tabindex="0">
                        <div class="px-2 grid grid-cols-1 gap-4 mb-4">
                            <!--:Card:-->
                            @forelse($invest as $item)
                                <div
                                    class="rounded-xl bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card overflow-hidden relative">
                                    <div class="p-4">
                                        <div class="flex flex-wrap items-start justify-between">
                                            <div class="flex items-center gap-3">
                                                <!-- Icon inside a background span -->
                                                <span
                                                    class="bg-blue-500/10 text-blue-500 rounded-xl p-3 flex items-center justify-center">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="27"
                                                        height="27" viewBox="0 0 24 24">
                                                        <g fill="none" stroke="currentColor"
                                                            stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2">
                                                            <path d="M10 12h4m-4-4h4m0 13v-3a2 2 0 0 0-4 0v3" />
                                                            <path
                                                                d="M6 10H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2" />
                                                            <path d="M6 21V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v16" />
                                                        </g>
                                                    </svg>
                                                </span>

                                                <!-- Plan name and description -->
                                                <div>
                                                    <h3 class="text-xl font-semibold mb-1">{{ $item->estate->title }}
                                                    </h3>
                                                </div>
                                            </div>
                                            <!--:Legend:-->
                                            <div class="flex flex-wrap gap-3 pt-4">
                                                <span class="badge bg-primary-subtle text-primary">
                                                    <p class="text-zinc-400 text-sm flex items-center gap-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                            height="20" viewBox="0 0 24 24" class="shrink-0">
                                                            <g fill="none" stroke="currentColor"
                                                                stroke-width="1.5">
                                                                <circle cx="12" cy="12" r="10"
                                                                    opacity="0.5" />
                                                                <path stroke-linecap="round"
                                                                    d="M12 6v12m3-8.5C15 8.12 13.657 7 12 7S9 8.12 9 9.5s1.343 2.5 3 2.5s3 1.12 3 2.5s-1.343 2.5-3 2.5s-3-1.12-3-2.5" />
                                                            </g>
                                                        </svg>
                                                        Investment Amount:
                                                        <span
                                                            class="font-semibold">${{ number_format($item->amount, 2) }}</span>
                                                    </p>
                                                </span>
                                                <span class="badge bg-sky-500/10 text-sky-500">
                                                    <p class="text-zinc-400 text-sm flex items-center gap-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                            height="20" viewBox="0 0 24 24" class="shrink-0">
                                                            <path fill="currentColor"
                                                                d="M13.75 9a.75.75 0 0 1 .75-.75H18a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-1.69l-4.72 4.72a.75.75 0 0 1-1.06 0L9 13.06l-2.47 2.47a.75.75 0 0 1-1.06-1.06l3-3a.75.75 0 0 1 1.06 0L12 13.94l4.19-4.19H14.5a.75.75 0 0 1-.75-.75" />
                                                        </svg>
                                                        Expected ROI:
                                                        <span
                                                            class="text-green-500 font-semibold">{{ $item->estate->roi }}%</span>
                                                    </p>
                                                </span>
                                                <span class="badge bg-blue-500/10 text-blue-500">
                                                    <p class="text-zinc-400 text-sm  flex items-center gap-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                            height="20" viewBox="0 0 24 24" class="shrink-0">
                                                            <path fill="currentColor" fill-rule="evenodd"
                                                                d="m12.6 11.503l3.891 3.891l-.848.849L11.4 12V6h1.2zM12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m0-1.2a8.8 8.8 0 1 0 0-17.6a8.8 8.8 0 0 0 0 17.6" />
                                                        </svg>
                                                        Expiration:
                                                        <span id="countdown-{{ $item->id }}"
                                                            class="font-semibold"></span>
                                                    </p>
                                                </span>
                                                <span
                                                    class="badge  @if ($item->status === 'active') bg-green-500/10 text-green-500
                                                        @elseif($item->status === 'completed') bg-blue-500/10 text-blue-500
                                                        @elseif($item->status === 'pending') bg-amber-500/10 text-amber-500
                                                        @else bg-red-500/10 text-red-500 @endif">
                                                    <div
                                                        class="w-1.5 h-1.5 rounded-full mr-1.5
                                                            @if ($item->status === 'active') bg-green-500
                                                            @elseif($item->status === 'completed') bg-blue-500
                                                            @elseif($item->status === 'pending') bg-amber-500
                                                            @else bg-red-500 @endif">
                                                    </div>
                                                    {{ ucfirst($item->status) }}
                                                </span>
                                                </span>
                                                <a href="{{ url('user/estate_invest_details/' . $item->id) }}"
                                                    class="btn btn-sm bg-zinc-500/20 gap-1">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20"
                                                        height="20" viewBox="0 0 24 24">
                                                        <path fill="currentColor"
                                                            d="M11.5 18c4 0 7.46-2.22 9.24-5.5C18.96 9.22 15.5 7 11.5 7s-7.46 2.22-9.24 5.5C4.04 15.78 7.5 18 11.5 18m0-12c4.56 0 8.5 2.65 10.36 6.5C20 16.35 16.06 19 11.5 19S3 16.35 1.14 12.5C3 8.65 6.94 6 11.5 6m0 2C14 8 16 10 16 12.5S14 17 11.5 17S7 15 7 12.5S9 8 11.5 8m0 1A3.5 3.5 0 0 0 8 12.5a3.5 3.5 0 0 0 3.5 3.5a3.5 3.5 0 0 0 3.5-3.5A3.5 3.5 0 0 0 11.5 9" />
                                                    </svg> View Details
                                                </a>
                                            </div>
                                        </div>
                                        <div class="h-8"></div>
                                        <div class="flex items-center pb-4">
                                            @php
                                                $start = \Carbon\Carbon::parse($item->start_date);
                                                $end = \Carbon\Carbon::parse($item->end_date);
                                                $now = \Carbon\Carbon::now();

                                                $totalSeconds = $start->diffInSeconds($end);
                                                $elapsedSeconds = $start->isPast() ? $start->diffInSeconds($now) : 0;
                                                $progress =
                                                    $totalSeconds > 0
                                                        ? min(100, max(0, ($elapsedSeconds / $totalSeconds) * 100))
                                                        : 0;

                                                $remaining = $now->lt($end)
                                                    ? $now->diffForHumans($end, [
                                                        'parts' => 2,
                                                        'join' => true,
                                                        'short' => true,
                                                        'syntax' => \Carbon\CarbonInterface::DIFF_RELATIVE_TO_NOW,
                                                    ])
                                                    : 'Completed';

                                                // ✅ Determine progress bar color based on progress %
                                                if ($progress < 25) {
                                                    $progressColor = 'bg-primary';
                                                } elseif ($progress < 50) {
                                                    $progressColor = 'bg-amber-500/20';
                                                } elseif ($progress < 75) {
                                                    $progressColor = 'bg-sky-500';
                                                } else {
                                                    $progressColor = 'bg-green-500/30';
                                                }
                                            @endphp

                                            <!-- ✅ Progress Bar -->
                                            <div class="progress flex-grow h-2 rounded-full overflow-hidden bg-primary-subtle"
                                                role="progressbar" aria-label="Investment Progress"
                                                aria-valuenow="{{ round($progress, 2) }}" aria-valuemin="0"
                                                aria-valuemax="100">
                                                <div class="{{ $progressColor }} h-2 transition-all duration-500"
                                                    style="width: {{ $progress }}%;"></div>
                                            </div>

                                            <!-- ✅ Percentage Display -->
                                            <div class="text-right text-xs text-zinc-400 px-1">
                                                {{ round($progress, 1) }}%
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                            @endforelse
                        </div>
                    </div>

                    <div class="tab-pane fade" id="howorks" role="tabpanel" aria-labelledby="howorks-tab"
                        tabindex="0">
                        <div class="grid grid-cols-1 gap-4 mb-4">
                            <!--:Card:-->
                            <div class="content flex-grow lg:px-4">
                                <div class="py-4 max-w-7xl mx-auto">
                                    <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card">
                                        <div class="px-4 pt-4 pb-1.5 flex items-center justify-between">
                                            <h5 class="text-lg">FAQs</h5>
                                        </div>
                                        <div class="divide-y px-4 divide-zinc-100 dark:divide-zinc-900"
                                            id="accordionExample">
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">
                                                    <span class="flex-grow truncate text-start block h5">How does 'Real
                                                        Estate'
                                                        work?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseOne" class="collapse show"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        Real estate allows you to invest in commercial real estate
                                                        projects,
                                                        and
                                                        in return, you earn a share of the returns. The 'open' projects
                                                        are
                                                        projects that are available for investment. The 'closed'
                                                        projects
                                                        are
                                                        projects that are no longer available for investment.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseTwo" aria-expanded="false"
                                                    aria-controls="collapseTwo">
                                                    <span class="flex-grow truncate text-start h5 block">How do I make
                                                        money
                                                        from real estate?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseTwo" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        We source for projects with potential and in their later stages
                                                        of
                                                        development. We carefully vet these projects, collect the
                                                        necessary
                                                        documents and then list them on the platform for you to invest
                                                        in.
                                                        These
                                                        projects are typically in the pre-lease-up stage, which means
                                                        they
                                                        are
                                                        in the early stages of development and have the potential to
                                                        generate
                                                        significant returns.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseThree" aria-expanded="false"
                                                    aria-controls="collapseThree">
                                                    <span class="flex-grow truncate text-start h5 block">How do I
                                                        invest in
                                                        a
                                                        project?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseThree" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        To invest in a project, simply select the project you are
                                                        interested
                                                        in,
                                                        and then click the 'Invest now' button. A dialog will appear,
                                                        where
                                                        you
                                                        can select the amount you want to invest and the duration of
                                                        your
                                                        investment. Once you have made your selection, click the
                                                        'Invest'
                                                        button
                                                        to complete the investment.
                                                    </div>
                                                </div>
                                            </div>
                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseFour" aria-expanded="false"
                                                    aria-controls="collapseFour">
                                                    <span class="flex-grow truncate text-start block h5">How do I know
                                                        how
                                                        much
                                                        I will earn?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseFour" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The ROI is the estimated percentage of your amount that you will
                                                        earn
                                                        back after the investment is complete. We also return back your
                                                        initial
                                                        investment amount to you.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseFive" aria-expanded="false"
                                                    aria-controls="collapseFive">
                                                    <span class="flex-grow truncate text-start block h5">How long does
                                                        an
                                                        investment last?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseFive" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The duration of the investment is defined by the project. For
                                                        example,
                                                        if you select a 12-month investment, you will earn a share of
                                                        the
                                                        returns for 12 months. Once the investment is complete, you will
                                                        receive
                                                        your initial investment amount back. We forward-fund the
                                                        project, so
                                                        you
                                                        don't have to wait for the project to be fully funded or
                                                        complete
                                                        before
                                                        you can start earning returns.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseSix" aria-expanded="false"
                                                    aria-controls="collapseSix">
                                                    <span class="flex-grow truncate text-start block h5">Can I invest
                                                        in
                                                        multiple projects at the same time?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseSix" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        Yes, you can invest in multiple projects at the same time. You
                                                        can
                                                        invest in as many projects as you want, and you can invest in
                                                        the
                                                        same
                                                        project multiple times.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseSeven" aria-expanded="false"
                                                    aria-controls="collapseSeven">
                                                    <span class="flex-grow truncate text-start block h5">What is the
                                                        minimum
                                                        investment amount?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseSeven" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The minimum investment amount is defined by the project. For
                                                        example, if
                                                        the minimum investment amount is $1000, you can invest in the
                                                        project
                                                        with a minimum of $1000.
                                                    </div>
                                                </div>
                                            </div>

                                            <!--:Collapse item:-->
                                            <div class="collapse-item">
                                                <button
                                                    class="flex w-full items-center justify-between cursor-pointer py-2.5 collapsed"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseEight" aria-expanded="false"
                                                    aria-controls="collapseEight">
                                                    <span class="flex-grow truncate text-start block h5">What is the
                                                        total
                                                        portfolio value?</span>
                                                    <span
                                                        class="icon-[lucide--chevron-up] collapse-arrow shrink-0 size-4 flex items-center justify-center"></span>
                                                </button>
                                                <div id="collapseEight" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="pb-4">
                                                        The total portfolio value is usually a total of your accumulated
                                                        earnings. You can withdraw from this amount at any time. At
                                                        completion
                                                        of an investment, your initial investment amount will be added
                                                        to
                                                        this
                                                        total and you will be able to withdraw from it.
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.querySelectorAll('.investment-calculator').forEach(card => {

            const amountInput = card.querySelector('.amountInput');
            const durationSelect = card.querySelector('.durationSelect');
            const roiInput = card.querySelector('.roiInput');
            const profitPreview = card.querySelector('.profitPreview');
            const totalPreview = card.querySelector('.totalPreview');

            function calculateReturn() {
                let amount = parseFloat(amountInput.value) || 0;
                let roi = parseFloat(roiInput.value) || 0;
                let duration = parseInt(durationSelect.value) || 0;

                let profit = amount * (roi / 100) * (duration / 30);
                let total = amount + profit;

                profitPreview.innerText = profit.toFixed(2);
                totalPreview.innerText = total.toFixed(2);
            }

            amountInput.addEventListener('input', calculateReturn);
            durationSelect.addEventListener('change', calculateReturn);

            calculateReturn();
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            @foreach ($invest as $item)
                const endDate{{ $item->id }} = new Date(
                    "{{ \Carbon\Carbon::parse($item->end_date) }}").getTime();

                const countdownFunc{{ $item->id }} = setInterval(function() {
                    const now = new Date().getTime();
                    const distance = endDate{{ $item->id }} - now;

                    if (distance <= 0) {
                        clearInterval(countdownFunc{{ $item->id }});
                        document.getElementById("countdown-{{ $item->id }}").innerHTML = "Completed";
                        const mobile = document.getElementById("countdown-mobile-{{ $item->id }}");
                        if (mobile) mobile.innerHTML = "Completed";
                        return;
                    }

                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    const formatted = `${days}d ${hours}h ${minutes}m ${seconds}s`;
                    document.getElementById("countdown-{{ $item->id }}").innerHTML = formatted;

                    const mobile = document.getElementById("countdown-mobile-{{ $item->id }}");
                    if (mobile) mobile.innerHTML = formatted;
                }, 1000);
            @endforeach
        });
    </script>

</x-user>
