<x-user :title="$pageTitle">
    <!--:Page content:-->

    <div class="px-4 py-10 mb-4 lg:py-12 rounded-b-xl bg-gradient-to-t from-primary dark:from-primary">
        <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
            <div class="flex justify-center mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 32 32">
                    <g fill="none">
                        <path fill="#f8312f"
                            d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                        <path fill="#ffb02e"
                            d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                        <path fill="#cdc4d6"
                            d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                        <path fill="#212121"
                            d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                        <path fill="#00a6ed"
                            d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                    </g>
                </svg>
            </div>
            <h1 class="text-xl lg:text-2xl font-semibold mb-2">AI Bot Trading Dashboard</h1>
            <p class="text-white mb-6">
                Manage and Monitor your Automated Trading Investments
            </p>
        </div>
    </div>

    <div class="content flex-grow pt-4 lg:px-4">
        <div class="max-w-7xl mx-auto">
            <div class="mb-4 p-4 rounded-xl shadow-card overflow-hidden">
                <div class="px-2 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4 mb-4">
                    <!--:Card:-->
                    <div class="p-4 gap-2.5 rounded-xl shadow-card border border-zinc-200 dark:border-zinc-700">
                        <div class="flex px-2 flex-col">
                            <div class="flex items-center justify-between mb-3">
                                <!--:Icon:-->
                                <div
                                    class="size-12 rounded-lg bg-primary-subtle dark:bg-primary-subtle flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        class="text-sky-500" viewBox="0 0 38 32">
                                        <g fill="currentColor">
                                            <path
                                                d="M32.509 7.5a.5.5 0 0 0 .5-.5V5.335a1.64 1.64 0 0 0-1.638-1.638h-2.687l-.613-1.809a.5.5 0 0 0-.619-.318L12.899 5.994a.501.501 0 0 0 .292.957L27.28 2.667l1.343 3.965a.499.499 0 1 0 .947-.321l-.547-1.615h2.349c.352 0 .638.286.638.638V7c-.001.276.223.5.499.5" />
                                            <path
                                                d="M36.5 15a.5.5 0 0 0 0 1c.351 0 .5.149.5.5v6c0 .351-.149.5-.5.5h-8c-.351 0-.5-.149-.5-.5v-5c0-.351.149-.5.5-.5h6a.5.5 0 0 0 .5-.5v-6c0-.911-.589-1.5-1.5-1.5H3c-1.233 0-2-.767-2-2s.767-2 2-2h5.076l-3.026.998a.5.5 0 1 0 .313.949L23.482.974a.5.5 0 1 0-.314-.95l-12.1 3.99C11.045 4.01 11.024 4 11 4H3C1.206 4 0 5.206 0 7v22c0 1.794 1.206 3 3 3h30.5c.911 0 1.5-.589 1.5-1.5v-5a.5.5 0 0 0-1 0v5c0 .351-.149.5-.5.5H3c-1.233 0-2-.767-2-2V9.312c.513.433 1.192.688 2 .688h30.5c.351 0 .5.149.5.5V16h-5.5c-.911 0-1.5.589-1.5 1.5v5c0 .911.589 1.5 1.5 1.5h8c.911 0 1.5-.589 1.5-1.5v-6c0-.911-.589-1.5-1.5-1.5" />
                                            <circle cx="32" cy="20" r="1" />
                                        </g>
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <h5 class="text-2xl mb-1">${{ $totalInvested }}</h5>
                                <p class="text-muted text-sm">Total Invested</p>
                            </div>
                        </div>
                    </div>
                    <!--:Card:-->
                    <div class="p-4 gap-2.5 rounded-xl shadow-card border border-zinc-200 dark:border-zinc-700">
                        <div class="flex px-2 flex-col">
                            <div class="flex items-center justify-between mb-3">
                                <!--:Icon:-->
                                <div
                                    class="size-10 rounded-lg bg-zinc-100 dark:bg-zinc-800 flex items-center justify-center">
                                    <span class="icon-[lucide--dollar-sign] text-2xl text-primary"></span>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <h5 class="text-2xl mb-1">${{ $currentBalance }}</h5>
                                <p class="text-muted text-sm">Current Balance</p>
                            </div>
                        </div>
                    </div>
                    <!--:Card:-->
                    <div class="p-4 gap-2.5 rounded-xl shadow-card border border-zinc-200 dark:border-zinc-700">
                        <div class="flex px-2 flex-col">
                            <div class="flex items-center justify-between mb-3">
                                <!--:Icon:-->
                                <div
                                    class="size-10 rounded-lg bg-green-500/20 dark:bg-green-500/20 flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        viewBox="0 0 24 24">
                                        <path fill="currentColor" d="M7.03 9.97h4v8.92l2.01.03V9.97h3.99l-5-5Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <p class="text-2xl font-semibold mb-1 text-green-500">+${{ $totalPositive }}</p>
                                <p class="text-muted text-sm">Total profit</p>
                            </div>
                        </div>
                    </div>
                    <!--:Card:-->
                    <div class="p-4 gap-2.5 rounded-xl shadow-card border border-zinc-200 dark:border-zinc-700">
                        <div class="flex px-2 flex-col">
                            <div class="flex items-center justify-between mb-3">
                                <!--:Icon:-->
                                <div
                                    class="size-10 rounded-lg bg-red-500/10 dark:bg-red-500/10 flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="text-red-500" width="32"
                                        height="32" viewBox="0 0 24 24">
                                        <g fill="none">
                                            <path
                                                d="M24 0v24H0V0zM12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z" />
                                            <path fill="currentColor"
                                                d="m11 17.243l-3.95-3.95a1 1 0 1 0-1.414 1.414l5.657 5.657a1 1 0 0 0 1.414 0l5.657-5.657a1 1 0 0 0-1.414-1.414L13 17.243V4a1 1 0 1 0-2 0z" />
                                        </g>
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <p class="text-2xl font-semibold mb-1 text-red-500">${{ $totalNegative }}</p>
                                <p class="text-muted text-sm">Total Loss</p>
                            </div>
                        </div>
                    </div>
                    <!--:Card:-->
                    <div class="p-4 gap-2.5 rounded-xl shadow-card border border-zinc-200 dark:border-zinc-700">
                        <div class="flex px-2 flex-col">
                            <div class="flex items-center justify-between mb-3">
                                <!--:Icon:-->
                                <div
                                    class="size-10 rounded-lg bg-sky-500/10 dark:bg-sky-500/10 flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        class="text-blue-500" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-width="1.5">
                                            <path
                                                d="M14.706 4.313H9.294a4.98 4.98 0 0 0-4.982 4.981v5.412a4.98 4.98 0 0 0 4.982 4.982h5.412a4.98 4.98 0 0 0 4.982-4.982V9.294a4.98 4.98 0 0 0-4.982-4.982Z" />
                                            <path
                                                d="M19.606 15.588h1.619a1.025 1.025 0 0 0 1.025-1.025V9.438a1.025 1.025 0 0 0-1.025-1.025h-1.62m-15.21 7.175h-1.62a1.025 1.025 0 0 1-1.025-1.025V9.438a1.025 1.025 0 0 1 1.025-1.025h1.62" />
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M2.765 8.413v-4.1m18.46 4.1l-.01-4.1M9.95 15.237a2.91 2.91 0 0 0 4.1 0m-6.17-4.262L8.903 9.95l1.025 1.025m4.102 0l1.025-1.025l1.024 1.025" />
                                        </g>
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <p class="text-2xl mb-1 text-muted">{{ $activeCount }}</p>
                                <p class="text-muted text-sm">Active Bots</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="max-w-7xl mx-auto">
            <div class="px-4 grid grid-cols-1 lg:grid-cols-12 gap-4">
                <div class="lg:col-span-8">
                    <!--:Card:-->
                    <div class="rounded-xl shadow-card overflow-hidden">
                        <div class="flex items-center justify-between p-4">
                            <h5 class="text-lg">Your Investments</h5>
                            <a href="{{ url('user/bot_ai_trading') }}" class="btn btn-sm btn-default">+ New
                                Investment</a>
                        </div>
                        <div>
                            <!--:Card:-->
                            @forelse($runningtrades as $item)
                                <div
                                    class="rounded-xl bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card mb-3">
                                    <!--:Card header:-->
                                    <div class="flex items-center gap-4 p-4">
                                        <div class="shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                                viewBox="0 0 32 32">
                                                <g fill="none">
                                                    <path fill="#f8312f"
                                                        d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                                                    <path fill="#ffb02e"
                                                        d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                                                    <path fill="#cdc4d6"
                                                        d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                                                    <path fill="#212121"
                                                        d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                                                    <path fill="#00a6ed"
                                                        d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="flex-grow">
                                            <h5 class="truncate text-lg mb-1">
                                                {{ $item->bot->name }}
                                            </h5>
                                            <span class="flex items-center gap-2 text-sm">
                                                <p>
                                                    {{ $item->bot->description }}
                                                </p>
                                            </span>

                                        </div>
                                        <div class="relative shrink-0">
                                            <span
                                                class="badge shrink-0 bg-green-500/10 text-green-500">{{ $item->status }}</span>
                                        </div>
                                    </div>
                                    <!--:About team:-->
                                    <div class="px-4 pb-4">
                                        <div class="items-center grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-2">
                                            <div
                                                class="p-3 rounded-lg flex-grow border border-dashed border-zinc-200 dark:border-zinc-800">
                                                <span class="text-sm text-zinc-400">Invested</span>
                                                <h5 class="text-lg">${{ $item->amount_invested }}</h5>
                                            </div>
                                            <div
                                                class="p-3 rounded-lg flex-grow border border-dashed border-zinc-200 dark:border-zinc-800">
                                                <span class="text-sm text-zinc-400">Current Value</span>
                                                <h5 class="text-lg">${{ $item->current_value }}</h5>
                                            </div>
                                            <div
                                                class="p-3 rounded-lg flex-grow border border-dashed border-zinc-200 dark:border-zinc-800">
                                                <span class="text-sm text-zinc-400">P$L</span>
                                                @php
                                                    $isProfit = $item->profit_earned > 0;
                                                    $isLoss = $item->profit_earned < 0;
                                                @endphp

                                                <p
                                                    class="text-md font-semibold {{ $isProfit ? 'text-green-500' : ($isLoss ? 'text-red-500' : 'text-gray-500') }}">
                                                    {{ $isProfit ? '+' : ($isLoss ? '-' : '') }}${{ number_format(abs($item->profit_earned), 2) }}
                                                </p>

                                            </div>
                                            <div
                                                class="p-3 rounded-lg flex-grow border border-dashed border-zinc-200 dark:border-zinc-800">
                                                <span class="text-sm text-zinc-400">ROI</span>
                                                <h5 class="text-lg">$</h5>
                                            </div>
                                        </div>
                                    </div>
                                    <!--:Progress:-->
                                    <div class="px-4 pb-4">
                                        <hr class="border-zinc-200 dark:border-zinc-800 border my-3">
                                    </div>
                                    <!--:Action:-->
                                    <div class="flex items-center justify-between gap-4 px-4 pb-4">
                                        <span class="text-zinc-400 text-sm"><span
                                                class="icon-[lucide--history]"></span>
                                            Started: {{ $item->started_at->format('M d Y') }}</span>
                                        <a href="{{ route('user.botdetails', ['name' => $item->bot->name]) }}"
                                            class="btn btn-sm border border-zinc-200 dark:border-zinc-700 text-white hover:bg-primary-deep">View
                                            details</a>
                                    </div>
                                </div>
                            @empty
                                <div
                                    class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55"
                                        viewBox="0 0 48 48" class="mb-3">
                                        <g fill="none">
                                            <path fill="url(#SVGHyoaDcJJ)"
                                                d="M23.5 13a1.5 1.5 0 0 1 1.5 1.5V23h5.5a1.5 1.5 0 0 1 0 3h-7a1.5 1.5 0 0 1-1.5-1.5v-10a1.5 1.5 0 0 1 1.5-1.5" />
                                            <path fill="url(#SVGGRTsNbtc)"
                                                d="M24 9c8.284 0 15 6.716 15 15s-6.716 15-15 15S9 32.284 9 24q.002-1.162.171-2.275a1.5 1.5 0 0 0-2.966-.45Q6.001 22.61 6 24c0 9.941 8.059 18 18 18s18-8.059 18-18S33.941 6 24 6c-4.61 0-8.816 1.734-12 4.584V7.5a1.5 1.5 0 0 0-3 0v7a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 0-3h-3.698A14.94 14.94 0 0 1 24 9" />
                                            <defs>
                                                <linearGradient id="SVGHyoaDcJJ" x1="20.313" x2="44.734"
                                                    y1="37.809" y2="28.299" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#d373fc" />
                                                    <stop offset="1" stop-color="#6d37cd" />
                                                </linearGradient>
                                                <linearGradient id="SVGGRTsNbtc" x1="6" x2="15.663"
                                                    y1="8.118" y2="48.577" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#0fafff" />
                                                    <stop offset="1" stop-color="#0067bf" />
                                                </linearGradient>
                                            </defs>
                                        </g>
                                    </svg>
                                    <p class="text-xl font-semibold">No Ai Bot trades yet.</p>
                                    <a href="{{ url('user/bot_ai_trading') }}"
                                        class="btn btn-sm mt-4 btn-default">Start New
                                        Investment</a>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
                <div class="lg:col-span-4">
                    <!--:Card:-->
                    <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card border border-zinc-200 dark:border-zinc-700"
                        overflow-hidden mb-4">
                        <div class="flex items-center justify-between p-4 pb-0">
                            <h5 class="text-lg mb-3">Recent Activity</h5>
                        </div>
                        <ul class="px-4 divide-y divide-zinc-500/10 dark:divide-zinc-800">
                            @forelse($dailyLogs as $item)
                                @php
                                    $isProfit = $item->profit > 0;
                                @endphp
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 32 32">
                                            <g fill="none">
                                                <path fill="#f8312f"
                                                    d="M5 3.5a1.5 1.5 0 0 1-1 1.415V12l2.16 5.487L4 23c-1.1 0-2-.9-2-1.998v-7.004a2 2 0 0 1 1-1.728V4.915A1.5 1.5 0 1 1 5 3.5m25.05.05c0 .681-.44 1.26-1.05 1.468V12.2c.597.347 1 .994 1 1.73v7.01c0 1.1-.9 2-2 2l-2.94-5.68L28 11.93V5.018a1.55 1.55 0 1 1 2.05-1.468" />
                                                <path fill="#ffb02e"
                                                    d="M11 4.5A1.5 1.5 0 0 1 12.5 3h7a1.5 1.5 0 0 1 .43 2.938c-.277.082-.57.104-.847.186l-3.053.904l-3.12-.908c-.272-.08-.56-.1-.832-.18A1.5 1.5 0 0 1 11 4.5" />
                                                <path fill="#cdc4d6"
                                                    d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94" />
                                                <path fill="#212121"
                                                    d="M9.247 18.5h13.506c2.33 0 4.247-1.919 4.247-4.25A4.257 4.257 0 0 0 22.753 10H9.247A4.257 4.257 0 0 0 5 14.25a4.257 4.257 0 0 0 4.247 4.25m4.225 7.5h5.056C19.34 26 20 25.326 20 24.5s-.66-1.5-1.472-1.5h-5.056C12.66 23 12 23.674 12 24.5s.66 1.5 1.472 1.5" />
                                                <path fill="#00a6ed"
                                                    d="M10.25 12C9.56 12 9 12.56 9 13.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25m11.5 0c-.69 0-1.25.56-1.25 1.25v2.5a1.25 1.25 0 1 0 2.5 0v-2.5c0-.69-.56-1.25-1.25-1.25" />
                                            </g>
                                        </svg>
                                    </a>
                                    <div class="flex-grow overflow-hidden">
                                        <h6 class="mb-1"><a
                                                href="">{{ $item->trade->bot->name ?? 'N/A' }}</a></h6>
                                        <p class="text-zinc-400 truncate">
                                            {{ $item->percent !== null ? number_format($item->percent, 2) . '%' : '—' }}
                                        </p>
                                    </div>
                                    <div class="shrink-0">
                                        <p
                                            class="px-4 py-2 font-semibold {{ $isProfit ? 'text-green-500' : 'text-red-500' }}">
                                            {{ $isProfit ? '+' : '' }}${{ number_format($item->profit, 2) }}
                                        </p>
                                    </div>
                                </li>
                            @empty
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>




</x-user>
