<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 py-8 lg:py-12 rounded-b-xl">
        <div class="text-center">
            <div class="flex justify-center items-center gap-2 mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24">
                    <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                        <path
                            d="m14.022 16.483l-3.568 2.649c-.21.16-.52.48-.85.71a.7.7 0 0 1-.4.19a1.8 1.8 0 0 1-1.06-.55a14.5 14.5 0 0 1-1.448-1.69c-.79-1-1.56-1.999-2.3-2.999s-1.419-2.049-2.069-3.118c-1.349-2.18-1.269-1.41-.75-1.97q.47-.53 1-.999t1.11-.87l1.999-1.589l.66-.51c.16 0 .33.18.51.34q.372.349.7.74l.999 1.2l3.278 4.387a.361.361 0 1 0 .58-.43L9.254 7.488l-.95-1.26a7 7 0 0 0-1.119-1.16a1.48 1.48 0 0 0-.94-.32a1.4 1.4 0 0 0-.509.2q-.348.222-.66.49l-1.999 1.48c-.43.29-.84.59-1.24.91q-.6.497-1.139 1.059a4.6 4.6 0 0 0-.64.78a.7.7 0 0 0 0 .56q.144.381.36.73c.28.469.65.929.91 1.349c.65 1.089 1.34 2.168 2.119 3.208s1.6 2 2.449 2.999a11.5 11.5 0 0 0 1.999 1.999c.384.28.844.44 1.32.46a1.4 1.4 0 0 0 .76-.27q.526-.41.999-.88c.68-.56 1.36-1.14 1.999-1.689q.68-.549 1.38-1.08a.32.32 0 0 0-.36-.52z" />
                        <path
                            d="M8.915 11.175a2.38 2.38 0 0 0-3-.27a2.45 2.45 0 0 0-.889 1.74a2.15 2.15 0 0 0 .74 1.809c.397.308.887.47 1.39.46c.468.007.929-.117 1.329-.36a.33.33 0 0 0 .12-.44a.35.35 0 0 0 .27-.1a1.83 1.83 0 0 0 .04-2.839m-.58 2.309a.35.35 0 0 0 0 .47h-.12a1.76 1.76 0 0 1-1 .12a1.27 1.27 0 0 1-.77-.39a1.14 1.14 0 0 1-.23-1a1.33 1.33 0 0 1 .46-.89a1.24 1.24 0 0 1 1.55.07a1 1 0 0 1 .11 1.62m9.015-7.077a14 14 0 0 0-.379-1.55a7 7 0 0 0-.54-1.229a1.77 1.77 0 0 0-.81-.75a1.6 1.6 0 0 0-.739-.08q-.646.12-1.27.33a.324.324 0 1 0 .15.63q.495-.099 1-.13a.86.86 0 0 1 .45.09c.14.08.2.26.28.43q.215.518.32 1.07c.19.56.32 1.13.46 1.699s.33 1.17.49 1.75c.16.579.25.819.25.829c.079.42.619.08.659-.53c-.2-1.03-.12-1.53-.32-2.559m6.617 10.116a7.7 7.7 0 0 0-.51-2.12a6.7 6.7 0 0 0-1.12-1.889a8.18 8.18 0 0 0-4.367-2.598c-.36-.17-.63.09-.62.52a5.7 5.7 0 0 1-.71 1.579a2.71 2.71 0 0 1-2.759.38a1.35 1.35 0 0 0-.83.09a1.54 1.54 0 0 0-1.079 1.529a2 2 0 0 0 .8 1.609c.13.07.4.2.74.34c.77.32 1.999.74 2.468 1c-.08.2.21.73.26.88a5.5 5.5 0 0 0 1.07 1.808a1.8 1.8 0 0 0 1.44.62a.36.36 0 1 0 0-.72a1.1 1.1 0 0 1-.82-.45a4.3 4.3 0 0 1-.76-1.559c-.05-.18-.07-.75-.15-1a.6.6 0 0 0-.24-.34a5.6 5.6 0 0 0-.74-.399c-.87-.4-2.288-1-2.618-1.2a.77.77 0 0 1-.21-.57a.41.41 0 0 1 .25-.42a1 1 0 0 1 .35 0q.732.074 1.469.06a3 3 0 0 0 2.209-1.289a3.26 3.26 0 0 0 .48-1.709a7.6 7.6 0 0 1 3.448 2.56a7 7 0 0 1 .9 1.618c.234.583.402 1.19.5 1.81c.23 1.504.161 3.04-.2 4.518a.37.37 0 0 0 .25.45a.36.36 0 0 0 .44-.25c.556-1.556.78-3.21.66-4.858" />
                        <path
                            d="M14.852 10.066c-.29-1-.55-2-.83-3c-.18-.669-.39-1.329-.58-1.998a7.7 7.7 0 0 0-.75-2a1.45 1.45 0 0 0-1.079-.71a.87.87 0 0 0-.46.1q-.383.23-.74.5l-2.438 1.55a.32.32 0 1 0 .27.57l2.639-1.26c.45-.23.58-.89 1 .3c.18.48.29 1 .37 1.29c.389 1.189.769 2.368 1.189 3.548s.69 1.61 1.14 2.669c.199.58.719.72.719.29c-.21-.7-.24-1.15-.45-1.85" />
                    </g>
                </svg>
                <h4 class="text-xl lg:text-2xl font-semibold text-gray-900 dark:text-gray-100">
                    Loan Application
                </h4>
            </div>

            <p class="text-lg mx-auto text-muted mb-4">
                Apply for various credit facilities with competitive rates and flexible terms
            </p>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-4xl mx-auto">
            @if (session('message'))
                <div role="alert"
                    class="flex gap-2.5 items-center px-4 py-2.5 mb-4 rounded-lg bg-green-500/20 text-green-800 dark:text-green-200 gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="M5.25 4h13.5a3.25 3.25 0 0 1 3.245 3.066L22 7.25v9.5a3.25 3.25 0 0 1-3.066 3.245L18.75 20H5.25a3.25 3.25 0 0 1-3.245-3.066L2 16.75v-9.5a3.25 3.25 0 0 1 3.066-3.245zh13.5zM20.5 9.373l-8.15 4.29a.75.75 0 0 1-.603.043l-.096-.042L3.5 9.374v7.376a1.75 1.75 0 0 0 1.606 1.744l.144.006h13.5a1.75 1.75 0 0 0 1.744-1.607l.006-.143zM18.75 5.5H5.25a1.75 1.75 0 0 0-1.744 1.606L3.5 7.25v.429l8.5 4.474l8.5-4.475V7.25a1.75 1.75 0 0 0-1.607-1.744z" />
                    </svg>
                    <div class="flex-grow">
                        {{ session('message') }}
                    </div>
                </div>
            @endif
            <div class="mb-4 p-4 rounded-xl shadow-card overflow-hidden">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <!--:Card:-->
                    <div
                        class="overflow-hidden flex flex-col items-center border border-zinc-200 dark:border-zinc-700 justify-center text-center p-6 rounded-xl">
                        <div
                            class="flex items-center justify-center mb-4 size-12 rounded-full shrink-0 bg-green-500/10 text-green-500 shadow-lg">
                            <span class="icon-[lucide--percent] text-2xl"></span>
                        </div>
                        <h5 class="text-xl font-semibold mb-2 text-gray-800 dark:text-gray-100">Competitive Rates
                        </h5>
                        <p class="text-md text-gray-500 dark:text-gray-400">Low interest rates starting from 5.5%
                            APR</p>
                    </div>

                    <!--:Card:-->
                    <div
                        class="overflow-hidden flex flex-col items-center border border-zinc-200 dark:border-zinc-700 justify-center text-center p-6 rounded-xl">
                        <div
                            class="flex items-center justify-center mb-4 size-12 rounded-full shrink-0 bg-primary text-white shadow-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd"
                                    d="m12.6 11.503l3.891 3.891l-.848.849L11.4 12V6h1.2zM12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m0-1.2a8.8 8.8 0 1 0 0-17.6a8.8 8.8 0 0 0 0 17.6" />
                            </svg>
                        </div>
                        <h5 class="text-xl font-semibold mb-2 text-gray-800 dark:text-gray-100">Quick Approval</h5>
                        <p class="text-md text-gray-500 dark:text-gray-400">Get approved within 24–48 hours</p>
                    </div>

                    <!--:Card:-->
                    <div
                        class="overflow-hidden flex flex-col items-center border border-zinc-200 dark:border-zinc-700 justify-center text-center p-6 rounded-xl">
                        <div
                            class="flex items-center justify-center mb-4 size-12 rounded-full shrink-0 bg-sky-500 text-white shadow-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 50 50">
                                <g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                                    <path stroke="#344054" d="m18.75 22.917l4.167 4.166l8.333-8.333" />
                                    <path stroke="#306cfe"
                                        d="m25 43.75l1.833-.792a22.92 22.92 0 0 0 13.813-19.291l.896-11.5a2.08 2.08 0 0 0-1.584-2.084L25 6.25L10.042 10a2.08 2.08 0 0 0-1.584 2.083l.896 11.5a22.92 22.92 0 0 0 13.813 19.292z" />
                                </g>
                            </svg>
                        </div>
                        <h5 class="text-xl font-semibold mb-2 text-gray-800 dark:text-gray-100">Secure Process</h5>
                        <p class="text-md text-gray-500 dark:text-gray-400">Bank-level security and encryption</p>
                    </div>

                </div>
            </div>
            <!--:Search results:-->

            <div
                class="rounded-lg overflow-hidden shadow-card bg-white dark:bg-zinc-950 border border-zinc-200 dark:border-zinc-700">
                <div class="px-4 py-2.5 bg-sky-500/10">
                    <div class="flex items-center gap-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 36 36">
                            <path fill="currentColor"
                                d="M21 12H7a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1M8 10h12V7.94H8Z"
                                class="clr-i-outline clr-i-outline-path-1" />
                            <path fill="currentColor"
                                d="M21 14.08H7a1 1 0 0 0-1 1V19a1 1 0 0 0 1 1h11.36L22 16.3v-1.22a1 1 0 0 0-1-1M20 18H8v-2h12Z"
                                class="clr-i-outline clr-i-outline-path-2" />
                            <path fill="currentColor"
                                d="M11.06 31.51v-.06l.32-1.39H4V4h20v10.25l2-1.89V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v28a1 1 0 0 0 1 1h8a3.4 3.4 0 0 1 .06-.49"
                                class="clr-i-outline clr-i-outline-path-3" />
                            <path fill="currentColor" d="m22 19.17l-.78.79a1 1 0 0 0 .78-.79"
                                class="clr-i-outline clr-i-outline-path-4" />
                            <path fill="currentColor"
                                d="M6 26.94a1 1 0 0 0 1 1h4.84l.3-1.3l.13-.55v-.05H8V24h6.34l2-2H7a1 1 0 0 0-1 1Z"
                                class="clr-i-outline clr-i-outline-path-5" />
                            <path fill="currentColor"
                                d="m33.49 16.67l-3.37-3.37a1.61 1.61 0 0 0-2.28 0L14.13 27.09L13 31.9a1.61 1.61 0 0 0 1.26 1.9a1.6 1.6 0 0 0 .31 0a1.2 1.2 0 0 0 .37 0l4.85-1.07L33.49 19a1.6 1.6 0 0 0 0-2.27ZM18.77 30.91l-3.66.81l.89-3.63L26.28 17.7l2.82 2.82Zm11.46-11.52l-2.82-2.82L29 15l2.84 2.84Z"
                                class="clr-i-outline clr-i-outline-path-6" />
                            <path fill="none" d="M0 0h36v36H0z" />
                        </svg>
                        <h5 class="text-lg !text-white">
                            Loan Application
                        </h5>
                    </div>
                </div>
                <div class="px-2 p-4">
                    <form action="{{ route('user.loan.store') }}" method="POST">
                        @csrf
                        <div class="flex px-2 lg:px-4 flex-wrap -mx-2">
                            <div class="flex px-4 items-center gap-2 mb-4 text-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                    viewBox="0 0 20 20">
                                    <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                        <g opacity="0.2">
                                            <path
                                                d="M8.397 5.7c-.551.413-.8.908-.8 1.37s.249.958.8 1.372c.552.414 1.36.7 2.295.7a1 1 0 1 1 0 2c-1.326 0-2.565-.402-3.495-1.1s-1.6-1.738-1.6-2.971s.67-2.274 1.6-2.972C8.127 3.402 9.367 3 10.692 3c2.053 0 3.994.983 4.766 2.62a1 1 0 0 1-1.81.853C13.298 5.726 12.206 5 10.693 5c-.935 0-1.743.286-2.295.7" />
                                            <path
                                                d="M12.657 14.583c.551-.413.799-.908.799-1.37s-.248-.959-.8-1.372c-.551-.414-1.36-.7-2.295-.7a1 1 0 0 1 0-2c1.327 0 2.566.402 3.496 1.1s1.599 1.738 1.599 2.971s-.669 2.274-1.6 2.971c-.93.698-2.168 1.1-3.495 1.1c-2.052 0-3.994-.983-4.765-2.621a1 1 0 0 1 1.809-.853c.352.748 1.444 1.474 2.956 1.474c.936 0 1.744-.286 2.296-.7M10.5 1a1 1 0 0 1 1 1v1a1 1 0 1 1-2 0V2a1 1 0 0 1 1-1" />
                                            <path d="M10.5 16a1 1 0 0 1 1 1v1a1 1 0 1 1-2 0v-1a1 1 0 0 1 1-1" />
                                        </g>
                                        <path
                                            d="M7.097 5.3c-.646.484-1 1.115-1 1.77c0 .656.354 1.287 1 1.772s1.562.8 2.595.8a.5.5 0 0 1 0 1c-1.228 0-2.36-.373-3.195-1c-.836-.627-1.4-1.53-1.4-2.571c0-1.04.564-1.945 1.4-2.572c.836-.626 1.967-.999 3.195-.999c1.918 0 3.647.919 4.314 2.334a.5.5 0 0 1-.905.426c-.457-.97-1.761-1.76-3.409-1.76c-1.033 0-1.949.315-2.595.8" />
                                        <path
                                            d="M11.957 14.983c.646-.484.999-1.116.999-1.77c0-.656-.353-1.287-1-1.772c-.646-.485-1.562-.8-2.594-.8a.5.5 0 1 1 0-1c1.228 0 2.36.373 3.195 1s1.399 1.53 1.399 2.571c0 1.04-.564 1.945-1.4 2.571c-.835.627-1.966 1-3.194 1c-1.918 0-3.647-.919-4.314-2.334a.5.5 0 0 1 .905-.426c.457.97 1.76 1.76 3.409 1.76c1.032 0 1.948-.315 2.595-.8M9 1a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 9 1" />
                                        <path d="M9 16a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 9 16" />
                                    </g>
                                </svg>
                                <h5 class="text-xl text-white">
                                    Loan Details
                                </h5>
                            </div>
                            <hr class="border-blue-500 dark:border-blue-500 border-dashed my-3">
                            <div class="px-2 flex lg:px-4 flex-wrap -mx-2">
                                <div class="w-full px-2 sm:w-6/12 mb-4">
                                    <label class="mb-1 block">Loan Amount($) *</label>
                                    <input type="number" name="amount" id="loan_amount" class="input input-lg"
                                        value="0">
                                </div>
                                <div class="w-full px-2 sm:w-6/12 mb-4">
                                    <label class="mb-1 block">Loan Duration *</label>
                                    <select name="duration" id="loan_duration" class="input input-lg">
                                        <option value="" disabled selected>Select Duration</option>
                                        <option value="1">1 Month</option>
                                        <option value="2">2 Months</option>
                                        <option value="3">3 Months</option>
                                        <option value="4">4 Months</option>
                                        <option value="6">6 Months</option>
                                        <option value="12">12 Months</option>
                                        <option value="24">24 Months</option>
                                        <option value="36">36 Months</option>
                                        <option value="48">48 Months</option>
                                        <option value="60">60 Months</option>
                                    </select>
                                </div>
                                <div class="flex mt-3 px-4 items-center gap-2 mb-4 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                        viewBox="0 0 64 64">
                                        <g fill="#a2c3cb">
                                            <path
                                                d="M28.947 21.03v42.331c0 .348.245.64.532.64h34.232c.285 0 .53-.292.53-.64V21.03a.65.65 0 0 0-.144-.438l-.014-.011c0-.011-.009-.013-.009-.013a.47.47 0 0 0-.365-.181H29.477c-.286 0-.53.295-.53.643" />
                                            <path
                                                d="M0 21.03v42.331c0 .348.245.64.532.64h34.229c.288 0 .533-.292.533-.64V21.03a.65.65 0 0 0-.146-.438l-.013-.011c0-.011-.011-.013-.02-.019a.44.44 0 0 0-.356-.174H.529c-.284 0-.529.294-.529.642" />
                                        </g>
                                        <path fill="#5697a2"
                                            d="M2.151 31.04h11.542c.096 0 .185-.039.185-.078v-4.898c0-.043-.088-.075-.185-.075H2.151a.3.3 0 0 0-.128.023v.004c-.026.015-.047.028-.047.047v4.898c0 .04.072.079.175.079m.002 8.24h11.852c.092 0 .189-.038.189-.077V34.31c0-.043-.097-.077-.189-.077H2.152a.3.3 0 0 0-.133.026v.004c-.023.013-.047.025-.047.047v4.893c0 .039.076.077.181.077m.054 7.11h15.199c.12 0 .24-.037.24-.076v-4.898c0-.043-.12-.072-.24-.072H2.207a.6.6 0 0 0-.172.021v.005a.3.3 0 0 1-.06.029v4.916c0 .036.099.075.232.075m-.026 8.241h13.336c.105 0 .21-.039.21-.076v-4.894c0-.043-.105-.078-.21-.078H2.181c-.06 0-.12.001-.152.026v.004l-.054.026v4.916c0 .037.086.076.206.076m49.564-22.949h10.481c.084 0 .166-.039.166-.078v-4.895c0-.043-.082-.075-.166-.075H51.745a.3.3 0 0 0-.12.024v.004l-.039.028v4.914c0 .039.066.078.159.078m-2.215 8.244h12.657c.101 0 .201-.039.201-.076v-4.899c0-.043-.102-.073-.201-.073H49.53a.4.4 0 0 0-.142.021v.004c-.026.018-.055.029-.055.029v4.916c.002.039.085.078.197.078m-4.01 7.104h16.609c.131 0 .264-.039.264-.078v-4.894c0-.043-.133-.076-.264-.076H45.52a.6.6 0 0 0-.188.025v.004c-.035.014-.066.025-.066.047v4.894c-.002.039.103.078.254.078m2.71 8.24h13.945c.111 0 .225-.037.225-.076v-4.898c0-.043-.112-.072-.225-.072H48.23a.5.5 0 0 0-.158.021v.005c-.027.018-.057.029-.057.047v4.898c0 .038.09.075.215.075" />
                                        <path fill="#c6dcdf"
                                            d="M11.777 3.273v59.799c0 .493.279.905.61.905h39.319c.33 0 .607-.412.607-.905V3.271c0-.268-.063-.474-.162-.618l-.017-.017s-.011-.017-.021-.026c-.094-.146-.233-.245-.409-.245H12.386c-.33 0-.609.412-.609.906" />
                                        <path fill="#9a535f"
                                            d="M26.587 63.999h11.148c.086 0 .168-.056.168-.124v-8.008c0-.068-.082-.125-.168-.125H26.588a.2.2 0 0 0-.116.039l-.002.004h-.004c-.023.021-.047.053-.047.082v8.008c0 .068.081.124.168.124" />
                                        <path fill="#86a7ac"
                                            d="M27.979 60.03h1.937s.03-.019.03-.035v-2.191c0-.017-.015-.033-.015-.033H27.98s-.017.004-.023.013c-.002.009-.007.013-.007.013v2.198c-.002.017.011.035.029.035" />
                                        <path fill="#6cb5c6"
                                            d="M14.4 29.25h34.936c.279 0 .558-.051.558-.099v-6.126c0-.054-.277-.094-.558-.094H14.401c-.133 0-.303.011-.386.03v.007c-.071.017-.14.034-.14.058v6.126c0 .047.223.098.525.098m.318 9.01h34.621c.274 0 .551-.047.551-.094v-6.128c0-.056-.275-.094-.551-.094H14.714c-.138 0-.303.008-.384.03v.004c-.069.017-.138.035-.138.06v6.128c0 .047.221.094.523.094m.003 10.317h34.621c.274 0 .551-.048.551-.095v-6.127c0-.057-.275-.096-.551-.096H14.714c-.138 0-.303 0-.384.03v.005c-.069.018-.138.034-.138.061v6.127c0 .047.221.095.523.095" />
                                        <path fill="#86a7ac"
                                            d="M34.33 60.03h1.94s.027-.019.027-.035v-2.191c0-.017-.016-.033-.016-.033H34.33l-.021.013l-.009.013v2.198c0 .017.015.035.03.035" />
                                        <path fill="#04a69c"
                                            d="M38.19 19.498c0-3.654-2.573-4.704-5.361-5.292l-1.477-.298c-2.179-.43-2.351-1.061-2.351-1.911c0-1.099.992-1.756 2.651-1.756c1.969 0 2.474.985 2.684 1.729l.021.062c.248.648.821 1.035 1.541 1.035c.185 0 .346-.03.475-.056c.77-.15 1.306-.767 1.306-1.49q0-.273-.102-.533c-.396-1.267-1.494-3.265-4.572-3.72V5.096c0-1.814-2.836-1.814-2.836 0v2.186c-3.297.517-4.513 2.761-4.513 4.716c0 3.559 2.476 4.553 4.899 5.05l1.6.341c2.273.459 2.672 1.052 2.672 2.127c0 1.31-1.107 2.097-2.971 2.097c-2.415 0-2.907-1.088-3.237-2.31c-.193-.679-.803-1.112-1.557-1.112c-.165 0-.298.021-.455.049l-.045.006c-.782.187-1.305.799-1.305 1.526c0 .142.025.256.045.352l.023.11c.35 1.183 1.123 3.768 4.987 4.349v2.273c0 .907.71 1.384 1.415 1.384s1.423-.477 1.423-1.384v-2.235c3.058-.399 5.04-2.355 5.04-5.124" />
                                    </svg>
                                    <h5 class="text-xl text-white">
                                        Credit Facility
                                    </h5>
                                </div>
                                <hr class="border-blue-500 dark:border-blue-500 border-dashed my-3">
                                <div class="w-full px-2 mb-4">
                                    <label class="mb-1 block">Select Loan Facility</label>
                                    <select name="loan_type_id" id="loan_type" class="input input-lg">
                                        <option value="">Select Loan/Credit Facility</option>
                                        @foreach ($type as $item)
                                            <option value="{{ $item->id }}"
                                                data-min-duration="{{ $item->min_duration }}"
                                                data-max-duration="{{ $item->max_duration }}"
                                                data-min-amount="{{ $item->min_amount }}"
                                                data-max-amount="{{ $item->max_amount }}"
                                                data-rate="{{ $item->interest_rate }}">
                                                {{ $item->emoji }} {{ $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="w-full px-2 mb-4">
                                    <label class="mb-1 block">Expected Total Payable ($)</label>
                                    <input type="text" class="input input-lg" name="expected_return"
                                        id="expected_return" readonly>
                                </div>

                                <div class="flex mt-3 px-4 items-center gap-2 mb-4 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 32 32">
                                        <path fill="currentColor"
                                            d="M23 9A7 7 0 1 1 9 9a7 7 0 0 1 14 0m-2 0a5 5 0 1 0-10 0a5 5 0 0 0 10 0M7.5 18A3.5 3.5 0 0 0 4 21.5v.5c0 2.393 1.523 4.417 3.685 5.793C9.859 29.177 12.802 30 16 30s6.14-.823 8.315-2.207C26.477 26.417 28 24.393 28 22v-.5a3.5 3.5 0 0 0-3.5-3.5zM6 21.5A1.5 1.5 0 0 1 7.5 20h17a1.5 1.5 0 0 1 1.5 1.5v.5c0 1.473-.94 2.949-2.759 4.106C21.434 27.256 18.877 28 16 28s-5.434-.744-7.241-1.894C6.939 24.95 6 23.472 6 22z" />
                                    </svg>
                                    <h5 class="text-xl text-white">
                                        Financial Information
                                    </h5>
                                </div>
                                <hr class="border-blue-500 dark:border-blue-500 border-dashed my-3">
                                <div class="w-full px-2 mb-4">
                                    <label class="mb-1 block">Monthly Net Incomen *</label>
                                    <select class="input input-lg" name="monthly_income" required>
                                        <option value="" disabled selected>Select Income Range</option>
                                        <option value="3000">$2000 - $5000</option>
                                        <option value="8000">$6000 - $10000</option>
                                        <option value="15000">$11000 - $20000</option>
                                        <option value="30000">$21000 - $50000</option>
                                        <option value="75000">$51000 - $100000</option>
                                        <option value="100000">$100000 and Above</option>
                                    </select>
                                </div>
                                <div class="w-full px-2 mb-4">
                                    <label class="mb-1 block">Purpose of loan</label>
                                    <textarea type="text" class="input" name="reason"
                                        placeholder="Please provide detailed information about the purpose of this loan" rows="5"></textarea>
                                    <small>Minimum 50 characters required</small>
                                </div>
                                <!-- ✅ Consent Checkbox -->
                                <div class="w-full px-2 mb-4">
                                    <input type="checkbox" id="agree_terms" name="agree_terms" value="1"
                                        class="mt-1 h-4 w-4 text-primary border-gray-300 rounded focus:ring-primary"
                                        required>
                                    <label for="agree_terms"
                                        class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed">
                                        I hereby confirm that all information provided is accurate, and I agree to the
                                        loan terms,
                                        repayment schedule, and applicable interest rates.
                                    </label>
                                </div>
                            </div>
                            <!--:Page footer:-->
                            <div class="pb-4 px-2 flex items-center w-full">
                                <button type="submit"
                                    class="btn w-full bg-sky-500/10 text-white hover:bg-primary-deep flex items-center h-12 justify-center gap-2">
                                    <span class="icon-[lucide--send] text-lg leading-none"></span>
                                    Submit Loan Application
                                </button>
                            </div>
                            <small class="text-center">Your information is encrypted and secure. We'll review your
                                application within
                                24-48 hours. </small>
                        </div>
                    </form>
                </div>
            </div>
            <div class="divide-dashed divide-y mt-3 border-zinc-200 dark:border-zinc-700 border divide-zinc-500/10 dark:divide-zinc-800 overflow-hidden rounded-xl bg-white dark:bg-zinc-900 shadow-card"
                id="task-board">
                <!-- Parent Task -->
                <div class="mb-2 pb-2 parent-task group">
                    <div class="flex items-center justify-between px-4 gap-2 pt-4 pb-2.5">
                        <div class="w-8 h-8 flex items-center justify-center bg-primary-subtle rounded-lg shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M4 4a2 2 0 0 1 2-2h8a1 1 0 0 1 .707.293l5 5A1 1 0 0 1 20 8v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2zm13.586 4L14 4.414V8zM12 4H6v16h12V10h-5a1 1 0 0 1-1-1zm-4 9a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1m0 4a1 1 0 0 1 1-1h6a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1" />
                            </svg>
                        </div>
                        <div class="flex-grow">
                            <h5 class="text-md">Terms & Condition</h5>
                        </div>
                    </div>

                    <!-- Child Tasks List -->
                    <ul class="divide-y divide-zinc-500/10 dark:divide-zinc-800 px-2">
                        <!--:Child task item:-->
                        <li class="flex items-start py-2.5 child-task">
                            <div class="flex items-start flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" class="flex-shrink-0 mt-1 text-green-600">
                                    <path fill="currentColor"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p class="text-md leading-relaxed text-gray-700 dark:text-gray-300">
                                    Interest rates are subject to credit assessment and may vary based on loan type and
                                    duration.
                                </p>
                            </div>
                        </li>

                        <li class="flex items-start py-2.5 child-task">
                            <div class="flex items-start flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" class="flex-shrink-0 mt-1 text-green-600">
                                    <path fill="currentColor"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p class="text-md leading-relaxed text-gray-700 dark:text-gray-300">
                                    All loan applications are subject to approval and verification of provided
                                    information.
                                </p>
                            </div>
                        </li>

                        <li class="flex items-start py-2.5 child-task">
                            <div class="flex items-start flex-grow px-3 gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                    viewBox="0 0 24 24" class="flex-shrink-0 mt-1 text-green-600">
                                    <path fill="currentColor"
                                        d="M20 12a8 8 0 0 1-8 8a8 8 0 0 1-8-8a8 8 0 0 1 8-8c.76 0 1.5.11 2.2.31l1.57-1.57A9.8 9.8 0 0 0 12 2A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10M7.91 10.08L6.5 11.5L11 16L21 6l-1.41-1.42L11 13.17z" />
                                </svg>
                                <p class="text-md leading-relaxed text-gray-700 dark:text-gray-300">
                                    Early repayment options are available with potential fee reductions.
                                </p>
                            </div>
                        </li>
                    </ul>

                </div>
            </div>

            <div class="overflow-hidden rounded-xl shadow-card" id="task-board">
                <!-- Parent Task -->
                <div class="mb-2 pb-2 parent-task group text-center">
                    <div class="flex items-center justify-between px-4 gap-2 pt-4 pb-2.5">
                        <div class="flex-grow">
                            <h5 class="text-md">Need help with your application?</h5>
                        </div>
                    </div>
                </div>
                <div class="flex items-center flex-wrap justify-center gap-4">
                    <a href="{{ url('user/support') }}" type="button"
                        class="btn bg-sky-500/10 text-white hover:bg-primary-deep">Contact Support<span
                            class="icon-[lucide--phone]"></span< /a>
                            <a href="{{ url('user/dashboard') }}" type="button"
                                class="btn bg-sky-500/10 text-white hover:bg-primary-deep gap-2">
                                Back to Dashboard<span class="icon-[lucide--external-link]"></span>
                            </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const amountInput = document.getElementById("loan_amount");
            const durationSelect = document.getElementById("loan_duration");
            const typeSelect = document.getElementById("loan_type");
            const expectedInput = document.getElementById("expected_return");

            function calculateLoan() {
                const amount = parseFloat(amountInput.value);
                const duration = parseInt(durationSelect.value);
                const selected = typeSelect.options[typeSelect.selectedIndex];

                if (!selected || !amount || !duration) {
                    expectedInput.value = '';
                    return;
                }

                const minAmt = parseFloat(selected.getAttribute('data-min-amount'));
                const maxAmt = parseFloat(selected.getAttribute('data-max-amount'));
                const minDur = parseInt(selected.getAttribute('data-min-duration'));
                const maxDur = parseInt(selected.getAttribute('data-max-duration'));
                const rate = parseFloat(selected.getAttribute('data-rate'));

                // Validation
                if (amount < minAmt || amount > maxAmt) {
                    expectedInput.value = `❌ Amount must be between $${minAmt} - $${maxAmt}`;
                    return;
                }
                if (duration < minDur || duration > maxDur) {
                    expectedInput.value = `❌ Duration must be between ${minDur}-${maxDur} months`;
                    return;
                }

                // 💰 Calculate loan total payable
                const interest = (amount * rate * duration) / 100; // Simple interest formula
                const totalPayable = amount + interest;
                const monthlyPayment = totalPayable / duration;

                expectedInput.value = `$${totalPayable.toFixed(2)} (Monthly: $${monthlyPayment.toFixed(2)})`;
            }

            // Trigger calculation when user changes fields
            amountInput.addEventListener("input", calculateLoan);
            durationSelect.addEventListener("change", calculateLoan);
            typeSelect.addEventListener("change", calculateLoan);
        });
    </script>

</x-user>
