<div class="shrink-0 h-16 px-5 flex items-center">
    <div class="relative flex items-center justify-between w-full">
        <a href="{{ url('user/dashboard') }}" class="flex items-center relative z-[1]">
            <img class="logo-icon" :class="sidebarToggle ? 'xl:block' : 'hidden'"
                src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="Logo"
                style="height: 50px; width:100%;" />
        </a>
        <!--Sidebar mini for lg screen-->
        <button id="isSidebarMini"
            class="btn-sidebar-min lg:flex size-7 flex items-center justify-center hover:bg-zinc-200 dark:hover:bg-zinc-800 rounded-md cursor-w-resize">
            <span class="icon-[lucide--sidebar] rtl:rotate-180"></span>
        </button>
    </div>
</div>
<div class="flex flex-col h-full overflow-y-auto" data-simplebar>
    <div class="flex flex-col py-3 px-3">
        <nav class="flex flex-col space-y-0.5" id="SidebarCollapseGroup">
            <!--:Menu title:-->
            <span
                class="text-xs text-zinc-400 mb-2 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">Overview</span>
            <a href="{{ url('/user/dashboard') }}" class="sidebar-link">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <path fill="none" stroke="currentColor" stroke-linejoin="round" stroke-miterlimit="10"
                            stroke-width="1.5"
                            d="M8.4 3H5.6A1.6 1.6 0 0 0 4 4.6v4.8A1.6 1.6 0 0 0 5.6 11h2.8A1.6 1.6 0 0 0 10 9.4V4.6A1.6 1.6 0 0 0 8.4 3Zm0 12H5.6A1.6 1.6 0 0 0 4 16.6v2.8A1.6 1.6 0 0 0 5.6 21h2.8a1.6 1.6 0 0 0 1.6-1.6v-2.8A1.6 1.6 0 0 0 8.4 15Zm10-12h-2.8A1.6 1.6 0 0 0 14 4.6v2.8A1.6 1.6 0 0 0 15.6 9h2.8A1.6 1.6 0 0 0 20 7.4V4.6A1.6 1.6 0 0 0 18.4 3Zm0 10h-2.8a1.6 1.6 0 0 0-1.6 1.6v4.8a1.6 1.6 0 0 0 1.6 1.6h2.8a1.6 1.6 0 0 0 1.6-1.6v-4.8a1.6 1.6 0 0 0-1.6-1.6Z" />
                    </svg>
                </span>
                <span class="sidebar-text">Dashboard</span>
            </a>
            <a href="{{ url('/user/statement') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="1.5">
                            <path
                                d="M15.093 12.343a2.43 2.43 0 0 0 2.031.956c1.244 0 2.254-.757 2.254-1.691s-1.01-1.69-2.254-1.69s-2.255-.758-2.255-1.692s1.01-1.691 2.255-1.691a2.43 2.43 0 0 1 2.031.956M17.124 13.3v1.126m0-9.018v1.127" />
                            <path
                                d="M20.354 2.25H3.646A2.646 2.646 0 0 0 1 4.896v10.708a2.646 2.646 0 0 0 2.646 2.646h16.708A2.646 2.646 0 0 0 23 15.604V4.896a2.646 2.646 0 0 0-2.646-2.646M12 18.25v3.5m-5 0h10M4.622 6.689h6.012m-6.012 3.826h6.012m-6.012 3.826h3.006" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Account Statement</span>
            </a>
            <a href="{{ url('/user/portfolio') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 32 32">
                        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="2"
                            d="M29 17v11H3V17M2 8h28v8s-6 4-14 4s-14-4-14-4zm14 14v-4m4-10s0-4-4-4s-4 4-4 4" />
                    </svg>
                </span>
                <span class="sidebar-text">My Portfolio</span>
            </a>
            {{-- <a href="index-social.html" class="sidebar-link ">
                <span class="sidebar-icon">
                    <span class="icon-[lucide--at-sign]"></span>
                </span>
                <span class="sidebar-text">Performance History</span>
            </a> --}}

            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">WALLET
                & FUNDS</span>
            <a href="{{ url('user/deposit') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 256 256">
                        <path fill="currentColor"
                            d="M126 30.49V128a6 6 0 0 1-12 0V30.49L92.24 52.24a6 6 0 0 1-8.48-8.48l32-32a6 6 0 0 1 8.48 0l32 32a6 6 0 1 1-8.48 8.48Zm64 94.2V96a14 14 0 0 0-14-14h-16a6 6 0 0 0 0 12h16a2 2 0 0 1 2 2v86.14A26 26 0 0 0 133.49 209c0 .1.11.19.17.29l22.26 34a6 6 0 0 0 10-6.58l-22.12-33.84A14 14 0 0 1 168.13 189a3 3 0 0 0 .17.29l10.7 16.3a6 6 0 0 0 11-3.28v-62.74a76.83 76.83 0 0 1 28 59.08V240a6 6 0 0 0 12 0v-41.35a88.88 88.88 0 0 0-40-73.96M80 82H64a14 14 0 0 0-14 14v104a6 6 0 0 0 12 0V96a2 2 0 0 1 2-2h16a6 6 0 0 0 0-12" />
                    </svg>
                </span>
                <span class="sidebar-text">Deposit Funds</span>
            </a>
            <a href="{{ url('user/withdrawal') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                            <path
                                d="M21.825 13.15a4.06 4.06 0 0 0-2.5-2.53a4 4 0 0 0-1.66-.22c0-.08-.07-5.881-.45-6.641a1.17 1.17 0 0 0-.84-.69c-3.8-.81-5.471-.06-7.871.35c-1.15.19-2.75.47-2.81 1.6q.19 1.494.22 3a91 91 0 0 0 .16 10.361a6 6 0 0 0 .66 3c.63.85 1.95.54 2.9.48l2.88-.19a.35.35 0 0 0 0-.7l-2 .05c.07-1.93-1.09-2.51-2.85-3.42c-.07 0-.36-.26-.46-.2a.3.3 0 0 0-.14-.08c-.11-3.06 0-6.38 0-8.83c0-.54 1.46-.22 2.64-2.401a3.28 3.28 0 0 0 .45-2.19a7.6 7.6 0 0 1 3.1-.44a5.24 5.24 0 0 0 1.2 2.63a4 4 0 0 0 2 1v.71c0 .25.49 1.91.58 2.94c-.7.95.26 3.62 0 6a8.06 8.06 0 0 0-3-2.33c-1.32-.33-2.67.74-1.57 2.6a41 41 0 0 0 3.27 3.861c.34.41.37.52.32 1.53c.014.36-.036.719-.15 1.06a.31.31 0 1 0 .52.34a5.8 5.8 0 0 0 .24-2.78c-.27-1-4.38-4.81-3.58-5.55s2.78 1.59 3.64 2.54c.215.166.48.255.75.25c1.58-.24.25-5.63.52-6.76a3 3 0 0 1 2 .75a6.07 6.07 0 0 1 1.391 2.79a7.7 7.7 0 0 1 .09 3.73c-.11.49-1.08 1.81-1 2.33c.044.893.168 1.78.37 2.65a.351.351 0 1 0 .66-.24a15 15 0 0 1-.21-2.49c.07 0 .07-.2.15-.35c.18-.35.46-.81.65-1.16c.9-1.61.46-4.78-.27-6.36M7.994 19.02c1.2 1 1.53 1 1.75 2h-.14c-.5 0-1.84.22-2.13-.2a6 6 0 0 1-.37-2.69zm1-13.791a17 17 0 0 1-1.38 1.6c-.78.92-.56.5-.65-.43c-.19-1.67-.21-1.51.34-1.73a18 18 0 0 1 2.16-.58c-.07.41-.23.8-.47 1.14m6.4.13c-.12-.12-2.11-2.1-1.2-1.87q.98.357 2 .58c.135.674.189 1.363.16 2.05a4.3 4.3 0 0 1-.95-.76z" />
                            <path
                                d="M23.995 4.099c0-.72 0-3-.58-3.43s-3.68-.65-7.21-.65c-3.86 0-8.291.2-10.461.44q-1.779.254-3.52.69c-.51.12-1.25 0-1.77.55s-.39 1.67-.38 2.4c0 .54-.241 2.19.15 2.6c.442.324.98.49 1.53.47a7.9 7.9 0 0 0 3.24-.06a.31.31 0 0 0-.16-.6a8.64 8.64 0 0 1-4.04-.34c.35-4.87-.1-3.69 1.65-4c2.77-.55 3.42-.69 9.44-.88c1.2 0 9.811-.3 10.901.18c.199.872.296 1.765.29 2.66c0 .11-.18.87 0 1c-.26.06-.92 0-1.19.09q-1.389.186-2.79.22a.35.35 0 0 0 0 .7q1.453.026 2.9-.12c.33 0 .8 0 1.17-.05c1.11-.19.77-.95.83-1.87M10.554 10.63a.353.353 0 0 0-.15-.69c-.54.09-.92.45-1 1.25c-.35-.17-1.28.19-1.27.57s.94.69 1.35.4c.093.444.281.863.55 1.23a1 1 0 0 0 1.26.21c.93-.5 1-2.18 1.48-2.59c.24-.22.35-.31.62 0c.5.61.37 1.23.25 1.27a.32.32 0 0 0-.21.39c.13.43.91.25 1-.74a1 1 0 0 0 1.25-.58a.91.91 0 0 0-1.33-.27c-.36-1.19-1.26-1.53-1.87-1.27a3 3 0 0 0-.45.3c-.77.56-.76 1.54-1.14 2.17s-.06.53-.34.05s-.56-1.54 0-1.7" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Withdraw Funds</span>
            </a>
            <a href="{{ url('user/internal_transfer') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <path fill="currentColor" fill-rule="evenodd"
                            d="M4.201 11.51a.31.31 0 1 0 .29-.51a4.85 4.85 0 0 1-1.49-1.59c-1-1.37-1.39-2.62-.4-4a3.88 3.88 0 0 1 2.9-1.48c1.91-.22 3.27.15 8.811.93a.58.58 0 0 0 .64-.57c0-.66.21-2.671.79-3.001c.32-.18.44.22 1 .68s1.34 1.26 2.1 2.03c2.001 2 1.781 1.82 1.691 1.94a18 18 0 0 1-4.53 4.14q-.214.12-.45.18c0-.1-.07-.25-.07-.36a2.9 2.9 0 0 0-.33-1.63c-.18-.36-.8-.4-1.49-.54a22 22 0 0 0-4.421-.38a20.6 20.6 0 0 0-3.42.06c-1.44.24-1.75 1.33-1.18 2.59a.354.354 0 0 0 .65-.28c-.81-1.89.83-1.72 3.9-1.53a21.7 21.7 0 0 1 4.27.46c.08 0 .71.38.92.29c.21.57-.05 1.52.25 2c1.09 1.651 5.06-2.27 6.411-3.78c.47-.54 1-1 .8-1.53c-.29-.74-3.68-3.95-4.39-4.57c-.53-.47-1.14-1.51-2.34-.84c-1 .54-1.24 2.26-1.32 3.38l-2.791-.32c-3.17-.44-7.34-1.08-9.121 1.64c-1.13 1.72-.74 3.28.53 4.9a5.3 5.3 0 0 0 1.79 1.69m18.542 5.811a7 7 0 0 0-2.94-4a.32.32 0 0 0-.29.56a4.85 4.85 0 0 1 1.54 1.55c1 1.39 1.38 2.63.4 4a3.87 3.87 0 0 1-2.9 1.48c-1.91.221-3.32-.15-8.801-.93a.58.58 0 0 0-.65.57c-.06.901-.07 1.901-.62 2.261a10.86 10.86 0 0 1-5-3.31c-.3-.45-.31-.6 0-1.16a20.1 20.1 0 0 1 4.62-4.25c.21-.14.49-.22.62-.3c0 1-.24 2 .14 2.77c.19.36.78.39 1.49.54a22 22 0 0 0 4.42.38c1.14.075 2.284.054 3.42-.06c1.42-.24 1.75-1.31 1.17-2.63a.354.354 0 1 0-.65.28c.81 1.93-.83 1.74-3.9 1.57a21 21 0 0 1-4.26-.46c-.08 0-.66-.34-.9-.3c-.17-1.21.74-3.371-1-3.241C7.762 12.7 2.12 17 2.11 19S7.73 24.611 9 23.911c1-.56 1.14-1.55 1.22-2.69l2.761.33c3.22.44 7.37 1.08 9.151-1.64a3.5 3.5 0 0 0 .61-2.59"
                            clip-rule="evenodd" />
                    </svg>
                </span>
                <span class="sidebar-text">Internal Transfer</span>
            </a>
            <a href="{{ url('user/swap') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="M7.5 9.616v1.034l3.15-2.25L7.5 6.375v.92a4.95 4.95 0 0 0 .45 9.88c1.133 0 2.7-.399 3.6-1.35c1.125-1.299 2.466-4.57 2.466-4.57L9.999 13.86a2.59 2.59 0 0 1-3.327.465A2.588 2.588 0 0 1 7.5 9.616" />
                        <path fill="currentColor"
                            d="M16.5 14.384V13.35l-3.15 2.25l3.15 2.025v-.92a4.95 4.95 0 0 0-.45-9.88c-1.134 0-2.7.399-3.6 1.35c-1.125 1.299-2.466 4.57-2.466 4.57L14 10.14a2.588 2.588 0 1 1 2.499 4.243" />
                    </svg>
                </span>
                <span class="sidebar-text">Swap Balance</span>
            </a>
            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">TRADING
                & MARKETS</span>
            <a href="{{ url('/user/investment') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                            <path
                                d="m14.703 1.022l2.414.239c.13 0 .47.19.599.12q.003.5-.06.997l-.1 4.63a.38.38 0 0 0 .36.379a.39.39 0 0 0 .389-.38c.09-1.097.359-2.164.508-3.252q.088-.736.1-1.476a6 6 0 0 0-.15-1.427a1.06 1.06 0 0 0-.419-.589a1 1 0 0 0-.369-.14h-.748l-2.514.19a.35.35 0 0 0-.34.33a.35.35 0 0 0 .33.378m9.019 20.244a6.3 6.3 0 0 0-1.157-1.746a24 24 0 0 0-1.996-1.866a4.41 4.41 0 0 0 1.687-3.322a5.93 5.93 0 0 0-1.228-3.851a5.53 5.53 0 0 0-5.986-2.045a5.99 5.99 0 0 0-4.06 3.99a5.71 5.71 0 0 0 1.087 5.508a5.3 5.3 0 0 0 3.642 1.646a6 6 0 0 0 2.993-.549c.379.838.648 1.766.997 2.634q.26.66.639 1.257c.34.463.814.811 1.357.998c.428.133.89.101 1.297-.09a1.63 1.63 0 0 0 .838-.947c.16-.535.12-1.109-.11-1.617m-1.297 1.387a.64.64 0 0 1-.539 0a1.7 1.7 0 0 1-.628-.459a6.5 6.5 0 0 1-.669-.998c-.469-.838-.858-1.756-1.347-2.554c-.488-.798-2.075.24-3.462.07a4.28 4.28 0 0 1-2.923-1.457a4.7 4.7 0 0 1-.708-4.47a4.87 4.87 0 0 1 3.222-3.132a4.56 4.56 0 0 1 2.634 0a4.65 4.65 0 0 1 2.215 1.506a5 5 0 0 1 1.158 3.173a3.58 3.58 0 0 1-1.407 2.903c-.27.19-.11.729 0 .818c.578.63 1.297 1.338 1.875 2.106c.357.452.633.961.819 1.506c.077.214.098.444.06.669a.43.43 0 0 1-.3.319" />
                            <path
                                d="M18.165 13.154a3 3 0 0 0-.808-.08q.007-.105 0-.21v-.768c.243.021.482.078.708.17a.33.33 0 0 0 .41-.5a.3.3 0 0 0-.1-.079a3.4 3.4 0 0 0-1.048-.37v-.997a.35.35 0 0 0-.35-.319a.34.34 0 0 0-.359.3c-.07.309-.11.628-.17.937a3 3 0 0 0-.817.09a1.517 1.517 0 0 0-1.217 1.806a1.29 1.29 0 0 0 .838 1.087c.272.097.559.144.848.14v.648c0 .22.06.45.08.679a2.27 2.27 0 0 1-1.477-.4a.379.379 0 0 0-.509.55a3.2 3.2 0 0 0 2.085.788c0 .31.06.618.1.928a.38.38 0 0 0 .532.316a.37.37 0 0 0 .216-.356c0-.31 0-.619.06-.928q.269-.021.529-.09a1.857 1.857 0 0 0 1.407-2.325a1.36 1.36 0 0 0-.958-1.017m-2.644-.24c-.12-.489.27-.708.718-.808c0 .24-.11.47-.13.709s0 .2 0 .299q-.184.015-.369 0a.28.28 0 0 1-.219-.2m1.746 2.624v-1.217q.19-.015.38 0a.25.25 0 0 1 .249.16c.239.558-.14.878-.629 1.057" />
                            <path
                                d="M13.166 19.31a79 79 0 0 1-2.544.997q-.844.275-1.716.44a3.5 3.5 0 0 0-1.097.09a8 8 0 0 1-.43-.72c-.478-.917-.848-1.995-1.277-2.803c-.598-1.127-1.167-2.225-1.746-3.322c-.578-1.098-1.167-2.195-1.706-3.313c-.638-1.366-1.297-2.773-1.865-4.2a43 43 0 0 1 3.81-2.464a25 25 0 0 1 4.4-1.996a9.8 9.8 0 0 1 2.475-.778a6.25 6.25 0 0 1 1.826 2.245c.818 1.526 1.337 3.173 1.966 4.52a.387.387 0 1 0 .718-.29a43 43 0 0 0-2.075-5.447A6.5 6.5 0 0 0 12.149.213a1.56 1.56 0 0 0-1.058-.19c-.856.194-1.694.461-2.504.799a24 24 0 0 0-3.662 1.786C-1.4 6.389-.682 5.6 2.221 12.256c.41.998.848 1.915 1.317 2.853a73 73 0 0 0 1.467 2.774c.499.898.858 1.846 1.367 2.744q.361.634.848 1.177a.67.67 0 0 0 .569.19q.672-.115 1.327-.31q.92-.236 1.805-.579c.869-.329 1.707-.718 2.545-1.117a.37.37 0 0 0 .19-.499a.37.37 0 0 0-.49-.18" />
                            <path
                                d="M6.392 6.758L7.509 6.2c1.118-.599 2.225-1.208 3.392-1.776a.379.379 0 0 0-.279-.699c-.918.3-1.816.569-2.694.918c-.389.15-.758.32-1.127.5q-.558.269-1.078.608q-1.2.805-2.245 1.806a.34.34 0 0 0-.06.449a.33.33 0 0 0 .46.06c.459-.29.908-.54 1.376-.779c.47-.24.749-.339 1.138-.529m6.734-.04a.37.37 0 0 0-.498-.17c-.928.38-1.856.74-2.774 1.148c-.39.17-.778.36-1.157.549c-.38.19-.759.41-1.118.639C6.721 9.412 5.923 10 5.105 10.6a.33.33 0 1 0 .339.558c.898-.429 1.806-.798 2.704-1.217l1.137-.579c.38-.2.749-.409 1.108-.618a96 96 0 0 0 2.564-1.527a.37.37 0 0 0 .17-.499m-4.391 5.658a4 4 0 0 0-.568.269a3 3 0 0 0-.51.35q-.54.455-.997.997a.33.33 0 0 0-.09.482a.33.33 0 0 0 .49.037c.468-.24.997-.39 1.426-.629c.27-.14.519-.31.768-.469c.25-.16.749-.539 1.148-.758a.37.37 0 1 0-.25-.698q-.73.139-1.417.419" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Investment Plans</span>
            </a>
            <div class="static">
                <a data-bs-toggle="collapse" href="widgets.html#cApps" class="sidebar-link ">
                    <span class="sidebar-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 48 48">
                            <g fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="4">
                                <path d="M6 20h8v14H6zm14-6h8v26h-8z" />
                                <path stroke-linecap="round" d="M24 44v-4" />
                                <path d="M34 12h8v9h-8z" />
                                <path stroke-linecap="round" d="M10 20V10m28 24V21m0-9V4" />
                            </g>
                        </svg>
                    </span>
                    <span class="sidebar-text">Live Trading</span>
                    <span class="icon-[lucide--chevron-up] sidebar-link-arrow"></span>
                </a>
                <div data-bs-parent="#SidebarCollapseGroup" id="cApps"
                    class="collapse sidebar-collapse w-48 z-50 ">
                    <div class="py-1">
                        <a href="{{ url('/user/market') }}" class="sidebar-collapse-item @@app_api">
                            <span class="sidebar-text">Live Markets</span>
                            <span class="ms-auto"
                                style="display:inline-flex;align-items:center;gap:6px;font-weight:600;font-family:sans-serif;">
                                <span class="ms-auto badge bg-green-500/20 text-white gap-1"><span
                                        style="
                                    position:relative;
                                    width:8px;height:8px;
                                    border-radius:50%;
                                    background:#22c55e;
                                    display:inline-block;
                                    animation:pulse 1.4s infinite;
                                "></span>
                                    Live</span>
                            </span>
                        </a>
                        <a href="{{ url('user/live_trades') }}"
                            class="sidebar-collapse-item @@app_inbox">Market
                            Orders</a>
                    </div>
                </div>
            </div>
            <a href="{{ url('/user/copy_trading') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <span class="icon-[lucide--users]"></span>
                </span>
                <span class="sidebar-text">Copy Trading</span>
                <span class="ms-auto badge bg-purple-500 text-white">Pro</span>
            </a>
            <a href="{{ url('/user/bot_ai_trading') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 16 16">
                        <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                            <path
                                d="M8 8a2 2 0 1 1-4 0a2 2 0 0 1 4 0M5 8a1 1 0 1 0 2 0a1 1 0 0 0-2 0m3 0a2 2 0 1 0 4 0a2 2 0 0 0-4 0m3 0a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-2.49 3.251a2.7 2.7 0 0 0 1.37-.74l.7.71A3.7 3.7 0 0 1 8 12.291a3.8 3.8 0 0 1-1.42-.29a3.6 3.6 0 0 1-1.19-.79l.7-.71a2.71 2.71 0 0 0 2.42.74z" />
                            <path
                                d="M9.5 1.5a1.5 1.5 0 0 1-1 1.415V3H11a3 3 0 0 1 3 3v1l1 1v2l-1 1v1a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3v-1l-1-1V8l1-1V6a3 3 0 0 1 3-3h2.5v-.085a1.5 1.5 0 1 1 2-1.415M5 4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">AI Trading Bots</span>
                <span class="ms-auto badge bg-blue-500 text-white">AI</span>
            </a>
            <a href="{{ url('/user/real_estate') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="2">
                            <path d="M10 12h4m-4-4h4m0 13v-3a2 2 0 0 0-4 0v3" />
                            <path d="M6 10H4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2" />
                            <path d="M6 21V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v16" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Real Estate</span>
            </a>
            <a href="{{ url('/user/staking') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="2">
                            <circle cx="8" cy="8" r="6" />
                            <path d="M18.09 10.37A6 6 0 1 1 10.34 18M7 6h1v4" />
                            <path d="m16.71 13.88l.7.71l-2.82 2.82" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Stake</span>
            </a>

            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">Market
                Intelligence</span>
            <a href="{{ url('user/signals') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="2"
                            d="M12 20h.01M2 8.82a15 15 0 0 1 20 0M5 12.859a10 10 0 0 1 14 0m-10.5 3.57a5 5 0 0 1 7 0" />
                    </svg>
                </span>
                <span class="sidebar-text">Premium Signals</span>
                <span class="ms-auto badge bg-green-500/10 text-white">Premium</span>
            </a>

            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">CREDIT
                & FINANCING</span>
            <a href="{{ url('user/apply_loan') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 64 64">
                        <ellipse cx="10.97" cy="52.578" fill="currentColor" rx="1.742" ry="1.188" />
                        <path fill="currentColor"
                            d="m62 46.669l-.654-.384c-.05-.029-5.047-2.994-6.289-6.592l-.277-.797l-.512.669c-.016.021-.726.899-2.713 1.929c-1.471-8.373-6.475-18.369-13.051-22.631c1.88.152 3.766-.004 5.586-.666c1.096-.398.623-2.184-.483-1.78c-1.492.543-2.987.691-4.479.615c3.663-3.357 6.539-8.502 6.539-12.264c0-.904 0-2.587-1.34-2.587c-.538 0-.973.336-1.574.8c-.922.711-2.314 1.787-4.359 1.787c-.779 0-2.205-.822-3.351-1.482C33.658 2.489 32.773 2 32.029 2c-1.232 0-3.043.996-4.641 1.875c-.65.357-1.539.847-1.723.894c-2.316 0-3.661-1.068-4.553-1.775c-.52-.414-.897-.714-1.4-.714c-1.318 0-1.318 1.581-1.318 3.412c0 3.534 2.692 8.199 6.217 11.334c-2.221.159-4.411.83-5.95 2.321c-.85.822.438 2.126 1.285 1.306c1.279-1.24 2.956-1.771 4.75-1.874q.076.274.189.54C17.369 24.72 12.03 37.545 12.03 46.203c0 .854.066 1.627.168 2.355c-1.938-.861-2.645-1.616-2.659-1.633l-.516-.595l-.254.75c-1.123 3.304-6.005 6.17-6.054 6.199L2 53.694l.727.393c.255.138.508.259.763.39l-.46.319l.243 3.04L22.326 62l7.224-4.621q1.093.006 2.218.006L40.212 62l19.089-6v-3.209l-.505-.303q.378-.24.755-.491l.669-.447l-.147-.072l.851-.233l.144-3.336l-.492-.349q.393-.235.785-.483zM20.213 5.692c0-.444.006-.79.015-1.059c.153.12.331.251.521.386c.583 1.396 1.686 3.406 3.556 4.672c2.272 1.54 1.97-.23 3.182-1.846c1.212-1.615 2.032-2.461 4.062 1.693c.885 1.811 2.36-3.25 3.762-3.989c.371.202.741.39 1.104.55c2.514 4.088 3.679 2.813 5.912-.585c.614-.36 1.118-.746 1.519-1.055q.003.139.004.311c0 3.21-2.623 7.814-5.835 10.817a3.6 3.6 0 0 0-.642-1.053c-1.297-1.469-3.324.16-4.285 1.229c-1.705-.548-4.483-2.057-6.293-1.193a4.6 4.6 0 0 0-1.226.831c-2.96-2.698-5.356-6.593-5.356-9.709m16.204 10.974a27 27 0 0 1-1.337-.32c.558-.481 1.07-.649 1.285.066c.023.078.037.167.052.254m-7.6.621q-.496-.096-1.021-.165a14 14 0 0 1-.779-.525c.914-.613 2.49-.287 3.996.224c-.743.075-1.476.237-2.196.466m.454 2.64c-.56.14-1.17.084-1.697-.126c.214-.113.43-.211.646-.31c.35.169.7.31 1.051.436M10.774 56.379a39.3 39.3 0 0 1-6.912-2.733c1.357-.892 4.313-3.049 5.515-5.641c.824.647 2.726 1.827 6.43 2.733c-.063.102-.14.211-.214.318c-3.162-.828-4.96-1.875-4.989-1.893l-.436-.26l-.209.467c-.275.612-.92.704-1.279.704c-.1 0-.167-.007-.176-.008l-.357-.052l-.13.342c-.266.698-1.358 1.61-1.758 1.903l-.668.49l.764.313c.284.116.361.223.365.251c.01.069-.111.251-.24.356l-.582.469l.677.313c1.387.64 2.958 1.17 4.529 1.607q-.186.183-.33.321m8.064-3.726c1.398.196 2.947.32 4.639.32h.001q.527 0 1.073-.017a1 1 0 0 0 .103.213q.133.203.361.334l-2.552 2.181l-.146-.003c-1.137 0-1.985.418-2.392 1.162a69 69 0 0 1-4.602-.747a51 51 0 0 0 3.515-3.443M7.489 53.85c.1-.189.165-.418.13-.668a1 1 0 0 0-.307-.59c.449-.385 1.068-.979 1.408-1.594c.773-.011 1.411-.304 1.813-.822c.677.354 2.202 1.069 4.455 1.689c-.921 1.155-2.162 2.465-3.127 3.439c-1.504-.398-3.019-.878-4.372-1.454m14.251 4.209l-.205.001c-.861 0-3.714-.07-7.483-.855c.132-.112.269-.227.396-.337c3.058.639 5.524.913 5.709.934l.366.039l.113-.355c.247-.766 1.158-.879 1.68-.879c.143 0 .238.009.249.01l.194.021l4.433-3.788l-1.185-.039c-.396-.014-.563-.103-.604-.164l.251-.657l-.694.029q-.759.033-1.483.033h-.001c-1.396 0-2.691-.092-3.888-.237l.278-.328c2.416.323 5.309.522 8.802.497c-.834 1.17-2.914 3.657-6.928 6.075m10.024-4.345v1.825q-.853 0-1.665-.006l-.163-2.054l-1.354.11c.912-1.078 1.301-1.797 1.336-1.862l.367-.694l-.775.014c-7.418.136-12.256-.748-15.31-1.73c-.223-.902-.352-1.922-.352-3.113c0-8.123 5.191-20.401 12.083-25.377c1.221 1.181 3.073 1.698 4.833.549c.386-.252.722-.582 1.037-.933c.075.002.152.019.228.019c.252 0 .508-.021.763-.053c.323.129.639.259.932.388c1.403.618 2.601.234 3.419-.618c6.313 3.82 11.371 13.925 12.702 22.093c-2.886 1.154-7.464 2.28-14.49 2.478c1.386-.792 2.426-2.124 2.052-3.874c-.393-1.85-1.939-2.37-3.54-2.455q-.007-1.302.002-2.605c.491.217.962.467 1.39.734c.756.475 1.44-.756.689-1.231a10.3 10.3 0 0 0-2.072-.999q.015-1.508.015-3.014c.001-.92-1.366-.92-1.366 0q-.001 1.325-.014 2.646a7.1 7.1 0 0 0-2.202-.037a27 27 0 0 0-.432-1.97c-.226-.886-1.546-.511-1.317.378c.168.639.305 1.275.418 1.92c-.058.022-.121.033-.178.059c-1.852.733-2.982 2.602-1.627 4.345c.631.812 1.456 1.14 2.359 1.249c.049 1.203.08 2.407.115 3.609c-.605-.393-1.156-.897-1.655-1.43c-.618-.652-1.583.355-.966 1.006c.839.893 1.72 1.568 2.675 2c.043 1.027.104 2.057.204 3.079c.088.907 1.456.912 1.367 0a54 54 0 0 1-.187-2.657c.52.09 1.066.113 1.646.058c.065.946.141 1.892.249 2.838c.062.542.58.755.962.645l-.085 1.964c-.602.054-1.216.104-1.856.146l-.762.05l.406.656c.041.066.502.795 1.531 1.856h-1.412zm24.888-6.582c-1.257.591-2.847 1.133-4.467 1.606c-.996-1.029-2.27-2.402-3.221-3.62c2.119-.642 3.305-1.304 3.84-1.661c.423.373.983.567 1.646.566c.22 0 .415-.021.565-.045c.48.622 1.254 1.34 1.738 1.769q-.344.353-.331.776c.008.24.104.444.23.609m-7.155 3.286q.307.27.63.55c-4.054 1.075-7.071 1.192-7.728 1.203c-4.198-2.561-6.374-5.271-7.213-6.491c3.513-.088 6.417-.406 8.839-.844a24 24 0 0 0 .299.36a53 53 0 0 1-5.877.583l-.807.034l.444.679c-.001.001-.091.169-.687.285l-.969.189l4.764 3.857l.222-.06c.005-.001.425-.114.933-.114c.733 0 1.234.223 1.486.659l.16.276l.311-.055a87 87 0 0 0 5.193-1.111M35.4 47.479l-1.138-.062c-.053-.568-.106-1.136-.146-1.704c.2.332.61.956 1.284 1.766m-1.408-3.661a105 105 0 0 1-.119-4.041q.248.01.48.043c1.768.268 2.23 2.234.85 3.34c-.36.285-.775.494-1.211.658m10.439 6.752c-.448-.553-1.161-.843-2.083-.843c-.385 0-.724.052-.938.094l-2.995-2.427q.372-.214.509-.546a1 1 0 0 0 .052-.171c2.374-.13 4.374-.367 6.065-.657c.82.915 2.025 2.177 3.623 3.644c-1.963.467-3.6.787-4.233.906M32.505 39.813c.019 1.449.055 2.902.132 4.35c-.129.02-.256.045-.383.058c-.43.049-.838.013-1.226-.085c-.049-1.4-.081-2.803-.134-4.204c.538-.025 1.083-.078 1.611-.119m-1.68-1.265a44 44 0 0 0-.31-3.286a5.3 5.3 0 0 1 1.987.101a285 285 0 0 0-.005 3.067c-.439.024-.856.066-1.223.099a6 6 0 0 1-.449.019m-1.372-.175c-.085-.023-.169-.041-.256-.07a2.7 2.7 0 0 1-1.057-.667c-.854-.797.318-1.579 1.057-1.95c.116.89.196 1.788.256 2.687M40.49 57.839c-4.341-2.218-6.67-4.683-7.595-5.825c.665-.05 1.294-.11 1.917-.173l7.118 4.62l15.61-4.288c-8.05 4.852-16.003 5.591-17.05 5.666m12.892-7.89l-.462-.463c1.776-.538 3.494-1.162 4.775-1.848l.779-.419l-.79-.402c-.177-.091-.35-.258-.353-.321c.002-.024.072-.152.375-.326l.578-.332l-.514-.428c-.016-.013-1.619-1.344-2.182-2.201l-.186-.28l-.319.093c-.003 0-.277.079-.633.079c-.55.001-.962-.179-1.226-.533l-.292-.387l-.366.315c-.019.016-1.152.945-4.191 1.823a10 10 0 0 1-.289-.44c3.685-1.117 5.568-2.469 6.384-3.209c1.31 2.834 4.429 5.117 5.783 6.012a38 38 0 0 1-6.871 3.267" />
                        <path fill="currentColor"
                            d="M44.38 47.117c-.997-.271-2.122-.086-2.516.409c-.391.497.103 1.123 1.099 1.396c.998.271 2.122.085 2.516-.411c.391-.497-.101-1.121-1.099-1.394" />
                    </svg>
                </span>
                <span class="sidebar-text">Apply for Credit</span>
                <span class="ms-auto badge bg-green-500/20 text-white">Fast</span>
            </a>
            <a href="{{ url('user/loan_history') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <span class="icon-[lucide--history]"></span>
                </span>
                <span class="sidebar-text">Credit History</span>
            </a>
            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">Account
                Management</span>
            <a href="{{ url('user/profile') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <span class="icon-[lucide--user]"></span>
                </span>
                <span class="sidebar-text">Profile Settings</span>
            </a>
            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">GROWTH
                & REWARD</span>
            <a href="{{ url('user/referrals') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <span class="icon-[lucide--users]"></span>
                </span>
                <span class="sidebar-text">Referral Program</span>
            </a>
            <span
                class="text-xs text-zinc-400 mb-2 mt-4 ps-4 sidebar-title uppercase font-semibold whitespace-nowrap">Support
                & help</span>
            <a href="{{ url('user/support') }}" class="sidebar-link ">
                <span class="sidebar-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <g fill="none" stroke="currentColor" stroke-width="1.5">
                            <path
                                d="M17 10.805c0-.346 0-.519.052-.673c.151-.448.55-.621.95-.803c.448-.205.672-.307.895-.325c.252-.02.505.034.721.155c.286.16.486.466.69.714c.943 1.146 1.415 1.719 1.587 2.35c.14.51.14 1.044 0 1.553c-.251.922-1.046 1.694-1.635 2.41c-.301.365-.452.548-.642.655a1.27 1.27 0 0 1-.721.155c-.223-.018-.447-.12-.896-.325c-.4-.182-.798-.355-.949-.803c-.052-.154-.052-.327-.052-.673zm-10 0c0-.436-.012-.827-.364-1.133c-.128-.111-.298-.188-.637-.343c-.449-.204-.673-.307-.896-.325c-.667-.054-1.026.402-1.41.87c-.944 1.145-1.416 1.718-1.589 2.35a2.94 2.94 0 0 0 0 1.553c.252.921 1.048 1.694 1.636 2.409c.371.45.726.861 1.363.81c.223-.018.447-.12.896-.325c.34-.154.509-.232.637-.343c.352-.306.364-.697.364-1.132z" />
                            <path stroke-linecap="square" stroke-linejoin="round"
                                d="M5 9c0-3.314 3.134-6 7-6s7 2.686 7 6" />
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M19 17v.8c0 1.767-1.79 3.2-4 3.2h-2" />
                        </g>
                    </svg>
                </span>
                <span class="sidebar-text">Support Center</span>
            </a>

            @if (session()->has('impersonator_id'))
                <a href="{{ route('admin.impersonate.stop') }}" class="sidebar-link ">
                    <span class="sidebar-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="currentColor" stroke-width="1.5">
                                <path
                                    d="M17 10.805c0-.346 0-.519.052-.673c.151-.448.55-.621.95-.803c.448-.205.672-.307.895-.325c.252-.02.505.034.721.155c.286.16.486.466.69.714c.943 1.146 1.415 1.719 1.587 2.35c.14.51.14 1.044 0 1.553c-.251.922-1.046 1.694-1.635 2.41c-.301.365-.452.548-.642.655a1.27 1.27 0 0 1-.721.155c-.223-.018-.447-.12-.896-.325c-.4-.182-.798-.355-.949-.803c-.052-.154-.052-.327-.052-.673zm-10 0c0-.436-.012-.827-.364-1.133c-.128-.111-.298-.188-.637-.343c-.449-.204-.673-.307-.896-.325c-.667-.054-1.026.402-1.41.87c-.944 1.145-1.416 1.718-1.589 2.35a2.94 2.94 0 0 0 0 1.553c.252.921 1.048 1.694 1.636 2.409c.371.45.726.861 1.363.81c.223-.018.447-.12.896-.325c.34-.154.509-.232.637-.343c.352-.306.364-.697.364-1.132z" />
                                <path stroke-linecap="square" stroke-linejoin="round"
                                    d="M5 9c0-3.314 3.134-6 7-6s7 2.686 7 6" />
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M19 17v.8c0 1.767-1.79 3.2-4 3.2h-2" />
                            </g>
                        </svg>
                    </span>
                    <span class="sidebar-text">Return to Admin</span>
                </a>
            @endif
        </nav>
        <!--:CTA:-->
        {{-- <div class="text-center sidebar-cta pt-4">
            <div class="p-4 rounded-xl bg-gradient-to-tr from-blue-500 to-primary">
                <img src="images/illustrations/wallet.png" alt="" class="w-16 mx-auto block mb-4">
                <h5 class="mb-3 !text-white">
                    Unlock premium features and elevate your workflow
                </h5>
                <button type="button"
                    class="btn btn-sm bg-white text-zinc-700 hover:bg-zinc-100 hover:text-primary">Upgrade to
                    Pro</button>
            </div>
        </div> --}}
    </div>
</div>



<div class="py-3 px-5 flex flex-col shrink-0">
    <div class="static">
        <a data-bs-auto-close="outside" data-bs-offset="10,10" data-bs-boundry="viewport" data-bs-toggle="dropdown"
            href="{{ url('/') }}#" class="block">
            <div class="flex flex-nowrap items-center gap-3.5 rounded-lg">
                <img src="{{ asset('upload/profile/' . Auth::User()->image) }}" class="block rounded-full shrink-0"
                    alt="" style="height:30px; width:30px;">
                <div class="flex-grow shrink-0 flex items-center justify-between">
                    <h6 class="!text-current user-text">{{ Auth::User()->firstname }}
                        {{ Auth::User()->lastname }}
                    </h6>

                </div>
            </div>
        </a>
        <div class="dropdown-menu w-54 z-50">
            <div class="flex items-center gap-3.5 p-2 mb-2 rounded-lg bg-zinc-50 dark:bg-zinc-800">
                <img src="{{ asset('upload/profile/' . Auth::User()->image) }}" class="shrink-0 rounded-full"
                    alt="" style="height:30px; width:30px;">
                <div class="flex-grow">
                    <p class="text-sm text-muted">Signed in as</p>
                    <p class="text-sm">{{ Auth::User()->username }}</p>
                </div>
                <span class="shrink-0 pl-2">
                    <span class="icon-[solar--verified-check-bold] text-green-500"></span>
                </span>
            </div>
            <a href="{{ url('user/profile') }}" class="dropdown-item">
                <span class="dropdown-icon">
                    <span class="icon-[lucide--user]"></span>
                </span>Profile</a>
            <hr class="border-zinc-100 dark:border-zinc-800 my-2">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();"
                    class="dropdown-item">
                    <span class="dropdown-icon">
                        <span class="icon-[lucide--log-out]"></span>
                    </span>Sign out</a>
            </form>
        </div>
    </div>
</div>
