    <!--:Scripts:-->
    <script src="/user/js/theme.js"></script>


    <!--:Dashboard scripts:-->
    <script src="/user/vendor/js/sweetalert2.all.min.js"></script>
    <script src="/user/vendor/js/echarts.min.js"></script>
    <script src="/user/js/dashboard-analytic.js" type="text/javascript"></script>


    <!-- from node_modules -->
    <script src="node_modules/@material-tailwind/html/scripts/tabs.js"></script>

    <!-- from cdn -->
    <script src="https://unpkg.com/@material-tailwind/html@latest/scripts/tabs.js"></script>

    <!--:Dashboard data range picker:-->
    <script type="text/javascript" src="/user/vendor/js/jquery.min.js"></script>
    <script type="text/javascript" src="/user/vendor/js/moment.min.js"></script>
    <script type="text/javascript" src="/user/vendor/js/daterangepicker.js"></script>

    <!-- jQuery (required for Toastr) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Toastr JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/flowbite@3.1.2/dist/flowbite.min.js"></script>

    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            @if (session('success'))
                toastr.success("{{ session('success') }}");
            @endif

            @if (session('error'))
                toastr.error("{{ session('error') }}");
            @endif

            @if (session('warning'))
                toastr.warning("{{ session('warning') }}");
            @endif

            @if (session('info'))
                toastr.info("{{ session('info') }}");
            @endif

            // Optional Toastr settings
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "timeOut": "4000"
            };
        });
    </script>


    <script>
        const copyBtn = document.getElementById("copyBtn");
        const referralInput = document.getElementById("referralCode");
        const copyMsg = document.getElementById("copyMsg");

        copyBtn.addEventListener("click", async () => {
            const text = referralInput.value;
            let copied = false;

            // Try modern clipboard API
            if (navigator.clipboard && window.isSecureContext) {
                try {
                    await navigator.clipboard.writeText(text);
                    copied = true;
                } catch (err) {
                    copied = false;
                }
            }

            // Fallback for mobile & older browsers
            if (!copied) {
                referralInput.select();
                referralInput.setSelectionRange(0, 99999); // For mobile devices
                try {
                    document.execCommand("copy");
                    copied = true;
                } catch (err) {
                    copied = false;
                }
                window.getSelection().removeAllRanges();
            }

            // Show success message
            if (copied) {
                copyMsg.classList.remove("hidden");
                copyMsg.style.opacity = "1";
                setTimeout(() => {
                    copyMsg.style.opacity = "0";
                    setTimeout(() => copyMsg.classList.add("hidden"), 300);
                }, 2000);
            } else {
                alert("Copy failed. Please copy manually.");
            }
        });
    </script>

    <script type="text/javascript">
        $(function() {

            var start = moment().subtract(29, 'days');
            var end = moment();

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMM D, YY') + ' - ' + end.format('MMM D, YY'));
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                }
            }, cb);

            cb(start, end);

        });
    </script>
