<div class="px-2 pt-2 pb-3 space-y-1 sm:px-3">

    <a href="{{ url('/')}}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Home</a>
    <!-- Mobile Navigation -->
    <div x-data="{ open: false }" class="py-1">
        <button @click="open = !open"
            class="w-full flex justify-between items-center px-4 py-2 text-sm text-gray-200 hover:bg-gray-700">
            <span>Trading</span>
            <svg class="h-4 w-4 text-gray-400" :class="{'transform rotate-180': open}"
                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                    clip-rule="evenodd" />
            </svg>
        </button>
        <div x-show="open" class="pl-4">
            <a href="{{  url('cryptocurrencies') }}"
                class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Cryptocurrencies</a>
            <a href="{{  url('forex') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Forex</a>
            <a href="{{  url('shares') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Shares</a>
            <a href="{{  url('indices') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Indices</a>
            <a href="{{  url('etfs') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">ETFs</a>
        </div>
    </div>

    <div x-data="{ open: false }" class="py-1">
        <button @click="open = !open"
            class="w-full flex justify-between items-center px-4 py-2 text-sm text-gray-200 hover:bg-gray-700">
            <span>System</span>
            <svg class="h-4 w-4 text-gray-400" :class="{'transform rotate-180': open}"
                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                    clip-rule="evenodd" />
            </svg>
        </button>
        <div x-show="open" class="pl-4">
            <a href="{{ url('trade') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Trade</a>
            <a href="{{  url('copy') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Copy
                Trading</a>
            <a href="{{  url('automate') }}" class="block px-4 py-2 text-sm text-gray-200 hover:bg-dark-200">Automated
                Trading</a>
        </div>
    </div>

    <div x-data="{ open: false }" class="py-1">
        <button @click="open = !open"
            class="w-full flex justify-between items-center px-4 py-2 text-sm text-gray-200 hover:bg-gray-700">
            <span>Company</span>
            <svg class="h-4 w-4 text-gray-400" :class="{'transform rotate-180': open}"
                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                    clip-rule="evenodd" />
            </svg>
        </button>
        <div x-show="open" class="pl-4">
            <a href="{{  url('about') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">About Us</a>
            <a href="{{  url('why') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Why Us</a>
            <a href="{{  url('faq') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">FAQ</a>
            <a href="{{  url('regulation') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Legal &
                Regulation</a>
        </div>
    </div>

    <a href="{{ url('for-traders')}}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Education</a>
    <a href="{{ url('contact')}}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700">Contact</a>

    <!-- Language Selector (Mobile) -->

    <div class="pt-4 pb-3 border-t border-gray-700">
        <div class="flex items-center justify-between px-4">
            <div class="flex items-center space-x-3">
                <a href="{{ url('login')}}"
                    class="text-gray-300 hover:bg-gray-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium">
                    <i class="fas fa-lock mr-1"></i> Log in
                </a>
                <a href="{{ url('register')}}"
                    class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium">
                    Sign up
                </a>
            </div>
        </div>
    </div>
</div>