<!-- Upper Footer -->
<div class="border-t border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="py-12">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div>
                    <div class="flex items-center mb-6">
                        <a href="{{ url('/') }}" class="flex items-center">
                            <img class="h-8 w-auto"
                                src="storage/app/public/photos/3op553ou4DfSZgXgMJNW0gD2SfiyUQ2JV2JEUNXC.png"
                                alt="{{ $websiteSettings->site_name }}">
                        </a>
                    </div>
                    <p class="text-sm text-gray-400 mb-6">
                        {{ $websiteSettings->site_name }} offers CFD trading on stocks, forex, indices, commodities, and
                        cryptocurrencies
                        with competitive spreads and advanced trading tools.
                    </p>
                    <div class="flex space-x-4">
                        <a href="{{ url('/') }}#" class="text-gray-400 hover:text-white">
                            <span class="sr-only">Twitter</span>
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="{{ url('/') }}#" class="text-gray-400 hover:text-white">
                            <span class="sr-only">LinkedIn</span>
                            <i class="fab fa-linkedin"></i>
                        </a>
                        <a href="mailto:{{ $websiteSettings->site_email }}" class="text-gray-400 hover:text-white">
                            <span class="sr-only">Email</span>
                            <i class="fas fa-envelope"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-sm font-semibold text-white uppercase tracking-wider mb-4">Quick Links</h3>
                    <ul class="space-y-3">
                        <li><a href="{{ url('about') }}"
                                class="text-sm text-gray-400 hover:text-white transition">About
                                Us</a></li>
                        <li><a href="{{ url('why') }}" class="text-sm text-gray-400 hover:text-white transition">Why
                                Choose Us</a></li>
                        <li><a href="{{ url('for-traders') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Education</a></li>
                        <li><a href="{{ url('contact') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Contact</a></li>
                    </ul>
                </div>

                <!-- Trading -->
                <div>
                    <h3 class="text-sm font-semibold text-white uppercase tracking-wider mb-4">Trading</h3>
                    <ul class="space-y-3">
                        <li><a href="{{ url('cryptocurrencies') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Cryptocurrencies</a>
                        </li>
                        <li><a href="{{ url('forex') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Forex</a>
                        </li>
                        <li><a href="{{ url('shares') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Shares</a>
                        </li>
                        <li><a href="{{ url('indices') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Indices</a>
                        </li>
                    </ul>
                </div>

                <!-- Account -->
                <div>
                    <h3 class="text-sm font-semibold text-white uppercase tracking-wider mb-4">Your Account</h3>
                    <ul class="space-y-3">
                        <li><a href="{{ url('login') }}" class="text-sm text-gray-400 hover:text-white transition">Log
                                In</a></li>
                        <li><a href="{{ url('register') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Create
                                Account</a>
                        </li>
                        <li><a href="{{ url('login') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Demo
                                Account</a></li>
                        <li><a href="{{ url('contact') }}"
                                class="text-sm text-gray-400 hover:text-white transition">Help
                                Center</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Platform Availability -->
<div class="border-t border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="py-6">
            <div class="flex flex-col md:flex-row items-center justify-between">
                <div class="mb-4 md:mb-0">
                    <h4 class="text-sm font-semibold text-white">Available On</h4>
                </div>
                <div class="flex items-center space-x-6">
                    <a href="{{ url('/') }}#" class="flex items-center text-gray-400 hover:text-white"
                        aria-label="Web Platform">
                        <i class="fas fa-desktop mr-2"></i>
                        <span class="text-sm">Web</span>
                    </a>
                    <a href="{{ url('/') }}#" class="flex items-center text-gray-400 hover:text-white"
                        aria-label="Windows App">
                        <i class="fab fa-windows mr-2"></i>
                        <span class="text-sm">Windows</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Disclaimer & Legal -->
<div class="bg-dark-500 border-t border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="py-6">
            <div class="text-xs text-gray-400">
                <p class="mb-4 leading-relaxed">
                    <span class="font-semibold text-gray-300">RISK WARNING:</span> The Financial Products
                    offered by the company include Contracts for Difference ('CFDs') and other complex financial
                    products. Trading CFDs carries a high level of risk since leverage can work both to your
                    advantage and disadvantage. As a result, CFDs may not be suitable for all investors because
                    it is possible to lose all of your invested capital. You should never invest money that you
                    cannot afford to lose. Before trading in the complex financial products offered, please
                    ensure you understand the risks involved.
                </p>
                <div class="flex flex-wrap gap-4 mb-4">
                    <a href="{{ url('terms') }}" class="text-blue-400 hover:text-blue-300 transition">Terms &
                        Conditions</a>
                    <a href="{{ url('privacy') }}" class="text-blue-400 hover:text-blue-300 transition">Privacy
                        Policy</a>
                    <a href="{{ url('legals') }}" class="text-blue-400 hover:text-blue-300 transition">Legal
                        Documents</a>
                </div>
                <p>©
                    <script>
                        document.write(new Date().getFullYear())
                    </script> {{ $websiteSettings->site_name }}. All
                    Rights Reserved.
                </p>
            </div>
        </div>
    </div>
</div>

<div class="gtranslate_wrapper"></div>
<script>
    window.gtranslateSettings = {
        default_language: "en",
        alt_flags: {
            "en": "usa"
        },
        wrapper_selector: ".gtranslate_wrapper",
        flag_style: "3d",
    };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
