<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Welcome to {{$websiteSettings->site_name}}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            padding: 50px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .logo {
            text-align: center;
            margin-bottom: 25px;
        }

        h1 {
            font-size: 22px;
            font-weight: 700;
            color: #111827;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            color: #2563eb;
            margin-top: 0;
            margin-bottom: 20px;
        }

        p {
            font-size: 15px;
            line-height: 24px;
            color: #444;
            text-align: center;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            background-color: #2563eb;
            color: #fff !important;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 8px;
            margin: 10px auto 25px;
        }

        .highlight {
            color: #2563eb;
            font-weight: 600;
        }

        .footer {
            margin-top: 30px;
            font-size: 13px;
            color: #6b7280;
            background-color: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
        }

        @media (max-width: 480px) {
            .container {
                padding: 30px 20px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="logo">
            <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="{{$websiteSettings->site_name}} Logo"
                width="70" height="70" />
        </div>

        <h1>Welcome to {{$websiteSettings->site_name}}, {{ $name }}!</h1>
        <h2>Your journey to smarter investing starts here.</h2>

        <p>
            Thank you for joining <span class="highlight">{{$websiteSettings->site_name}}</span> — your trusted platform
            for
            secure and transparent investments.
            You’ve taken the first step toward financial growth and stability.
        </p>

        <p>
            You can now explore your dashboard to view available investment plans, monitor your portfolio, and track
            your earnings in real time.
        </p>

        <div style="text-align:center;">
            <a href="{{ route('user.dashboard') }}" class="button">Go to Dashboard</a>
        </div>

        <p>
            Need help getting started? Our support team is here 24/7 to assist you with anything you need.
        </p>

        <div class="footer">
            Best regards,<br>
            <strong>{{$websiteSettings->site_name}} Team</strong><br>
            <small>Invest smart. Earn confidently.</small>
        </div>
    </div>
</body>

</html>