<!DOCTYPE html>
@php
    $getSetting = App\Models\WebsiteSetting::first();
@endphp

<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            padding: 10px 0;
        }

        .header img {
            width: 100px;
        }

        .content {
            padding: 20px;
            line-height: 1.6;
        }

        .footer {
            text-align: center;
            padding: 10px 0;
            font-size: 12px;
            color: #777777;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <img src="{{ asset('upload/' . $getSetting->site_logo) }}" width="250" height="50" class="img-fluid "
                alt="logo">
        </div>
        <div class="content">
            <h6>Staking Successful!</h6>
            <p>Hello, {{ $user_name }}!</p>
            <p>We are pleased to inform you that your stake is processed successfully.</p>
            <p>Stake Amount: ${{ $staking_amount }}</p>
            <p>Thank you for choosing {{ $getSetting->site_name }}. We are committed to helping you achieve your
                financial goals.</p>
            <p>If you have any questions or need further assistance, please do not hesitate to contact our support team.
            </p>
            <p>Best regards,<br>The {{ $getSetting->site_name }} Team</p>
        </div>
        <div class="footer">
            <p> &copy; {{ date('Y') }} {{ $getSetting->site_name }}. All rights reserved.</p>
        </div>
    </div>
</body>

</html>