<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Loan Rejected</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />
    <style>
        body {
            background: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background: #fff;
            border-radius: 20px;
            border: 1px solid #ddd;
            padding: 40px;
        }

        h1 {
            color: #dc2626;
            font-size: 22px;
            text-align: center;
        }

        p {
            text-align: center;
            font-size: 15px;
            line-height: 22px;
            color: #444;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 13px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>❌ Loan Rejected</h1>
        <p>Hello {{ $loan->user->firstname }},</p>
        <p>We regret to inform you that your loan request for
            <strong>${{ number_format($loan->amount, 2) }}</strong>
            ({{ $loan->loanType->name ?? 'Loan' }}) has been rejected.
        </p>
        <p>Please contact our support team if you wish to review your application or reapply.</p>
        <p><strong>Date:</strong> {{ $loan->created_at->format('M d, Y') }}</p>
        <div class="footer">
            — The {{ config('app.name') }} Team
        </div>
    </div>
</body>

</html>