<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Loan Approved</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />
    <style>
        body {
            background: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background: #fff;
            border-radius: 20px;
            border: 1px solid #ddd;
            padding: 40px;
        }

        h1 {
            color: #16a34a;
            font-size: 22px;
            text-align: center;
        }

        p {
            text-align: center;
            font-size: 15px;
            line-height: 22px;
            color: #444;
        }

        .amount {
            font-size: 18px;
            font-weight: bold;
            color: #111;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 13px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>✅ Loan Approved!</h1>
        <p>Hello {{ $loan->user->firstname }},</p>
        <p>Your loan request for <span class="amount">${{ number_format($loan->amount, 2) }}</span>
            ({{ $loan->loanType->name ?? 'Personal Loan' }}) has been approved.</p>
        <p>The funds have been credited to your account balance.</p>
        <p><strong>Duration:</strong> {{ $loan->duration }} months<br>
            <strong>Interest Rate:</strong> {{ $loan->interest_rate }}%<br>
            <strong>Total Payable:</strong> ${{ number_format($loan->total_payable, 2) }}
        </p>
        <p>You can now manage your repayments directly from your dashboard.</p>
        <div class="footer">
            — The {{ config('app.name') }} Team
        </div>
    </div>
</body>

</html>