<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Trade Confirmation - {{ $websiteSettings->site_name }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            background-color: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            padding: 0;
            margin: 0;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background: white;
            padding: 40px 35px;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
        }

        h1 {
            font-size: 22px;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            font-size: 16px;
            text-align: center;
            color: #2563eb;
            margin-bottom: 20px;
        }

        p {
            font-size: 15px;
            line-height: 24px;
            text-align: center;
        }

        .highlight {
            font-weight: 700;
            color: #2563eb;
        }

        .details-box {
            margin-top: 25px;
            background: #f3f4f6;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 14px;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }
    </style>
</head>

<body>
    <div class="container">
        <div style="text-align:center; margin-bottom:20px;">
            <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}" width="70" height="70">
        </div>

        <h1>Trade Successfully Placed!</h1>
        <h2>{{ $websiteSettings->site_name }}</h2>

        <p>
            Your live trade has been successfully placed on
            <span class="highlight">{{ $trade->symbol }}</span>.
        </p>

        <div class="details-box">
            <p><strong>Market Type:</strong> {{ ucfirst($trade->market_type) }}</p>
            <p><strong>Order Type:</strong> {{ ucfirst($trade->order_type) }}</p>
            <p><strong>Side:</strong> {{ strtoupper($trade->side) }}</p>
            <p><strong>Amount:</strong> ${{ number_format($trade->amount, 2) }}</p>
            <p><strong>Entry Price:</strong> ${{ number_format($trade->entry_price, 5) }}</p>
            <p><strong>Units:</strong> {{ number_format($trade->units, 6) }}</p>
        </div>


        <div class="footer">
            Best Regards,<br>
            <strong>{{ $websiteSettings->site_name }} Team</strong><br>
            <small>Trade smart. Earn confidently.</small>
        </div>
    </div>
</body>

</html>