<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Investment Started - {{ $websiteSettings->site_name }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            padding: 50px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .logo {
            text-align: center;
            margin-bottom: 25px;
        }

        h1 {
            font-size: 22px;
            font-weight: 700;
            color: #111827;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            color: #2563eb;
            margin-top: 0;
            margin-bottom: 20px;
        }

        p {
            font-size: 15px;
            line-height: 24px;
            color: #444;
            text-align: center;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            background-color: #2563eb;
            color: #fff !important;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 8px;
            margin: 10px auto 25px;
        }

        .highlight {
            color: #2563eb;
            font-weight: 600;
        }

        .footer {
            margin-top: 30px;
            font-size: 13px;
            color: #6b7280;
            background-color: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="container">

        <div class="logo">
            <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="{{ $websiteSettings->site_name }} Logo"
                width="70" height="70" />
        </div>

        <h1>Your Investment Has Started</h1>
        <h2>{{ $websiteSettings->site_name }}</h2>

        <p>
            Hello <span class="highlight">{{ $investment->user->firstname }}</span>,
            your investment in the <strong>{{ $investment->plan->name }}</strong> plan has started successfully.
        </p>

        <p>
            You invested: <strong>${{ number_format($investment->amount, 2) }}</strong><br>
            Expected return: <strong>${{ number_format($investment->expected_return, 2) }}</strong><br>
            Duration: <strong>{{ $investment->duration }} days</strong>
        </p>

        <div style="text-align:center;">
            <a href="{{ route('user.portfolio') }}" class="button">View Portfolio</a>
        </div>

        <p>
            Your investment will grow automatically based on the plan’s interest rate.
            You can track your progress anytime from your dashboard.
        </p>

        <div class="footer">
            Best regards,<br>
            <strong>{{ $websiteSettings->site_name }} Team</strong><br>
            <small>Invest smart. Earn confidently.</small>
        </div>

    </div>
</body>

</html>