<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>New Investment Notification</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 20px;
            border: 1px solid #e5e7eb;
            padding: 50px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .logo {
            text-align: center;
            margin-bottom: 25px;
        }

        h1 {
            font-size: 22px;
            font-weight: 700;
            color: #111827;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            color: #ef4444;
            margin-top: 0;
            margin-bottom: 20px;
        }

        p {
            font-size: 15px;
            line-height: 24px;
            color: #444;
            text-align: center;
            margin-bottom: 20px;
        }

        .highlight {
            color: #2563eb;
            font-weight: 600;
        }

        .footer {
            margin-top: 30px;
            font-size: 13px;
            color: #6b7280;
            background-color: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
        }
    </style>
</head>

<body>

    <div class="container">

        <div class="logo">
            <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}" alt="{{ $websiteSettings->site_name }} Logo"
                width="70" height="70" />
        </div>

        <h1>New Investment Received</h1>
        <h2>{{ $websiteSettings->site_name }} Admin Alert</h2>

        <p>
            A user has just started a new investment.
        </p>

        <p>
            <strong>User:</strong> {{ $investment->user->firstname }} {{ $investment->user->lastname }} <br>
            <strong>Email:</strong> {{ $investment->user->email }} <br><br>

            <strong>Plan:</strong> {{ $investment->plan->name }} <br>
            <strong>Amount Invested:</strong> ${{ number_format($investment->amount, 2) }} <br>
            <strong>Expected Return:</strong> ${{ number_format($investment->expected_return, 2) }}
        </p>

        <div class="footer">
            This is an automated admin alert.<br>
            <strong>{{ $websiteSettings->site_name }}</strong>
        </div>

    </div>

</body>

</html>