<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>New Trade Alert - {{ $websiteSettings->site_name }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />

    <style>
        body {
            background: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            padding: 40px 35px;
            border-radius: 20px;
            background: white;
            border: 1px solid #e5e7eb;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
        }

        h1 {
            text-align: center;
            font-size: 20px;
        }

        h2 {
            font-size: 16px;
            text-align: center;
            color: #e11d48;
        }

        p {
            font-size: 14px;
            line-height: 22px;
        }

        .details-box {
            margin-top: 20px;
            background: #f3f4f6;
            padding: 15px 20px;
            border-radius: 12px;
            font-size: 14px;
        }

        .footer {
            margin-top: 25px;
            text-align: center;
            color: #6b7280;
            font-size: 13px;
        }
    </style>
</head>

<body>
    <div class="container">

        <h1>New Live Trade Alert</h1>
        <h2>{{ $websiteSettings->site_name }}</h2>

        <p>
            A user has just placed a new live trade. Here are the details:
        </p>

        <div class="details-box">
            <p><strong>User:</strong> {{ $trade->user->firstname }} {{ $trade->user->lastname }}</p>
            <p><strong>Asset:</strong> {{ $trade->symbol }}</p>
            <p><strong>Amount:</strong> ${{ number_format($trade->amount, 2) }}</p>
            <p><strong>Market Type:</strong> {{ ucfirst($trade->market_type) }}</p>
            <p><strong>Side:</strong> {{ strtoupper($trade->side) }}</p>
            <p><strong>Entry Price:</strong> ${{ number_format($trade->entry_price, 5) }}</p>
        </div>

        <div class="footer">
            Admin Dashboard — {{ $websiteSettings->site_name }}
        </div>

    </div>
</body>

</html>