<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.getItem('theme') === 'light' ? false : true }" :class="{ 'dark': darkMode }" class="dark bg-gray-300 h-full">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="wivA4MyFouig0kGM80BoALBDN6KeIjdkkinmpiPV">
    <title>{{ $websiteSettings->site_name }} - Create Account</title>

    <!-- Favicon -->
    <link href="{{ asset('upload/' . $websiteSettings->site_favicon) }}" rel="icon" type="image/x-icon" />

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Set dark mode as default if no preference is stored
        if (!localStorage.getItem('theme')) {
            localStorage.setItem('theme', 'dark');
            document.documentElement.classList.add('dark');
        }

        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                        'glass': 'rgba(255, 255, 255, 0.05)',
                    },
                    backdropBlur: {
                        'xs': '2px',
                    },
                    animation: {
                        'gradient-x': 'gradient-x 15s ease infinite',
                        'gradient-y': 'gradient-y 15s ease infinite',
                        'gradient-xy': 'gradient-xy 15s ease infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'float': 'float 6s ease-in-out infinite',
                    },
                    keyframes: {
                        'gradient-y': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'center top'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'center center'
                            }
                        },
                        'gradient-x': {
                            '0%, 100%': {
                                'background-size': '200% 200%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'gradient-xy': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'float': {
                            '0%, 100%': {
                                transform: 'translateY(0)'
                            },
                            '50%': {
                                transform: 'translateY(-10px)'
                            }
                        }
                    }
                }
            }
        }
    </script>

    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <title>{{ $websiteSettings->site_name }}</title>
    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">


    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">

    <link href="{{ asset('upload/' . $websiteSettings->site_favicon) }}" rel="icon" type="image/x-icon" />
    <!-- <link rel="icon" sizes="192x192" href="404.html"> -->

    <meta name="keywords" content="{{ $websiteSettings->site_name }}" />
    <meta property="og:image" content="{{ asset('upload/' . $websiteSettings->site_favicon) }}" />

    <meta name="msapplication-square310x310logo" content="{{ asset('upload/' . $websiteSettings->site_favicon) }}">
    <meta name="msapplication-square70x70logo" content="{{ asset('upload/' . $websiteSettings->site_favicon) }}">
    <meta name="msapplication-square150x150logo" content="{{ asset('upload/' . $websiteSettings->site_favicon) }}">
    <meta name="msapplication-wide310x150logo" content="{{ asset('upload/' . $websiteSettings->site_favicon) }}">

    <link rel="apple-touch-icon-precomposed" href="{{ asset('upload/' . $websiteSettings->site_favicon) }}">
    <!-- <link rel="apple-touch-icon-precomposed" sizes="57x57" href="404.html" /> -->
    <!-- <link rel="apple-touch-icon-precomposed" sizes="72x72" href="404.html" /> -->
    <link rel="apple-touch-icon-precomposed" sizes="114x114"
        href="{{ asset('upload/' . $websiteSettings->site_favicon) }}" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144"
        href="{{ asset('upload/' . $websiteSettings->site_favicon) }}" />


    <meta property="og:site_name" content="{{ $websiteSettings->site_name }}">
    <meta property="og:title" content="Trading With {{ $websiteSettings->site_name }}" />
    <meta name="description"
        content="{{ $websiteSettings->site_name }} LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:description"
        content="{{ $websiteSettings->site_name }} LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:type" content="website" />


    <!-- <link href="404" rel="stylesheet" /> -->

</head>


<style>
    body {
        overflow-x: hidden;
    }

    [x-cloak] {
        display: none !important;
    }

    .glass-effect {
        background: rgba(255, 255, 255, 0.03);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.05);
        box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
    }

    .trading-card {
        background: rgba(17, 24, 39, 0.95);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(75, 85, 99, 0.2);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.3),
            0 20px 25px -5px rgba(0, 0, 0, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.05);
    }

    .light .trading-card {
        background: rgba(255, 255, 255, 0.95);
        border: 1px solid rgba(229, 231, 235, 0.3);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.1),
            0 20px 25px -5px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.1);
    }

    .step-indicator {
        position: relative;
        z-index: 1;
    }

    .step-indicator::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, transparent 0%, rgba(79, 70, 229, 0.3) 50%, transparent 100%);
        transform: translateY(-50%);
        z-index: -1;
    }

    .skiptranslate {
        display: none !important;
    }

    body {
        top: 0 !important;
    }
</style>
</head>

<body class="h-full bg-gray-300 font-sans antialiased transition-colors duration-300 text-gray-900"
    x-data="{ darkMode: localStorage.theme === 'dark' || !localStorage.theme }" :class="{ 'dark': darkMode }" x-cloak>

    <!-- Theme Toggle (Hidden but accessible) -->
    {{-- <div class="fixed top-4 right-4 z-50">
        <button x-data="{ darkMode: localStorage.getItem('theme') === 'dark' || !localStorage.getItem('theme') }"
            @click="darkMode = !darkMode; localStorage.setItem('theme', darkMode ? 'dark' : 'light'); document.documentElement.classList.toggle('dark', darkMode)"
            class="relative inline-flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg transition-colors duration-150 backdrop-blur-sm"
            :aria-pressed="darkMode" x-cloak>
            <svg x-cloak x-show="!darkMode" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364-6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 12.728l-.707-.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
            </svg>
            <svg x-cloak x-show="darkMode" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
            </svg>
            <span
                class="absolute inset-0 rounded-lg ring-2 ring-inset ring-transparent transition-colors duration-150 hover:ring-blue-400/20"></span>
        </button>
    </div> --}}

    <!-- Main Content Wrapper -->
    <div class="relative min-h-screen overflow-hidden">
        <!-- Content -->
        <div class="relative z-10">

            <!-- Fintech Trading Platform Registration -->
            <div class="min-h-screen bg-gray-900 relative overflow-hidden py-8 sm:py-12">
                <div class="relative z-10 flex items-center justify-center px-4 sm:px-6 lg:px-8">
                    <div class="w-full max-w-2xl">
                        <!-- Professional Trading Registration Card -->
                        <div class="bg-gray-900 border border-gray-700 rounded-2xl sm:rounded-3xl p-6 sm:p-8 lg:p-10 shadow-2xl"
                            x-data="registrationForm()" x-cloak>

                            <!-- Header Section -->
                            <div class="text-center mb-8">
                                <!-- Logo -->
                                <div class="flex items-center justify-center mb-6">
                                    <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}"
                                        class="h-12 sm:h-16 w-auto" alt="{{ $websiteSettings->site_name }}" />
                                </div>

                                <!-- Title -->
                                <h1 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-white mb-2">
                                    Join <span
                                        class="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-cyan-400">{{ $websiteSettings->site_name }}</span>
                                </h1>
                                <p class="text-gray-300 text-sm sm:text-base lg:text-lg mb-6">
                                    Start your professional trading journey
                                </p>

                                <!-- Trading Stats - Mobile Responsive -->
                                {{-- <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 sm:gap-6 text-xs sm:text-sm">
                                    <div class="text-center p-3 bg-gray-800/50 rounded-xl border border-gray-700/50">-->
                                        <div class="flex items-center justify-center gap-1 text-green-400 mb-1">-->
                                            <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>-->
                                            <span class="font-semibold">99.9% Uptime</span>-->
                                        </div>
                                       <div class="text-gray-400">Reliable Platform</div>
                                    </div>
                                    <div class="text-center p-3 bg-gray-800/50 rounded-xl border border-gray-700/50">
                                        <div class="flex items-center justify-center gap-1 text-blue-400 mb-1">
                                            <i data-lucide="shield-check" class="w-3 h-3"></i>
                                            <span class="font-semibold">Bank-Grade</span>
                                        </div>
                                        <div class="text-gray-400">Security</div>
                                    <div>
                                    <div class="text-center p-3 bg-gray-800/50 rounded-xl border border-gray-700/50">
                                        <div class="flex items-center justify-center gap-1 text-cyan-400 mb-1">
                                            <i data-lucide="users" class="w-3 h-3"></i>
                                            <span class="font-semibold">1M+ Traders</span>
                                        </div>
                                        <div class="text-gray-400">Community</div>
                                    </div>
                                </div> --}}
                            </div>

                            <!-- Enhanced Progress Steps - Mobile Optimized -->
                            <div class="mb-8">
                                <div class="flex items-center justify-between sm:justify-center sm:space-x-8">
                                    <template x-for="(step, index) in steps" :key="index">
                                        <div class="flex flex-col items-center">
                                            <!-- Step Circle -->
                                            <div class="relative mb-2">
                                                <div class="flex items-center justify-center w-8 h-8 sm:w-10 sm:h-10 rounded-full text-xs sm:text-sm font-bold transition-all duration-300"
                                                    :class="currentStep > index ? 'bg-green-500 text-white' :
                                                        currentStep === index ? 'bg-blue-500 text-white' :
                                                        'bg-gray-700 text-gray-400'">
                                                    <span x-show="currentStep <= index" x-text="index + 1"></span>
                                                    <i x-show="currentStep > index" data-lucide="check"
                                                        class="w-4 h-4 sm:w-5 sm:h-5"></i>
                                                </div>
                                                <!-- Active Step Pulse -->
                                                <div x-show="currentStep === index"
                                                    class="absolute inset-0 w-8 h-8 sm:w-10 sm:h-10 rounded-full bg-blue-500 animate-ping opacity-20">
                                                </div>
                                            </div>

                                            <!-- Step Label -->
                                            <div class="text-center">
                                                <div class="text-xs sm:text-sm font-medium transition-colors duration-300"
                                                    :class="currentStep >= index ? 'text-white' : 'text-gray-500'"
                                                    x-text="step.title"></div>
                                                <div class="text-xs text-gray-500 hidden sm:block"
                                                    x-text="step.description"></div>
                                            </div>

                                            <!-- Connector Line -->
                                            <div x-show="index < steps.length - 1"
                                                class="hidden sm:block absolute top-4 left-1/2 w-16 h-0.5 transition-colors duration-300"
                                                :class="currentStep > index ? 'bg-green-500' : 'bg-gray-700'"
                                                style="transform: translateX(2rem);"></div>
                                        </div>
                                    </template>
                                </div>
                            </div>

                            <!-- Error Summary Section -->

                            <!-- Registration Form -->
                            <form action="{{ route('register') }}" method="POST" class="space-y-6" x-cloak>
                                @csrf
                                <!-- Step 1: Personal Information -->
                                <div x-show="currentStep === 0" x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform translate-x-4"
                                    x-transition:enter-end="opacity-100 transform translate-x-0">

                                    <!-- Step Header -->
                                    <div class="mb-6 p-4 bg-blue-500/10 rounded-xl border border-blue-500/20">
                                        <div class="flex items-center gap-3">
                                            <div class="p-2 bg-blue-500/20 rounded-lg">
                                                <i data-lucide="user-circle" class="w-5 h-5 text-blue-400"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg sm:text-xl font-bold text-white">Personal
                                                    Information</h3>
                                                <p class="text-gray-400 text-sm">Create your trading profile</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">

                                        <!-- Full Name Field -->
                                        <div class="space-y-2">
                                            <label for="name" class="block text-sm font-bold text-gray-200">
                                                First Name <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="user-check"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="text" name="firstname" id="firstname" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Enter first name">
                                            </div>
                                            <x-input-error :messages="$errors->get('firstname')" class="mt-1" />
                                        </div>

                                        <div class="space-y-2">
                                            <label for="name" class="block text-sm font-bold text-gray-200">
                                                Last Name <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="user-check"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="text" name="lastname" id="lastname" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Enter Last name">
                                            </div>
                                            <x-input-error :messages="$errors->get('lastname')" class="mt-1" />
                                        </div>

                                        <!-- Username Field -->
                                        <div class="space-y-2">
                                            <label for="username" class="block text-sm font-bold text-gray-200">
                                                Trading Username <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="user"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="text" name="username" id="username" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Choose username">
                                            </div>
                                            <x-input-error :messages="$errors->get('username')" class="mt-1" />
                                        </div>

                                        <!-- Email Field -->
                                        <div class="space-y-2">
                                            <label for="email" class="block text-sm font-bold text-gray-200">
                                                Email Address <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="mail"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="email" name="email" id="email" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="youremail@example.com">
                                            </div>
                                        </div>

                                        <!-- Phone Field -->
                                        <div class="space-y-2">
                                            <label for="phone" class="block text-sm font-bold text-gray-200">
                                                Phone Number <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="phone"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="tel" name="phone" id="phone" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="+1 (555) 123-4567">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Step 2: Location & Currency -->
                                <div x-show="currentStep === 1" x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform translate-x-4"
                                    x-transition:enter-end="opacity-100 transform translate-x-0">

                                    <!-- Step Header -->
                                    <div class="mb-6 p-4 bg-purple-500/10 rounded-xl border border-purple-500/20">
                                        <div class="flex items-center gap-3">
                                            <div class="p-2 bg-purple-500/20 rounded-lg">
                                                <i data-lucide="globe-2" class="w-5 h-5 text-purple-400"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg sm:text-xl font-bold text-white">Location</h3>
                                                <p class="text-gray-400 text-sm">Set your regional trading preferences
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-1 sm:grid-cols-1 gap-4 sm:gap-6">
                                        <!-- Country Field -->
                                        <div class="space-y-2">
                                            <label for="country" class="block text-sm font-bold text-gray-200">
                                                Country <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4 z-10">
                                                    <i data-lucide="flag"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <select name="country" id="country" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-8 py-4 text-white focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold appearance-none">
                                                    <option selected disabled class="text-gray-400">Select your country
                                                    </option>
                                                    @foreach ($country as $count)
                                                        <option value="{{ $count->name }}">{{ $count->emoji }}
                                                            {{ $count->name }}</option>
                                                    @endforeach
                                                </select>
                                                <div
                                                    class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                                    <i data-lucide="chevron-down" class="h-4 w-4 text-gray-400"></i>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Currency Field -->
                                        <div class="space-y-2">
                                            <label for="currency" class="block text-sm font-bold text-gray-200">
                                                Currency <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4 z-10">
                                                    <i data-lucide="banknote"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <select name="currency" id="currency" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-8 py-4 text-white focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold appearance-none">
                                                    <option selected class="text-gray-400">Select your currency
                                                    </option>
                                                    @foreach ($currency as $cur)
                                                        <option value="{{ $cur->code }}">{{ $cur->symbol }} -
                                                            {{ $cur->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div
                                                    class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                                    <i data-lucide="chevron-down" class="h-4 w-4 text-gray-400"></i>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Account Type -->
                                        <div class="space-y-2">
                                            <label for="currency" class="block text-sm font-bold text-gray-200">
                                                Currency <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4 z-10">
                                                    <i data-lucide="banknote"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <select name="account_type" id="account_type" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-8 py-4 text-white focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold appearance-none">
                                                    <option value="Trading Account">Trading Account</option>
                                                    <option value="Stock Account">Stock Account</option>
                                                    <option value="Forex Account">Forex Account</option>
                                                    <option value="Binary Account">Binary Account</option>
                                                </select>
                                                <div
                                                    class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                                                    <i data-lucide="chevron-down" class="h-4 w-4 text-gray-400"></i>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Trading Preferences Info -->
                                    <div class="mt-6 p-4 bg-blue-500/10 rounded-xl border border-blue-500/20">
                                        <div class="flex items-start gap-3">
                                            <i data-lucide="info"
                                                class="w-5 h-5 text-blue-400 mt-0.5 flex-shrink-0"></i>
                                            <div class="text-sm">
                                                <p class="text-blue-300 font-bold mb-1">Regional Trading Information
                                                </p>
                                                <p class="text-gray-300">Your location helps us provide region-specific
                                                    features, compliance, and optimal server connections for faster
                                                    trading execution.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Step 3: Security -->
                                <div x-show="currentStep === 2" x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform translate-x-4"
                                    x-transition:enter-end="opacity-100 transform translate-x-0">

                                    <!-- Step Header -->
                                    <div class="mb-6 p-4 bg-green-500/10 rounded-xl border border-green-500/20">
                                        <div class="flex items-center gap-3">
                                            <div class="p-2 bg-green-500/20 rounded-lg">
                                                <i data-lucide="shield-check" class="w-5 h-5 text-green-400"></i>
                                            </div>
                                            <div>
                                                <h3 class="text-lg sm:text-xl font-bold text-white">Account Security
                                                </h3>
                                                <p class="text-gray-400 text-sm">Secure your trading account</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                                        <!-- Password Field -->
                                        <div class="space-y-2">
                                            <label for="password" class="block text-sm font-bold text-gray-200">
                                                Password <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="lock"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="password" name="password" id="password" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Create strong password">
                                            </div>
                                        </div>

                                        <!-- Confirm Password Field -->
                                        <div class="space-y-2">
                                            <label for="password_confirmation"
                                                class="block text-sm font-bold text-gray-200">
                                                Confirm Password <span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="key"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="password" name="password_confirmation"
                                                    id="password_confirmation" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Confirm your password">
                                            </div>
                                        </div>

                                        <!-- Referral Code -->
                                        <div class="space-y-2">
                                            <label for="password_confirmation"
                                                class="block text-sm font-bold text-gray-200">
                                                Referral Code<span class="text-red-400">*</span>
                                            </label>
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="key"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input type="text" name="referral_code" id="referral_code"
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                                    placeholder="Enter Referral Code">
                                            </div>
                                            <x-input-error :messages="$errors->get('referral_code')" class="mt-1" />
                                        </div>
                                    </div>

                                    <!-- CAPTCHA Section -->
                                    <div class="space-y-4 mt-6" id="captcha-wrapper">
                                        <div class="space-y-2">
                                            <label for="captcha" class="block text-sm font-bold text-gray-200">
                                                Simple Captcha Verification <span class="text-red-400">*</span>
                                            </label>
                                            <!-- CAPTCHA Display -->
                                            <div class="bg-gray-800 border border-gray-600 rounded-xl p-4 mb-3">
                                                {{-- Refresh button --}}
                                                <button id="refresh-captcha" type="button"
                                                    class="text-sm px-3 py-1 rounded-md border border-blue-200 bg-white/60 hover:bg-white transition text-blue-700 dark:text-blue-200">
                                                    Refresh
                                                </button>
                                                <div class="flex items-center justify-center">
                                                    <div
                                                        class="bg-gradient-to-r from-blue-900 to-purple-900 rounded-lg p-4 border border-gray-600">
                                                        <div class="text-center">
                                                            <p class="text-sm text-gray-300 mb-3 font-medium">Enter
                                                                the code shown below (caps & numbers).</p>
                                                            <div
                                                                class="bg-gray-900 rounded-lg px-8 py-4 border border-gray-700">
                                                                <span id="captcha-code"
                                                                    class="text-3xl font-bold text-green-400 tracking-wide select-none"
                                                                    style="font-family: 'Arial', sans-serif;">
                                                                    {{ session('captcha_code', $captcha ?? '') }}
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- CAPTCHA Input -->
                                            <div class="relative group">
                                                <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                    <i data-lucide="calculator"
                                                        class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                                </div>
                                                <input id="captcha" name="captcha" maxlength="8" required
                                                    class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold text-center"
                                                    placeholder="Type the code above" autocomplete="off">
                                                @error('captcha')
                                                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            <!-- Helper text -->
                                            <p class="text-xs text-gray-400 flex items-center gap-1">
                                                <i data-lucide="info" class="w-3 h-3"></i>
                                                Enter the captch to verify you're human!
                                            </p>
                                        </div>
                                    </div>

                                    {{-- JS: refresh + copy (place at bottom of file or in a script stack) --}}
                                    <script>
                                        document.addEventListener('DOMContentLoaded', function() {
                                            const refreshBtn = document.getElementById('refresh-captcha');
                                            const captchaCode = document.getElementById('captcha-code');
                                            const copyBtn = document.getElementById('copy-captcha');

                                            refreshBtn?.addEventListener('click', async function() {
                                                refreshBtn.disabled = true;
                                                refreshBtn.textContent = 'Refreshing...';
                                                try {
                                                    const res = await fetch("{{ route('captcha.refresh') }}", {
                                                        method: 'GET',
                                                        headers: {
                                                            'X-Requested-With': 'XMLHttpRequest'
                                                        }
                                                    });
                                                    if (!res.ok) throw new Error('Network response was not ok');
                                                    const data = await res.json();
                                                    if (data.captcha) {
                                                        captchaCode.textContent = data.captcha;
                                                    }
                                                } catch (err) {
                                                    console.error(err);
                                                    alert('Could not refresh captcha. Try again.');
                                                } finally {
                                                    refreshBtn.disabled = false;
                                                    refreshBtn.textContent = 'Refresh';
                                                }
                                            });

                                            copyBtn?.addEventListener('click', function() {
                                                const text = captchaCode.textContent.trim();
                                                if (!text) return;
                                                navigator.clipboard?.writeText(text).then(() => {
                                                    copyBtn.textContent = 'Copied';
                                                    setTimeout(() => copyBtn.textContent = 'Copy', 1500);
                                                });
                                            });
                                        });
                                    </script>

                                    <!-- Password Requirements -->
                                    <div class="mt-6 p-4 bg-gray-800/50 rounded-xl border border-gray-700">
                                        <p class="text-sm font-bold text-gray-200 mb-2">Password Requirements:</p>
                                        <ul class="text-xs text-gray-300 space-y-1">
                                            <li class="flex items-center gap-2">
                                                <i data-lucide="check" class="w-3 h-3 text-green-400"></i>
                                                At least 8 characters long
                                            </li>
                                            <li class="flex items-center gap-2">
                                                <i data-lucide="check" class="w-3 h-3 text-green-400"></i>
                                                Contains uppercase and lowercase letters
                                            </li>
                                            <li class="flex items-center gap-2">
                                                <i data-lucide="check" class="w-3 h-3 text-green-400"></i>
                                                Includes at least one number or special character
                                            </li>
                                        </ul>
                                    </div>

                                    <!-- Terms Agreement -->
                                    <div class="mt-6 p-6 bg-blue-500/10 rounded-xl border border-blue-500/20">
                                        <div class="flex items-start gap-4">
                                            <div class="flex items-center h-5 mt-1">
                                                <input type="checkbox" name="agree" id="agree" required
                                                    class="h-4 w-4 rounded border-gray-600 bg-gray-900 text-blue-500 focus:ring-2 focus:ring-blue-400/20 transition-colors">
                                            </div>
                                            <div class="flex-1">
                                                <label for="agree"
                                                    class="text-sm font-bold text-gray-200 leading-relaxed">
                                                    I agree to {{ $websiteSettings->site_name }}'s
                                                    <a href="{{ url('terms') }}" target="_blank"
                                                        class="text-blue-400 hover:text-blue-300 font-bold underline underline-offset-2">
                                                        Terms and Conditions
                                                    </a>
                                                    and acknowledge that I have read and understood the
                                                    <a href="{{ url('privacy') }}" target="_blank"
                                                        class="text-blue-400 hover:text-blue-300 font-bold underline underline-offset-2">
                                                        Privacy Policy
                                                    </a>
                                                </label>
                                                <p class="text-xs text-gray-400 mt-2">
                                                    By creating an account, you confirm that you are at least 18 years
                                                    old and agree to receive trading updates and market insights.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Enhanced Navigation Buttons -->
                                <div class="flex flex-col sm:flex-row justify-between items-center mt-10 pt-8 border-t border-gray-700 gap-4"
                                    x-cloak>
                                    <!-- Previous Button -->
                                    <button type="button" @click="previousStep()" x-show="currentStep > 0"
                                        class="inline-flex items-center gap-2 px-6 py-3 text-gray-400 hover:text-white transition-all duration-200 rounded-xl hover:bg-gray-800/50 group">
                                        <i data-lucide="arrow-left"
                                            class="w-4 h-4 group-hover:-translate-x-1 transition-transform"></i>
                                        <span class="font-bold">Previous Step</span>
                                    </button>

                                    <!-- Progress Indicator -->
                                    <div class="flex items-center gap-2 text-sm text-gray-400">
                                        <span x-text="`Step ${currentStep + 1} of ${steps.length}`"
                                            class="font-bold"></span>
                                    </div>

                                    <!-- Next Button -->
                                    <button type="button" @click="nextStep()"
                                        x-show="currentStep < steps.length - 1"
                                        class="inline-flex items-center gap-2 px-8 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-bold rounded-xl transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 group">
                                        <span>Continue</span>
                                        <i data-lucide="arrow-right"
                                            class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                                    </button>

                                    <!-- Create Account Button -->
                                    <button type="submit" x-show="currentStep === steps.length - 1"
                                        class="inline-flex items-center gap-2 px-8 py-3 bg-gradient-to-r from-green-600 to-emerald-600 hover:from-green-700 hover:to-emerald-700 text-white font-bold rounded-xl transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 group">
                                        <i data-lucide="user-plus" class="w-5 h-5"></i>
                                        <span>Create Trading Account</span>
                                        <i data-lucide="sparkles"
                                            class="w-4 h-4 group-hover:rotate-12 transition-transform"></i>
                                    </button>
                                </div>

                                <!-- Professional Footer -->
                                <div class="mt-8 text-center space-y-4">
                                    <div class="flex items-center justify-center gap-6 text-sm">
                                        <p class="text-gray-400">
                                            Already have an account?
                                            <a href="{{ url('login') }}"
                                                class="font-bold text-blue-400 hover:text-blue-300 transition-colors underline underline-offset-2">
                                                Sign in here
                                            </a>
                                        </p>
                                    </div>

                                    <!-- Trust Indicators -->
                                    <div class="flex items-center justify-center gap-8 py-4 text-xs text-gray-500">
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="shield" class="w-3 h-3"></i>
                                            <span>SSL Secured</span>
                                        </div>
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="lock" class="w-3 h-3"></i>
                                            <span>256-bit Encryption</span>
                                        </div>
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="award" class="w-3 h-3"></i>
                                            <span>Regulated Platform</span>
                                        </div>
                                    </div>

                                    <p class="text-xs text-gray-500">
                                        ©
                                        <script>
                                            document.write(new Date().getFullYear())
                                        </script> {{ $websiteSettings->site_name }}. All rights
                                        reserved. |
                                        Licensed and regulated trading platform.
                                    </p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>





                <style>
                    .skiptranslate {
                        display: none !important;
                    }

                    body {
                        top: 0 !important;
                    }

                    [x-cloak] {
                        display: none !important;
                    }
                </style>

                <div id="google_translate_element" style="display:none"></div>
                <script type="text/javascript">
                    function googleTranslateElementInit() {
                        new google.translate.TranslateElement({
                            pageLanguage: "en"
                        }, 'google_translate_element');
                    }
                </script>
                <script type="text/javascript"
                    src="https://translate.google.com/translate_a/elementa0d8.js?cb=googleTranslateElementInit"></script>

                <script>
                    function registrationForm() {
                        return {
                            currentStep: 0,
                            steps: [{
                                    title: 'Personal Info',
                                    description: 'Basic details',
                                    completed: false
                                },
                                {
                                    title: 'Location',
                                    description: 'Regional settings',
                                    completed: false
                                },
                                {
                                    title: 'Security',
                                    description: 'Account protection',
                                    completed: false
                                }
                            ],

                            nextStep() {
                                if (this.validateCurrentStep()) {
                                    this.steps[this.currentStep].completed = true;
                                    if (this.currentStep < this.steps.length - 1) {
                                        this.currentStep++;
                                        this.scrollToTop();
                                    }
                                }
                            },

                            previousStep() {
                                if (this.currentStep > 0) {
                                    this.currentStep--;
                                    this.scrollToTop();
                                }
                            },

                            scrollToTop() {
                                window.scrollTo({
                                    top: 0,
                                    behavior: 'smooth'
                                });
                            },

                            validateCurrentStep() {
                                const step = this.currentStep;
                                let isValid = true;
                                let missingFields = [];

                                if (step === 0) {
                                    // Validate personal information
                                    const fields = [{
                                            id: 'firstname',
                                            name: 'First Name'
                                        },
                                        {
                                            id: 'lastname',
                                            name: 'Last Name'
                                        },
                                        {
                                            id: 'username',
                                            name: 'Username'
                                        },
                                        {
                                            id: 'email',
                                            name: 'Email'
                                        },
                                        {
                                            id: 'phone',
                                            name: 'Phone Number'
                                        }
                                    ];

                                    fields.forEach(field => {
                                        const element = document.getElementById(field.id);
                                        const value = element.value.trim();
                                        if (!value) {
                                            missingFields.push(field.name);
                                            isValid = false;
                                            // Add visual feedback
                                            element.classList.add('border-red-500', 'bg-red-900/20');
                                            element.classList.remove('border-gray-600');
                                        } else {
                                            // Remove error styling if field is now valid
                                            element.classList.remove('border-red-500', 'bg-red-900/20');
                                            element.classList.add('border-gray-600');
                                        }
                                    });

                                    // Email validation
                                    const emailElement = document.getElementById('email');
                                    const email = emailElement.value.trim();
                                    if (email && !email.includes('@')) {
                                        missingFields.push('Valid Email Format');
                                        isValid = false;
                                        emailElement.classList.add('border-red-500', 'bg-red-900/20');
                                        emailElement.classList.remove('border-gray-600');
                                    }

                                } else if (step === 1) {
                                    // Validate location
                                    const countryElement = document.getElementById('country');
                                    const country = countryElement.value;

                                    if (!country || country === 'Select your country') {
                                        missingFields.push('Country Selection');
                                        isValid = false;
                                        countryElement.classList.add('border-red-500', 'bg-red-900/20');
                                        countryElement.classList.remove('border-gray-600');
                                    } else {
                                        countryElement.classList.remove('border-red-500', 'bg-red-900/20');
                                        countryElement.classList.add('border-gray-600');
                                    }

                                } else if (step === 2) {
                                    // Validate security
                                    const passwordElement = document.getElementById('password');
                                    const confirmPasswordElement = document.getElementById('password_confirmation');
                                    const captchaElement = document.getElementById('captcha');
                                    const agreeElement = document.getElementById('agree');

                                    const password = passwordElement.value;
                                    const confirmPassword = confirmPasswordElement.value;
                                    const captcha = captchaElement.value.trim();
                                    const agree = agreeElement.checked;

                                    // Password validation
                                    if (!password) {
                                        missingFields.push('Password');
                                        isValid = false;
                                        passwordElement.classList.add('border-red-500', 'bg-red-900/20');
                                    } else if (password.length < 8) {
                                        missingFields.push('Password (minimum 8 characters)');
                                        isValid = false;
                                        passwordElement.classList.add('border-red-500', 'bg-red-900/20');
                                    } else {
                                        passwordElement.classList.remove('border-red-500', 'bg-red-900/20');
                                        passwordElement.classList.add('border-gray-600');
                                    }

                                    // Confirm password validation
                                    if (!confirmPassword) {
                                        missingFields.push('Password Confirmation');
                                        isValid = false;
                                        confirmPasswordElement.classList.add('border-red-500', 'bg-red-900/20');
                                    } else if (password !== confirmPassword) {
                                        missingFields.push('Passwords Must Match');
                                        isValid = false;
                                        confirmPasswordElement.classList.add('border-red-500', 'bg-red-900/20');
                                    } else {
                                        confirmPasswordElement.classList.remove('border-red-500', 'bg-red-900/20');
                                        confirmPasswordElement.classList.add('border-gray-600');
                                    }

                                    // CAPTCHA validation
                                    if (!captcha) {
                                        missingFields.push('Math Verification Answer');
                                        isValid = false;
                                        captchaElement.classList.add('border-red-500', 'bg-red-900/20');
                                    } else {
                                        captchaElement.classList.remove('border-red-500', 'bg-red-900/20');
                                        captchaElement.classList.add('border-gray-600');
                                    }

                                    // Terms agreement validation
                                    if (!agree) {
                                        missingFields.push('Terms & Conditions Agreement');
                                        isValid = false;
                                    }
                                }

                                if (!isValid) {
                                    const message = missingFields.length === 1 ?
                                        `Please provide: ${missingFields[0]}` :
                                        `Please complete these fields: ${missingFields.join(', ')}`;

                                    // Show professional alert
                                    this.showAlert('Complete Required Fields', message, 'warning');
                                }

                                return isValid;
                            },

                            showAlert(title, message, type = 'info') {
                                // Simple alert fallback if SweetAlert2 is not available
                                if (typeof Swal !== 'undefined') {
                                    Swal.fire({
                                        title: title,
                                        text: message,
                                        icon: type,
                                        confirmButtonText: 'Got it',
                                        confirmButtonColor: '#3B82F6'
                                    });
                                } else {
                                    alert(`${title}: ${message}`);
                                }
                            }
                        }
                    }

                    // Enhanced initialization with better error handling
                    document.addEventListener('alpine:init', () => {
                        setTimeout(() => {
                            if (typeof lucide !== 'undefined') {
                                lucide.createIcons();
                            }
                        }, 100);
                    });

                    document.addEventListener('alpine:updated', () => {
                        if (typeof lucide !== 'undefined') {
                            lucide.createIcons();
                        }
                    });

                    // Form submission enhancement
                    document.addEventListener('DOMContentLoaded', function() {
                        const form = document.getElementById('register');
                        if (form) {
                            form.addEventListener('submit', function(e) {
                                const submitBtn = form.querySelector('button[type="submit"]');
                                if (submitBtn) {
                                    submitBtn.disabled = true;
                                    submitBtn.innerHTML =
                                        '<i data-lucide="loader-2" class="w-4 h-4 animate-spin mr-2"></i>Creating Account...';
                                }
                            });
                        }

                        // Auto-scroll to errors if they exist
                        const errorSummary = document.querySelector('.bg-red-500\\/10');
                        if (errorSummary) {
                            setTimeout(() => {
                                errorSummary.scrollIntoView({
                                    behavior: 'smooth',
                                    block: 'center'
                                });

                                // Add a subtle shake animation to draw attention
                                errorSummary.style.animation = 'shake 0.5s ease-in-out';
                            }, 100);
                        }
                    });
                </script>

                <!-- Add shake animation CSS -->
                <style>
                    @keyframes shake {

                        0%,
                        100% {
                            transform: translateX(0);
                        }

                        25% {
                            transform: translateX(-5px);
                        }

                        75% {
                            transform: translateX(5px);
                        }
                    }
                </style>
            </div>
        </div>

        <!-- Professional Trading Ticker -->
        {{-- <div
            class="fixed bottom-0 left-0 right-0 bg-white/80 dark:bg-gray-900/90 backdrop-blur-md border-t border-gray-200/50 dark:border-gray-700/50 z-40">
            <div class="tradingview-widget-container">
                <div class="tradingview-widget-container__widget"></div>
                <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                    {
                        "symbols": [{
                                "proName": "BINANCE:BTCUSDT",
                                "title": "BTC/USDT"
                            },
                            {
                                "proName": "BINANCE:ETHUSDT",
                                "title": "ETH/USDT"
                            },
                            {
                                "proName": "FX:EURUSD",
                                "title": "EUR/USD"
                            } {
                                "proName": "FX:GBPUSD",
                                "title": "GBP/USD"
                            },
                            {
                                "proName": "FX:USDJPY",
                                "title": "USD/JPY"
                            },
                            {
                                "proName": "NASDAQ:AAPL",
                                "title": "APPLE"
                            },
                            {
                                "proName": "TVC:GOLD",
                                "title": "GOLD"
                            }
                        ],
                        "showSymbolLogo": true,
                        "colorTheme": "dark",
                        "isTransparent": true,
                        "displayMode": "adaptive",
                        "locale": "en"
                    }
                </script>
                <div class="gtranslate_wrapper"></div>
                <script>
                    window.gtranslateSettings = {
                        default_language: "en",
                        alt_flags: {
                            "en": "usa"
                        },
                        wrapper_selector: ".gtranslate_wrapper",
                        flag_style: "3d",
                    };
                </script>
                <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
            </div>
        </div> --}}

        <!-- Initialize Scripts -->
        <script>
            // Set dark mode as default if no preference is stored
            if (!localStorage.getItem('theme')) {
                localStorage.setItem('theme', 'dark');
                document.documentElement.classList.add('dark');
            }

            // Initialize theme
            document.addEventListener('alpine:init', () => {
                Alpine.store('theme', {
                    init() {
                        // Default to dark if no preference is set
                        this.darkMode = localStorage.getItem('theme') === 'dark' || !localStorage.getItem(
                            'theme');
                        this.updateTheme();
                    },
                    darkMode: true, // Set default to true
                    toggle() {
                        this.darkMode = !this.darkMode;
                        this.updateTheme();
                    },
                    updateTheme() {
                        localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
                        document.documentElement.classList.toggle('dark', this.darkMode);
                    }
                });
            });

            // Initialize Lucide icons
            document.addEventListener('DOMContentLoaded', () => {
                if (typeof lucide !== 'undefined') {
                    lucide.createIcons();
                }
            });

            // Re-initialize icons after Alpine updates
            document.addEventListener('alpine:updated', () => {
                if (typeof lucide !== 'undefined') {
                    lucide.createIcons();
                }
            });
        </script>

        <!-- Language Selector -->
        <div class="gtranslate_wrapper"></div>
        <script>
            window.gtranslateSettings = {
                default_language: "en",
                alt_flags: {
                    "en": "usa"
                },
                wrapper_selector: ".gtranslate_wrapper",
                flag_style: "3d",
            };
        </script>
        <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
        <!-- Language Selector -->
        <div class="gtranslate_wrapper"></div>
        <script>
            window.gtranslateSettings = {
                default_language: "en",
                alt_flags: {
                    "en": "usa"
                },
                wrapper_selector: ".gtranslate_wrapper",
                flag_style: "3d",
            };
        </script>
        <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
</body>

</html>
