<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.getItem('theme') === 'light' ? false : true }" :class="{ 'dark': darkMode }" class="dark bg-gray-300 h-full">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="wivA4MyFouig0kGM80BoALBDN6KeIjdkkinmpiPV">
    <title>{{ $websiteSettings->site_name }} - Forgot your password</title>

    <!-- Favicon -->
    <link href="{{ asset('upload/' . $websiteSettings->site_favicon) }}" rel="icon" type="image/x-icon" />

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Set dark mode as default if no preference is stored
        if (!localStorage.getItem('theme')) {
            localStorage.setItem('theme', 'dark');
            document.documentElement.classList.add('dark');
        }

        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                        'glass': 'rgba(255, 255, 255, 0.05)',
                    },
                    backdropBlur: {
                        'xs': '2px',
                    },
                    animation: {
                        'gradient-x': 'gradient-x 15s ease infinite',
                        'gradient-y': 'gradient-y 15s ease infinite',
                        'gradient-xy': 'gradient-xy 15s ease infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'float': 'float 6s ease-in-out infinite',
                    },
                    keyframes: {
                        'gradient-y': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'center top'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'center center'
                            }
                        },
                        'gradient-x': {
                            '0%, 100%': {
                                'background-size': '200% 200%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'gradient-xy': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'float': {
                            '0%, 100%': {
                                transform: 'translateY(0)'
                            },
                            '50%': {
                                transform: 'translateY(-10px)'
                            }
                        }
                    }
                }
            }
        }
    </script>

    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>


    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet"
        href="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/css/bootstrap.min.css">
    <!-- jQuery library -->
    <script src="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/js/jquery.min.js"></script>
    <!-- Popper JS -->
    <script src="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/js/popper.min.js"></script>
    <!-- Latest compiled JavaScript -->
    <script src="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/js/bootstrap.min.js"></script>

    <link href="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/css/main.css"
        rel="stylesheet" />
    <!-- <link href="404.html" rel="stylesheet" /> -->

    <title>{{ $websiteSettings->site_name }}</title>
    <link rel="manifest"
        href="https://{{ $websiteSettings->site_name }}algotradescript.sbs/temp/custom/js/manifest.json">
    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">


    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">

    <link href="storage/app/public/photos/Px9MifdF6k4uRiyRSGBX6qi4kKWtbhpkYNQrAouw.png" rel="icon"
        type="image/x-icon" />
    <!-- <link rel="icon" sizes="192x192" href="404.html"> -->

    <meta name="keywords" content="{{ $websiteSettings->site_name }}" />
    <meta property="og:image" content="temp/custom/images/icon/icon-310x310.png" />

    <meta name="msapplication-square310x310logo" content="">
    <meta name="msapplication-square70x70logo" content="">
    <meta name="msapplication-square150x150logo" content="">
    <meta name="msapplication-wide310x150logo" content="">

    <link rel="apple-touch-icon-precomposed"
        href="storage/app/public/photos/Px9MifdF6k4uRiyRSGBX6qi4kKWtbhpkYNQrAouw.png">
    <!-- <link rel="apple-touch-icon-precomposed" sizes="57x57" href="404.html" /> -->
    <!-- <link rel="apple-touch-icon-precomposed" sizes="72x72" href="404.html" /> -->
    <link rel="apple-touch-icon-precomposed" sizes="114x114"
        href="storage/app/public/photos/Px9MifdF6k4uRiyRSGBX6qi4kKWtbhpkYNQrAouw.png" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144"
        href="storage/app/public/photos/Px9MifdF6k4uRiyRSGBX6qi4kKWtbhpkYNQrAouw.png" />


    <meta property="og:site_name" content="{{ $websiteSettings->site_name }}">
    <meta property="og:title" content="Trading With {{ $websiteSettings->site_name }}" />
    <meta name="description"
        content="{{ $websiteSettings->site_name }} LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:description"
        content="{{ $websiteSettings->site_name }} LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:type" content="website" />


    <!-- <link href="404" rel="stylesheet" /> -->

</head>


<style>
    body {
        overflow-x: hidden;
    }

    [x-cloak] {
        display: none !important;
    }

    .glass-effect {
        background: rgba(255, 255, 255, 0.03);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.05);
        box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
    }

    .trading-card {
        background: rgba(17, 24, 39, 0.95);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(75, 85, 99, 0.2);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.3),
            0 20px 25px -5px rgba(0, 0, 0, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.05);
    }

    .light .trading-card {
        background: rgba(255, 255, 255, 0.95);
        border: 1px solid rgba(229, 231, 235, 0.3);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.1),
            0 20px 25px -5px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.1);
    }

    .step-indicator {
        position: relative;
        z-index: 1;
    }

    .step-indicator::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, transparent 0%, rgba(79, 70, 229, 0.3) 50%, transparent 100%);
        transform: translateY(-50%);
        z-index: -1;
    }

    .skiptranslate {
        display: none !important;
    }

    body {
        top: 0 !important;
    }
</style>
</head>

<body class="h-full bg-gray-300 font-sans antialiased transition-colors duration-300 text-gray-900"
    x-data="{ darkMode: localStorage.theme === 'dark' || !localStorage.theme }" :class="{ 'dark': darkMode }" x-cloak>
    <!-- Theme Toggle (Hidden but accessible) -->
    {{-- <div class="fixed top-4 right-4 z-50">
        <button x-data="{ darkMode: localStorage.getItem('theme') === 'dark' || !localStorage.getItem('theme') }"
            @click="darkMode = !darkMode; localStorage.setItem('theme', darkMode ? 'dark' : 'light'); document.documentElement.classList.toggle('dark', darkMode)"
            class="relative inline-flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg transition-colors duration-150 backdrop-blur-sm"
            :aria-pressed="darkMode" x-cloak>
            <svg x-cloak x-show="!darkMode" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364-6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 12.728l-.707-.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
            </svg>
            <svg x-cloak x-show="darkMode" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
            </svg>
            <span
                class="absolute inset-0 rounded-lg ring-2 ring-inset ring-transparent transition-colors duration-150 hover:ring-blue-400/20"></span>
        </button>
    </div> --}}

    <!-- Main Content Wrapper -->
    <div class="relative min-h-screen overflow-hidden">
        <!-- Content -->
        <div class="relative z-10">
            <div class="min-h-screen bg-gray-900 flex items-center justify-center p-4">
                <div class="w-full max-w-md space-y-8">
                    <!-- Logo and Header -->
                    <div class="text-center space-y-6">
                        <div class="flex justify-center">
                            <a href="{{ url('/') }}" class="inline-block">
                                <img src="{{ asset('upload/' . $websiteSettings->site_logo) }}"
                                    alt="{{ $websiteSettings->site_name }}" class="h-12 sm:h-16 w-auto">
                            </a>
                        </div>

                        <!-- Header Section -->
                        <div class="space-y-3">
                            <div class="flex items-center justify-center gap-2 mb-4">
                                <div class="p-2 bg-blue-500/20 rounded-lg">
                                    <i data-lucide="key" class="w-6 h-6 text-blue-400"></i>
                                </div>
                                <h1 class="text-2xl sm:text-3xl font-bold text-white">Access Registration</h1>
                            </div>
                            <p class="text-gray-400 text-sm sm:text-base max-w-sm mx-auto leading-relaxed">
                                For security reason, the registeration portal is locked with an access code, provide
                                the access code to continue
                            </p>
                        </div>
                    </div>

                    <!-- Forgot Password Form -->
                    <div class="bg-gray-900 backdrop-blur-sm border border-gray-700 rounded-2xl p-6 sm:p-8 space-y-6">
                        <!-- Error Message -->

                        <!-- Session Status -->
                        <x-auth-session-status class="mb-4" :status="session('status')" />

                        <form method="POST" action="{{ route('access-code.submit') }}" class="space-y-6">
                            @csrf

                            <!-- Email Field -->
                            <div class="space-y-2">
                                <label for="email" class="block text-sm font-bold text-gray-200">
                                    Access Code <span class="text-red-400">*</span>
                                </label>
                                <div class="relative group">
                                    <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                        <i data-lucide="key"
                                            class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors"></i>
                                    </div>
                                    <input id="access_code" name="access_code" type="text" required
                                        class="block w-full rounded-xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-bold"
                                        placeholder="Enter access code">
                                    <x-input-error :messages="$errors->get('access_code')" class="mt-2 text-red-400 text-sm" />
                                </div>
                                <p class="text-xs text-gray-400">
                                    Enter the access code to register
                                </p>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit"
                                class="w-full flex items-center justify-center gap-2 px-6 py-4 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-bold rounded-xl transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 focus:ring-2 focus:ring-blue-400/20">
                                <i data-lucide="send" class="w-5 h-5"></i>
                                <span>Continue to Registration</span>
                            </button>
                        </form>

                        <!-- Additional Options -->
                        <div class="space-y-4 pt-4 border-t border-gray-700">
                            <!-- Back to Login -->
                            <div class="text-center">
                                <p class="text-gray-400 text-sm">
                                    Already have an account?
                                    <a href="{{ url('login') }}"
                                        class="font-bold text-blue-400 hover:text-blue-300 transition-colors underline underline-offset-2">
                                        Back to Login
                                    </a>
                                </p>
                            </div>
                        </div>

                        <!-- Security Notice -->
                        <div class="p-4 bg-amber-500/10 rounded-xl border border-amber-500/20">
                            <div class="flex items-start gap-3">
                                <i data-lucide="shield-check" class="w-5 h-5 text-amber-400 mt-0.5 flex-shrink-0"></i>
                                <div>
                                    <h4 class="text-sm font-bold text-amber-300 mb-1">Security Notice</h4>
                                    <p class="text-xs text-gray-300">
                                        For security reason, the registeration portal is locked with an access code,
                                        provide the access code to continue
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Trust Indicators -->
                    <div class="flex items-center justify-center gap-6 text-xs text-gray-500">
                        <div class="flex items-center gap-1">
                            <i data-lucide="shield" class="w-3 h-3"></i>
                            <span>SSL Secured</span>
                        </div>
                        <div class="flex items-center gap-1">
                            <i data-lucide="lock" class="w-3 h-3"></i>
                            <span>256-bit Encryption</span>
                        </div>
                        <div class="flex items-center gap-1">
                            <i data-lucide="award" class="w-3 h-3"></i>
                            <span>Regulated Platform</span>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="text-center">
                        <p class="text-xs text-gray-500">
                            ©
                            <script>
                                document.write(new Date().getFullYear())
                            </script> {{ $websiteSettings->site_name }}. All rights reserved. |
                            Licensed and regulated trading platform.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Professional Trading Ticker -->
    {{-- <div
        class="fixed bottom-0 left-0 right-0 bg-white/80 dark:bg-gray-900/90 backdrop-blur-md border-t border-gray-200/50 dark:border-gray-700/50 z-40">
        <div class="tradingview-widget-container">
            <div class="tradingview-widget-container__widget"></div>
            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                -- >
                <
                !--{
                    -- >
                    <
                    !--"symbols": [-- >
                        <
                        !--{
                            "proName": "BINANCE:BTCUSDT",
                            "title": "BTC/USDT"
                        }, -- >
                        <
                        !--{
                            "proName": "BINANCE:ETHUSDT",
                            "title": "ETH/USDT"
                        }, -- >
                        <
                        !--{
                            "proName": "FX:EURUSD",
                            "title": "EUR/USD"
                        }, -- >
                        <
                        !--{
                            "proName": "FX:GBPUSD",
                            "title": "GBP/USD"
                        }, -- >
                        <
                        !--{
                            "proName": "FX:USDJPY",
                            "title": "USD/JPY"
                        }, -- >
                        <
                        !--{
                            "proName": "NASDAQ:AAPL",
                            "title": "APPLE"
                        }, -- >
                        <
                        !--{
                            "proName": "TVC:GOLD",
                            "title": "GOLD"
                        }-- >
                        <
                        !--
                    ],
                    -- >
                    <
                    !--"showSymbolLogo": true,
                    -- >
                    <
                    !--"colorTheme": "dark",
                    -- >
                    <
                    !--"isTransparent": true,
                    -- >
                    <
                    !--"displayMode": "adaptive",
                    -- >
                    <
                    !--"locale": "en"-- >
                        <
                        !--
                }-- >
                <
                !--
            </script>
            <div class="gtranslate_wrapper"></div>
            <script>
                window.gtranslateSettings = {
                    default_language: "en",
                    alt_flags: {
                        "en": "usa"
                    },
                    wrapper_selector: ".gtranslate_wrapper",
                    flag_style: "3d",
                };
            </script>
            <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
        </div>
    </div> --}}

    <!-- Initialize Scripts -->
    <script>
        // Set dark mode as default if no preference is stored
        if (!localStorage.getItem('theme')) {
            localStorage.setItem('theme', 'dark');
            document.documentElement.classList.add('dark');
        }

        // Initialize theme
        document.addEventListener('alpine:init', () => {
            Alpine.store('theme', {
                init() {
                    // Default to dark if no preference is set
                    this.darkMode = localStorage.getItem('theme') === 'dark' || !localStorage.getItem(
                        'theme');
                    this.updateTheme();
                },
                darkMode: true, // Set default to true
                toggle() {
                    this.darkMode = !this.darkMode;
                    this.updateTheme();
                },
                updateTheme() {
                    localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
                    document.documentElement.classList.toggle('dark', this.darkMode);
                }
            });
        });

        // Initialize Lucide icons
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });

        // Re-initialize icons after Alpine updates
        document.addEventListener('alpine:updated', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
    </script>
    <!-- Language Selector -->
    <div class="gtranslate_wrapper"></div>
    <script>
        window.gtranslateSettings = {
            default_language: "en",
            alt_flags: {
                "en": "usa"
            },
            wrapper_selector: ".gtranslate_wrapper",
            flag_style: "3d",
        };
    </script>
    <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>

    <!-- Language Selector -->
    <div class="gtranslate_wrapper"></div>
    <script>
        window.gtranslateSettings = {
            default_language: "en",
            alt_flags: {
                "en": "usa"
            },
            wrapper_selector: ".gtranslate_wrapper",
            flag_style: "3d",
        };
    </script>
    <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
</body>

</html>
