<x-admin :title="$pageTitle">

    <div class="mx-auto max-w-(--breakpoint-2xl) p-4 pb-20 md:p-6 md:pb-6">
        <!-- Breadcrumb Start -->
        <div x-data="{ pageName: `Signals` }">
            <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                <nav>
                    <ol class="flex items-center gap-1.5">
                        <li>
                            <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                href="{{ url('/') }}">
                                Home
                                <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke=""
                                        stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <div class="space-y-5 sm:space-y-6">
            <div class="rounded-2xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
                <div class="flex flex-col justify-between gap-5 px-6 py-5 sm:flex-row sm:items-start">
                    <div>
                        <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                            Signals
                        </h3>
                    </div>
                    <div>
                        <a href="{{ url('admin/signal/add') }}"
                            class="shadow-theme-xs flex w-full justify-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-3 text-sm font-medium text-gray-700 hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
                                fill="none">
                                <path d="M5.5 10.0002H15.5006M10.5002 5V15.0006" stroke="currentColor"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                            Add New Signal
                        </a>
                    </div>
                </div>
                <div class="border-t border-gray-100 p-4 sm:p-6 dark:border-gray-800">
                    <!-- Pricing Table Two -->
                    <div class="gird-cols-1 grid gap-5 sm:grid-cols-2 xl:grid-cols-3 xl:gap-6">
                        <!-- Pricing item -->
                        @forelse($signal as $plan)
                            <div
                                class="rounded-2xl border border-gray-200 bg-white p-6 dark:border-gray-800 dark:bg-white/[0.03] xl:p-8">
                                <div class="-mb-4 flex items-start justify-between">
                                    <span class="block text-theme-xl font-semibold text-gray-800 dark:text-white/90">
                                        {{ $plan->title }}
                                    </span>
                                </div>

                                <div class="flex items-end mt-4">
                                    <h2 class="text-title-md font-bold text-gray-800 dark:text-white/90">
                                        ${{ $plan->price }}
                                    </h2>
                                </div>

                                <div class="my-6 h-px w-full bg-gray-200 dark:bg-gray-800"></div>

                                <div class="mb-8 space-y-3">
                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Pair: ${{ $plan->pair }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Status: {{ $plan->status }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Direction: {{ $plan->direction }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Entry Price: {{ $plan->entry_price }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Take Profit: {{ $plan->take_profit }}
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Stop Loss: {{ $plan->stop_loss }}
                                    </p>


                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        Strength: {{ $plan->strength }}%
                                    </p>

                                    <p class="flex items-center gap-3 text-sm text-gray-700 dark:text-gray-400">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.4017 4.35986L6.12166 11.6399L2.59833 8.11657" stroke="#12B76A"
                                                stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        {{ $plan->description }}
                                    </p>
                                </div>
                                <div class="flex gap-2">
                                    <a href="{{ url('admin/signal/edit', $plan->id) }}"
                                        class="flex w-full items-center justify-center rounded-lg bg-gray-800 p-3.5 text-sm font-medium text-white shadow-theme-xs transition-colors hover:bg-brand-500 dark:bg-white/10">
                                        Edit
                                    </a>

                                    <form action="{{ route('admin.signal.destroy', $plan->id) }}" method="POST"
                                        onsubmit="return confirm('Are you sure you want to delete this signal?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                            class="btn flex w-full items-center justify-center rounded-lg btn-red p-3.5 text-sm font-medium text-white shadow-theme-xs transition-colors hover:bg-brand-500 dark:bg-white/10">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @empty
                        @endforelse
                    </div>
                    <!-- Pricing Table Two -->
                </div>
            </div>
        </div>
    </div>

</x-admin>
