<x-admin>

    <div class="mx-auto max-w-(--breakpoint-2xl) px-5 py-4 md:p-6">
        <div>
            <!-- Breadcrumb Start -->
            <div x-data="{ pageName: `Users Loan Application` }">
                <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                    <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                    <nav>
                        <ol class="flex items-center gap-1.5">
                            <li>
                                <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                    href="{{ url('admin/dashboard') }}">
                                    Home
                                    <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke=""
                                            stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </li>
                            <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!-- Breadcrumb End -->

            <!-- Content Start -->
            <div class="col-span-12">
                <!-- Table Five -->
                <div class="rounded-2xl border border-gray-200 bg-white pt-4 dark:border-gray-800 dark:bg-white/[0.03]">
                    <div class="flex flex-col justify-between gap-5 px-6 py-5 sm:flex-row sm:items-start">
                        <div>
                            <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                                User Copied Trades
                            </h3>
                        </div>
                    </div>

                    <div class="custom-scrollbar max-w-full overflow-x-auto overflow-y-visible px-5 sm:px-6">
                        <table class="min-w-full">
                            <thead class="border-y border-gray-100 py-3 dark:border-gray-800">
                                <th class="py-3 pr-5 font-normal whitespace-nowrap sm:pr-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">User Name</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">Method Used</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <Entry class="text-theme-sm text-gray-500 dark:text-gray-400">Amount</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">
                                            Status
                                        </p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">
                                            Action
                                        </p>
                                    </div>
                                </th>
                            </thead>
                            <tbody class="divide-y divide-gray-100 dark:divide-gray-800">
                                @forelse($data as $item)
                                    <tr>
                                        <td class="py-3 pr-5 whitespace-nowrap sm:pr-5">
                                            <div class="col-span-3 flex items-center">
                                                <div class="flex items-center gap-3">
                                                    <div class="h-8 w-8">
                                                        @if (!empty($item->user->image))
                                                            <img src="{{ url('upload/profile/' . $item->user->image) }}"
                                                                alt="brand" />
                                                        @else
                                                            <img src="{{ asset('admin/src/images/brand/brand-08.svg') }}"
                                                                alt="brand" />
                                                        @endif
                                                    </div>

                                                    <div>
                                                        <span
                                                            class="text-theme-sm block font-medium text-gray-700 dark:text-gray-400">
                                                            {{ $item->user->firstname}}
                                                            {{ $item->user->lastname}}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    {{ $item->loantype->emoji}}
                                                    {{ $item->loantype->name}}
                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    ${{ number_format($item->amount, 2)}}
                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                @if ($item->status === 'approved')
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-success-500 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        dark:bg-amber-500/10 dark:text-green-400">
                                                        Approved
                                                    </span>
                                                @elseif ($item->status === 'rejected')
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-error-500 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        dark:bg-blue-500/10 dark:text-blue-400">
                                                        Rejected
                                                    </span>
                                                @elseif ($item->status === 'pending')
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-warning-500 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        dark:bg-blue-500/10 dark:text-blue-400">
                                                        Pending
                                                    </span>
                                                @else
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-gray-700 bg-gray-100 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        dark:bg-gray-500/10 dark:text-gray-400">
                                                        Unknown
                                                    </span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-6 py-3 whitespace-nowrap gap-3">
                                            <div x-data="dropdown()" class="relative flex justify-center">
                                                <button @click="toggle" class="text-gray-500 dark:text-gray-400">
                                                    <svg class="fill-current" width="24" height="24" viewBox="0 0 24 24"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M5.99902 10.245C6.96552 10.245 7.74902 11.0285 7.74902 11.995V12.005C7.74902 12.9715 6.96552 13.755 5.99902 13.755C5.03253 13.755 4.24902 12.9715 4.24902 12.005V11.995C4.24902 11.0285 5.03253 10.245 5.99902 10.245ZM17.999 10.245C18.9655 10.245 19.749 11.0285 19.749 11.995V12.005C19.749 12.9715 18.9655 13.755 17.999 13.755C17.0325 13.755 16.249 12.9715 16.249 12.005V11.995C16.249 11.0285 17.0325 10.245 17.999 10.245ZM13.749 11.995C13.749 11.0285 12.9655 10.245 11.999 10.245C11.0325 10.245 10.249 11.0285 10.249 11.995V12.005C10.249 12.9715 11.0325 13.755 11.999 13.755C12.9655 13.755 13.749 12.9715 13.749 12.005V11.995Z"
                                                            fill="" />
                                                    </svg>
                                                </button>
                                                <div x-show="open" @click.outside="open = false"
                                                    class="shadow-theme-lg dark:bg-gray-dark fixed w-40 space-y-1 rounded-2xl border border-gray-200 bg-white p-2 dark:border-gray-800"
                                                    x-ref="dropdown">
                                                    <a href="{{ url('admin/loan/user_loan/' . $item->id) }}"
                                                        class="text-theme-xs flex w-full rounded-lg px-3 py-2 text-left font-medium text-gray-500 hover:bg-gray-100 hover:text-gray-700 dark:text-gray-400 dark:hover:bg-white/5 dark:hover:text-gray-300">
                                                        Edit
                                                    </a>
                                                    <button
                                                        class="text-theme-xs flex w-full rounded-lg px-3 py-2 text-left font-medium text-gray-500 hover:bg-gray-100 hover:text-gray-700 dark:text-gray-400 dark:hover:bg-white/5 dark:hover:text-gray-300">
                                                        Delete
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-gray-200 px-6 py-4 dark:border-gray-800">
                        <div class="flex items-center justify-between">
                            {{ $data->links('vendor.pagination.custom') }}
                        </div>
                    </div>

                </div>
                <!-- Table Five -->
            </div>
            <!-- Content End -->
        </div>
    </div>
</x-admin>