<x-admin :title="$pageTitle">

    <div class="mx-auto max-w-(--breakpoint-2xl) p-4 pb-20 md:p-6 md:pb-6">
        <!-- Breadcrumb Start -->
        <div x-data="{ pageName: `Payments Gateway` }">
            <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                <nav>
                    <ol class="flex items-center gap-1.5">
                        <li>
                            <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                href="index.html">
                                Home
                                <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke=""
                                        stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </li>
                        <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- Breadcrumb End -->
        <!-- Payment -->
        <div class="mb-6 rounded-2xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-white/[0.03]">
            <div class="flex flex-col justify-between gap-5 px-6 py-5 sm:flex-row sm:items-start">
                <div>
                    <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                        Payment Methods
                    </h3>
                </div>
                <div>
                    <a href="{{ url('admin/deposit/add_gateway') }}"
                        class="shadow-theme-xs flex w-full justify-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-3 text-sm font-medium text-gray-700 hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
                            fill="none">
                            <path d="M5.5 10.0002H15.5006M10.5002 5V15.0006" stroke="currentColor" stroke-width="1.5"
                                stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        Add New Gateway
                    </a>
                </div>
            </div>
            <div class="border-t border-gray-200 p-4 sm:p-6 dark:border-gray-800">
                <div class="grid grid-cols-1 gap-5 sm:grid-cols-2 xl:grid-cols-3">
                    <!-- Master -->
                    @foreach ($payment as $item)
                        <div class="flex gap-5 rounded-xl border border-gray-200 p-3 pr-5 dark:border-gray-800">
                            <div
                                class="inline-flex h-13 w-13 shrink-0 items-center justify-center rounded-lg border border-gray-200 dark:border-gray-800">
                                @if (!empty($item->logo))
                                    <img src="{{ url('upload/' . $item->logo) }}" alt="brand" />
                                @endif
                            </div>
                            <div>
                                <h3 class="mb-2 flex items-center gap-2 text-gray-800 dark:text-white/90">
                                    {{ $item->name }}
                                    <span
                                        class="bg-success-50 text-success-600 dark:bg-success-500/15 dark:text-success-500 inline-flex items-center justify-center gap-1 rounded-full py-0.5 pr-2.5 pl-2 text-sm font-medium">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="12"
                                            viewBox="0 0 13 12" fill="none">
                                            <path d="M9.875 3.646L5.16657 8.35442L3.125 6.31285" stroke="currentColor"
                                                stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        {{ $item->status }}
                                    </span>
                                </h3>
                                <div class="flex flex-wrap items-center justify-between gap-5">
                                    <p class="text-sm font-normal text-gray-400 dark:text-gray-400">
                                        {{ $item->wallet_address }}
                                    </p>
                                    <p class="text-sm font-normal text-gray-400 dark:text-gray-400">
                                        | {{ $item->network }}
                                    </p>
                                </div>
                                <div class="mt-4 flex flex-wrap gap-3">
                                    <a href="{{ url('admin/deposit/edit_gateway', $item->id) }}"
                                        class="shadow-theme-xs inline-flex h-6 items-center justify-center rounded-md border border-gray-300 px-3 py-1 text-xs font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                                        Edit
                                    </a>
                                    <button
                                        class="shadow-theme-xs inline-flex h-6 items-center justify-center rounded-md border border-gray-300 px-3 py-1 text-xs font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                                        Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</x-admin>
