<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('staking_plans', function (Blueprint $table) {
            $table->id();

            // Foreign Key
            $table->foreignId('cryptocurrency_id')
                ->constrained('cryptocurrencies')
                ->cascadeOnDelete();

            $table->string('name');
            $table->decimal('interest_rate', 8, 2);
            $table->integer('duration');
            $table->decimal('minimum_amount', 18, 2);
            $table->decimal('maximum_amount', 18, 2)->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staking_plans');
    }
};
