<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('real_estates', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('price', 12, 2); // minimum investment
            $table->decimal('roi', 5, 2)->nullable(); // return %
            $table->date('end_date')->nullable();
            $table->enum('status', ['open', 'closed'])->default('open');

            // TEXT CONTENT
            $table->text('strategy')->nullable();
            $table->string('type')->nullable(); // residential, commercial etc
            $table->integer('stories')->nullable();
            $table->text('objective')->nullable();
            $table->text('why_project')->nullable();
            $table->text('why_sponsor')->nullable();

            // DOCUMENT FILES
            $table->string('site_plan')->nullable();
            $table->string('organizational_chart')->nullable();
            $table->string('sponsor_record')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('real_estates');
    }
};
