<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('signals', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();

            $table->string('pair'); // e.g BTC/USDT
            $table->string('direction'); // BUY / SELL
            $table->decimal('entry_price', 12, 4)->nullable();
            $table->decimal('take_profit', 12, 4)->nullable();
            $table->decimal('stop_loss', 12, 4)->nullable();

            $table->decimal('price', 10, 2)->default(0); // cost to unlock
            $table->boolean('is_active')->default(true);
            $table->boolean('is_vip')->default(false);

            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('signals');
    }
};
