<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('live_trades', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('symbol');            // e.g., BTCUSDT
            $table->enum('side', ['buy', 'sell']); // long/short
            $table->decimal('entry_price', 16, 8); // price at which trade was opened
            $table->decimal('amount', 16, 2);     // investment amount
            $table->decimal('units', 16, 8);      // amount of asset bought/sold
            $table->decimal('leverage', 5, 2)->default(1);
            $table->string('order_type')->default('market');
            $table->string('expiration')->nullable(); // e.g., 15m, 1h
            $table->timestamp('expires_at')->nullable();
            $table->decimal('current_value', 16, 2)->default(0); // updated in job
            $table->decimal('profit_loss', 16, 2)->default(0);   // updated in job
            $table->enum('status', ['open', 'closed'])->default('open');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('live_trades');
    }
};
