<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ai_bots', function (Blueprint $table) {
            // decimal(8,2) allows e.g. -99.99% to +999999.99%
            $table->decimal('daily_change', 8, 2)->nullable()->after('success_rate')->comment('Daily % profit or loss set by admin');
        });
    }

    public function down(): void
    {
        Schema::table('ai_bots', function (Blueprint $table) {
            $table->dropColumn('daily_change');
        });
    }
};
