<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trade_experts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('title')->nullable(); // e.g. "Pro Trader", "Crypto Analyst"
            $table->string('image')->nullable(); // profile image
            $table->decimal('rating', 3, 2)->default(0.00);
            $table->unsignedBigInteger('followers')->default(0);
            $table->decimal('win_rate', 5, 2)->default(0.00); // %
            $table->decimal('total_return', 8, 2)->default(0.00); // %
            $table->unsignedInteger('total_trades')->default(0);
            $table->decimal('min_amount', 15, 2)->default(0);
            $table->string('status')->default('active'); // active/inactive
            $table->longText('description')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trade_experts');
    }
};
