<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_bot_trades', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('ai_bot_id')->constrained()->cascadeOnDelete();

            $table->decimal('amount_invested', 15, 2);
            $table->decimal('profit_percent', 10, 2)->default(0.00);
            $table->decimal('profit_earned', 15, 2)->default(0.00);

            $table->enum('status', ['running', 'completed', 'cancelled'])->default('running');
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_bot_trades');
    }
};
