<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investments', function (Blueprint $table) {
            $table->id();

            // Foreign keys
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('investment_plan_id')->constrained()->onDelete('cascade');

            // Investment details
            $table->decimal('amount', 15, 2);
            $table->decimal('expected_return', 15, 2)->nullable();
            $table->decimal('profit', 15, 2)->default(0);
            $table->string('duration')->nullable(); // e.g. 30 days
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('days_completed')->default(0);

            // Status
            $table->enum('status', ['active', 'completed', 'cancelled', 'pending'])->default('pending');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investments');
    }
};
