<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investment_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g. Basic Plan, Gold Plan
            $table->text('description')->nullable();
            $table->decimal('min_amount', 15, 2)->default(0);
            $table->decimal('max_amount', 15, 2)->nullable();
            $table->decimal('interest_rate', 10, 2)->default(0); // percentage (e.g. 5 for 5%)
            $table->string('duration'); // e.g. 30 days, 1 month
            $table->enum('interest_type', ['daily', 'weekly', 'monthly', 'yearly', 'end'])->default('daily');
            $table->integer('total_return_days')->nullable(); // for daily interest plans
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investment_plans');
    }
};
