<?php

namespace Database\Factories;

// database/factories/TradeExpertFactory.php
use App\Models\TradeExpert;
use Illuminate\Database\Eloquent\Factories\Factory;

class TradeExpertFactory extends Factory
{
    protected $model = TradeExpert::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'title' => $this->faker->jobTitle(),
            'image' => 'experts/default.jpg',
            'rating' => $this->faker->numberBetween(1, 5),
            'followers' => $this->faker->numberBetween(1000, 100000),
            'win_rate' => $this->faker->numberBetween(50, 95),
            'total_return' => $this->faker->randomFloat(2, 5, 120),
            'total_trades' => $this->faker->numberBetween(100, 2000),
            'min_amount' => $this->faker->randomFloat(2, 50, 500),
            'status' => 'active',
            'description' => $this->faker->paragraph(),
        ];
    }
}
