<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'twelvedata' => [
        'key' => env('TWELVEDATA_KEY'),
    ],

    'finnhub' => [
        'key' => env('FINNHUB_KEY'),
    ],

    'vantage' => [
        'key' => env('ALPHA_VANTAGE'),
    ],

    'marketstack' => [
        'key' => env('MARKETSTACK_KEY'),
    ],

    'logodev' => [
        'publishable_key' => env('LOGODEV_PUBLISHABLE_KEY'),
        'secret_key' => env('LOGODEV_SECRET_KEY'),
    ],

    'yahoo' => [
        'key' => env('YAHOO_API_KEY'),
    ],

    'google' => [
        'client_id' => env('GOOGLE_CLIENT_ID'),
        'client_secret' => env('GOOGLE_CLIENT_SECRET'),
        'redirect' => env('GOOGLE_REDIRECT_URL'),
    ],



];
