<?php

use App\Http\Middleware\Role;
use App\Http\Middleware\CheckUserStatus;
use App\Http\Middleware\KycCheck;
use App\Http\Middleware\AccessCodeMiddleware;
use App\Http\Middleware\AdminMiddleware;
use App\Http\Middleware\RedirectIfAuthenticated;
use Illuminate\Foundation\Application;
use App\Http\Middleware\RoleRedirectMiddleware;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\RestrictUserLoginMiddleware;
use App\Http\Middleware\RestrictAdminLoginMiddleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->web([
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            // \App\Http\Middleware\VerifyCsrfToken::class,
        ]);

        $middleware->alias([
            'role' => Role::class,
            'checkstatus' => CheckUserStatus::class,
            'guest' => RedirectIfAuthenticated::class,
            'admin' => AdminMiddleware::class,
            'kyccheck' => KycCheck::class,
            'access.code' => AccessCodeMiddleware::class,
            'withdrawal.access' => \App\Http\Middleware\WithdrawalAccess::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })
    ->create();
