<?php

namespace App\Providers;

use App\Models\User;
use App\Models\Deposit;
use App\Models\Withdrawal;
use App\Models\Notification;
use App\Models\WebsiteSetting;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useTailwind();

        $settings = WebsiteSetting::first();
        View::share('websiteSettings', $settings);


        View::composer('*', function ($view) {
            $adminNotifications = collect();
            $userNotifications = collect();

            // ✅ Admin notifications
            $admin = User::where('role', 'admin')->first();
            if ($admin) {
                $adminNotifications = Notification::where('notifiable_id', $admin->id)
                    ->whereNull('read_at')
                    ->latest()
                    ->take(10)
                    ->get();
            }

            // ✅ Logged-in user's notifications
            if (Auth::check()) {
                $userNotifications = Notification::where('notifiable_id', Auth::id())
                    ->whereNull('read_at')
                    ->latest()
                    ->take(10)
                    ->get();
            }

            $view->with([
                'adminNotifications' => $adminNotifications,
                'userNotifications' => $userNotifications,
            ]);
        });

        View::composer('*', function ($view) {
            if (Auth::check()) {

                // Total Deposits
                $totalDeposits = Deposit::where('user_id', Auth::id())
                    ->where('status', 'approved')
                    ->sum('amount');

                // Total Withdrawals
                $totalWithdrawals = Withdrawal::where('user_id', Auth::id())
                    ->where('status', 'approved')
                    ->sum('amount');

                $view->with([
                    'totalDeposits' => $totalDeposits,
                    'totalWithdrawals' => $totalWithdrawals,
                ]);
            }
        });
    }
}
