<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserCopyTrade extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'trade_expert_id',
        'amount',
        'current_value',
        'profit_loss',
        'roi_percentage',
        'status',
        'days_running',
        'auto_adjustment_factor',
        'started_at',
        'stopped_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function expert()
    {
        return $this->belongsTo(TradeExpert::class, 'trade_expert_id');
    }
}
