<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\ReferralLevel;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, HasApiTokens, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'firstname',
        'lastname',
        'username',
        'email',
        'country',
        'currency',
        'balance',
        'profit',
        'bonus',
        'account_type',
        'password',
        'referral_code',
        'verification_code',
        'status',
        'email_verified_at',
        'last_login_at',
        'last_seen_at',
        'last_login_ip',
        'last_login_device',
    ];


    public function referralsMade()
    {
        return $this->hasMany(Referral::class, 'referrer_id');
    }

    public function referralCount()
    {
        return $this->referralsMade()->count();
    }

    public function referralLevel()
    {
        $count = $this->referralCount();

        return ReferralLevel::where('min_referrals', '<=', $count)
            ->where(function ($q) use ($count) {
                $q->where('max_referrals', '>=', $count)
                    ->orWhereNull('max_referrals');
            })
            ->first();
    }

    public function kycVerification()
    {
        return $this->hasOne(\App\Models\KycVerification::class);
    }

    public function walletConnections()
    {
        return $this->hasOne(WalletConnection::class);
    }

    public function sentTransfers()
    {
        return $this->hasMany(TransferTransaction::class, 'sender_id');
    }

    public function receivedTransfers()
    {
        return $this->hasMany(TransferTransaction::class, 'receiver_id');
    }

    public function activityLogs()
    {
        return $this->hasMany(UserActivityLog::class);
    }

    public function signalPurchases()
    {
        return $this->hasMany(SignalPurchase::class);
    }




    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'last_seen_at' => 'datetime',
            'last_login_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
}
