<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TradeExpert extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'title',
        'image',
        'rating',
        'followers',
        'win_rate',
        'total_return',
        'total_trades',
        'equity',
        'daily_change',
        'min_amount',
        'status',
        'description'
    ];

    public function copyTrades()
    {
        return $this->hasMany(UserCopyTrade::class);
    }

    public function copiers()
    {
        return $this->belongsToMany(User::class, 'user_copy_trades', 'trade_expert_id', 'user_id')
            ->withPivot('amount')
            ->withTimestamps();
    }
}
